/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.ui.plugin.editor.SquareIcon;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.UnitSizeLayoutProperties;
import repast.simphony.visualization.VisualizationProperties;
import repast.simphony.visualization.continuous.ContinuousDecorator;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.ProjectionDescriptor;
import repast.simphony.visualization.gui.DisplayWizardModel;
import saf.core.ui.util.FloatDocument;

public class ContinuousStyleStep
extends PluginWizardStep {
    private static final long serialVersionUID = 7952844028233688422L;
    private DisplayWizardModel model;
    private JTextField sizeFld;
    private JLabel nameLbl;
    private JCheckBox boundingBox;
    private JButton colorBtn;
    private Color color;
    private boolean prepared;
    private boolean applied;

    public ContinuousStyleStep() {
        super("Continuous Space Style", "Please enter the continuous space details");
        this.setComplete(true);
    }

    protected JPanel getContentPanel() {
        this.sizeFld = new JTextField();
        this.nameLbl = new JLabel();
        this.boundingBox = new JCheckBox();
        this.colorBtn = new JButton();
        this.color = Color.WHITE;
        this.sizeFld.setDocument((Document)new FloatDocument());
        FormLayout layout = new FormLayout("right:pref, 3dlu, pref, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addLabel("Space Name:", cc.xy(1, 1));
        this.nameLbl.setFont(this.nameLbl.getFont().deriveFont(1));
        builder.add((Component)this.nameLbl, cc.xyw(3, 1, 2));
        builder.addLabel("Unit size:", cc.xy(1, 3));
        builder.add((Component)this.sizeFld, cc.xyw(3, 3, 2));
        builder.addLabel("Show Bounding Box:", cc.xy(1, 5));
        builder.add((Component)this.boundingBox, cc.xyw(3, 5, 2));
        final JLabel boxColorLabel = builder.addLabel("Bounding Box:", cc.xy(1, 7));
        builder.add((Component)this.colorBtn, cc.xy(3, 7));
        this.boundingBox.setSelected(true);
        this.boundingBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContinuousStyleStep.this.colorBtn.setEnabled(ContinuousStyleStep.this.boundingBox.isSelected());
                boxColorLabel.setEnabled(ContinuousStyleStep.this.boundingBox.isSelected());
            }
        });
        this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, this.color));
        this.colorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color c = JColorChooser.showDialog((Component)((Object)ContinuousStyleStep.this), "Select Color", ContinuousStyleStep.this.color);
                if (c != null) {
                    ContinuousStyleStep.this.color = c;
                    ContinuousStyleStep.this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, ContinuousStyleStep.this.color));
                }
            }
        });
        return builder.getPanel();
    }

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    private void prepareLayoutProps() {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        VisualizationProperties props = descriptor.getLayoutProperties();
        if (props != null) {
            if (props.getProperty(UnitSizeLayoutProperties.UNIT_SIZE_LAYOUT_PROPERTIES_ID) == null) {
                this.resetLayoutProperties(descriptor);
            } else {
                UnitSizeLayoutProperties hints = (UnitSizeLayoutProperties)props;
                this.sizeFld.setText(String.valueOf(hints.getUnitSize()));
            }
        } else {
            this.resetLayoutProperties(descriptor);
        }
    }

    private void resetLayoutProperties(DisplayDescriptor descriptor) {
        descriptor.setLayoutProperties(new UnitSizeLayoutProperties());
        if (descriptor.getDisplayType().equals("3D")) {
            this.sizeFld.setText(".06");
        } else {
            this.sizeFld.setText("15");
            this.color = Color.BLACK;
            this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, this.color));
        }
    }

    public void prepare() {
        String name = this.model.getTypeDescriptor("continuous space").getProjectionName();
        if (name != null) {
            this.nameLbl.setText(name);
        }
        if (!this.prepared || this.prepared && this.applied) {
            this.prepareLayoutProps();
            this.prepareDecoratorProps();
        }
        this.prepared = true;
    }

    private void prepareDecoratorProps() {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        ProjectionDescriptor pd = this.model.getTypeDescriptor("continuous space");
        Boolean show = (Boolean)pd.getProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "SHOW");
        if (show == null) {
            this.boundingBox.setSelected(true);
            pd.setProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "COLOR", this.color.getRGB());
            pd.setProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "SHOW", true);
            VisualizationProperties lProps = descriptor.getLayoutProperties();
            Float cellSize = (Float)lProps.getProperty("cellSize");
            pd.setProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "UNIT_SIZE", cellSize);
        } else {
            this.boundingBox.setSelected(show);
            Integer colorAsInt = (Integer)pd.getProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "COLOR");
            this.color = new Color(colorAsInt);
            this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, this.color));
        }
    }

    public void applyState() throws InvalidStateException {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        UnitSizeLayoutProperties hints = (UnitSizeLayoutProperties)descriptor.getLayoutProperties();
        float unitSize = Float.parseFloat(this.sizeFld.getText());
        hints.setUnitSize(unitSize);
        ProjectionDescriptor pd = this.model.getTypeDescriptor("continuous space");
        pd.setProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "COLOR", this.color.getRGB());
        pd.setProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "SHOW", this.boundingBox.isSelected());
        pd.setProperty(ContinuousDecorator.CONTINUOUS_DECORATOR, "UNIT_SIZE", Float.valueOf(unitSize));
        for (ProjectionData proj : descriptor.getProjections()) {
            if (!proj.getType().equals("continuous space")) continue;
            descriptor.setLayoutProjection(proj.getId());
            descriptor.setLayoutFrequency(IDisplay.LayoutFrequency.ON_MOVE);
            descriptor.setLayoutClassName("foo.bar.baz");
        }
        this.applied = true;
    }
}

