/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.scenario.data.AgentData;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.gui.AgentSelectionPanel;
import repast.simphony.visualization.gui.DisplayWizardModel;

public class AgentSelectionStep
extends PluginWizardStep {
    protected AgentSelectionPanel panel;
    protected DisplayWizardModel model;
    protected ListDataListener dataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            try {
                AgentSelectionStep.this.applyState();
            }
            catch (InvalidStateException e1) {
                e1.printStackTrace();
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            try {
                AgentSelectionStep.this.applyState();
            }
            catch (InvalidStateException e1) {
                e1.printStackTrace();
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            try {
                AgentSelectionStep.this.applyState();
            }
            catch (InvalidStateException e1) {
                e1.printStackTrace();
            }
        }
    };

    public AgentSelectionStep() {
        super("Agent Selection", "Please select the agent types to display and the order in which the layers (2D) will appear");
        this.setComplete(false);
    }

    protected JPanel getContentPanel() {
        this.panel = new AgentSelectionPanel();
        this.panel.source.setCellRenderer(new AgentDataRenderer());
        this.panel.target.setCellRenderer(new AgentDataRenderer());
        return this.panel;
    }

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    public void applyState() throws InvalidStateException {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        ListModel listModel = this.panel.target.getModel();
        boolean reset = false;
        Map<String, Integer> layerOrders = descriptor.getLayerOrders();
        layerOrders.clear();
        int i = 0;
        while (i < listModel.getSize()) {
            AgentData agent = (AgentData)listModel.getElementAt(i);
            descriptor.addLayerOrder(agent.getClassName(), listModel.getSize() - i - 1);
            ++i;
        }
        HashMap<String, String> styles = new HashMap<String, String>(descriptor.getStyles());
        for (String classname : descriptor.getLayerOrders().keySet()) {
            String styleClass;
            if (styles.containsKey(classname) || (styleClass = this.model.getDefaultStyle()) == null) continue;
            descriptor.addStyle(classname, styleClass);
        }
        this.updateListeners();
    }

    protected List<AgentData> getTargetAgentList(DisplayDescriptor descriptor) {
        ArrayList<AgentData> target = new ArrayList<AgentData>();
        ArrayList<AgentData> unorderedTarget = new ArrayList<AgentData>();
        Map<String, String> styles = descriptor.getStyles();
        ArrayList<Integer> orders = new ArrayList<Integer>();
        HashMap<Integer, AgentData> orderedMap = new HashMap<Integer, AgentData>();
        if (styles.keySet().size() > 0) {
            for (String className : styles.keySet()) {
                if (descriptor.getLayerOrder(className) != null) {
                    int order = descriptor.getLayerOrder(className);
                    orderedMap.put(order, new AgentData(className));
                    orders.add(order);
                    continue;
                }
                unorderedTarget.add(new AgentData(className));
            }
        }
        Collections.sort(orders);
        Iterator<String> iterator = orders.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)((Object)iterator.next());
            target.add(i, (AgentData)orderedMap.get(i));
        }
        Collections.reverse(target);
        target.addAll(unorderedTarget);
        return target;
    }

    public void prepare() {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        if (descriptor.getDisplayType().equals("3D")) {
            this.panel.upBtn.setEnabled(false);
            this.panel.downBtn.setEnabled(false);
        }
        List<AgentData> target = this.getTargetAgentList(descriptor);
        List source = this.model.getContext().getAgentData(true);
        Collections.sort(source, new Comparator<AgentData>(){

            @Override
            public int compare(AgentData o1, AgentData o2) {
                return o1.getShortName().compareTo(o2.getShortName());
            }
        });
        this.panel.target.getModel().removeListDataListener(this.dataListener);
        source.removeAll(target);
        this.panel.init(source, target);
        this.panel.target.getModel().addListDataListener(this.dataListener);
        try {
            this.applyState();
        }
        catch (InvalidStateException e) {
            e.printStackTrace();
        }
        this.setComplete(true);
    }

    public ListModel getListModel() {
        return this.panel.target.getModel();
    }

    protected static class AgentDataRenderer
    extends DefaultListCellRenderer {
        protected AgentDataRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                value = ((AgentData)value).getShortName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

