/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import repast.simphony.scenario.data.AgentData;
import repast.simphony.ui.widget.IconUtils;

public class AgentSelectionPanel
extends JPanel {
    protected JPanel panel5;
    protected JPanel hSpacer1;
    protected JLabel label2;
    protected JScrollPane scrollPane1;
    JList source;
    protected JPanel panel1;
    protected JPanel vSpacer1;
    protected JButton addBtn;
    protected JButton removeBtn;
    protected JPanel vSpacer2;
    protected JScrollPane scrollPane2;
    JList target;
    protected JPanel panel4;
    JButton upBtn;
    JButton downBtn;
    protected JLabel label1;

    public AgentSelectionPanel() {
        this.initComponents();
        this.initButtons();
        this.addListeners();
    }

    protected void initButtons() {
        this.addBtn.setIcon(IconUtils.loadIcon((String)"forward.png"));
        this.removeBtn.setIcon(IconUtils.loadIcon((String)"back.png"));
        this.upBtn.setIcon(IconUtils.loadIcon((String)"up.png"));
        this.downBtn.setIcon(IconUtils.loadIcon((String)"down.png"));
    }

    protected void addListeners() {
        boolean sourceSize;
        this.source.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AgentSelectionPanel.this.addBtn.setEnabled(AgentSelectionPanel.this.source.getSelectedValues().length > 0);
                AgentSelectionPanel.this.target.setSelectedIndex(-1);
            }
        });
        this.target.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AgentSelectionPanel.this.removeBtn.setEnabled(AgentSelectionPanel.this.target.getSelectedValues().length > 0);
                AgentSelectionPanel.this.upBtn.setEnabled(AgentSelectionPanel.this.target.getSelectedIndex() > 0);
                AgentSelectionPanel.this.downBtn.setEnabled(AgentSelectionPanel.this.target.getSelectedIndex() > -1 && AgentSelectionPanel.this.target.getSelectedIndex() < AgentSelectionPanel.this.target.getModel().getSize() - 1);
                AgentSelectionPanel.this.source.setSelectedIndex(-1);
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object[] objs = AgentSelectionPanel.this.source.getSelectedValues();
                DefaultListModel tModel = (DefaultListModel)AgentSelectionPanel.this.target.getModel();
                DefaultListModel sModel = (DefaultListModel)AgentSelectionPanel.this.source.getModel();
                Object[] objectArray = objs;
                int n = objs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    sModel.removeElement(obj);
                    tModel.addElement(obj);
                    ++n2;
                }
                if (sModel.size() > 0) {
                    AgentSelectionPanel.this.source.setSelectedIndex(0);
                }
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object[] objs = AgentSelectionPanel.this.target.getSelectedValues();
                DefaultListModel tModel = (DefaultListModel)AgentSelectionPanel.this.target.getModel();
                DefaultListModel sModel = (DefaultListModel)AgentSelectionPanel.this.source.getModel();
                Object[] objectArray = objs;
                int n = objs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    tModel.removeElement(obj);
                    sModel.addElement(obj);
                    ++n2;
                }
                if (tModel.size() > 0) {
                    AgentSelectionPanel.this.target.setSelectedIndex(0);
                }
            }
        });
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = AgentSelectionPanel.this.target.getSelectedIndex();
                DefaultListModel tModel = (DefaultListModel)AgentSelectionPanel.this.target.getModel();
                Object obj = tModel.remove(index);
                tModel.add(index - 1, obj);
                AgentSelectionPanel.this.target.setSelectedIndex(index - 1);
            }
        });
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = AgentSelectionPanel.this.target.getSelectedIndex();
                DefaultListModel tModel = (DefaultListModel)AgentSelectionPanel.this.target.getModel();
                Object obj = tModel.remove(index);
                tModel.add(index + 1, obj);
                AgentSelectionPanel.this.target.setSelectedIndex(index + 1);
            }
        });
        boolean bl = sourceSize = this.source.getModel().getSize() > 0;
        if (sourceSize) {
            this.source.setSelectedIndex(0);
        }
        this.target.setSelectedIndex(-1);
    }

    public void init(List<AgentData> sourceList, List<AgentData> targetList) {
        DefaultListModel<AgentData> model = new DefaultListModel<AgentData>();
        for (AgentData item : sourceList) {
            model.addElement(item);
        }
        this.source.setModel(model);
        model = new DefaultListModel();
        for (AgentData item : targetList) {
            model.addElement(item);
        }
        this.target.setModel(model);
        this.source.setVisibleRowCount(8);
        this.target.setVisibleRowCount(8);
        this.upBtn.setEnabled(false);
        this.downBtn.setEnabled(false);
    }

    protected void initComponents() {
        this.panel5 = new JPanel();
        this.hSpacer1 = new JPanel(null);
        this.label2 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.source = new AgentList();
        this.panel1 = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.vSpacer2 = new JPanel(null);
        this.scrollPane2 = new JScrollPane();
        this.target = new AgentList();
        this.panel4 = new JPanel();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.label1 = new JLabel();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.75), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.25), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.panel5.setLayout(new BoxLayout(this.panel5, 0));
        this.panel5.add(this.hSpacer1);
        this.label2.setText("Foreground");
        this.label2.setFont(this.label2.getFont().deriveFont((float)this.label2.getFont().getSize() - 2.0f));
        this.label2.setHorizontalAlignment(4);
        this.panel5.add(this.label2);
        this.add((Component)this.panel5, cc.xy(5, 1));
        this.scrollPane1.setViewportView(this.source);
        this.add((Component)this.scrollPane1, cc.xy(1, 3));
        this.panel1.setLayout(new BoxLayout(this.panel1, 1));
        this.panel1.add(this.vSpacer1);
        this.panel1.add(this.addBtn);
        this.panel1.add(this.removeBtn);
        this.panel1.add(this.vSpacer2);
        this.add((Component)this.panel1, cc.xy(3, 3));
        this.scrollPane2.setViewportView(this.target);
        this.add((Component)this.scrollPane2, cc.xy(5, 3));
        this.panel4.setLayout(new BoxLayout(this.panel4, 1));
        this.panel4.add(this.upBtn);
        this.panel4.add(this.downBtn);
        this.add((Component)this.panel4, cc.xy(7, 3));
        this.label1.setText("Background");
        this.label1.setFont(this.label1.getFont().deriveFont((float)this.label1.getFont().getSize() - 2.0f));
        this.label1.setHorizontalAlignment(4);
        this.add((Component)this.label1, cc.xy(5, 5));
    }

    protected static class AgentList
    extends JList {
        protected AgentList() {
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point p = event.getPoint();
            int index = this.locationToIndex(p);
            if (index > -1 && index < this.getModel().getSize()) {
                return ((AgentData)this.getModel().getElementAt(index)).getClassName();
            }
            return "";
        }
    }
}

