/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.grid;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.piccolo2d.PNode;
import org.piccolo2d.util.PPaintContext;

public class GridShape
extends PNode {
    private float cellSize;
    private Color color;
    private int cols;
    private int rows;

    public GridShape(float cellSize, Color color, int cols, int rows) {
        this.cellSize = cellSize;
        this.color = color;
        this.cols = cols;
        this.rows = rows;
        this.setBounds(0.0, 0.0, (float)cols * cellSize, (float)rows * cellSize);
    }

    protected void paint(PPaintContext pPaintContext) {
        Graphics2D g2 = pPaintContext.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color c = g2.getColor();
        Stroke stroke = g2.getStroke();
        g2.setColor(this.color);
        g2.setStroke(new BasicStroke(1.0f));
        GeneralPath path = new GeneralPath();
        float y = this.cellSize * (float)this.rows;
        int i = 0;
        while (i <= this.cols) {
            float x = (float)i * this.cellSize;
            path.reset();
            path.moveTo(x, 0.0f);
            path.lineTo(x, y);
            g2.draw(path);
            ++i;
        }
        float x = this.cellSize * (float)this.cols;
        int i2 = 0;
        while (i2 <= this.rows) {
            y = (float)i2 * this.cellSize;
            path.reset();
            path.moveTo(0.0f, y);
            path.lineTo(x, y);
            g2.draw(path);
            ++i2;
        }
        g2.setColor(c);
        g2.setStroke(stroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public Point getXY(Point2D point) {
        double x1 = point.getX() + (double)(this.cellSize / 2.0f);
        int x = (int)Math.floor(x1 / (double)this.cellSize);
        double y1 = point.getY() + (double)(this.cellSize / 2.0f);
        int y = (int)Math.floor(y1 / (double)this.cellSize);
        if (x < 0 || x > this.cols - 1) {
            return null;
        }
        if (y < 0 || y > this.rows - 1) {
            return null;
        }
        return new Point(x, y);
    }
}

