/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import repast.simphony.visualization.engine.DisplayDescriptor;

public abstract class StyleRegistrar<T> {
    public void registerStyles(Registrar<T> registrar, DisplayDescriptor descriptor) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Collection<String> agentNames = this.getOrderedAgentCollection(descriptor);
        this.registerStyles(registrar, descriptor, agentNames);
    }

    private Collection<String> getOrderedAgentCollection(DisplayDescriptor descriptor) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        ArrayList<String> unsorted = new ArrayList<String>();
        for (String agentName : descriptor.agentClassStyleNames()) {
            Integer layerOrder = descriptor.getLayerOrder(agentName);
            if (layerOrder != null) {
                map.put(layerOrder, agentName);
                continue;
            }
            unsorted.add(agentName);
        }
        int index = map.size() > 0 ? (Integer)map.lastKey() + 1 : 0;
        for (String s : unsorted) {
            map.put(index, s);
            ++index;
        }
        return map.values();
    }

    protected abstract T createdEditedStyle(String var1);

    private void registerStyles(Registrar<T> registrar, DisplayDescriptor descriptor, Collection<String> agentNames) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (String agentName : agentNames) {
            String styleName = descriptor.getStyleClassName(agentName);
            String editedStyleName = descriptor.getEditedStyleName(agentName);
            Class<?> agentClass = Class.forName(agentName, true, this.getClass().getClassLoader());
            if (editedStyleName != null) {
                T style = this.createdEditedStyle(editedStyleName);
                registrar.register(agentClass, style);
                continue;
            }
            if (styleName == null) continue;
            Class<?> styleClass = Class.forName(styleName, true, this.getClass().getClassLoader());
            Object style = styleClass.newInstance();
            registrar.register(agentClass, style);
        }
    }

    public static interface Registrar<T> {
        public void register(Class<?> var1, T var2);
    }
}

