/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import repast.simphony.context.Context;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.space.graph.Network;
import repast.simphony.visualization.engine.DisplayDescriptor;

public abstract class NetworkStyleRegistrar<T> {
    protected abstract T createEditedEdgeStyle(String var1);

    public void registerNetworkStyles(Registrar<T> registrar, DisplayDescriptor descriptor, Context<?> context) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (ProjectionData proj : descriptor.getProjections()) {
            if (!proj.getType().equals("network")) continue;
            String netStyleName = descriptor.getNetworkStyleClassName(proj.getId());
            String netEditedStyleName = descriptor.getNetworkEditedStyleName(proj.getId());
            Network network = (Network)context.getProjection(Network.class, proj.getId());
            if (netEditedStyleName != null) {
                T style = this.createEditedEdgeStyle(netEditedStyleName);
                registrar.register(network, style);
                continue;
            }
            if (netStyleName == null) continue;
            Class<?> styleClass = Class.forName(netStyleName, true, this.getClass().getClassLoader());
            Object style = styleClass.newInstance();
            registrar.register(network, style);
        }
    }

    public static interface Registrar<T> {
        public void register(Network<?> var1, T var2);
    }
}

