/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import repast.simphony.context.Context;
import repast.simphony.engine.environment.RunState;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayCreationException;
import repast.simphony.visualization.engine.DisplayCreator3D;
import repast.simphony.visualization.engine.DisplayCreatorFactory;
import repast.simphony.visualization.engine.DisplayCreatorOGL2D;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.VisualizationRegistry;
import repast.simphony.visualization.engine.VisualizationRegistryData;
import simphony.util.messages.MessageCenter;

public class DisplayProducer {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(DisplayProducer.class);
    private DisplayDescriptor displayDescriptor;
    private Context<?> context;

    public DisplayProducer(Object contextID, RunState runState, DisplayDescriptor displayDescriptor) {
        this.displayDescriptor = displayDescriptor;
        Context masterContext = runState.getMasterContext();
        this.setContext(masterContext, contextID);
    }

    private void setContext(Context<?> context, Object contextID) {
        if (context.getId().equals(contextID)) {
            this.context = context;
        } else {
            for (Context child : context.getSubContexts()) {
                this.setContext(child, contextID);
            }
        }
    }

    public IDisplay createDisplay() throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException, IOException, DisplayCreationException {
        if (this.displayDescriptor.getDisplayType().equals("2D")) {
            return new DisplayCreatorOGL2D(this.context, (CartesianDisplayDescriptor)this.displayDescriptor).createDisplay();
        }
        if (this.displayDescriptor.getDisplayType().equals("3D")) {
            return new DisplayCreator3D(this.context, (CartesianDisplayDescriptor)this.displayDescriptor).createDisplay();
        }
        VisualizationRegistryData data = VisualizationRegistry.getDataFor(this.displayDescriptor.getDisplayType());
        if (data != null) {
            try {
                DisplayCreatorFactory factory = data.getDisplayCreatorFactory();
                return factory.createDisplayCreator(this.context, this.displayDescriptor).createDisplay();
            }
            catch (Exception ex) {
                msg.error((Object)("Error creating display for " + this.displayDescriptor.getDisplayType()), (Throwable)ex, new Object[0]);
            }
        } else {
            msg.error((Object)("No display implementation found for " + this.displayDescriptor.getDisplayType()), null, new Object[0]);
        }
        return null;
    }
}

