/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.awt.Color;
import repast.simphony.context.Context;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.Projection;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.DefaultDisplayData;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.decorator.ProjectionDecorator2D;
import repast.simphony.visualization.engine.AbstractCartesianDisplayCreator;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayCreationException;
import repast.simphony.visualization.engine.NetworkStyleRegistrar;
import repast.simphony.visualization.engine.NetworkStyleRegistrarOGL2D;
import repast.simphony.visualization.engine.ProjectionDescriptor;
import repast.simphony.visualization.engine.StyleRegistrar;
import repast.simphony.visualization.engine.StyleRegistrarOGL2D;
import repast.simphony.visualization.engine.VLStyleRegistrar;
import repast.simphony.visualization.engine.VLStyleRegistrarOGL2D;
import repast.simphony.visualizationOGL2D.DisplayOGL2D;
import repast.simphony.visualizationOGL2D.EdgeStyleOGL2D;
import repast.simphony.visualizationOGL2D.StyleOGL2D;
import repast.simphony.visualizationOGL2D.ValueLayerStyleOGL;

public class DisplayCreatorOGL2D
extends AbstractCartesianDisplayCreator {
    public DisplayCreatorOGL2D(Context<?> context, CartesianDisplayDescriptor descriptor) {
        super(context, descriptor);
    }

    private void registerProjectionDecorators(DisplayOGL2D display) {
        for (ProjectionDescriptor projDesc : this.descriptor.getProjectionDescriptors()) {
            String name = projDesc.getProjectionName();
            for (ProjectionDecorator2D deco : projDesc.get2DDecorators()) {
                Projection projection = this.context.getProjection(name);
                deco.setProjection(projection);
                display.registerDecorator(deco);
            }
        }
    }

    @Override
    public IDisplay createDisplay() throws DisplayCreationException {
        try {
            DefaultDisplayData<?> data = this.createDisplayData();
            Layout layout = null;
            if (data.getProjectionCount() > 0) {
                String layoutProj = this.descriptor.getLayoutProjection();
                ProjectionDescriptor projDesc = this.descriptor.getProjectionDescriptor(layoutProj);
                String layoutClassName = projDesc.getImpliedLayout2D();
                layout = this.createLayout(layoutClassName);
            } else {
                layout = new Layout();
            }
            final DisplayOGL2D display = new DisplayOGL2D(data, layout);
            VLStyleRegistrarOGL2D vlReg = new VLStyleRegistrarOGL2D();
            vlReg.registerValueLayerStyle(new VLStyleRegistrar.Registrar<ValueLayerStyleOGL>(){

                @Override
                public void register(ValueLayerStyleOGL style, ValueLayer layer) {
                    display.registerValueLayerStyle(layer, style);
                }
            }, this.descriptor, this.context);
            StyleRegistrarOGL2D styleReg = new StyleRegistrarOGL2D();
            styleReg.registerStyles(new StyleRegistrar.Registrar<StyleOGL2D<?>>(){

                @Override
                public void register(Class<?> agentClass, StyleOGL2D<?> style) {
                    display.registerStyle(agentClass, style);
                }
            }, this.descriptor);
            NetworkStyleRegistrarOGL2D netReg = new NetworkStyleRegistrarOGL2D();
            netReg.registerNetworkStyles(new NetworkStyleRegistrar.Registrar<EdgeStyleOGL2D>(){

                @Override
                public void register(Network<?> network, EdgeStyleOGL2D style) {
                    display.registerNetworkStyle(network, style);
                }
            }, this.descriptor, this.context);
            this.registerProjectionDecorators(display);
            display.setLayoutFrequency(this.descriptor.getLayoutFrqeuency(), this.descriptor.getLayoutInterval());
            Color color = this.descriptor.getBackgroundColor();
            if (color != null) {
                display.setBackgroundColor(color);
            }
            return display;
        }
        catch (Exception ex) {
            throw new DisplayCreationException(ex);
        }
    }
}

