/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import repast.simphony.context.Context;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.Projection;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.DefaultDisplayData;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.decorator.ProjectionDecorator3D;
import repast.simphony.visualization.engine.AbstractCartesianDisplayCreator;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayCreationException;
import repast.simphony.visualization.engine.NetworkStyleRegistrar;
import repast.simphony.visualization.engine.NetworkStyleRegistrar3D;
import repast.simphony.visualization.engine.ProjectionDescriptor;
import repast.simphony.visualization.engine.StyleRegistrar;
import repast.simphony.visualization.engine.StyleRegistrar3D;
import repast.simphony.visualization.engine.VLStyleRegistrar;
import repast.simphony.visualization.engine.VLStyleRegistrar3D;
import repast.simphony.visualization.visualization3D.Display3D;
import repast.simphony.visualization.visualization3D.style.EdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualization.visualization3D.style.ValueLayerStyle3D;

public class DisplayCreator3D
extends AbstractCartesianDisplayCreator {
    public DisplayCreator3D(Context<?> context, CartesianDisplayDescriptor descriptor) {
        super(context, descriptor);
    }

    private void registerProjectionDecorators(Display3D display) {
        for (ProjectionDescriptor projDesc : this.descriptor.getProjectionDescriptors()) {
            String name = projDesc.getProjectionName();
            for (ProjectionDecorator3D deco : projDesc.get3DDecorators()) {
                Projection projection = this.context.getProjection(name);
                deco.setProjection(projection);
                display.registerDecorator(deco);
            }
        }
    }

    @Override
    public IDisplay createDisplay() throws DisplayCreationException {
        try {
            DefaultDisplayData<?> data = this.createDisplayData();
            Layout layout = null;
            if (data.getProjectionCount() > 0) {
                String layoutProj = this.descriptor.getLayoutProjection();
                ProjectionDescriptor projDesc = this.descriptor.getProjectionDescriptor(layoutProj);
                String layoutClassName = projDesc.getImpliedLayout3D();
                layout = this.createLayout(layoutClassName);
            } else {
                layout = new Layout();
            }
            final Display3D display = new Display3D(data, layout);
            StyleRegistrar3D styleReg = new StyleRegistrar3D();
            styleReg.registerStyles(new StyleRegistrar.Registrar<Style3D<?>>(){

                @Override
                public void register(Class<?> agentClass, Style3D<?> style) {
                    display.registerStyle(agentClass, style);
                }
            }, this.descriptor);
            NetworkStyleRegistrar3D netStyleReg = new NetworkStyleRegistrar3D();
            netStyleReg.registerNetworkStyles(new NetworkStyleRegistrar.Registrar<EdgeStyle3D<?>>(){

                @Override
                public void register(Network<?> network, EdgeStyle3D<?> style) {
                    display.registerNetworkStyle(network, style);
                }
            }, this.descriptor, this.context);
            this.registerProjectionDecorators(display);
            VLStyleRegistrar3D vlStyleReg = new VLStyleRegistrar3D();
            vlStyleReg.registerValueLayerStyle(new VLStyleRegistrar.Registrar<ValueLayerStyle3D>(){

                @Override
                public void register(ValueLayerStyle3D style, ValueLayer layer) {
                    style.addValueLayer(layer);
                    display.registerValueLayerStyle(style);
                }
            }, this.descriptor, this.context);
            display.setLayoutFrequency(this.descriptor.getLayoutFrqeuency(), this.descriptor.getLayoutInterval());
            display.setBackgroundColor(this.descriptor.getBackgroundColor());
            return display;
        }
        catch (Exception ex) {
            throw new DisplayCreationException(ex);
        }
    }
}

