/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DefaultDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.VisualizationRegistry;
import repast.simphony.visualization.engine.VisualizationRegistryData;

public class DefaultDisplayDescriptorConverter {
    private static final String VER_2_1_TWO_D = "TWO_D";
    private static final String VER_2_1_THREE_D = "THREE_D";
    private static final String VER_2_1_GIS = "GIS";
    private static final String VER_2_1_GIS3D = "GIS3D";
    private static final String VER_2_1_GRID = "GRID";
    private static final String VER_2_1_CONTNUOUS_SPACE = "CONTINUOUS_SPACE";
    private static final String VER_2_1_NETWORK = "NETWORK";
    private static final String VER_2_1_VALUE_LAYER = "VALUE_LAYER";
    private static final String VER_2_1_GEOGRAPHY = "GEOGRAPHY";
    private Map<String, String> displayTypeConversionMap = new HashMap<String, String>();
    private Map<String, String> projectionTypeConversionMap = new HashMap<String, String>();

    public DefaultDisplayDescriptorConverter() {
        this.displayTypeConversionMap.put(VER_2_1_TWO_D, "2D");
        this.displayTypeConversionMap.put(VER_2_1_THREE_D, "3D");
        this.displayTypeConversionMap.put(VER_2_1_GIS, VER_2_1_GIS);
        this.displayTypeConversionMap.put(VER_2_1_GIS3D, "GIS 3D");
        this.projectionTypeConversionMap.put(VER_2_1_GRID, "grid");
        this.projectionTypeConversionMap.put(VER_2_1_CONTNUOUS_SPACE, "continuous space");
        this.projectionTypeConversionMap.put(VER_2_1_NETWORK, "network");
        this.projectionTypeConversionMap.put(VER_2_1_VALUE_LAYER, "value layer");
        this.projectionTypeConversionMap.put(VER_2_1_GEOGRAPHY, "geography");
    }

    public DisplayDescriptor convertDesriptor(DefaultDisplayDescriptor descriptor) {
        String displayType = this.displayTypeConversionMap.get(descriptor.getDisplayType());
        String displayName = descriptor.getName();
        descriptor.setDisplayType(displayType);
        if ("2D".equals(displayType) || "3D".equals(displayType)) {
            CartesianDisplayDescriptor newDesc = new CartesianDisplayDescriptor(displayName);
            newDesc.set(descriptor);
            for (ProjectionData pd : newDesc.getProjections()) {
                pd.setType(this.projectionTypeConversionMap.get(pd.getType()));
            }
            for (String vlName : descriptor.getValueLayerNames()) {
                newDesc.addValueLayerName(vlName);
            }
            newDesc.setValueLayerStyleName(descriptor.getValueLayerStyleName());
            if (descriptor.getValueLayerEditedStyleName() != null) {
                newDesc.setValueLayerEditedStyleName(descriptor.getValueLayerEditedStyleName());
            }
            return newDesc;
        }
        Iterator<VisualizationRegistryData> iterator = VisualizationRegistry.getRegistryData().iterator();
        if (iterator.hasNext()) {
            VisualizationRegistryData data = iterator.next();
            DisplayDescriptor newDesc = data.getDescriptorFactory().createDescriptor(displayName);
            newDesc.set(descriptor);
            for (ProjectionData pd : newDesc.getProjections()) {
                pd.setType(this.projectionTypeConversionMap.get(pd.getType()));
            }
            return newDesc;
        }
        return null;
    }
}

