/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.visualization.engine.BasicDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.ValueLayerDescriptor;

public class CartesianDisplayDescriptor
extends BasicDisplayDescriptor
implements ValueLayerDescriptor {
    private String valueLayerStyleName;
    private String valueLayerEditedStyleName;
    public List<String> valueLayers = new ArrayList<String>();

    public CartesianDisplayDescriptor(CartesianDisplayDescriptor descriptor) {
        super(descriptor.getName());
        this.set(descriptor);
    }

    public CartesianDisplayDescriptor(String name) {
        super(name);
    }

    @Override
    public void clearValueLayerNames() {
        if (this.valueLayers.size() > 0) {
            this.valueLayers.clear();
            this.scs.fireScenarioChanged((Object)this, "valueLayers");
        }
    }

    @Override
    public int getValueLayerCount() {
        return this.valueLayers.size();
    }

    @Override
    public void set(DisplayDescriptor descriptor) {
        super.set(descriptor);
        if (this.getDisplayType().equals("2D")) {
            this.getLayerOrders().clear();
            if (descriptor.agentClassLayerOrders() != null) {
                for (String name : descriptor.agentClassLayerOrders()) {
                    this.addLayerOrder(name, descriptor.getLayerOrder(name));
                }
            }
        }
        if (descriptor instanceof CartesianDisplayDescriptor) {
            this.setValueLayers((CartesianDisplayDescriptor)descriptor);
        }
    }

    private void setValueLayers(CartesianDisplayDescriptor descriptor) {
        for (String vlName : descriptor.getValueLayerNames()) {
            this.addValueLayerName(vlName);
        }
        this.setValueLayerStyleName(descriptor.getValueLayerStyleName());
        if (descriptor.getValueLayerEditedStyleName() != null) {
            this.setValueLayerEditedStyleName(descriptor.getValueLayerEditedStyleName());
        }
    }

    @Override
    public void addValueLayerName(String name) {
        if (!this.valueLayers.contains(name)) {
            this.valueLayers.add(name);
            this.scs.fireScenarioChanged((Object)this, "valueLayer");
        }
    }

    @Override
    public Iterable<String> getValueLayerNames() {
        return this.valueLayers;
    }

    @Override
    public void setValueLayerStyleName(String name) {
        this.valueLayerStyleName = name;
        this.scs.fireScenarioChanged((Object)this, "valueLayerStyle");
    }

    @Override
    public String getValueLayerStyleName() {
        return this.valueLayerStyleName;
    }

    @Override
    public String getValueLayerEditedStyleName() {
        return this.valueLayerEditedStyleName;
    }

    @Override
    public void setValueLayerEditedStyleName(String name) {
        this.valueLayerEditedStyleName = name;
        this.scs.fireScenarioChanged((Object)this, "valueLayerEditedStyle");
    }

    @Override
    public DisplayDescriptor makeCopy() {
        return new CartesianDisplayDescriptor(this);
    }
}

