/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor.space;

import java.util.ArrayList;
import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.projection.DefaultProjection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;

public class Projected3DSpace<T>
extends DefaultProjection<T>
implements ContinuousSpace<T>,
ProjectionListener {
    private ContinuousSpace<T> space;
    private int dimIndex1;
    private int dimIndex2;
    private int constantIndex;

    public Projected3DSpace(ContinuousSpace<T> space, int dimIndex1, int dimIndex2) {
        super("2D of " + space.getName());
        this.space = space;
        this.space.addProjectionListener((ProjectionListener)this);
        this.dimIndex1 = dimIndex1;
        this.dimIndex2 = dimIndex2;
        if (space.getDimensions().size() != 3) {
            throw new IllegalArgumentException("Grid must be 3D");
        }
        if (dimIndex1 == 0) {
            if (dimIndex2 == 1) {
                this.constantIndex = 2;
            } else if (dimIndex2 == 2) {
                this.constantIndex = 1;
            }
        } else if (dimIndex1 == 1) {
            if (dimIndex2 == 2) {
                this.constantIndex = 0;
            } else if (dimIndex2 == 0) {
                this.constantIndex = 2;
            }
        } else {
            if (dimIndex2 == 0) {
                this.constantIndex = 1;
            }
            if (dimIndex2 == 1) {
                this.constantIndex = 0;
            }
        }
    }

    public int getIndex1() {
        return this.dimIndex1;
    }

    public int getIndex2() {
        return this.dimIndex2;
    }

    public int getConstantIndex() {
        return this.constantIndex;
    }

    public Dimensions getDimensions() {
        Dimensions dimensions = this.space.getDimensions();
        double[] dims = new double[]{dimensions.getDimension(this.dimIndex1), dimensions.getDimension(this.dimIndex2)};
        return new Dimensions(dims);
    }

    public void setAdder(ContinuousAdder<T> adder) {
        this.space.setAdder(adder);
    }

    public ContinuousAdder<T> getAdder() {
        return this.space.getAdder();
    }

    public boolean moveTo(T object, double ... newLocation) {
        NdPoint pt = this.space.getLocation(object);
        double[] loc = new double[3];
        loc[this.dimIndex1] = newLocation[0];
        loc[this.dimIndex2] = newLocation[1];
        loc[this.constantIndex] = pt.getCoord(this.constantIndex);
        return this.space.moveTo(object, loc);
    }

    public NdPoint getLocation(Object obj) {
        NdPoint pt = this.space.getLocation(obj);
        double[] loc = new double[]{pt.getCoord(this.dimIndex1), pt.getCoord(this.dimIndex2)};
        return new NdPoint(loc);
    }

    public int size() {
        return this.space.size();
    }

    public PointTranslator getPointTranslator() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public void setPointTranslator(PointTranslator rule) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public Iterable<T> getObjects() {
        return this.space.getObjects();
    }

    public T getObjectAt(double ... location) {
        double coord1 = location[0];
        double coord2 = location[1];
        for (T obj : this.getObjects()) {
            NdPoint pt = this.space.getLocation(obj);
            if (pt.getCoord(this.dimIndex1) != coord1 || pt.getCoord(this.dimIndex2) != coord2) continue;
            return obj;
        }
        return null;
    }

    public Iterable<T> getObjectsAt(double ... location) {
        double[] loc = new double[3];
        double coord1 = location[0];
        double coord2 = location[1];
        ArrayList<T> objs = new ArrayList<T>();
        for (T obj : this.getObjects()) {
            NdPoint pt = this.getLocation(obj);
            if (pt.getCoord(this.dimIndex1) != coord1 || pt.getCoord(this.dimIndex2) != coord2) continue;
            objs.add(obj);
        }
        return objs;
    }

    public T getRandomObjectAt(double ... location) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public NdPoint moveByDisplacement(T object, double ... displacement) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public NdPoint moveByVector(T object, double distance, double ... anglesInRadians) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public boolean isPeriodic() {
        return false;
    }

    public void destroy() {
        this.space.removeProjectionListener((ProjectionListener)this);
    }

    public void projectionEventOccurred(ProjectionEvent evt) {
        this.fireProjectionEvent(evt);
    }

    public double getDistance(NdPoint point1, NdPoint point2) {
        double distanceSq = this.getDistanceSq(point1, point2);
        return Double.isNaN(distanceSq) ? distanceSq : Math.sqrt(distanceSq);
    }

    public double getDistanceSq(NdPoint point1, NdPoint point2) {
        if (point1.dimensionCount() != point2.dimensionCount()) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 0;
        while (i < 2) {
            double diff = point1.getCoord(i) - point2.getCoord(i);
            if (this.isPeriodic()) {
                double dim = this.getDimensions().getDimension(i);
                double absDiff = Math.abs(diff);
                if (absDiff > dim / 2.0) {
                    diff = dim - absDiff;
                }
            }
            sum += diff * diff;
            ++i;
        }
        return sum;
    }

    public double[] getDisplacement(NdPoint point1, NdPoint point2) {
        if (point1.dimensionCount() != point2.dimensionCount()) {
            return null;
        }
        double[] displacement = new double[point1.dimensionCount()];
        int i = 0;
        int n = point1.dimensionCount();
        while (i < n) {
            double diff = point2.getCoord(i) - point1.getCoord(i);
            if (this.isPeriodic()) {
                double dim = this.getDimensions().getDimension(i);
                double absDiff = Math.abs(diff);
                if (absDiff > dim / 2.0) {
                    diff = -Math.signum(diff) * (dim - absDiff);
                }
            }
            displacement[i] = diff;
            ++i;
        }
        return displacement;
    }
}

