/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor.space;

import java.util.ArrayList;
import repast.simphony.space.grid.CellAccessor;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.projection.DefaultProjection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;

public class Projected3DGrid<T>
extends DefaultProjection<T>
implements Grid<T>,
ProjectionListener {
    private Grid<T> grid;
    private int dimIndex1;
    private int dimIndex2;
    private int constantIndex;

    public Projected3DGrid(Grid<T> grid, int dimIndex1, int dimIndex2) {
        super("2D of " + grid.getName());
        this.grid = grid;
        this.grid.addProjectionListener((ProjectionListener)this);
        this.dimIndex1 = dimIndex1;
        this.dimIndex2 = dimIndex2;
        if (grid.getDimensions().size() != 3) {
            throw new IllegalArgumentException("Grid must be 3D");
        }
        if (dimIndex1 == 0) {
            if (dimIndex2 == 1) {
                this.constantIndex = 2;
            } else if (dimIndex2 == 2) {
                this.constantIndex = 1;
            }
        } else if (dimIndex1 == 1) {
            if (dimIndex2 == 2) {
                this.constantIndex = 0;
            } else if (dimIndex2 == 0) {
                this.constantIndex = 2;
            }
        } else {
            if (dimIndex2 == 0) {
                this.constantIndex = 1;
            }
            if (dimIndex2 == 1) {
                this.constantIndex = 0;
            }
        }
    }

    public int getConstantIndex() {
        return this.constantIndex;
    }

    public int getIndex1() {
        return this.dimIndex1;
    }

    public int getIndex2() {
        return this.dimIndex2;
    }

    public GridDimensions getDimensions() {
        GridDimensions dimensions = this.grid.getDimensions();
        int[] dims = new int[]{dimensions.getDimension(this.dimIndex1), dimensions.getDimension(this.dimIndex2)};
        return new GridDimensions(dims);
    }

    public void setAdder(GridAdder<T> gridAdder) {
        this.grid.setAdder(gridAdder);
    }

    public CellAccessor getCellAccessor() {
        return this.grid.getCellAccessor();
    }

    public GridAdder<T> getAdder() {
        return this.grid.getAdder();
    }

    public boolean moveTo(T object, int ... newLocation) {
        GridPoint pt = this.grid.getLocation(object);
        int[] loc = new int[3];
        loc[this.dimIndex1] = newLocation[0];
        loc[this.dimIndex2] = newLocation[1];
        loc[this.constantIndex] = pt.getCoord(this.constantIndex);
        return this.grid.moveTo(object, loc);
    }

    public GridPoint getLocation(Object obj) {
        GridPoint pt = this.grid.getLocation(obj);
        int[] loc = new int[]{pt.getCoord(this.dimIndex1), pt.getCoord(this.dimIndex2)};
        return new GridPoint(loc);
    }

    public int size() {
        return this.grid.size();
    }

    public GridPointTranslator getGridPointTranslator() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public void setGridPointTranslator(GridPointTranslator rule) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public Iterable<T> getObjects() {
        return this.grid.getObjects();
    }

    public T getObjectAt(int ... location) {
        int[] loc = new int[3];
        loc[this.dimIndex1] = location[0];
        loc[this.dimIndex2] = location[1];
        GridDimensions dimensions = this.grid.getDimensions();
        int n = dimensions.getDimension(this.constantIndex);
        int i = 0;
        while (i < n) {
            loc[this.constantIndex] = i++;
            Object obj = this.grid.getObjectAt(loc);
            if (obj == null) continue;
            return (T)obj;
        }
        return null;
    }

    public Iterable<T> getObjectsAt(int ... location) {
        int[] loc = new int[3];
        loc[this.dimIndex1] = location[0];
        loc[this.dimIndex2] = location[1];
        GridDimensions dimensions = this.grid.getDimensions();
        int n = dimensions.getDimension(this.constantIndex);
        ArrayList<Object> objs = new ArrayList<Object>();
        int i = 0;
        while (i < n) {
            loc[this.constantIndex] = i;
            Object obj = this.grid.getObjectAt(loc);
            if (obj != null) {
                objs.add(obj);
            }
            ++i;
        }
        return objs;
    }

    public T getRandomObjectAt(int ... location) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public GridPoint moveByDisplacement(T object, int ... displacement) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public GridPoint moveByVector(T object, double distance, double ... anglesInRadians) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public boolean isPeriodic() {
        return false;
    }

    public void destroy() {
        this.grid.removeProjectionListener((ProjectionListener)this);
    }

    public void projectionEventOccurred(ProjectionEvent evt) {
        this.fireProjectionEvent(evt);
    }

    public double getDistance(GridPoint point1, GridPoint point2) {
        double distanceSq = this.getDistanceSq(point1, point2);
        return Double.isNaN(distanceSq) ? distanceSq : Math.sqrt(distanceSq);
    }

    public double getDistanceSq(GridPoint point1, GridPoint point2) {
        if (point1.dimensionCount() != point2.dimensionCount()) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 0;
        while (i < 2) {
            double diff = point1.getCoord(i) - point2.getCoord(i);
            if (this.isPeriodic()) {
                int dim = this.getDimensions().getDimension(i);
                double absDiff = Math.abs(diff);
                if (absDiff > (double)(dim / 2)) {
                    diff = (double)dim - absDiff;
                }
            }
            sum += diff * diff;
            ++i;
        }
        return sum;
    }
}

