/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import repast.simphony.space.graph.Network;
import repast.simphony.visualization.editor.DefaultEdgeFinder;
import repast.simphony.visualization.editor.EdgeFinder;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.PNodeSelector;
import repast.simphony.visualization.network.PEdge;
import repast.simphony.visualization.visualization2D.Display2D;

public class NetMoveHandler
extends PDragSequenceEventHandler
implements PEditorEventListener {
    private PNodeSelector selector = new PNodeSelector();
    private PCanvas canvas;
    private Point2D nodesStartPosition;
    private EdgeFinder edgeFinder;
    private List<PEdge> curEdges = new ArrayList<PEdge>();

    public NetMoveHandler(PCanvas canvas, Display2D display, List<Network> nets) {
        this.canvas = canvas;
        this.edgeFinder = new DefaultEdgeFinder(nets, display);
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    protected boolean shouldStartDragInteraction(PInputEvent event) {
        if (super.shouldStartDragInteraction(event)) {
            this.selector.selectNodes(event.getPath().getNodeStackReference(), false);
            return this.selector.getSelectedNodes().size() > 0;
        }
        return false;
    }

    protected void startDrag(PInputEvent event) {
        super.startDrag(event);
        PNode selectedNode = this.selector.getSelectedNodes().get(0);
        selectedNode.raiseToTop();
        this.nodesStartPosition = selectedNode.getOffset();
        this.curEdges = this.edgeFinder.findEdges(selectedNode);
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        Point2D start = this.canvas.getCamera().localToView((Point2D)this.getMousePressedCanvasPoint().clone());
        Point2D current = event.getPosition();
        Point2D.Double dest = new Point2D.Double();
        ((Point2D)dest).setLocation(this.nodesStartPosition.getX() + (current.getX() - start.getX()), this.nodesStartPosition.getY() + (current.getY() - start.getY()));
        for (PNode node : this.selector.getSelectedNodes()) {
            node.setOffset(((Point2D)dest).getX(), ((Point2D)dest).getY());
        }
        for (PEdge edge : this.curEdges) {
            edge.update();
        }
    }

    protected void endDrag(PInputEvent event) {
        super.endDrag(event);
        this.selector.unselectNodes();
        this.curEdges.clear();
    }

    @Override
    public void start() {
        this.canvas.addInputEventListener((PInputEventListener)this);
    }

    @Override
    public void stop() {
        this.selector.unselectNodes();
        this.canvas.removeInputEventListener((PInputEventListener)this);
    }
}

