/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.Cursor;
import java.awt.geom.Point2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.NullLayout;
import repast.simphony.visualization.editor.AddListener;
import repast.simphony.visualization.editor.DisplayEditor2D;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.visualization2D.Display2D;

public class NetAddListener
implements AddListener {
    private NetAddHandler handler;
    private Display2D display;
    private Layout layout;

    public NetAddListener(PCanvas canvas, DisplayEditor2D editor, Display2D display) {
        this.handler = new NetAddHandler(canvas, canvas.getCamera(), editor);
        this.display = display;
        this.layout = display.getLayout();
    }

    @Override
    public boolean preAdd(Object obj, double ... location) {
        this.display.setLayout(new TmpLayout(this.display, obj, (float)location[0], (float)location[1]));
        return true;
    }

    @Override
    public void postAdd() {
        this.display.setLayout(this.layout);
    }

    @Override
    public PEditorEventListener getAddHandler() {
        return this.handler;
    }

    class NetAddHandler
    extends PBasicInputEventHandler
    implements PEditorEventListener {
        private PCanvas canvas;
        private PCamera camera;
        private DisplayEditor2D editor;

        NetAddHandler(PCanvas canvas, PCamera camera, DisplayEditor2D editor) {
            this.canvas = canvas;
            this.camera = camera;
            this.editor = editor;
        }

        @Override
        public void init() {
        }

        @Override
        public void start() {
            this.camera.addInputEventListener((PInputEventListener)this);
            this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        }

        @Override
        public void stop() {
            this.camera.removeInputEventListener((PInputEventListener)this);
            this.canvas.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void destroy() {
        }

        public void mouseClicked(PInputEvent event) {
            Point2D pt = event.getPosition();
            this.editor.addAgentAt(pt.getX(), pt.getY());
        }
    }

    static class TmpLayout
    extends NullLayout {
        float[] newLocation = new float[2];
        Display2D display;
        Object obj;

        TmpLayout(Display2D display, Object obj, float x, float y) {
            this.display = display;
            this.newLocation[0] = x;
            this.newLocation[1] = y;
            this.obj = obj;
        }

        @Override
        public float[] getLocation(Object obj) {
            PNode node = this.display.getVisualItem(obj);
            if (this.obj.equals(obj)) {
                return this.newLocation;
            }
            return new float[]{(float)node.getOffset().getX(), (float)node.getOffset().getY()};
        }
    }
}

