/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.Point;
import java.awt.geom.Point2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.nodes.PText;
import org.piccolo2d.util.PPickPath;
import org.piccolo2d.util.PStack;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.grid.GridShape;

public class GridLocationToolTip
extends PBasicInputEventHandler
implements PEditorEventListener {
    private GridShape shape;
    private PText ttNode = new PText();
    private String location = "";
    private PCamera camera;

    public GridLocationToolTip(PCamera camera) {
        this.camera = camera;
        this.ttNode.setPickable(false);
        this.ttNode.setFont(this.ttNode.getFont().deriveFont(1));
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() {
        this.camera.addChild((PNode)this.ttNode);
        this.camera.addInputEventListener((PInputEventListener)this);
    }

    @Override
    public void stop() {
        this.camera.removeChild((PNode)this.ttNode);
        this.camera.removeInputEventListener((PInputEventListener)this);
    }

    public void mouseEntered(PInputEvent evt) {
        this.findShape(evt);
        this.updateToolTip(evt);
    }

    public void mouseExited(PInputEvent evt) {
        this.updateToolTip(evt);
    }

    public void mouseMoved(PInputEvent evt) {
        this.updateToolTip(evt);
    }

    public void mouseDragged(PInputEvent evt) {
        this.updateToolTip(evt);
    }

    public void updateToolTip(PInputEvent event) {
        if (this.shape == null) {
            this.location = "";
        } else {
            String newLoc;
            Point xy = this.shape.getXY(event.getPosition());
            String string = newLoc = xy == null ? null : String.valueOf(xy.getX()) + ", " + xy.getY();
            if (newLoc == null) {
                newLoc = "";
            }
            if (!this.location.equals(newLoc)) {
                this.location = newLoc;
            }
        }
        Point2D p = event.getCanvasPosition();
        event.getPath().canvasToLocal(p, (PNode)this.camera);
        this.ttNode.setText(this.location);
        this.ttNode.setOffset(p.getX() + 8.0, p.getY() - 8.0);
    }

    private void findShape(PInputEvent evt) {
        PPickPath path = evt.getInputManager().getMouseOver();
        PStack pNodes = path.getNodeStackReference();
        for (PNode node : pNodes) {
            if (!(node instanceof GridShape)) continue;
            this.shape = (GridShape)node;
        }
    }
}

