/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import repast.simphony.space.grid.CellAccessor;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.visualization.editor.AddListener;
import repast.simphony.visualization.editor.GridAddHandler;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.space.Projected3DGrid;

public class GridAddListener
implements AddListener {
    private Grid grid;
    private GridAdder adder;
    private LocationAdder locAdder;
    private int[] location;
    private int constantIndex = -1;
    private int dimIndex1;
    private int dimIndex2;
    private GridAddHandler handler;

    public GridAddListener(Grid grid, GridAddHandler handler) {
        this.grid = grid;
        this.adder = grid.getAdder();
        if (grid instanceof Projected3DGrid) {
            this.location = new int[3];
            Projected3DGrid pGrid = (Projected3DGrid)grid;
            this.constantIndex = pGrid.getConstantIndex();
            this.dimIndex1 = pGrid.getIndex1();
            this.dimIndex2 = pGrid.getIndex2();
        } else {
            this.location = new int[grid.getDimensions().size()];
        }
        this.locAdder = new LocationAdder();
        this.handler = handler;
    }

    @Override
    public boolean preAdd(Object obj, double ... point) {
        if (this.constantIndex == -1) {
            int i = 0;
            while (i < this.location.length) {
                this.location[i] = (int)point[i];
                ++i;
            }
        } else {
            this.location[this.constantIndex] = 0;
            this.location[this.dimIndex1] = (int)point[0];
            this.location[this.dimIndex2] = (int)point[1];
        }
        CellAccessor accessor = this.grid.getCellAccessor();
        if (accessor.allowsMultiOccupancy() || this.grid.getObjectAt(this.location) == null) {
            this.locAdder.initLocation(this.location);
            this.grid.setAdder((GridAdder)this.locAdder);
            return true;
        }
        return false;
    }

    @Override
    public void postAdd() {
        this.grid.setAdder(this.adder);
    }

    @Override
    public PEditorEventListener getAddHandler() {
        return this.handler;
    }

    class LocationAdder<Object>
    implements GridAdder<Object> {
        private int[] location;

        LocationAdder() {
        }

        public void initLocation(int[] location) {
            this.location = location;
        }

        public void add(Grid<Object> destination, Object object) {
            destination.moveTo(object, this.location);
        }
    }
}

