/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.Cursor;
import java.awt.Point;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.util.PPickPath;
import org.piccolo2d.util.PStack;
import repast.simphony.space.grid.Grid;
import repast.simphony.visualization.editor.DisplayEditor2D;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.grid.GridShape;

public class GridAddHandler
extends PBasicInputEventHandler
implements PEditorEventListener {
    private Grid grid;
    private GridShape shape;
    private PCamera camera;
    private DisplayEditor2D editor;
    private PCanvas canvas;

    public GridAddHandler(PCanvas canvas, DisplayEditor2D editor, Grid grid) {
        this.camera = canvas.getCamera();
        this.editor = editor;
        this.canvas = canvas;
        this.grid = grid;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() {
        this.camera.addInputEventListener((PInputEventListener)this);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void stop() {
        this.camera.removeInputEventListener((PInputEventListener)this);
        this.canvas.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseEntered(PInputEvent evt) {
        this.findShape(evt);
    }

    public void mouseClicked(PInputEvent evt) {
        if (this.shape != null) {
            if (evt.isLeftMouseButton()) {
                Point xy = this.shape.getXY(evt.getPosition());
                if (xy != null) {
                    int[] origin = this.grid.getDimensions().originToIntArray(null);
                    int xOffset = origin[0];
                    int yOffset = origin[1];
                    this.editor.addAgentAt(xy.getX() - (double)xOffset, xy.getY() - (double)yOffset);
                }
            } else if (evt.isRightMouseButton()) {
                this.editor.addCanceled();
            }
        }
    }

    private void findShape(PInputEvent evt) {
        PPickPath path = evt.getInputManager().getMouseOver();
        PStack pNodes = path.getNodeStackReference();
        for (PNode node : pNodes) {
            if (!(node instanceof GridShape)) continue;
            this.shape = (GridShape)node;
        }
    }
}

