/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.ui.probe.ProbeID;
import repast.simphony.util.ClassUtilities;

public class FloatingList {
    private JList list;
    private JPopupMenu popup;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();

    public FloatingList(Object ... items) {
        this.list = new JList<Object>(items);
        this.list.setCellRenderer(new CellRenderer());
        this.list.setFont(this.list.getFont().deriveFont(10.0f));
        this.list.setVisibleRowCount(2);
        this.list.setSelectedIndex(0);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FloatingList.this.popup.setVisible(false);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FloatingList.this.popup.setVisible(false);
                }
            }
        });
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public Object[] getSelectedItems() {
        return this.list.getSelectedValues();
    }

    public void show(JComponent comp, int x, int y) {
        this.popup = new JPopupMenu();
        this.popup.add(this.list);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FloatingList.this.fireItemSelected();
            }
        });
        this.popup.show(comp, x, y);
        this.list.requestFocus();
    }

    private void fireItemSelected() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this.list, 0, "itemSelected"));
        }
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String title = this.probeForTitle(value);
            if (title == null) {
                title = value.getClass().getName();
                title = title.substring(title.lastIndexOf("."), title.length());
            }
            return super.getListCellRendererComponent((JList<?>)list, String.format("%-30s", title), index, isSelected, cellHasFocus);
        }

        private String probeForTitle(Object obj) {
            String target;
            RepastEdge edge;
            String source;
            Method method;
            Method[] methods = ClassUtilities.findMethods(obj.getClass(), (Class[])new Class[]{ProbeID.class});
            if (methods.length > 0 && !(method = methods[0]).getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0) {
                try {
                    return method.invoke(obj, new Object[0]).toString();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (obj instanceof RepastEdge && (source = this.probeForTitle((edge = (RepastEdge)obj).getSource())) != null && (target = this.probeForTitle(edge.getTarget())) != null) {
                return edge.isDirected() ? String.valueOf(source) + " -> " + target : String.valueOf(source) + " <-> " + target;
            }
            return null;
        }
    }
}

