/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editedStyle;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XStream11XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Method;
import org.jscience.physics.amount.Amount;
import repast.simphony.scenario.ScenarioUtils;
import repast.simphony.visualization.editedStyle.EditedEdgeStyleData;
import repast.simphony.visualization.editedStyle.EditedStyleData;
import repast.simphony.visualization.editedStyle.EditedValueLayerStyleData;
import repast.simphony.visualization.editedStyle.PaintableStyleData;
import repast.simphony.visualization.editedStyle.SizeableStyleData;
import simphony.util.messages.MessageCenter;

public class EditedStyleUtils {
    public static String getStyleDirName() {
        return ScenarioUtils.getScenarioDir() + File.separator + "styles";
    }

    public static EditedStyleData<Object> getStyle(String userStyleFile) {
        EditedStyleData style = null;
        XStream stream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        stream.setClassLoader(EditedStyleData.class.getClassLoader());
        if (userStyleFile == null) {
            return null;
        }
        try {
            FileReader file = new FileReader(new File(EditedStyleUtils.getStyleDirName(), userStyleFile));
            style = (EditedStyleData)stream.fromXML((Reader)file);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return style;
    }

    public static EditedValueLayerStyleData getValueLayerStyle(String userStyleFile) {
        EditedValueLayerStyleData style = null;
        XStream stream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        stream.setClassLoader(EditedValueLayerStyleData.class.getClassLoader());
        if (userStyleFile == null) {
            return null;
        }
        try {
            FileReader file = new FileReader(new File(EditedStyleUtils.getStyleDirName(), userStyleFile));
            style = (EditedValueLayerStyleData)stream.fromXML((Reader)file);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return style;
    }

    public static EditedEdgeStyleData<Object> getEdgeStyle(String userStyleFile) {
        EditedEdgeStyleData style = null;
        XStream stream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        stream.setClassLoader(EditedStyleData.class.getClassLoader());
        if (userStyleFile == null) {
            return null;
        }
        try {
            FileReader file = new FileReader(new File(EditedStyleUtils.getStyleDirName(), userStyleFile));
            style = (EditedEdgeStyleData)stream.fromXML((Reader)file);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return style;
    }

    public static float getSize(SizeableStyleData style, Object object) {
        float size = style.getSize();
        if (style.getSizeMethodName() == null) {
            return size;
        }
        size = EditedStyleUtils.getMethodFloat(style.getSizeMethodName(), object);
        float sizeMax = style.getSizeMax();
        float sizeMin = style.getSizeMin();
        float sizeScale = style.getSizeScale();
        float div = sizeMax - sizeMin;
        if (div <= 0.0f) {
            div = 1.0f;
        }
        size = (size - sizeMin) / div * sizeScale;
        return size;
    }

    public static String getLabel(EditedStyleData style, Object object) {
        String label = style.getLabel();
        if (style.getLabelMethod() == null) {
            return label;
        }
        String methodName = style.getLabelMethod();
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            if (method.getReturnType().equals(String.class)) {
                return (String)method.invoke(object, new Object[0]);
            }
            if (method.getReturnType().equals(Amount.class)) {
                return ((Amount)method.invoke(object, new Object[0])).toString();
            }
            label = ((Number)method.invoke(object, new Object[0])).toString();
            int precision = style.getLabelPrecision();
            int labelLength = label.indexOf(46) + precision + 1;
            if (labelLength < label.length()) {
                label = label.substring(0, labelLength);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return label;
    }

    public static float getMethodFloat(String methodName, Object object) {
        Method method;
        block9: {
            method = object.getClass().getMethod(methodName, new Class[0]);
            if (!method.getReturnType().equals(Amount.class)) break block9;
            Amount amnt = (Amount)method.invoke(object, new Object[0]);
            if (amnt != null) {
                return (float)amnt.getEstimatedValue();
            }
            return 0.0f;
        }
        try {
            Number nmbr = (Number)method.invoke(object, new Object[0]);
            if (nmbr != null) {
                return nmbr.floatValue();
            }
            return 0.0f;
        }
        catch (ClassCastException e) {
            try {
                Method method2 = object.getClass().getMethod(methodName, new Class[0]);
                MessageCenter.getMessageCenter(EditedStyleUtils.class).warn((Object)("Edited style tried to call " + object + "." + methodName + " and was expecting a numerical value but received a " + method2.getReturnType()), null);
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0f;
    }

    public static Color getColor(PaintableStyleData style, Object object) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        if (style.getRedMethod() == null) {
            red = style.getColor()[0];
        } else {
            red = EditedStyleUtils.getMethodFloat(style.getRedMethod(), object);
            red = Math.max(Math.min((red - style.getColorMin()[0]) / (style.getColorMax()[0] - style.getColorMin()[0]) * style.getColorScale()[0], 1.0f), 0.0f);
        }
        if (style.getBlueMethod() == null) {
            blue = style.getColor()[2];
        } else {
            blue = EditedStyleUtils.getMethodFloat(style.getBlueMethod(), object);
            blue = Math.max(Math.min((blue - style.getColorMin()[2]) / (style.getColorMax()[2] - style.getColorMin()[2]) * style.getColorScale()[2], 1.0f), 0.0f);
        }
        if (style.getGreenMethod() == null) {
            green = style.getColor()[1];
        } else {
            green = EditedStyleUtils.getMethodFloat(style.getGreenMethod(), object);
            green = Math.max(Math.min((green - style.getColorMin()[1]) / (style.getColorMax()[1] - style.getColorMin()[1]) * style.getColorScale()[1], 1.0f), 0.0f);
        }
        return new Color(red, green, blue);
    }

    public static Color getValueLayerColor(EditedValueLayerStyleData style, double val) {
        float[] rgb = new float[3];
        int i = 0;
        while (i < 3) {
            if (style.getColorValue()[i]) {
                rgb[i] = (float)val;
                rgb[i] = Math.max(Math.min((rgb[i] - style.getColorMin()[i]) / (style.getColorMax()[i] - style.getColorMin()[i]) * style.getColorScale()[i], 1.0f), 0.0f);
            } else {
                rgb[i] = style.getColor()[i];
            }
            ++i;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

