/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editedStyle;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import repast.simphony.visualization.editedStyle.DefaultEditedStyleData2D;
import repast.simphony.visualization.editedStyle.EditedStyleData;
import repast.simphony.visualization.editedStyle.EditedStyleUtils;
import repast.simphony.visualization.gui.styleBuilder.IconFactory2D;
import repast.simphony.visualizationOGL2D.ImageSpatialSource;
import repast.simphony.visualizationOGL2D.StyleOGL2D;
import saf.v3d.NamedShapeCreator;
import saf.v3d.ShapeFactory2D;
import saf.v3d.scene.Position;
import saf.v3d.scene.VSpatial;
import simphony.util.messages.MessageCenter;

public class EditedStyleOGL2D
implements StyleOGL2D<Object> {
    private static int counter = 0;
    private static final MessageCenter msg = MessageCenter.getMessageCenter(EditedStyleOGL2D.class);
    private EditedStyleData<Object> style;
    private String id = String.valueOf(++counter);
    private ShapeFactory2D factory;
    private float xOffset;
    private float yOffset;
    private Font font;
    private Position position;
    private Color labelColor;
    private float origSize;

    public EditedStyleOGL2D(String styleFile) {
        this.style = EditedStyleUtils.getStyle(styleFile);
        if (this.style == null) {
            this.style = new DefaultEditedStyleData2D<Object>();
        }
        this.font = new Font(this.style.getLabelFontFamily(), this.style.getLabelFontType(), this.style.getLabelFontSize());
        float[] colorRGB = this.style.getLabelColor();
        this.labelColor = new Color(colorRGB[0], colorRGB[1], colorRGB[2]);
        String pos = this.style.getLabelPosition();
        if (pos.equals("right")) {
            this.position = Position.EAST;
            this.xOffset = this.style.getLabelOffset();
            this.yOffset = 0.0f;
        } else if (pos.equals("left")) {
            this.position = Position.WEST;
            this.xOffset = this.style.getLabelOffset();
            this.yOffset = 0.0f;
        } else if (pos.equals("top")) {
            this.position = Position.NORTH;
            this.xOffset = 0.0f;
            this.yOffset = this.style.getLabelOffset();
        } else {
            this.position = Position.SOUTH;
            this.xOffset = 0.0f;
            this.yOffset = this.style.getLabelOffset();
        }
    }

    @Override
    public void init(ShapeFactory2D factory) {
        this.origSize = this.style.getSize();
        HashMap<String, String> props = new HashMap<String, String>();
        this.factory = factory;
        if (this.style.getIconFile2D() != null) {
            try {
                ImageSpatialSource source = new ImageSpatialSource(this.id, this.style.getIconFile2D());
                if (this.origSize != -1.0f) {
                    props.put("width", String.valueOf(this.origSize));
                    props.put("height", String.valueOf(this.origSize));
                }
                source.registerSource(factory, props);
            }
            catch (IOException ex) {
                msg.error((Object)"Error while initializing edited style", (Throwable)ex, new Object[0]);
            }
        } else {
            String wkt = this.style.getShapeWkt();
            Shape shape = IconFactory2D.getShape(wkt);
            Rectangle2D bounds = shape.getBounds2D();
            float size = this.origSize == -1.0f ? 15.0f : this.origSize;
            float scaleX = size / (float)bounds.getWidth();
            float scaleY = size / (float)bounds.getWidth();
            shape = AffineTransform.getScaleInstance(scaleX, scaleY).createTransformedShape(shape);
            GeneralPath path = new GeneralPath(shape);
            path.closePath();
            NamedShapeCreator creator = factory.createNamedShape(this.id);
            creator.addShape(path.createTransformedShape(new AffineTransform()), Color.BLACK, true);
            creator.registerShape();
        }
    }

    @Override
    public VSpatial getVSpatial(Object object, VSpatial spatial) {
        if (spatial == null) {
            return this.factory.getNamedSpatial(this.id);
        }
        return spatial;
    }

    @Override
    public Color getColor(Object object) {
        return EditedStyleUtils.getColor(this.style, object);
    }

    @Override
    public int getBorderSize(Object object) {
        return 0;
    }

    @Override
    public Color getBorderColor(Object object) {
        return null;
    }

    @Override
    public float getRotation(Object object) {
        return 0.0f;
    }

    @Override
    public float getScale(Object object) {
        float size = EditedStyleUtils.getSize(this.style, object);
        if (size == -1.0f) {
            return 1.0f;
        }
        return size / this.origSize;
    }

    @Override
    public String getLabel(Object object) {
        return EditedStyleUtils.getLabel(this.style, object);
    }

    @Override
    public Font getLabelFont(Object object) {
        return this.font;
    }

    @Override
    public float getLabelXOffset(Object object) {
        return this.xOffset;
    }

    @Override
    public float getLabelYOffset(Object object) {
        return this.yOffset;
    }

    @Override
    public Position getLabelPosition(Object object) {
        return this.position;
    }

    @Override
    public Color getLabelColor(Object object) {
        return this.labelColor;
    }
}

