/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editedStyle;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import repast.simphony.visualization.editedStyle.DefaultEditedStyleData3D;
import repast.simphony.visualization.editedStyle.EditedStyleData;
import repast.simphony.visualization.editedStyle.EditedStyleUtils;
import repast.simphony.visualization.editedStyle.ModelLoaderUtils;
import repast.simphony.visualization.visualization3D.AppearanceFactory;
import repast.simphony.visualization.visualization3D.ShapeFactory;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualization.visualization3D.style.TaggedAppearance;
import repast.simphony.visualization.visualization3D.style.TaggedBranchGroup;

public class EditedStyle3D
implements Style3D<Object> {
    EditedStyleData<Object> innerStyle;
    Texture texture;
    BranchGroup modelGroup;

    public EditedStyle3D(String userStyleFile) {
        Loader loader;
        String modelFile;
        this.innerStyle = EditedStyleUtils.getStyle(userStyleFile);
        if (this.innerStyle == null) {
            this.innerStyle = new DefaultEditedStyleData3D<Object>();
        }
        String textureFile = this.innerStyle.getTextureFile3D();
        this.texture = null;
        if (textureFile != null) {
            this.texture = new TextureLoader(textureFile, "RGB", (Component)new Container()).getTexture();
            this.texture.setBoundaryModeS(3);
            this.texture.setBoundaryModeT(3);
        }
        if ((modelFile = this.innerStyle.getModelFile3D()) != null && (loader = ModelLoaderUtils.getLoaderForFile(modelFile)) != null) {
            this.modelGroup = new BranchGroup();
            try {
                Scene scene = loader.load(this.innerStyle.getModelFile3D());
                this.modelGroup = scene.getSceneGroup();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IncorrectFormatException e) {
                e.printStackTrace();
            }
            catch (ParsingErrorException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public TaggedBranchGroup getBranchGroup(Object o, TaggedBranchGroup taggedGroup) {
        Shape3D shape = null;
        String wkt = this.innerStyle.getShapeWkt();
        float size = EditedStyleUtils.getSize(this.innerStyle, o);
        int primFlags = 1;
        Appearance ap = null;
        if (taggedGroup == null || taggedGroup.getTag() == null) {
            taggedGroup = new TaggedBranchGroup("DEFAULT");
            if (this.texture != null) {
                TextureAttributes texAttr = new TextureAttributes();
                texAttr.setTextureMode(2);
                ap = new Appearance();
                ap.setCapability(3);
                ap.setCapability(2);
                ap.setTexture(this.texture);
                ap.setTextureAttributes(texAttr);
                primFlags = 3;
            }
            if (this.modelGroup != null) {
                BranchGroup aGroup = new BranchGroup();
                Enumeration e = this.modelGroup.getAllChildren();
                while (e.hasMoreElements()) {
                    Node node = (Node)e.nextElement();
                    node.setCapability(15);
                    aGroup.addChild(node.cloneNode(true));
                }
                taggedGroup.getBranchGroup().addChild((Node)aGroup);
                return taggedGroup;
            }
            if ("sphere".equals(wkt)) {
                shape = ShapeFactory.createSphere(1.0f, 15, "DEFAULT", primFlags, ap);
            } else if ("cube".equals(wkt)) {
                shape = ShapeFactory.createBox(1.0f, 1.0f, 1.0f, "DEFAULT", primFlags, ap);
            } else if ("cylinder".equals(wkt)) {
                shape = ShapeFactory.createCylinder(1.0f, 2.0f, "DEFAULT", primFlags, ap);
            } else if ("cone".equals(wkt)) {
                shape = ShapeFactory.createCone(1.0f, 2.0f, "DEFAULT", primFlags, ap);
            }
            taggedGroup.getBranchGroup().addChild((Node)shape);
            return taggedGroup;
        }
        return null;
    }

    @Override
    public float[] getRotation(Object o) {
        return null;
    }

    @Override
    public String getLabel(Object o, String currentLabel) {
        return EditedStyleUtils.getLabel(this.innerStyle, o);
    }

    @Override
    public Color getLabelColor(Object t, Color currentColor) {
        float[] colorRGB = this.innerStyle.getLabelColor();
        return new Color(colorRGB[0], colorRGB[1], colorRGB[2]);
    }

    @Override
    public Font getLabelFont(Object t, Font currentFont) {
        return new Font(this.innerStyle.getLabelFontFamily(), this.innerStyle.getLabelFontType(), this.innerStyle.getLabelFontSize());
    }

    @Override
    public Style3D.LabelPosition getLabelPosition(Object o, Style3D.LabelPosition curentPosition) {
        if ("right".equals(this.innerStyle.getLabelPosition())) {
            return Style3D.LabelPosition.WEST;
        }
        if ("left".equals(this.innerStyle.getLabelPosition())) {
            return Style3D.LabelPosition.EAST;
        }
        if ("bottom".equals(this.innerStyle.getLabelPosition())) {
            return Style3D.LabelPosition.SOUTH;
        }
        return Style3D.LabelPosition.NORTH;
    }

    @Override
    public float getLabelOffset(Object t) {
        return this.innerStyle.getLabelOffset();
    }

    @Override
    public TaggedAppearance getAppearance(Object t, TaggedAppearance taggedAppearance, Object shapeID) {
        if (this.texture != null) {
            return taggedAppearance;
        }
        if (taggedAppearance == null || taggedAppearance.getTag() == null) {
            taggedAppearance = new TaggedAppearance("DEFAULT");
        }
        Color color = EditedStyleUtils.getColor(this.innerStyle, t);
        AppearanceFactory.setMaterialAppearance(taggedAppearance.getAppearance(), color);
        return taggedAppearance;
    }

    @Override
    public float[] getScale(Object o) {
        float size = EditedStyleUtils.getSize(this.innerStyle, o);
        return new float[]{size, size, size};
    }
}

