/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editedStyle;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.visualization.editedStyle.DefaultEditedEdgeStyleData2D;
import repast.simphony.visualization.editedStyle.EditedEdgeStyleData;
import repast.simphony.visualization.editedStyle.EditedStyleUtils;
import repast.simphony.visualization.editedStyle.LineStyle;
import repast.simphony.visualization.visualization2D.style.EdgeStyle2D;

public class EditedEdgeStyle2D
implements EdgeStyle2D {
    EditedEdgeStyleData<Object> innerStyle;
    int directedTargetEnd = 1;

    public EditedEdgeStyle2D(String userStyleFile) {
        this.innerStyle = EditedStyleUtils.getEdgeStyle(userStyleFile);
        if (this.innerStyle == null) {
            this.innerStyle = new DefaultEditedEdgeStyleData2D<Object>();
        }
    }

    @Override
    public Paint getPaint(RepastEdge edge) {
        return EditedStyleUtils.getColor(this.innerStyle, edge);
    }

    @Override
    public Stroke getStroke(RepastEdge edge) {
        LineStyle lineStyle = this.innerStyle.getLineStyle();
        float[] dash = lineStyle == LineStyle.DASH ? new float[]{10.0f, 10.0f} : (lineStyle == LineStyle.DASH_DOT ? new float[]{10.0f, 4.0f, 2.0f, 4.0f} : (lineStyle == LineStyle.DASH_DASH_DOT ? new float[]{10.0f, 4.0f, 10.0f, 4.0f, 2.0f, 4.0f} : null));
        float width = EditedStyleUtils.getSize(this.innerStyle, edge);
        return new BasicStroke(width, 0, 0, 10.0f, dash, 0.0f);
    }

    @Override
    public Paint getSourceEndPaint(RepastEdge edge) {
        return EditedStyleUtils.getColor(this.innerStyle, edge);
    }

    @Override
    public int getSourceEndStyle(RepastEdge edge) {
        return 0;
    }

    @Override
    public Paint getTargetEndPaint(RepastEdge edge) {
        return EditedStyleUtils.getColor(this.innerStyle, edge);
    }

    @Override
    public int getTargetEndStyle(RepastEdge edge) {
        if (edge.isDirected()) {
            return this.directedTargetEnd;
        }
        return 0;
    }
}

