/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.cgd.graph;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import repast.simphony.visualization.cgd.graph.CGDGraph;
import repast.simphony.visualization.cgd.graph.CGDNode;
import repast.simphony.visualization.cgd.util.CGDTreeSet;
import repast.simphony.visualization.cgd.util.Clan;
import repast.simphony.visualization.cgd.util.ParseClanTree;

public class GraphUtil {
    public double distH = 30.0;
    public double distV = 40.0;
    private double scale = 1.0;
    private CGDGraph graph = null;
    private ParseClanTree[] treeLookup;
    private int numNodes;
    private int initialNumNodes;
    private TreeSet[] parentRelation;

    public double getHDistance() {
        return 1.0 / this.scale * this.distH;
    }

    public double getVDistance() {
        return 1.0 / this.scale * this.distV;
    }

    public void buildNodeLayout(CGDGraph _graph, ParseClanTree _root, int _numNodes, int _initialNumNodes, TreeSet[] parentRel) {
        this.graph = _graph;
        this.numNodes = _numNodes;
        this.parentRelation = parentRel;
        this.initialNumNodes = _initialNumNodes;
        this.bbSizeAttribute(_root, false);
        this.fillLeftSiblings(_root);
        this.bbCornerAttribute(_root);
        this.treeLookup = new ParseClanTree[this.numNodes];
        this.setLookup(_root);
        this.setHeightInTree(_root, 0);
        this.longEdgeHeuristic();
        this.treeLookup = new ParseClanTree[this.numNodes];
        this.setLookup(_root);
        this.bbSizeAttribute(_root, true);
        this.bbCornerAttribute(_root);
        this.realSizes(_root);
        this.angleFix();
        this.angleFix();
        CGDNode first_source = _graph.getNode(0);
        int i = 0;
        while (i < this.numNodes) {
            if (this.parentRelation[i].isEmpty()) {
                first_source = _graph.getNode(i);
                break;
            }
            ++i;
        }
        Point2D.Double offset = first_source.getPosition();
        this.copyCorner(_root);
        this.removeBends();
        Point2D.Double pos = first_source.getPosition();
        offset.x -= pos.x;
        offset.y -= pos.y;
        ArrayList nodes = _graph.getNodes();
        int j = 0;
        while (j < nodes.size()) {
            CGDNode tmpnode = (CGDNode)nodes.get(j);
            pos = tmpnode.getPosition();
            tmpnode.setPosition(pos.x + offset.x, pos.y + offset.y);
            ++j;
        }
    }

    private void bbSizeAttribute(ParseClanTree node, boolean repeat) {
        if (node == null) {
            return;
        }
        this.bbSizeAttribute(node.firstChild, repeat);
        node.extraheight = 0.0;
        node.size = this.bbSize(node, repeat);
        this.bbSizeAttribute(node.nextSibling, repeat);
    }

    private Point2D.Double bbSize(ParseClanTree node, boolean repeat) {
        Point2D.Double size = new Point2D.Double(0.0, 0.0);
        if (node.clan.clanType == 2) {
            size.x = this.childMax(node, 1);
            size.y = this.childSum(node, 2);
        } else if (node.clan.clanType == 5) {
            if (!repeat) {
                size = this.graph.getNode(node.clan.id).getBoundingBox();
                size.x += this.distH;
                size.y += this.distV;
            } else {
                size.x = node.size.x;
                size.y = node.size.y;
            }
        } else {
            size.y = node.size.y < this.childMax(node, 2) ? this.childMax(node, 2) : node.size.y;
            this.setExtras(node, size.y);
            size.x = this.childSum(node, 1);
        }
        return size;
    }

    private double childMax(ParseClanTree node, int axis) {
        double max = 0.0;
        ParseClanTree child = node.firstChild;
        while (child != null) {
            if (axis == 1 && child.size.x > max || axis == 2 && child.size.y > max) {
                max = axis == 1 ? child.size.x : child.size.y;
            }
            child = child.nextSibling;
        }
        return max;
    }

    private double childSum(ParseClanTree node, int axis) {
        double sum = 0.0;
        ParseClanTree child = node.firstChild;
        while (child != null) {
            sum += axis == 1 ? child.size.x : child.size.y;
            child = child.nextSibling;
        }
        return sum;
    }

    private void setExtras(ParseClanTree node, double height) {
        ParseClanTree child = node.firstChild;
        while (child != null) {
            if (child.clan.clanType == 2 && child.size.y < height) {
                int children = 0;
                ParseClanTree tmp = child.firstChild;
                while (tmp != null) {
                    ++children;
                    tmp = tmp.nextSibling;
                }
                if (children > 1) {
                    child.extraheight = (height - child.size.y) / (double)(children - 1);
                    child.size.y = height;
                }
            }
            child = child.nextSibling;
        }
    }

    private void fillLeftSiblings(ParseClanTree node) {
        ParseClanTree tmpnode = node.firstChild;
        ParseClanTree prevnode = null;
        while (tmpnode != null) {
            tmpnode.leftSibling = prevnode;
            prevnode = tmpnode;
            tmpnode = tmpnode.nextSibling;
        }
        tmpnode = node.firstChild;
        while (tmpnode != null) {
            this.fillLeftSiblings(tmpnode);
            tmpnode = tmpnode.nextSibling;
        }
    }

    private void bbCornerAttribute(ParseClanTree node) {
        if (node == null) {
            return;
        }
        if (node.parent == null) {
            node.position.x = 0.0;
            node.position.y = 0.0;
        } else if (node.parent.clan.clanType == 2) {
            node.position.x = node.parent.position.x + (node.parent.size.x - node.size.x) / 2.0;
            node.position.y = node.leftSibling != null ? node.leftSibling.position.y - node.leftSibling.size.y - node.parent.extraheight : node.parent.position.y;
        } else {
            node.position.y = node.parent.position.y - (node.parent.size.y - node.size.y) / 2.0;
            node.position.x = node.leftSibling != null ? node.leftSibling.position.x + node.leftSibling.size.x : node.parent.position.x;
        }
        this.bbCornerAttribute(node.firstChild);
        this.bbCornerAttribute(node.nextSibling);
    }

    private void setLookup(ParseClanTree node) {
        if (node == null) {
            return;
        }
        if (node.clan.clanType == 5) {
            this.treeLookup[node.clan.id] = node;
        }
        this.setLookup(node.firstChild);
        this.setLookup(node.nextSibling);
    }

    private void setHeightInTree(ParseClanTree node, int height) {
        if (node == null) {
            return;
        }
        node.heightInTree = height;
        this.setHeightInTree(node.firstChild, height + 1);
        this.setHeightInTree(node.nextSibling, height);
    }

    private void longEdgeHeuristic() {
        int old_numnodes = this.numNodes;
        int i = 0;
        while (i < old_numnodes) {
            if (this.graph.getNode(i) != null) {
                CGDTreeSet children = (CGDTreeSet)this.graph.getNode(i).getChildren().clone();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    ParseClanTree tmpnode;
                    ParseClanTree right_node;
                    ParseClanTree left_node;
                    int j = (Integer)it.next();
                    ParseClanTree nodei = this.treeLookup[i];
                    ParseClanTree nodej = this.treeLookup[j];
                    int topnode = i;
                    int bottomnode = j;
                    ParseClanTree sparenti = nodei.parent;
                    ParseClanTree sparentj = nodej.parent;
                    while (sparenti != null && sparenti.clan.clanType != 2) {
                        sparenti = sparenti.parent;
                    }
                    while (sparentj != null && sparentj.clan.clanType != 2) {
                        sparentj = sparentj.parent;
                    }
                    if (sparenti == null || sparentj == null) continue;
                    ParseClanTree lca = nodei;
                    ParseClanTree lca2 = nodej;
                    while (lca.parent != lca2.parent) {
                        if (lca.heightInTree >= lca2.heightInTree) {
                            lca = lca.parent;
                        }
                        if (lca.heightInTree >= lca2.heightInTree) continue;
                        lca2 = lca2.parent;
                    }
                    while (lca2 != null && lca2 != lca) {
                        lca2 = lca2.nextSibling;
                    }
                    if (lca2 == null) {
                        left_node = nodei;
                        right_node = nodej;
                    } else {
                        left_node = nodej;
                        right_node = nodei;
                    }
                    lca = lca.parent;
                    while (left_node.parent != lca) {
                        if (left_node.parent.clan.clanType == 2) {
                            tmpnode = left_node.nextSibling;
                            while (tmpnode != null) {
                                topnode = this.addDummy(tmpnode, topnode, bottomnode, nodei, nodej);
                                tmpnode = tmpnode.nextSibling;
                            }
                        }
                        left_node = left_node.parent;
                    }
                    while (right_node.parent != lca) {
                        if (right_node.parent.clan.clanType == 2) {
                            tmpnode = right_node.leftSibling;
                            while (tmpnode != null) {
                                bottomnode = this.addDummy(tmpnode, topnode, bottomnode, nodei, nodej);
                                tmpnode = tmpnode.leftSibling;
                            }
                        }
                        right_node = right_node.parent;
                    }
                    left_node = left_node.nextSibling;
                    while (left_node != right_node) {
                        topnode = this.addDummy(left_node, topnode, bottomnode, nodei, nodej);
                        left_node = left_node.nextSibling;
                    }
                }
            }
            ++i;
        }
    }

    public int addDummy(ParseClanTree treenode, int top, int bottom, ParseClanTree edgesource, ParseClanTree edgesink) {
        ++this.numNodes;
        int newnodeindex = this.graph.getNodes().size();
        this.graph.removeEdge(top, bottom);
        this.graph.addEdge(top, newnodeindex);
        this.graph.addEdge(newnodeindex, bottom);
        this.graph.addNode(newnodeindex);
        if (treenode.clan.clanType == 5) {
            ParseClanTree copy = new ParseClanTree();
            copy.clan = treenode.clan;
            copy.size.setLocation(treenode.size);
            copy.position.setLocation(treenode.position);
            copy.parent = treenode;
            treenode.clan = new Clan(1, new CGDTreeSet(), null, null, 0);
            treenode.firstChild = copy;
        }
        ParseClanTree tnode = new ParseClanTree();
        CGDTreeSet newTreeSet = new CGDTreeSet();
        newTreeSet.add(newnodeindex);
        tnode.clan = new Clan(5, newTreeSet, null, null, 0);
        tnode.clan.id = newnodeindex;
        tnode.parent = treenode;
        double x1 = edgesource.position.x + edgesource.size.x / 2.0;
        double y1 = edgesource.position.y + edgesource.size.y / 2.0;
        double x2 = edgesink.position.x + edgesink.size.x / 2.0;
        double y2 = edgesink.position.y + edgesink.size.y / 2.0;
        double y = treenode.position.y + treenode.size.y / 2.0;
        double idealx = x2 + (x1 - x2) / (y1 - y2) * (y - y2);
        int closest = 0;
        int index = 1;
        double cdist = Math.abs(treenode.position.x - idealx);
        ParseClanTree tmpnode = treenode.firstChild;
        while (tmpnode != null) {
            if (Math.abs(tmpnode.position.x + tmpnode.size.x - idealx) <= cdist) {
                cdist = Math.abs(tmpnode.position.x + tmpnode.size.x - idealx);
                closest = index;
            }
            ++index;
            tmpnode = tmpnode.nextSibling;
        }
        if (closest == 0) {
            tnode.nextSibling = treenode.firstChild;
            treenode.firstChild = tnode;
        } else {
            tmpnode = treenode.firstChild;
            index = 1;
            while (index < closest) {
                tmpnode = tmpnode.nextSibling;
                ++index;
            }
            tnode.nextSibling = tmpnode.nextSibling;
            tmpnode.nextSibling = tnode;
            tnode.leftSibling = tmpnode;
        }
        if (tnode.nextSibling != null) {
            tnode.nextSibling.leftSibling = tnode;
        }
        tnode.size.setLocation(this.distH, this.distV);
        CGDNode newnode = this.graph.getNode(newnodeindex);
        newnode.setBoundingBox(this.distH, this.distV);
        return newnodeindex;
    }

    private void realSizes(ParseClanTree node) {
        if (node == null) {
            return;
        }
        if (node.parent != null) {
            if (node.parent.clan.clanType == 2) {
                node.size.x = node.parent.size.x;
                node.position.x = node.parent.position.x;
            } else {
                node.size.y = node.parent.size.y;
                node.position.y = node.parent.position.y;
            }
        }
        this.realSizes(node.firstChild);
        this.realSizes(node.nextSibling);
    }

    private void angleFix() {
        int i = 0;
        while (i < this.numNodes) {
            ParseClanTree tnodei = this.treeLookup[i];
            int k = 0;
            while (k < 2) {
                CGDTreeSet connections = k == 0 ? this.graph.parents(i) : this.graph.children(i);
                Iterator it = connections.iterator();
                while (it.hasNext()) {
                    double y2;
                    double x2;
                    int j = (Integer)it.next();
                    if (j < this.numNodes) {
                        ParseClanTree tnodej = this.treeLookup[j];
                        x2 = tnodej.position.x + tnodej.size.x / 2.0;
                        y2 = tnodej.position.y - tnodej.size.y / 2.0;
                    } else {
                        Point2D.Double pos = this.graph.getNode(j).getPosition();
                        x2 = pos.x;
                        y2 = pos.y;
                    }
                    double x1 = tnodei.position.x + tnodei.size.x / 2.0;
                    double y1 = tnodei.position.y - tnodei.size.y / 2.0;
                    double dx = Math.abs(x1 - x2);
                    if (dx == 0.0) continue;
                    double dy = Math.abs(y1 - y2);
                    double dy2 = dy / dx * tnodei.size.x / 2.0;
                    double dist = tnodei.size.y / 2.0;
                    if ((dist -= dy2) <= this.distV / 2.0) continue;
                    double offs = dy * dy / (dx * dx + dy * dy);
                    offs = Math.sqrt(offs);
                    offs *= tnodei.size.x / 2.0;
                    if (x2 > x1) {
                        offs = tnodei.size.x - offs;
                    }
                    int newnodeindex = this.graph.getNodes().size() - 1;
                    CGDNode newnode = this.graph.getNode(newnodeindex);
                    if (k == 0) {
                        this.graph.removeEdge(j, i);
                        this.graph.addEdge(j, newnodeindex);
                        this.graph.addEdge(newnodeindex, i);
                        newnode.setPosition(tnodei.position.x + offs, tnodei.position.y - this.distV / 4.0);
                        continue;
                    }
                    this.graph.removeEdge(i, j);
                    this.graph.addEdge(i, newnodeindex);
                    this.graph.addEdge(newnodeindex, j);
                    newnode.setPosition(tnodei.position.x + offs, tnodei.position.y - tnodei.size.y + this.distV / 4.0);
                }
                ++k;
            }
            ++i;
        }
    }

    private void copyCorner(ParseClanTree node) {
        if (node == null) {
            return;
        }
        if (node.clan.clanType == 5) {
            Point2D.Double center_position = new Point2D.Double(node.position.x, node.position.y);
            center_position.x += node.size.x / 2.0;
            center_position.y -= node.size.y / 2.0;
            this.graph.getNode(node.clan.id).setPosition(center_position);
        }
        this.copyCorner(node.firstChild);
        this.copyCorner(node.nextSibling);
    }

    private void removeBends() {
        ArrayList nodes = this.graph.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            CGDNode tmpnode = (CGDNode)nodes.get(i);
            if (tmpnode.getIndex() >= this.initialNumNodes) {
                boolean needed = false;
                int index = tmpnode.getIndex();
                CGDNode node1 = null;
                CGDNode node2 = null;
                try {
                    node1 = this.graph.getNode((Integer)this.graph.parents(index).first());
                }
                catch (Exception e) {
                    System.out.println("GraphUtil.removeBends():Parent not found for node=" + index + ".");
                    return;
                }
                try {
                    node2 = this.graph.getNode((Integer)tmpnode.getChildren().first());
                }
                catch (Exception e) {
                    System.out.println("GraphUtil.removeBends():Child not found for node=" + index + ".");
                    return;
                }
                Point2D.Double p1 = node1.getPosition();
                Point2D.Double p2 = node2.getPosition();
                double dxdy = (p2.x - p1.x) / (p2.y - p1.y);
                double minx = Math.min(p1.x, p2.x);
                double miny = Math.min(p1.y, p2.y);
                double maxx = Math.max(p1.x, p2.x);
                double maxy = Math.max(p1.y, p2.y);
                int j = 0;
                while (j < nodes.size()) {
                    CGDNode tmpnode2 = (CGDNode)nodes.get(i);
                    if (tmpnode2.getIndex() < this.initialNumNodes && tmpnode2 != node1 && tmpnode2 != node2) {
                        Point2D.Double p = tmpnode2.getPosition();
                        Point2D.Double bbx = tmpnode2.getBoundingBox();
                        double x1 = p.x - bbx.x / 2.0 - this.distH / 10.0;
                        double x2 = p.x + bbx.x / 2.0 + this.distH / 10.0;
                        double y1 = p.y - bbx.y / 2.0 - this.distV / 10.0;
                        double y2 = p.y + bbx.y / 2.0 + this.distV / 10.0;
                        if (!(x1 <= minx && x2 <= minx || x1 >= maxx && x2 >= maxx || y1 <= miny && y2 <= miny || y1 >= maxy && y2 >= maxy)) {
                            double cross;
                            if (y1 > miny && y1 < maxy && x1 <= (cross = p1.x + dxdy * (y1 - p1.y)) && cross <= x2) {
                                needed = true;
                                break;
                            }
                            if (y2 > miny && y2 < maxy && x1 <= (cross = p1.x + dxdy * (y2 - p1.y)) && cross <= x2) {
                                needed = true;
                                break;
                            }
                            if (x1 > minx && x1 < maxx && y1 <= (cross = p1.y + (x1 - p1.x) / dxdy) && cross <= y2) {
                                needed = true;
                                break;
                            }
                            if (x2 > minx && x2 < maxx && y1 <= (cross = p1.y + (x2 - p1.x) / dxdy) && cross <= y2) {
                                needed = true;
                                break;
                            }
                        }
                    }
                    ++j;
                }
                if (!needed) {
                    this.graph.removeEdge(node1.getIndex(), index);
                    this.graph.removeEdge(index, node2.getIndex());
                    this.graph.addEdge(node1.getIndex(), node2.getIndex());
                }
            }
            ++i;
        }
    }

    public void dummysToEdgePaths(CGDGraph _graph) {
        CGDNode tmpnode;
        this.graph = _graph;
        ArrayList nodes = this.graph.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            tmpnode = (CGDNode)nodes.get(i);
            if (!tmpnode.isDummy) {
                Iterator it = tmpnode.children.iterator();
                while (it.hasNext()) {
                    CGDNode childnode;
                    int child = (Integer)it.next();
                    CGDNode tmpchild = childnode = this.graph.getNode(child);
                    int numdummies = 0;
                    while (tmpchild != null && tmpchild.isDummy) {
                        ++numdummies;
                        tmpchild = this.graph.getNode((Integer)tmpchild.children.first());
                    }
                    if (numdummies <= 0 || tmpchild == null) continue;
                    Point2D.Double[] edge_points = new Point2D.Double[numdummies];
                    tmpchild = childnode;
                    int dummy = 0;
                    while (tmpchild.isDummy) {
                        Point2D.Double position = tmpchild.getPosition();
                        edge_points[dummy++] = new Point2D.Double(position.x, position.y);
                        tmpchild = this.graph.getNode((Integer)tmpchild.children.first());
                    }
                    this.graph.addEdge(tmpnode.getIndex(), tmpchild.getIndex(), edge_points);
                }
            }
            ++i;
        }
        int j = 0;
        while (j < nodes.size()) {
            tmpnode = (CGDNode)nodes.get(j);
            if (tmpnode.isDummy) {
                nodes.remove(j);
            }
            ++j;
        }
    }
}

