/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.cgd.algorithm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import repast.simphony.visualization.cgd.util.CGDTreeSet;
import repast.simphony.visualization.cgd.util.Clan;
import repast.simphony.visualization.cgd.util.ParseClanTree;
import repast.simphony.visualization.cgd.util.Separation;

public class Parser {
    private Clan firstClan;
    private ParseClanTree root = null;
    private int conComponents;
    private TreeSet[] conNodes;
    private TreeSet[] childR;
    private TreeSet[] parentR;
    private TreeSet[] descendentR;
    private TreeSet[] ancestorR;
    private HashMap<Integer, Integer> topObjOrder;
    private int numNodes;

    public ParseClanTree parseSet(TreeSet[] _childR, TreeSet[] _parentR, TreeSet[] _descendentR, TreeSet[] _ancestorR, TreeSet allNodes) {
        this.childR = _childR;
        this.parentR = _parentR;
        this.descendentR = _descendentR;
        this.ancestorR = _ancestorR;
        ParseClanTree pct = this.parseSet(allNodes);
        this.breakPrimitives(pct);
        pct.reduce();
        pct.setId(this.numNodes);
        return pct;
    }

    private ParseClanTree parseSet(TreeSet allNodes) {
        ParseClanTree pct = null;
        Separation S = new Separation(0, this.childR, this.parentR, this.descendentR, this.ancestorR, this.numNodes, allNodes);
        Separation M = new Separation(1, this.childR, this.parentR, this.descendentR, this.ancestorR, this.numNodes, allNodes);
        this.firstClan = null;
        int i = 0;
        while (i < S.size()) {
            int j = 0;
            while (j < M.size()) {
                CGDTreeSet F = (CGDTreeSet)S.mixSetTree(i).clone();
                F.intersect(M.mixSetTree(j));
                if (F.size() > 1) {
                    this.makeConnectedComponents(F, this.descendentR, this.ancestorR);
                    int legal_components = 0;
                    CGDTreeSet legal_nodes = new CGDTreeSet();
                    Clan candidates = null;
                    int k = 0;
                    while (k < this.conComponents) {
                        if (this.conNodes[k].size() > 1) {
                            CGDTreeSet sts = (CGDTreeSet)S.members(i).clone();
                            sts.intersect(this.conNodes[k]);
                            CGDTreeSet mts = (CGDTreeSet)M.members(j).clone();
                            mts.intersect(this.conNodes[k]);
                            CGDTreeSet ds = (CGDTreeSet)sts.clone();
                            CGDTreeSet am = (CGDTreeSet)mts.clone();
                            ds.indexUnion(this.descendentR, sts);
                            am.indexUnion(this.ancestorR, mts);
                            CGDTreeSet ads = (CGDTreeSet)ds.clone();
                            CGDTreeSet adm = (CGDTreeSet)am.clone();
                            ads.indexUnion(this.ancestorR, sts);
                            adm.indexUnion(this.descendentR, mts);
                            ds.intersect(allNodes);
                            am.intersect(allNodes);
                            ads.intersect(allNodes);
                            adm.intersect(allNodes);
                            if (adm.isSubset(ds) && ads.isSubset(am)) {
                                Clan clan = new Clan(0, this.conNodes[k], sts, mts, this.nodeOrder(this.conNodes[k]));
                                clan.next = candidates;
                                candidates = clan;
                                ++legal_components;
                                legal_nodes.union(this.conNodes[k]);
                            }
                        } else {
                            ++legal_components;
                            legal_nodes.union(this.conNodes[k]);
                        }
                        ++k;
                    }
                    if (legal_components > 1) {
                        CGDTreeSet sources = (CGDTreeSet)legal_nodes.clone();
                        CGDTreeSet sinks = (CGDTreeSet)legal_nodes.clone();
                        sources.intersect(S.members(i));
                        sinks.intersect(M.members(j));
                        Clan clan = new Clan(1, legal_nodes, sources, sinks, this.nodeOrder(sources));
                        clan.next = candidates;
                        candidates = clan;
                    }
                    this.mergeCandidateToClanList(candidates);
                }
                ++j;
            }
            ++i;
        }
        pct = this.buildParseTree(allNodes);
        pct.fixLinear(allNodes, this.childR, this.parentR);
        return pct;
    }

    void makeConnectedComponents(TreeSet f, TreeSet[] descendentR, TreeSet[] ancestorR) {
        this.conComponents = 0;
        this.conNodes = new TreeSet[f.size()];
        Iterator it = f.iterator();
        while (it.hasNext()) {
            int n = (Integer)it.next();
            this.conNodes[this.conComponents] = new CGDTreeSet();
            CGDTreeSet c = (CGDTreeSet)this.conNodes[this.conComponents];
            c.add(n);
            CGDTreeSet tmpset = (CGDTreeSet)ancestorR[n].clone();
            tmpset.union(descendentR[n]);
            tmpset.intersect(f);
            c.union(tmpset);
            int last_size = -1;
            while (c.size() != last_size) {
                last_size = c.size();
                tmpset = new CGDTreeSet();
                tmpset.indexUnion(ancestorR, c);
                tmpset.indexUnion(descendentR, c);
                tmpset.intersect(f);
                c.union(tmpset);
            }
            ((CGDTreeSet)f).difference(c);
            it = f.iterator();
            ++this.conComponents;
        }
    }

    private int nodeOrder(TreeSet nodeSet) {
        int order = this.numNodes;
        Iterator it = nodeSet.iterator();
        while (it.hasNext()) {
            int n = (Integer)it.next();
            int tmp = this.topObjOrder.get(n);
            if (tmp >= order) continue;
            order = tmp;
        }
        return order;
    }

    private void mergeCandidateToClanList(Clan _candidates) {
        while (_candidates != null) {
            Clan c = _candidates;
            _candidates = _candidates.next;
            TreeSet cNodes = c.nodes;
            Clan prevClan = null;
            Clan clan = this.firstClan;
            while (clan != null) {
                TreeSet clanNodes = clan.nodes;
                if (cNodes.equals(clanNodes)) {
                    if (c.clanType != 0) {
                        clan.clanType = c.clanType;
                    }
                    c = null;
                    break;
                }
                if (((CGDTreeSet)cNodes).intersects(clanNodes) && !((CGDTreeSet)clanNodes).isSubset(cNodes) && !((CGDTreeSet)cNodes).isSubset(clanNodes)) {
                    ((CGDTreeSet)cNodes).union(clanNodes);
                    c.size = cNodes.size();
                    c.clanType = 2;
                    if (prevClan != null) {
                        prevClan.listnext = clan.listnext;
                    } else {
                        this.firstClan = clan.listnext;
                    }
                }
                prevClan = clan;
                clan = clan.listnext;
            }
            if (c == null) continue;
            if (c.clanType == 0) {
                c.clanType = 3;
            }
            this.addToClanList(c);
        }
    }

    private void addToClanList(Clan clan) {
        if (this.firstClan == null) {
            this.firstClan = clan;
            return;
        }
        if (this.firstClan.size > clan.size) {
            clan.listnext = this.firstClan;
            this.firstClan = clan;
            return;
        }
        Clan tmp = this.firstClan;
        while (tmp.listnext != null && tmp.listnext.size < clan.size) {
            tmp = tmp.listnext;
        }
        clan.listnext = tmp.listnext;
        tmp.listnext = clan;
    }

    private ParseClanTree buildParseTree(TreeSet _allNodes) {
        ParseClanTree pct = new ParseClanTree();
        Clan lClan = null;
        Clan tmpClan = null;
        if (this.firstClan != null) {
            this.firstClan.next = null;
            lClan = this.firstClan;
            while (lClan.listnext != null) {
                lClan.listnext.next = lClan;
                lClan = lClan.listnext;
            }
        }
        if (this.root == null) {
            this.root = pct;
        }
        pct.clan = lClan;
        if (lClan != null) {
            lClan = lClan.next;
        }
        while ((tmpClan = lClan) != null) {
            lClan = lClan.next;
            pct.addClan(tmpClan);
        }
        Integer in = null;
        Iterator it = _allNodes.iterator();
        while (it.hasNext()) {
            CGDTreeSet ts = new CGDTreeSet();
            in = (Integer)it.next();
            ts.add(in);
            Clan clan = new Clan(5, ts, ts, ts, this.topObjOrder.get(in));
            pct.addClan(clan);
        }
        return pct;
    }

    public void setTopObjOrder(HashMap<Integer, Integer> _topObjOrder) {
        this.topObjOrder = _topObjOrder;
    }

    public void setNumNodes(int _numNodes) {
        this.numNodes = _numNodes;
    }

    private ParseClanTree breakPrimitives(ParseClanTree node) {
        if (node.clan.clanType == 3) {
            ParseClanTree subclan;
            node.clan.clanType = 2;
            ParseClanTree ind_tree = new ParseClanTree();
            ind_tree.clan = new Clan(4, new CGDTreeSet(), node.clan.sources, new CGDTreeSet(), node.clan.order);
            CGDTreeSet remaining_nodes = (CGDTreeSet)node.clan.nodes.clone();
            int currMax = 0;
            int i = 0;
            Iterator it = node.clan.sources.iterator();
            while (it.hasNext()) {
                i = (Integer)it.next();
                int tmp = this.topObjOrder.get(i);
                if (tmp <= currMax) continue;
                currMax = tmp;
            }
            while ((subclan = node.firstChild) != null) {
                node.firstChild = node.firstChild.nextSibling;
                if (!((CGDTreeSet)node.clan.sources).intersects(subclan.clan.sources)) continue;
                if (this.topObjOrder.get((Integer)subclan.clan.sources.first()) >= currMax) {
                    ((CGDTreeSet)ind_tree.clan.nodes).union(subclan.clan.nodes);
                    ((CGDTreeSet)ind_tree.clan.sinks).union(subclan.clan.sinks);
                    ind_tree.addChild(subclan);
                    remaining_nodes.difference(subclan.clan.nodes);
                    continue;
                }
                if (this.parentR[(Integer)subclan.clan.sources.first()].isEmpty()) continue;
                ((CGDTreeSet)ind_tree.clan.nodes).union(subclan.clan.nodes);
                ((CGDTreeSet)ind_tree.clan.sinks).union(subclan.clan.sinks);
                ind_tree.addChild(subclan);
                remaining_nodes.difference(subclan.clan.nodes);
            }
            node.addChild(ind_tree);
            node.addChild(this.parseSet(remaining_nodes));
        }
        ParseClanTree tmpclan = node.firstChild;
        while (tmpclan != null) {
            this.breakPrimitives(tmpclan);
            tmpclan = tmpclan.nextSibling;
        }
        return node;
    }
}

