/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.cgd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.visualization.AbstractNetworkLayout;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.VisualizationProperties;
import repast.simphony.visualization.cgd.CGDProcessor;
import repast.simphony.visualization.cgd.graph.CGDGraph;
import repast.simphony.visualization.cgd.graph.CGDNode;
import simphony.util.messages.MessageCenter;

public class CGDLayout<T>
extends AbstractNetworkLayout<T>
implements ProjectionListener {
    private VisualizationProperties properties;
    protected Network network;
    private CGDGraph cgd;
    private HashMap data;

    public CGDLayout() {
    }

    public CGDLayout(Network network) {
        this.network = network;
    }

    @Override
    public void update() {
        if (this.network != null) {
            this.setProjection(this.network);
        }
    }

    public float[] getLocation(T obj) {
        Iterator ic = this.data.entrySet().iterator();
        float[] results = new float[2];
        while (ic.hasNext()) {
            Map.Entry e = ic.next();
            if (e.getKey() != obj) continue;
            CGDNode node = (CGDNode)e.getValue();
            float x = (float)node.getX();
            float y = (float)node.getY();
            results[0] = x;
            results[1] = y;
            break;
        }
        return results;
    }

    @Override
    public void setLayoutProperties(VisualizationProperties props) {
        this.properties = props;
    }

    @Override
    public VisualizationProperties getLayoutProperties() {
        return this.properties;
    }

    @Override
    public void setProjection(Network projection) {
        if (projection != null && !projection.isDirected()) {
            MessageCenter.getMessageCenter(CGDLayout.class).error((Object)"Network is not a tree type network", new Throwable(), new Object[0]);
        }
        this.network = projection;
        CGDProcessor cgdP = new CGDProcessor();
        cgdP.processGraph(projection);
        this.data = cgdP.getObjectData();
        this.cgd = cgdP.graph;
    }

    public void projectionEventOccurred(ProjectionEvent evt) {
        CGDProcessor cgdP = new CGDProcessor();
        cgdP.processGraph(this.network);
        this.cgd = cgdP.graph;
        this.data = cgdP.getObjectData();
    }

    public Box getBoundingBox() {
        return new Box();
    }
}

