/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JToolBar;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.visualization.DisplayListener;
import repast.simphony.visualization.DisplayListenerSupport;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.ProbeListener;
import repast.simphony.visualization.ProbeListenerSupport;

public abstract class AbstractDisplay
implements IDisplay,
ProjectionListener {
    public static long FRAME_UPDATE_INTERVAL = 34L;
    private static final String INFO_POINTER_ICON = "info_viz_pointer.png";
    protected static final Cursor INFO_CURSOR = AbstractDisplay.createInfoCursor();
    protected ProbeListenerSupport probeSupport = new ProbeListenerSupport();
    protected DisplayListenerSupport dlSupport = new DisplayListenerSupport();
    protected long lastRenderTS = 0L;

    public void projectionEventOccurred(ProjectionEvent evt) {
        if (evt.getType() == ProjectionEvent.OBJECT_ADDED) {
            Object obj = evt.getSubject();
            this.addObject(obj);
        } else if (evt.getType() == ProjectionEvent.OBJECT_REMOVED) {
            Object obj = evt.getSubject();
            this.removeObject(obj);
        } else if (evt.getType() == ProjectionEvent.OBJECT_MOVED) {
            Object obj = evt.getSubject();
            this.moveObject(obj);
        }
    }

    protected abstract void addObject(Object var1);

    protected abstract void removeObject(Object var1);

    protected abstract void moveObject(Object var1);

    public void addProbeListener(ProbeListener listener) {
        this.probeSupport.addProbeListener(listener);
    }

    public void addDisplayListener(DisplayListener listener) {
        this.dlSupport.addDisplayListener(listener);
    }

    public void registerToolBar(JToolBar bar) {
    }

    public ProbeListenerSupport getProbeSupport() {
        return this.probeSupport;
    }

    public void setProbeSupport(ProbeListenerSupport probeSupport) {
        this.probeSupport = probeSupport;
    }

    public void destroy() {
        this.probeSupport.removeAllProbeListeners();
    }

    public static Cursor createInfoCursor() {
        URL url;
        BufferedImage im;
        block3: {
            im = null;
            url = AbstractDisplay.class.getClassLoader().getResource(INFO_POINTER_ICON);
            if (url != null) break block3;
            return null;
        }
        try {
            im = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(0, 0), "Info Cursor");
    }
}

