/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.translator.GraphicObject;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;

public class View {
    public static final String ARROW = "ARROW";
    public static final String VARIABLE = "VARIABLE";
    public static final String VALVE = "VALVE";
    public static final String COMMENT = "COMMENT";
    public static final String BITMAP = "BITMAP";
    public static final String METAFILE = "METAFILE";
    public static final String RATE = "RATE";
    public static final String CLOUD = "CLOUD";
    private String name;
    private String versionCode;
    private String viewDefaultFont;
    private List<String> rawObjects;
    private List<GraphicObject> graphicObjects;
    private int currentPtr = 0;
    private Map<String, String> idNameMap;

    public View(String name, String versionCode, String viewDefaultFont) {
        this.name = name;
        this.versionCode = versionCode;
        this.viewDefaultFont = viewDefaultFont;
        this.graphicObjects = new ArrayList<GraphicObject>();
        this.idNameMap = new HashMap<String, String>();
    }

    public void parse(SystemDynamicsObjectManager sdObjectManager) {
        while (this.currentPtr < this.rawObjects.size()) {
            String raw = this.rawObjects.get(this.currentPtr++);
            GraphicObject go = new GraphicObject(sdObjectManager, this, raw);
            this.graphicObjects.add(go);
            if (!go.isValve() || go.getAssociatedVariable() == null) continue;
            this.graphicObjects.add(go.getAssociatedVariable());
        }
        this.print();
        sdObjectManager.extractStructure(this);
    }

    public String translateCodeToString(String numeric) {
        if (numeric.equals("1")) {
            return ARROW;
        }
        if (numeric.equals("10")) {
            return VARIABLE;
        }
        if (numeric.equals("11")) {
            return VALVE;
        }
        if (numeric.equals("12")) {
            return COMMENT;
        }
        if (numeric.equals("30")) {
            return BITMAP;
        }
        if (numeric.equals("31")) {
            return METAFILE;
        }
        if (numeric.equals("99")) {
            return RATE;
        }
        if (numeric.equals("48")) {
            return CLOUD;
        }
        return "UNKNOWN";
    }

    public String peekNextRawObject() {
        String next = this.rawObjects.get(this.currentPtr);
        return next;
    }

    public String getNextRawObject() {
        String next = this.rawObjects.get(this.currentPtr);
        ++this.currentPtr;
        return next;
    }

    public void print() {
    }

    public List<String> getRawObjects() {
        return this.rawObjects;
    }

    public void setRawObjects(List<String> rawObjects) {
        this.rawObjects = rawObjects;
    }

    public String getName() {
        return this.name;
    }

    public List<GraphicObject> getGraphicObjects() {
        return this.graphicObjects;
    }
}

