/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.Map;
import repast.simphony.systemdynamics.support.MutableBoolean;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.OperationResult;

public class UsageChecker {
    public static final String ARRAY = "array.";
    public static final String FUNCTION = "sdFunctions.";
    public static final String SCALAR = "memory.";
    public static final String LOOKUP = "lookup.";
    public static final String UNKNOWN = "unknown.";
    private Equation equation;
    private Map<String, Equation> equations;

    public UsageChecker(Map<String, Equation> equations, Equation equation) {
        this.equations = equations;
        this.equation = equation;
    }

    public OperationResult checkUsage() {
        OperationResult allResults = new OperationResult();
        MutableBoolean lhs = new MutableBoolean(true);
        MutableInteger pos = new MutableInteger(-1);
        for (String token : this.equation.getTokens()) {
            String type;
            OperationResult or;
            pos.add(1);
            if (token.equals("=")) {
                lhs.setValue(false);
            }
            if (!this.isClassified(token) || (or = this.validateReference(pos, type = this.getType(token), token, lhs)).isOk()) continue;
            allResults.setErrorMessage(or.getMessage());
        }
        return allResults;
    }

    private OperationResult validateReference(MutableInteger pos, String type, String token, MutableBoolean lhs) {
        OperationResult or = new OperationResult();
        if (type.equals(ARRAY)) {
            or = InformationManagers.getInstance().getArrayManager().validateArrayReference(this.equations, this.equation, pos, lhs);
        } else if (type.equals(FUNCTION)) {
            or = InformationManagers.getInstance().getFunctionManager().validateFunctionReference(this.equations, this.equation, pos, lhs);
        } else if (type.equals(SCALAR)) {
            or = InformationManagers.getInstance().getNativeDataTypeManager().validateScalarReference(this.equations, this.equation, pos, lhs);
        } else if (type.equals(LOOKUP)) {
            or = InformationManagers.getInstance().getArrayManager().validateLookupReference(this.equations, this.equation, pos, lhs);
        }
        return or;
    }

    private boolean isClassified(String token) {
        return token.startsWith(FUNCTION) || token.startsWith(ARRAY) || token.startsWith(SCALAR) || token.startsWith(LOOKUP);
    }

    private String getType(String token) {
        if (token.startsWith(FUNCTION)) {
            return FUNCTION;
        }
        if (token.startsWith(ARRAY)) {
            return ARRAY;
        }
        if (token.startsWith(SCALAR)) {
            return SCALAR;
        }
        if (token.startsWith(LOOKUP)) {
            return LOOKUP;
        }
        return UNKNOWN;
    }
}

