/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.FunctionDescription;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.UnitConsistencyXMLWriter;
import repast.simphony.systemdynamics.translator.UnitExpression;

public class UnitsManager {
    private Map<String, String> lhsUnits = new HashMap<String, String>();
    private Map<String, String> lhsUnitsRaw = new HashMap<String, String>();
    private Map<String, String> unitsEquivalence = new HashMap<String, String>();
    private UnitConsistencyXMLWriter unitConsistencyXMLWriter;

    public Map<String, Equation> performUnitsConsistencyCheck(Map<String, Equation> equations, String file) {
        boolean consistent = true;
        ArrayList<String> evaluationOrder = new ArrayList<String>();
        for (String key : equations.keySet()) {
            evaluationOrder.add(key);
        }
        Map<String, Equation> errors = this.performUnitsConsistencyCheck(evaluationOrder, equations, file);
        return errors;
    }

    public Map<String, Equation> performUnitsConsistencyCheck(List<String> evaluationOrder, Map<String, Equation> equations, String file) {
        boolean consistent = true;
        HashMap<String, Equation> errors = new HashMap<String, Equation>();
        this.unitConsistencyXMLWriter = new UnitConsistencyXMLWriter();
        int equationCount = 0;
        for (String lhs : evaluationOrder) {
            Equation eqn = equations.get(lhs);
            if (!eqn.isAssignment() || !InformationManagers.getInstance().getFunctionManager().canCheckUnitsConsistency(eqn.getVensimEquation())) continue;
            ++equationCount;
            List<String> units = eqn.getEquationUnits();
            if (eqn.getUnits() == null) {
                System.out.println("UNITS Not Specified: " + eqn.getCleanEquation());
                errors.put(eqn.getLhs(), eqn);
                consistent = false;
                continue;
            }
            if (eqn.isArrayInitialization() || this.isConsistent(eqn, units)) continue;
            System.out.println("INCONSISTENT UNITS: " + eqn.getCleanEquation());
            errors.put(eqn.getLhs(), eqn);
            consistent = false;
        }
        this.unitConsistencyXMLWriter.setEquationCount(equationCount);
        this.unitConsistencyXMLWriter.write(file);
        this.unitConsistencyXMLWriter.writeReport(file.replace(".xml", ".txt"));
        return errors;
    }

    public void addEquivalence(String alternateUnit, String effectiveUnit) {
        this.unitsEquivalence.put(alternateUnit, effectiveUnit);
    }

    public String getEffectiveUnits(String units) {
        if (this.unitsEquivalence.containsKey(units)) {
            return this.unitsEquivalence.get(units);
        }
        return units;
    }

    public String getUnits(String lhs) {
        String units = this.lhsUnits.get(this.cleanseLHS(lhs));
        return this.getEffectiveUnits(units);
    }

    public void addLhsUnits(String lhs, String units) {
        this.lhsUnitsRaw.put(lhs, units);
        this.lhsUnits.put(this.cleanseLHS(lhs), this.cleanseUnits(units));
    }

    public boolean hasUnits(String lhs) {
        return this.lhsUnits.containsKey(this.cleanseLHS(lhs));
    }

    public String cleanseLHS(String lhs) {
        String lhside = lhs;
        if (ArrayReference.isArrayReference(lhs)) {
            lhside = new ArrayReference(lhs).getArrayName();
        }
        lhside = InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(lhside);
        lhside = lhside.replace("memory.", "").replace("lookup.", "").replace("sdFunctions.", "").replace("array.", "");
        return lhside.replace("memory.", "").replace("lookup.", "").replace("sdFunctions.", "");
    }

    public String cleanseUnits(String units) {
        if (units == null) {
            return null;
        }
        String u = units;
        if (units.contains("[")) {
            u = units.split("\\[")[0].trim();
        }
        return u;
    }

    public void dumpLhsUnits(BufferedWriter bw) {
        ArrayList<String> lhs = new ArrayList<String>();
        lhs.addAll(this.lhsUnits.keySet());
        Collections.sort(lhs);
        for (String l : lhs) {
            try {
                bw.append("\"");
                bw.append(l);
                bw.append("\"");
                bw.append(",");
                bw.append("\"");
                bw.append(this.lhsUnits.get(l));
                bw.append("\"");
                bw.append("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dumpLhsUnitsRaw(BufferedWriter bw) {
        ArrayList<String> lhs = new ArrayList<String>();
        lhs.addAll(this.lhsUnitsRaw.keySet());
        Collections.sort(lhs);
        for (String l : lhs) {
            try {
                bw.append("\"");
                bw.append(l);
                bw.append("\"");
                bw.append(",");
                bw.append("\"");
                bw.append(this.lhsUnitsRaw.get(l));
                bw.append("\"");
                bw.append("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isConsistent(Equation eqn, List<String> units) {
        List<String> unitsExpanded = this.expandUnits(units);
        boolean isValid = this.valid(unitsExpanded = this.addFunctionUnits(unitsExpanded), eqn);
        if (!isValid) {
            eqn.printTokensOneLine();
            this.printUnits(units);
            System.out.println("++++++++++++++++++++++++++++++++");
            this.printUnitsIndented(unitsExpanded, eqn);
        }
        return isValid;
    }

    private boolean valid(List<String> units, Equation eqn) {
        if (units.size() < 3) {
            return false;
        }
        String lhs = units.get(0);
        if (lhs == null) {
            return false;
        }
        String equal = units.get(1);
        ArrayList<String> rhs = new ArrayList<String>(units);
        rhs.remove(0);
        rhs.remove(0);
        UnitExpression unitExpression = new UnitExpression(lhs, equal, rhs, eqn);
        return unitExpression.isValid();
    }

    private List<String> addFunctionUnits(List<String> units) {
        ArrayList<String> unitsExpanded = new ArrayList<String>();
        MutableInteger i = new MutableInteger(0);
        while (i.value() < units.size()) {
            String s = units.get(i.value());
            if (Parser.isFunctionInvocation(s)) {
                s = s.split("<")[0];
                FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(s);
                if (fd == null) {
                    unitsExpanded.add(String.valueOf(s) + "<NULL>");
                } else {
                    unitsExpanded.add(String.valueOf(s) + "<" + fd.getReturnUnits() + ">");
                }
            } else {
                unitsExpanded.add(s);
            }
            i.add(1);
        }
        return unitsExpanded;
    }

    private List<String> expandUnits(List<String> units) {
        ArrayList<String> unitsExpanded = new ArrayList<String>();
        MutableInteger i = new MutableInteger(0);
        while (i.value() < units.size()) {
            String s = units.get(i.value());
            if (Parser.isFunctionInvocation(s)) {
                s = s.split("<")[0];
                i.add(1);
                FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(s);
                unitsExpanded.addAll(this.expandFunctionUnits(units, i, s));
                int p = 0;
                while (p < fd.getNumArgs()) {
                    String s1 = units.get(i.value());
                    if (s1 == null) {
                        s1 = "dmnl";
                    }
                    if (Parser.isFunctionInvocation(s1)) {
                        s1 = s1.split("<")[0];
                        i.add(1);
                        FunctionDescription fd1 = InformationManagers.getInstance().getFunctionManager().getDescription(s1);
                        unitsExpanded.addAll(this.expandFunctionUnits(units, i, s1));
                    } else {
                        unitsExpanded.add(s1);
                        i.add(1);
                    }
                    ++p;
                }
                continue;
            }
            unitsExpanded.add(s);
            i.add(1);
        }
        return unitsExpanded;
    }

    private List<String> expandFunctionUnits(List<String> units, MutableInteger i, String functionName) {
        ArrayList<String> unitsExpanded = new ArrayList<String>();
        FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(functionName);
        if (fd == null) {
            System.out.println("fd is null for " + functionName);
        }
        unitsExpanded.add(functionName);
        unitsExpanded.add(units.get(i.valueAndInc()));
        if (fd.isRequiresName()) {
            i.add(1);
            i.add(1);
        }
        if (fd.isRequiresValue()) {
            i.add(2);
        }
        if (fd.isRequiresTime()) {
            i.add(1);
            i.add(1);
        }
        if (fd.isRequiresTimeStep()) {
            i.add(1);
            i.add(1);
        }
        return unitsExpanded;
    }

    private void printUnits(List<String> units) {
        for (String s : units) {
            System.out.print(" \"" + s + "\"");
        }
        System.out.print("\n");
    }

    private void printUnitsIndented(List<String> units, Equation eqn) {
        int indent = 0;
        String indentation = this.getIndentation(indent);
        for (String s : units) {
            if (s == null) {
                s = "null";
            }
            if (s.equals(")")) {
                indentation = this.getIndentation(--indent);
            }
            System.out.println(String.valueOf(indentation) + "\"" + s + "\"");
            eqn.getUnitsMessages().add(String.valueOf(indentation) + "\"" + s + "\"");
            if (!s.equals("(")) continue;
            indentation = this.getIndentation(++indent);
        }
    }

    private String getIndentation(int indent) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indent) {
            sb.append("   ");
            ++i;
        }
        return sb.toString();
    }

    public UnitConsistencyXMLWriter getUnitConsistencyXMLWriter() {
        return this.unitConsistencyXMLWriter;
    }
}

