/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.FunctionDescription;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.SimplifiedUnit;

public class UnitExpression {
    private boolean valid;
    private boolean simpleExpression = true;
    private String simplifiedUnits;
    private String lhs;
    private String operator;
    private List<String> rhs;
    private String function;
    Equation equation;
    private String inconsistentMessage;
    boolean unitParseFatalError = false;
    private Stack<Object> stack = new Stack();
    private List<Object> rhsSimplifiedUnit = new ArrayList<Object>();
    private SimplifiedUnit lhsSimplifiedUnit;

    public UnitExpression(String lhs, String operator, List<String> rhs, Equation equation) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.operator = operator;
        this.equation = equation;
        this.lhsSimplifiedUnit = new SimplifiedUnit(this.lhs);
        this.simplifyRHS(this.rhs);
    }

    public String getEquationLHS() {
        return this.equation.getLhs().replace("array.", "");
    }

    public boolean isArrayInitialization() {
        return this.equation.isArrayInitialization();
    }

    public String getVensimEquation() {
        return this.equation.getVensimEquation();
    }

    public String getLhsUnitsString() {
        return this.lhsSimplifiedUnit.formUnit();
    }

    public String getRhsUnitsString() {
        if (this.rhsSimplifiedUnit.size() == 1) {
            return ((SimplifiedUnit)this.rhsSimplifiedUnit.get(0)).formUnit();
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.rhsSimplifiedUnit.size()) {
            Object obj = this.rhsSimplifiedUnit.get(i);
            if (obj instanceof SimplifiedUnit) {
                sb.append(String.valueOf(((SimplifiedUnit)obj).formUnit()) + " ");
            } else {
                String s = (String)obj;
                if (Parser.isFunctionInvocation(s)) {
                    s = s.split("<")[0].replace("sdFunctions.", "");
                } else if (s.startsWith("constant")) {
                    s = s.split("#")[0];
                }
                sb.append(String.valueOf(s) + " ");
            }
            ++i;
        }
        return sb.toString();
    }

    public String getCompleteRhsUnitsString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.rhs.size()) {
            String s = this.rhs.get(i);
            if (s == null) {
                s = "null";
            }
            if (Parser.isFunctionInvocation(s)) {
                s = s.split("<")[0].replace("sdFunctions.", "");
            } else if (s.startsWith("constant")) {
                s = s.split("#")[0];
            }
            sb.append(String.valueOf(s) + " ");
            ++i;
        }
        return sb.toString();
    }

    private void simplifyRHS(List<String> tokens) {
        int lastGood = 0;
        int endBad = 0;
        int currentToken = -1;
        for (String token : tokens) {
            ++currentToken;
            if (token == null) {
                if (this.unitParseFatalError) {
                    this.rhsSimplifiedUnit.add("null");
                    continue;
                }
                this.stack.push("null");
                continue;
            }
            if (Parser.isRelationalOperator(token)) {
                if (this.unitParseFatalError) {
                    this.rhsSimplifiedUnit.add(token);
                    continue;
                }
                this.stack.push(token);
                continue;
            }
            if (Parser.isOperator(token)) {
                if (this.unitParseFatalError) {
                    this.rhsSimplifiedUnit.add(token);
                    continue;
                }
                this.stack.push(token);
                continue;
            }
            if (token.equals(",")) {
                if (this.unitParseFatalError) {
                    this.rhsSimplifiedUnit.add(token);
                    continue;
                }
                this.stack.push(token);
                continue;
            }
            if (Parser.isFunctionInvocation(token)) {
                if (this.unitParseFatalError) {
                    this.rhsSimplifiedUnit.add(token);
                    continue;
                }
                this.stack.push(token);
                continue;
            }
            if (token.equals("(")) {
                if (this.unitParseFatalError) {
                    this.rhsSimplifiedUnit.add(token);
                    continue;
                }
                lastGood = currentToken;
                this.stack.push(token);
                continue;
            }
            if (token.equals(")")) {
                if (this.unitParseFatalError) {
                    this.rhsSimplifiedUnit.add(token);
                    continue;
                }
                this.processStackExpression();
                if (this.unitParseFatalError) {
                    endBad = currentToken;
                    continue;
                }
                lastGood = currentToken;
                continue;
            }
            if (this.unitParseFatalError) {
                this.rhsSimplifiedUnit.add(new SimplifiedUnit(token));
                continue;
            }
            this.stack.push(new SimplifiedUnit(token));
        }
        if (!this.unitParseFatalError) {
            this.processStackExpression();
        }
        while (!this.stack.isEmpty()) {
            Object obj = this.stack.pop();
            if (this.unitParseFatalError) continue;
            this.rhsSimplifiedUnit.add(obj);
        }
    }

    private void processStackExpression() {
        Stack<Object> tStack = new Stack<Object>();
        while (!this.stack.isEmpty()) {
            Object obj = this.stack.pop();
            Object peek = null;
            if (!this.stack.isEmpty()) {
                peek = this.stack.peek();
            }
            if (obj instanceof String) {
                String token = (String)obj;
                if (Parser.isOperator(token)) {
                    tStack.push(token);
                    continue;
                }
                if (token.equals("(")) {
                    String peeker;
                    if (peek == null || !(peek instanceof String) || !Parser.isFunctionInvocation(peeker = (String)peek)) break;
                    this.stack.pop();
                    tStack.push(peeker);
                    break;
                }
                if (!token.equals("null")) continue;
                tStack.push(token);
                continue;
            }
            tStack.push(obj);
        }
        SimplifiedUnit aSU = null;
        SimplifiedUnit otherSU = null;
        int countSU = 0;
        String oper = "";
        while (!tStack.isEmpty()) {
            Object obj = tStack.pop();
            if (obj instanceof SimplifiedUnit) {
                ++countSU;
                if (aSU == null) {
                    aSU = (SimplifiedUnit)obj;
                } else {
                    otherSU = (SimplifiedUnit)obj;
                }
                if (countSU != 2) continue;
                if (this.executeOperator(oper, aSU, otherSU)) {
                    countSU = 1;
                    continue;
                }
                System.out.println("Cannot execute operator " + oper);
                Stack<Object> reverse = this.reverseOrder(this.stack);
                while (!reverse.isEmpty()) {
                    this.rhsSimplifiedUnit.add(reverse.pop());
                }
                this.unitParseFatalError = true;
                this.rhsSimplifiedUnit.add("(");
                this.rhsSimplifiedUnit.add("ERROR >>>");
                this.rhsSimplifiedUnit.add(aSU);
                this.rhsSimplifiedUnit.add(oper);
                this.rhsSimplifiedUnit.add(otherSU);
                this.rhsSimplifiedUnit.add(" <<< ERROR");
                this.rhsSimplifiedUnit.add(")");
                return;
            }
            String s = (String)obj;
            if (Parser.isFunctionInvocation(s)) {
                boolean somethingWrong;
                int[] funcReturnIndicies;
                String funcName = FunctionDescription.getFunctionName(s);
                String funcReturn = FunctionDescription.getFunctionReturn(s);
                boolean returnsDmnl = funcReturn.equals("dmnl");
                if (returnsDmnl) {
                    System.out.println("RETURNS DMNL");
                }
                int funcReturnIndex = 0;
                if (funcReturn.contains("#")) {
                    String[] alts = funcReturn.split("#");
                    funcReturnIndicies = new int[alts.length];
                    String[] stringArray = alts;
                    int n = alts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String alt = stringArray[n2];
                        int i = 0;
                        while (i < alts.length) {
                            funcReturnIndicies[i] = Integer.parseInt(alt.replace("arg", "")) - 1;
                            ++i;
                        }
                        ++n2;
                    }
                    funcReturnIndex = funcReturnIndicies[0];
                } else {
                    funcReturnIndex = FunctionDescription.getFunctionReturnIndex(s);
                    funcReturnIndicies = new int[]{funcReturnIndex};
                }
                FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(funcName);
                boolean requiresUnitExpression = fd.requiresUnitExpression();
                boolean bl = somethingWrong = funcReturnIndex == -2;
                if (somethingWrong) {
                    System.out.println("!!! ERROR !!! Implemented Functions Data " + funcName);
                }
                int numArgs = fd.getNumArgs();
                String[] argUnits = fd.getArgUnits();
                SimplifiedUnit[] sus = new SimplifiedUnit[numArgs];
                int i = 0;
                String[] stringArray = argUnits;
                int n = argUnits.length;
                int n3 = 0;
                while (n3 < n) {
                    String u = stringArray[n3];
                    Object o = tStack.pop();
                    if (o instanceof String && ((String)o).equals(",")) {
                        o = tStack.pop();
                    }
                    if (o instanceof SimplifiedUnit) {
                        sus[i] = (SimplifiedUnit)o;
                        if (this.badFunctionArgumentUnits(argUnits[i], sus[i])) {
                            Stack<Object> reverse = this.reverseOrder(this.stack);
                            while (!reverse.isEmpty()) {
                                this.rhsSimplifiedUnit.add(reverse.pop());
                            }
                            this.unitParseFatalError = true;
                            this.rhsSimplifiedUnit.add("ERROR >>>");
                            this.rhsSimplifiedUnit.add(sus[i]);
                            this.rhsSimplifiedUnit.add(" <<< ERROR");
                            return;
                        }
                        ++i;
                    } else {
                        System.out.println("Expected SU found " + (String)o);
                        Stack<Object> reverse = this.reverseOrder(this.stack);
                        while (!reverse.isEmpty()) {
                            this.rhsSimplifiedUnit.add(reverse.pop());
                        }
                        this.unitParseFatalError = true;
                        this.rhsSimplifiedUnit.add("ERROR >>>");
                        this.rhsSimplifiedUnit.add((String)o);
                        this.rhsSimplifiedUnit.add(" <<< ERROR");
                        return;
                    }
                    ++n3;
                }
                if (returnsDmnl) {
                    aSU = new SimplifiedUnit("dmnl");
                    continue;
                }
                if (!requiresUnitExpression) {
                    SimplifiedUnit funcRetSU = sus[funcReturnIndex];
                    if (funcRetSU == null) {
                        Stack<Object> reverse = this.reverseOrder(this.stack);
                        while (!reverse.isEmpty()) {
                            this.rhsSimplifiedUnit.add(reverse.pop());
                        }
                        this.unitParseFatalError = true;
                        this.rhsSimplifiedUnit.add("ERROR >>>");
                        this.rhsSimplifiedUnit.add(sus[funcReturnIndex]);
                        this.rhsSimplifiedUnit.add(" <<< ERROR");
                        return;
                    }
                    if (funcRetSU.isConstant()) {
                        int[] nArray = funcReturnIndicies;
                        int n4 = funcReturnIndicies.length;
                        n = 0;
                        while (n < n4) {
                            int j = nArray[n];
                            if (j != funcReturnIndex && !sus[j].isConstant()) {
                                sus[funcReturnIndex] = new SimplifiedUnit(sus[j]);
                                break;
                            }
                            ++n;
                        }
                    }
                    aSU = sus[funcReturnIndex];
                    continue;
                }
                aSU = this.generateReturnUnits(funcReturn, sus);
                continue;
            }
            oper = s;
        }
        if (aSU == null) {
            aSU = new SimplifiedUnit("null");
        }
        aSU.reduce();
        this.stack.push(aSU);
    }

    private boolean badFunctionArgumentUnits(String correctUnits, SimplifiedUnit specifiedUnit) {
        boolean bad = false;
        if (!bad) {
            return bad;
        }
        if (specifiedUnit.isAny()) {
            return false;
        }
        if (correctUnits.equals("units")) {
            return !this.lhsSimplifiedUnit.formUnit().equals(specifiedUnit.formUnit());
        }
        return bad;
    }

    private Stack<Object> reverseOrder(Stack<Object> stack) {
        Stack<Object> reverse = new Stack<Object>();
        while (!stack.isEmpty()) {
            reverse.push(stack.pop());
        }
        return reverse;
    }

    private SimplifiedUnit generateReturnUnits(String funcReturn, SimplifiedUnit[] sus) {
        if (funcReturn.equals("NA")) {
            return new SimplifiedUnit("any");
        }
        if (funcReturn.equals("dmnl")) {
            return new SimplifiedUnit("dmnl");
        }
        boolean division = funcReturn.contains("/");
        boolean multiplication = !division;
        String operator = division ? "/" : "\\*";
        String[] units = funcReturn.split(operator);
        int sub = Integer.parseInt(units[0].replace("arg", "")) - 1;
        SimplifiedUnit su = new SimplifiedUnit(sus[sub]);
        sub = Integer.parseInt(units[1].replace("arg", "")) - 1;
        if (division) {
            su.dividedBy(sus[sub]);
        } else {
            su.times(sus[sub]);
        }
        return su;
    }

    private boolean executeOperator(String oper, SimplifiedUnit aSU, SimplifiedUnit otherSU) {
        if (aSU.validForOperation(oper, otherSU)) {
            if (oper.equals("+")) {
                aSU.plus(otherSU);
            } else if (oper.equals("^")) {
                aSU.exp(otherSU);
            } else if (oper.equals("-")) {
                aSU.minus(otherSU);
            } else if (oper.equals("*")) {
                aSU.times(otherSU);
            } else if (oper.equals("/")) {
                aSU.dividedBy(otherSU);
            } else if (oper.equals("==")) {
                aSU.equals(otherSU);
            } else if (Parser.isBooleanOperator(oper)) {
                aSU.equals(otherSU);
            }
            aSU.reduce();
            return true;
        }
        return false;
    }

    public void printUnitExpression() {
        System.out.println("UNIT EXPRESSION");
        System.out.println(this.getLhsUnitsString());
        System.out.println(this.operator);
        System.out.println(this.getRhsUnitsString());
    }

    public void validate() {
        this.lhsSimplifiedUnit.reduce();
        for (Object su : this.rhsSimplifiedUnit) {
            if (!(su instanceof SimplifiedUnit)) continue;
            ((SimplifiedUnit)su).reduce();
        }
        if (this.equation.isArrayInitialization()) {
            this.valid = true;
            return;
        }
        if (this.rhsSimplifiedUnit.size() == 1) {
            if (((SimplifiedUnit)this.rhsSimplifiedUnit.get(0)).hasSameUnits(this.lhsSimplifiedUnit)) {
                this.valid = true;
            } else {
                this.valid = false;
                this.equation.setUnitExpression(this);
                InformationManagers.getInstance().getUnitsManager().getUnitConsistencyXMLWriter().addInconsistent(this);
                this.inconsistentMessage = "1 RHS SU hasSameUnits false";
            }
        } else {
            this.valid = false;
            this.equation.setUnitExpression(this);
            InformationManagers.getInstance().getUnitsManager().getUnitConsistencyXMLWriter().addInconsistent(this);
            this.inconsistentMessage = "!= 1 RHS SU " + this.rhsSimplifiedUnit.size();
        }
    }

    public boolean isValid() {
        this.validate();
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isSimpleExpression() {
        return this.simpleExpression;
    }

    public void setSimpleExpression(boolean simpleExpression) {
        this.simpleExpression = simpleExpression;
    }

    public String getSimplifiedUnits() {
        return this.simplifiedUnits;
    }

    public void setSimplifiedUnits(String simplifiedUnits) {
        this.simplifiedUnits = simplifiedUnits;
    }

    public String getLhs() {
        return this.lhs;
    }

    public void setLhs(String lhs) {
        this.lhs = lhs;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public List<String> getRhs() {
        return this.rhs;
    }

    public void setRhs(List<String> rhs) {
        this.rhs = rhs;
    }

    public SimplifiedUnit getLhsSimplifiedUnit() {
        return this.lhsSimplifiedUnit;
    }

    public void setLhsSimplifiedUnit(SimplifiedUnit lhsSimplifiedUnit) {
        this.lhsSimplifiedUnit = lhsSimplifiedUnit;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getInconsistentMessage() {
        return this.inconsistentMessage;
    }

    public void setInconsistentMessage(String inconsistentMessage) {
        this.inconsistentMessage = inconsistentMessage;
    }

    public boolean isUnitParseFatalError() {
        return this.unitParseFatalError;
    }

    public void setUnitParseFatalError(boolean unitParseFatalError) {
        this.unitParseFatalError = unitParseFatalError;
    }
}

