/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.parameter.Parameters;
import repast.simphony.systemdynamics.analysis.PolarityCodeBuilder;
import repast.simphony.systemdynamics.engine.Engine;
import repast.simphony.systemdynamics.sdmodel.InfluenceLink;
import repast.simphony.systemdynamics.sdmodel.Stock;
import repast.simphony.systemdynamics.sdmodel.Subscript;
import repast.simphony.systemdynamics.sdmodel.SystemModel;
import repast.simphony.systemdynamics.sdmodel.Variable;
import repast.simphony.systemdynamics.sdmodel.VariableType;
import repast.simphony.systemdynamics.translator.CausalAnalyzer;
import repast.simphony.systemdynamics.translator.CodeGenerator;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Reader;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;
import repast.simphony.systemdynamics.translator.Translator;

public class TranslatorRepastSimphony
extends Translator {
    public static final String EQUATIONS_TERMINATOR = "\\\\\\---/// Sketch information - do not modify anything except names";
    public static final String GRAPHICS_TERMINATOR = "---\\\\\\";
    public static final String MDL_HEADER = "{UTF-8}";
    public static final String FIELD_SEPARATOR = "\t~\t";
    public static final String EQUATION_TERMINATOR = "\t|";
    public static final String MULTIPLE_SEPARATOR = "~~|";
    public static final String MULTIPLE_SEPARATOR_REGEX = "~~\\|";
    public static final String CLOUD_IDENTIFIER = "CLOUD_";
    private static final String SRC_GEN = "src-gen";
    private static String OUTPUT = "";
    private IProject project;
    private IProgressMonitor progressMonitor;
    private Engine engine;

    public TranslatorRepastSimphony(IProject project, IProgressMonitor progressMonitor, Engine engine) {
        this(engine);
        this.project = project;
        this.progressMonitor = progressMonitor;
    }

    public TranslatorRepastSimphony(Engine engine) {
        this.packageName = "Package";
        this.supportName = "support";
        this.unitsConsistency = true;
        this.generateC = false;
        this.generateJava = true;
        this.engine = engine;
        this.loadProperties();
        this.loadUnitsProperties();
        InformationManagers.getInstance().getFunctionManager().load(this.getClass().getResourceAsStream("/implementedFunctions.csv"));
        this.loadUnitsEquivalences();
        Translator.target = "Java";
    }

    @Override
    public void initialize() {
        Parameters params = RunEnvironment.getInstance().getParameters();
        this.reader = new Reader(params.getValueAsString("MDL_FILE"));
        this.objectName = params.getValueAsString("OBJECT_NAME");
        Translator.target = params.getValueAsString("TARGET_LANGUAGE");
        this.dataType = params.getValueAsString("DATA_TYPE");
        this.destinationDirectory = params.getValueAsString("DESTINATION_DIRECTORY");
        this.miscDirectory = params.getValueAsString("MISC_DIRECTORY");
        this.packageName = params.getValueAsString("PACKAGE_NAME");
        this.supportName = "repast.simphony.systemdynamics.support";
        this.unitsConsistency = (Boolean)params.getValue("unitsConsistency");
        this.generateC = (Boolean)params.getValue("generateC");
        this.generateJava = (Boolean)params.getValue("generateJava");
        if (Translator.target.equalsIgnoreCase("Java")) {
            Translator.target = "Java";
        } else if (Translator.target.equalsIgnoreCase("Javascript")) {
            Translator.target = "Javascript";
        } else if (Translator.target.equalsIgnoreCase("C")) {
            Translator.target = "C";
        }
        System.out.println("********");
        System.out.println("MDL File: " + params.getValueAsString("MDL_FILE"));
        System.out.println("Object Name: " + this.objectName);
        System.out.println("Target Language: " + target);
        System.out.println("Data Type: " + this.dataType);
        System.out.println("Dest Dir: " + this.destinationDirectory);
        System.out.println("Misc Dir: " + this.miscDirectory);
        System.out.println("Package: " + this.packageName);
        System.out.println("********");
        this.startProcess();
    }

    public void ingest(SystemModel systemModel) {
        System.out.println("\n\n\n\n ingest \n\n\n\n\n");
        HashMap<String, String> linksTo = new HashMap<String, String>();
        HashMap<String, String> linksFrom = new HashMap<String, String>();
        HashMap<String, String> uuidToName = new HashMap<String, String>();
        HashMap<String, String> nameToUuid = new HashMap<String, String>();
        for (Variable variable : systemModel.getVariables()) {
            System.out.println("Name: " + variable.getName());
            System.out.println("Type: " + variable.getType());
            System.out.println("Units: " + variable.getUnits());
            System.out.println("Equation: " + variable.getEquation());
            System.out.println("Subscripts: " + variable.getSubscripts());
            System.out.println("Comment: " + variable.getComment());
            System.out.println("Uuid: " + variable.getUuid());
            System.out.println("#####\n");
            uuidToName.put(variable.getUuid(), variable.getName());
            nameToUuid.put(variable.getName(), variable.getUuid());
        }
        for (InfluenceLink link : systemModel.getLinks()) {
            String id = link.getUuid();
            String to = link.getTo().getUuid();
            String from = link.getFrom().getUuid();
            linksTo.put(id, to);
            linksFrom.put(id, from);
            System.out.println("Link From " + (String)uuidToName.get(from) + " to " + (String)uuidToName.get(to));
        }
        for (Subscript subscript : systemModel.getSubscripts()) {
            System.out.println("Subscript: " + subscript.getName());
            for (String element : subscript.getElements()) {
                System.out.println("   Element: " + element);
            }
        }
    }

    public boolean validateGenerateMDL(String mdlFile, boolean generateCode, List<String> messages) {
        this.reader = null;
        this.objectName = "Object";
        Translator.target = "JAVA";
        this.dataType = "Arrays";
        try {
            this.destinationDirectory = this.addSrcPath(this.project, this.progressMonitor, SRC_GEN);
            this.miscDirectory = this.addPath(this.project, this.progressMonitor, this.getMiscDirectory());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.packageName = "Package";
        this.supportName = "support";
        this.unitsConsistency = true;
        this.generateC = false;
        this.generateJava = true;
        this.loadProperties();
        this.loadUnitsProperties();
        InformationManagers.getInstance().getFunctionManager().load(this.getClass().getResourceAsStream("/implementedFunctions.csv"));
        this.loadUnitsEquivalences();
        Translator.target = "Java";
        System.out.println("********");
        System.out.println("MFL File: " + mdlFile);
        System.out.println("Object Name: " + this.objectName);
        System.out.println("Target Language: " + target);
        System.out.println("Data Type: " + this.dataType);
        System.out.println("Dest Dir: " + this.destinationDirectory);
        System.out.println("Misc Dir: " + this.miscDirectory);
        System.out.println("Package: " + this.packageName);
        System.out.println("********");
        messages.add("********");
        messages.add("MDL File: " + mdlFile);
        messages.add("Object Name: " + this.objectName);
        messages.add("********");
        List<String> mdlContents = new Reader(mdlFile).readMDLFile();
        if (mdlContents == null) {
            messages.add("MDL Read failure");
            return false;
        }
        boolean success = this.validateGenerate(mdlContents, generateCode, messages);
        return success;
    }

    public boolean validateGenerateRSD(SystemModel systemModel, boolean generateCode, List<String> messages) {
        this.reader = null;
        this.objectName = systemModel.getClassName();
        Translator.target = "JAVA";
        this.dataType = "Arrays";
        try {
            this.destinationDirectory = this.addSrcPath(this.project, this.progressMonitor, SRC_GEN);
            this.miscDirectory = this.addPath(this.project, this.progressMonitor, this.getMiscDirectory());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.packageName = systemModel.getPackage();
        this.supportName = "support";
        this.unitsConsistency = true;
        this.generateC = false;
        this.generateJava = true;
        this.loadProperties();
        this.loadUnitsProperties();
        InformationManagers.getInstance().getFunctionManager().load(this.getClass().getResourceAsStream("/implementedFunctions.csv"));
        this.loadUnitsEquivalences();
        Translator.target = "Java";
        System.out.println("********");
        System.out.println("RSD File: " + systemModel.getClassName());
        System.out.println("Object Name: " + this.objectName);
        System.out.println("Target Language: " + target);
        System.out.println("Data Type: " + this.dataType);
        System.out.println("Dest Dir: " + this.destinationDirectory);
        System.out.println("Misc Dir: " + this.miscDirectory);
        System.out.println("Package: " + this.packageName);
        System.out.println("********");
        boolean success = true;
        if (systemModel.getPackage() == null) {
            messages.add("Package must be non-null on Properties tab");
            success = false;
        }
        if (systemModel.getClassName() == null) {
            messages.add("Class name must be non-null on Properties tab");
            success = false;
        }
        if (!success) {
            return success;
        }
        messages.add("********");
        messages.add("Package: " + systemModel.getPackage());
        messages.add("Class Name: " + systemModel.getClassName());
        messages.add("********");
        List<String> mdlContents = this.convertToMDL(systemModel);
        success = this.validateGenerate(mdlContents, generateCode, messages);
        return success;
    }

    public void generateCodeForRSD(SystemModel systemModel) {
        this.reader = null;
        this.objectName = systemModel.getClassName();
        Translator.target = "JAVA";
        this.dataType = "Arrays";
        try {
            this.destinationDirectory = this.addSrcPath(this.project, this.progressMonitor, SRC_GEN);
            this.miscDirectory = this.addPath(this.project, this.progressMonitor, this.getMiscDirectory());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.packageName = systemModel.getPackage();
        this.supportName = "support";
        this.unitsConsistency = true;
        this.generateC = false;
        this.generateJava = true;
        this.loadProperties();
        InformationManagers.getInstance().getFunctionManager().load(this.getClass().getResourceAsStream("/implementedFunctions.csv"));
        Translator.target = "Java";
        System.out.println("********");
        System.out.println("RSD File: " + systemModel.getClassName());
        System.out.println("Object Name: " + this.objectName);
        System.out.println("Target Language: " + target);
        System.out.println("Data Type: " + this.dataType);
        System.out.println("Dest Dir: " + this.destinationDirectory);
        System.out.println("Misc Dir: " + this.miscDirectory);
        System.out.println("Package: " + this.packageName);
        System.out.println("********");
        List<String> mdlContents = this.convertToMDL(systemModel);
        boolean success = this.execute(mdlContents);
        if (!success) {
            System.out.println("Errors Prevent completion of operation");
        }
    }

    private List<String> convertToMDL(SystemModel systemModel) {
        StringBuffer sb;
        ArrayList<String> mdlContents = new ArrayList<String>();
        HashMap linksTo = new HashMap();
        HashMap linksFrom = new HashMap();
        HashMap<String, String> uuidToName = new HashMap<String, String>();
        HashMap<String, String> nameToUuid = new HashMap<String, String>();
        mdlContents.add("INITIAL TIME = " + systemModel.getStartTime());
        mdlContents.add(FIELD_SEPARATOR + systemModel.getUnits());
        mdlContents.add(FIELD_SEPARATOR);
        mdlContents.add(EQUATION_TERMINATOR);
        mdlContents.add("FINAL TIME = " + systemModel.getEndTime());
        mdlContents.add(FIELD_SEPARATOR + systemModel.getUnits());
        mdlContents.add(FIELD_SEPARATOR);
        mdlContents.add(EQUATION_TERMINATOR);
        mdlContents.add("TIME STEP = " + systemModel.getTimeStep());
        mdlContents.add(FIELD_SEPARATOR + systemModel.getUnits());
        mdlContents.add(FIELD_SEPARATOR);
        mdlContents.add(EQUATION_TERMINATOR);
        mdlContents.add("SAVEPER = " + systemModel.getReportingInterval());
        mdlContents.add(FIELD_SEPARATOR + systemModel.getUnits());
        mdlContents.add(FIELD_SEPARATOR);
        mdlContents.add(EQUATION_TERMINATOR);
        for (Subscript subscript : systemModel.getSubscripts()) {
            mdlContents.add(String.valueOf(subscript.getName()) + ":");
            int i = 0;
            sb = new StringBuffer("\t");
            for (String element : subscript.getElements()) {
                if (i++ > 0) {
                    sb.append(",");
                }
                sb.append(element.replace("\n", ""));
            }
            mdlContents.add(sb.toString());
            mdlContents.add(FIELD_SEPARATOR);
            mdlContents.add(FIELD_SEPARATOR);
            mdlContents.add(EQUATION_TERMINATOR);
        }
        for (Variable variable : systemModel.getVariables()) {
            if (variable.getType().equals((Object)VariableType.CONSTANT) && (variable.getName() == null || variable.getName().startsWith(CLOUD_IDENTIFIER))) continue;
            if (variable.getType().equals((Object)VariableType.STOCK)) {
                Stock stk = (Stock)variable;
                stk.getInitialValue();
            }
            uuidToName.put(variable.getUuid(), variable.getName());
            nameToUuid.put(variable.getName(), variable.getUuid());
            if (variable.getName() == null) continue;
            String name = variable.getName();
            sb = new StringBuffer();
            if (variable.getSubscripts() != null && variable.getSubscripts().size() > 0) {
                int i = 0;
                sb.append("[");
                for (String s : variable.getSubscripts()) {
                    if (i++ > 0) {
                        sb.append(",");
                    }
                    sb.append(s);
                }
                sb.append("]");
            }
            String lhs = String.valueOf(name) + sb.toString();
            if (variable.getType().equals((Object)VariableType.STOCK)) {
                Stock stk = (Stock)variable;
                String equation = variable.getEquation();
                if (!equation.contains(MULTIPLE_SEPARATOR)) {
                    mdlContents.add(String.valueOf(variable.getLhs()) + "= INTEG(");
                    mdlContents.add(String.valueOf(variable.getEquation()) + "," + stk.getInitialValue() + ")");
                } else {
                    mdlContents.add(String.valueOf(variable.getLhs()) + "= INTEG(");
                    String[] parts = equation.split(MULTIPLE_SEPARATOR_REGEX);
                    String cmdHead = String.valueOf(parts[0]) + "," + stk.getInitialValue() + ")";
                    int i = 1;
                    while (i < parts.length) {
                        cmdHead = String.valueOf(cmdHead) + MULTIPLE_SEPARATOR + parts[i];
                        ++i;
                    }
                    mdlContents.add(cmdHead);
                }
            } else if (variable.getType().equals((Object)VariableType.RATE) || variable.getType().equals((Object)VariableType.CONSTANT) || variable.getType().equals((Object)VariableType.AUXILIARY)) {
                mdlContents.add(String.valueOf(variable.getLhs()) + "=");
                mdlContents.addAll(this.processMultiples(variable.getEquation()));
            } else if (variable.getType().equals((Object)VariableType.LOOKUP)) {
                mdlContents.add(variable.getEquation());
            }
            mdlContents.add(FIELD_SEPARATOR + (variable.getUnits() != null ? variable.getUnits() : ""));
            mdlContents.add(FIELD_SEPARATOR + (variable.getComment() != null ? variable.getComment() : ""));
            mdlContents.add(EQUATION_TERMINATOR);
        }
        mdlContents.add(EQUATIONS_TERMINATOR);
        mdlContents.add(GRAPHICS_TERMINATOR);
        return mdlContents;
    }

    private List<String> processMultiples(String anEquation) {
        ArrayList<String> al = new ArrayList<String>();
        if (!anEquation.contains(MULTIPLE_SEPARATOR)) {
            al.add(anEquation);
            return al;
        }
        String[] eqns = anEquation.split(MULTIPLE_SEPARATOR_REGEX);
        int numEqn = eqns.length;
        int proc = 0;
        String[] stringArray = eqns;
        int n = eqns.length;
        int n2 = 0;
        while (n2 < n) {
            String eqn = stringArray[n2];
            if (proc++ == numEqn - 1) {
                al.add(eqn.replace("\n", ""));
            } else {
                al.add((String.valueOf(eqn) + MULTIPLE_SEPARATOR).replace("\n", ""));
            }
            ++n2;
        }
        return al;
    }

    @Override
    protected void process(Map<String, Equation> equations) {
        CodeGenerator cg = null;
        if (equations != null) {
            this.generateMemory();
            ArrayList<String> evaluationOrder = this.determineEvaluationOrder(equations);
            if (evaluationOrder != null) {
                String dir = String.valueOf(this.getSourceDirectory()) + "/" + this.asDirectoryPath(this.packageName) + "/";
                new File(dir).mkdirs();
                cg = new CodeGenerator(dir, evaluationOrder, equations, this.objectName, Translator.target, this);
                cg.setInitializeScenarioDirectory(!this.isHybridCompatibility());
                cg.generateCode();
            }
            try {
                this.project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateCausalTrees(SystemDynamicsObjectManager sdObjectManager) {
        CausalAnalyzer analyzer = new CausalAnalyzer();
        analyzer.generateCausalTrees(sdObjectManager);
    }

    private void generatePolarityCode(Map<String, Equation> equations) {
        for (Equation eqn : equations.values()) {
            if (!eqn.isAssignment() || eqn.isDefinesLookup() || eqn.isUsesTimeSeries() || eqn.isDefinesLookupGetXls()) continue;
            if (eqn.getVensimEquation().contains("INTEG")) {
                System.out.println("INTEG");
            }
            PolarityCodeBuilder polarityCodeBuilder = new PolarityCodeBuilder(eqn);
            System.out.println(eqn.getVensimEquation());
            System.out.println(polarityCodeBuilder.getGeneratedCode());
        }
    }

    private String addPath(IProject project, IProgressMonitor monitor, String dirName) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath srcPath = javaProject.getPath().append(String.valueOf(dirName) + "/");
        IFolder folder = project.getFolder(dirName);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        return project.getLocation().append(srcPath.lastSegment()).toPortableString();
    }

    private String addSrcPath(IProject project, IProgressMonitor monitor, String dirName) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath srcPath = javaProject.getPath().append(String.valueOf(dirName) + "/");
        IFolder folder = project.getFolder(dirName);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            boolean found = false;
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)srcPath)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                IClasspathEntry srcEntry;
                IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                System.arraycopy(entries, 0, newEntries, 0, entries.length);
                newEntries[entries.length] = srcEntry = JavaCore.newSourceEntry((IPath)srcPath, null);
                javaProject.setRawClasspath(newEntries, null);
            }
        }
        return project.getLocation().append(srcPath.lastSegment()).toPortableString();
    }

    public String getProjectLocation() {
        return this.project.getLocation().toPortableString();
    }

    public String getProjectName() {
        return this.project.getName();
    }

    @Override
    public String getSourceDirectory() {
        return String.valueOf(this.destinationDirectory) + "/";
    }

    @Override
    public String getScenarioDirectory() {
        return String.valueOf(this.getProjectLocation()) + "/" + this.getProjectName() + ".rs/";
    }

    public Engine getEngine() {
        return this.engine;
    }
}

