/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.systemdynamics.translator.Arrow;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.GraphicObject;

public class SystemDynamicsObject {
    private String screenName;
    private List<GraphicObject> graphicObjects = new ArrayList<GraphicObject>();
    private List<Equation> equations = new ArrayList<Equation>();
    private List<Arrow> incomingArrows = new ArrayList<Arrow>();
    private List<Arrow> outgoingArrows = new ArrayList<Arrow>();

    public SystemDynamicsObject() {
    }

    public SystemDynamicsObject(String name) {
        this();
        this.screenName = name.replace("\"", "");
    }

    public String getAssociatedVariableName() {
        if (this.graphicObjects.size() == 0) {
            return null;
        }
        for (GraphicObject go : this.graphicObjects) {
            if (go.getAssociatedVariable() == null) continue;
            return go.getAssociatedVariable().getName();
        }
        return null;
    }

    public String getType() {
        if (this.graphicObjects.size() == 0) {
            return "UNKNOWN";
        }
        return this.graphicObjects.get(0).getTypeAsString();
    }

    public boolean isStock() {
        if (this.getType().equals("VARIABLE")) {
            if (this.equations.size() > 0) {
                return this.equations.get(0).isStock();
            }
            return false;
        }
        return false;
    }

    public void print() {
        System.out.println("Screen Name: " + this.screenName);
        System.out.println("\tNumber of Graphic Representations: " + this.graphicObjects.size());
        System.out.println("\tNumber of Equations: " + this.equations.size());
        for (Equation eqn : this.equations) {
            System.out.println("\t\t" + eqn.getEquation());
        }
        System.out.print("\tNumber of In Arrows: " + this.incomingArrows.size());
        for (Arrow s : this.incomingArrows) {
            System.out.print(", " + s);
        }
        System.out.print("\n");
        System.out.print("\tNumber of Out Arrows: " + this.outgoingArrows.size());
        for (Arrow s : this.outgoingArrows) {
            System.out.print(", " + s);
        }
        System.out.print("\n");
    }

    public void addGraphicObject(GraphicObject graphicObject) {
        if (!this.graphicObjects.contains(graphicObject)) {
            this.graphicObjects.add(graphicObject);
        }
    }

    public void addEquation(Equation equation) {
        if (!this.equations.contains(equation)) {
            this.equations.add(equation);
        }
    }

    public void addIncomingArrow(Arrow arrow) {
        if (!this.arrowExists(this.incomingArrows, arrow)) {
            this.incomingArrows.add(arrow);
        }
    }

    public void addOutgoingArrow(Arrow arrow) {
        if (!this.arrowExists(this.outgoingArrows, arrow)) {
            this.outgoingArrows.add(arrow);
        }
    }

    public boolean arrowExists(List<Arrow> arrows, Arrow newArrow) {
        for (Arrow arrow : arrows) {
            if (!arrow.getOtherEnd().equals(newArrow.getOtherEnd())) continue;
            return true;
        }
        return false;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public List<GraphicObject> getGraphicObjects() {
        return this.graphicObjects;
    }

    public void setGraphicObjects(List<GraphicObject> graphicObjects) {
        this.graphicObjects = graphicObjects;
    }

    public List<Equation> getEquations() {
        return this.equations;
    }

    public void setEquations(List<Equation> equations) {
        this.equations = equations;
    }

    public List<Arrow> getIncomingArrows() {
        return this.incomingArrows;
    }

    public void setIncomingArrows(List<Arrow> incomingArrows) {
        this.incomingArrows = incomingArrows;
    }

    public List<Arrow> getOutgoingArrows() {
        return this.outgoingArrows;
    }

    public void setOutgoingArrows(List<Arrow> outgoingArrows) {
        this.outgoingArrows = outgoingArrows;
    }
}

