/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import repast.simphony.systemdynamics.sdmodel.SDModelPackage;
import repast.simphony.systemdynamics.sdmodel.SystemModel;

public class Reader {
    private String filename;

    public Reader() {
    }

    public Reader(String filename) {
        this();
        this.filename = filename;
    }

    public SystemModel readRSDFile() {
        XMIResourceImpl resource = new XMIResourceImpl();
        try {
            resource.load((InputStream)new FileInputStream(this.filename), new HashMap());
            SystemModel systemModel = null;
            for (EObject obj : resource.getContents()) {
                if (!obj.eClass().equals(SDModelPackage.Literals.SYSTEM_MODEL)) continue;
                systemModel = (SystemModel)obj;
                return systemModel;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<String> readMDLFile() {
        String aLine;
        ArrayList<String> mdlContents = new ArrayList<String>();
        BufferedReader fileReader = null;
        try {
            FileInputStream fstream = new FileInputStream(this.filename);
            DataInputStream in = new DataInputStream(fstream);
            try {
                fileReader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            aLine = fileReader.readLine();
            if (!aLine.contains("{UTF-8}")) {
                System.out.println("Bad initial record: " + aLine);
                System.out.println("Will try to comtinue");
                boolean plusTab = false;
                if (aLine.endsWith("\t")) {
                    plusTab = true;
                }
                mdlContents.add(String.valueOf(aLine.trim()) + (plusTab ? "\t" : ""));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            aLine = fileReader.readLine();
            while (aLine != null) {
                boolean plusTab = false;
                if (aLine.endsWith("\t")) {
                    plusTab = true;
                }
                mdlContents.add(String.valueOf(aLine.trim()) + (plusTab ? "\t" : ""));
                aLine = fileReader.readLine();
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mdlContents;
    }
}

