/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import repast.simphony.systemdynamics.support.MutableInteger;

public class Parser {
    private static char[] terminators = new char[]{'+', '-', '*', '/', '(', ')', '=', ',', '^', '`', '>', '<', ':', ';'};
    private static HashSet<Character> terminatorSet = new HashSet();
    public static final String INTERNAL_UNARY_MINUS = "_";

    static {
        char[] cArray = terminators;
        int n = terminators.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            terminatorSet.add(Character.valueOf(c));
            ++n2;
        }
    }

    public static String translateUnaryOperator(String u) {
        if (u.equals(INTERNAL_UNARY_MINUS)) {
            return "-";
        }
        return u;
    }

    public static boolean isOperator(String token) {
        return Parser.isArithmeticOperator(token) || Parser.isLogicalOperator(token) || Parser.isRelationalOperator(token) || token.equals("=");
    }

    public static boolean isArithmeticOperator(String token) {
        return token.equals("+") || token.equals("-") || token.equals("*") || token.equals("/") || token.equals(INTERNAL_UNARY_MINUS) || token.equals("^");
    }

    public static boolean isBinaryOperator(String token) {
        return !token.equals(INTERNAL_UNARY_MINUS) && !token.equals("!") && !token.equals(":NOT:");
    }

    public static boolean isEqualSign(String token) {
        return token.equals("=");
    }

    public static boolean isUnaryOperator(String token) {
        return !Parser.isBinaryOperator(token);
    }

    public static boolean isBooleanOperator(String token) {
        return Parser.isLogicalOperator(token) || Parser.isRelationalOperator(token);
    }

    public static boolean isLogicalOperator(String token) {
        return token.equals(":OR:") || token.equals(":NOT:") || token.equals(":AND:") || token.equals("||") || token.equals("!") || token.equals("&&");
    }

    public static boolean isRelationalOperator(String token) {
        return token.equals("==") || token.equals("<>") || token.equals(">") || token.equals(">=") || token.equals("<") || token.equals("<=");
    }

    public static String getFunctionName(String functionInvocation) {
        return functionInvocation.replace("sdFunctions.", "");
    }

    public static boolean isFunctionInvocation(String token) {
        if (token == null) {
            return false;
        }
        return token.startsWith("sdFunction");
    }

    public static boolean isFunctionArgumentSeparator(String token) {
        return token.equals(",");
    }

    public static boolean isLeftParen(String token) {
        return token.equals("(");
    }

    public static boolean isRightParen(String token) {
        return token.equals(")");
    }

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isReal(String input) {
        if (input.equals(":NA:")) {
            return true;
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNumber(String token) {
        return Parser.isInteger(token) || Parser.isReal(token);
    }

    public static boolean isWord(String expression) {
        MutableInteger ptr = new MutableInteger(0);
        while (Parser.inRange(expression, ptr)) {
            String aChar = Parser.characterAt(expression, ptr);
            if (!(Character.isLetterOrDigit(aChar.charAt(0)) || Character.isWhitespace(aChar.charAt(0)) || aChar.equals(INTERNAL_UNARY_MINUS) || aChar.equals(","))) {
                return false;
            }
            ptr.add(1);
        }
        return true;
    }

    public static boolean isQuotedString(String s) {
        return s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'");
    }

    public static boolean isLocalVariable(String s) {
        return s.equalsIgnoreCase("time") || s.equalsIgnoreCase("timestep");
    }

    /*
     * Unable to fully structure code
     */
    public static String forceDouble(String expression) {
        tokens = new ArrayList<String>();
        ptr = new MutableInteger(0);
        inQuote = false;
        if (!expression.contains("VDMLOOKUP")) ** GOTO lbl25
        return expression;
lbl-1000:
        // 1 sources

        {
            aChar = Parser.characterAt(expression, ptr);
            if (aChar.equals("\"")) {
                v0 = inQuote = inQuote == false;
            }
            if (!inQuote && Parser.startMemoryReference(expression, ptr)) {
                memoryRef = Parser.getMemoryReferenceStartingAt(expression, ptr);
                tokens.add(memoryRef);
                continue;
            }
            if (!inQuote && (Character.isDigit(aChar.charAt(0)) || aChar.equals("."))) {
                number = Parser.getNumberStartingAt(expression, ptr);
                if (!number.contains(".")) {
                    number = String.valueOf(number) + ".0";
                }
                tokens.add(number);
                continue;
            }
            tokens.add(aChar);
            ptr.add(1);
lbl25:
            // 4 sources

            ** while (Parser.inRange((String)expression, (MutableInteger)ptr))
        }
lbl26:
        // 1 sources

        forced = "";
        for (String s : tokens) {
            forced = String.valueOf(forced) + s;
        }
        return forced;
    }

    private static boolean startMemoryReference(String expression, MutableInteger ptr) {
        return Parser.characterAt(ptr.value(), expression).equals("m") && Parser.characterAt(ptr.value() + 1, expression).equals("e") && Parser.characterAt(ptr.value() + 2, expression).equals("m") && Parser.characterAt(ptr.value() + 3, expression).equals("o") && Parser.characterAt(ptr.value() + 4, expression).equals("r") && Parser.characterAt(ptr.value() + 5, expression).equals("y") && Parser.characterAt(ptr.value() + 6, expression).equals(".");
    }

    private static String getMemoryReferenceStartingAt(String equation, MutableInteger position) {
        String memoryReference = "";
        while (Parser.inRange(equation, position) && !Parser.characterAt(equation, position).equals(",")) {
            memoryReference = String.valueOf(memoryReference) + Parser.characterAt(equation, position);
            position.add(1);
        }
        return memoryReference;
    }

    public static String characterAt(String equation, MutableInteger position) {
        return equation.substring(position.value(), position.value() + 1);
    }

    private static String getNumberStartingAt(String equation, MutableInteger position) {
        String number = "";
        if (Parser.characterAt(equation, position).equals("-")) {
            number = "-";
            position.add(1);
        }
        while (Parser.inRange(equation, position) && (Character.isDigit(Parser.characterAt(equation, position).charAt(0)) || Parser.characterAt(equation, position).equals("."))) {
            number = String.valueOf(number) + Parser.characterAt(equation, position);
            position.add(1);
        }
        return number;
    }

    public static boolean inRange(String equation, MutableInteger position) {
        return position.value() <= equation.length() - 1;
    }

    public static int getRowFromCellAddress(String cellAddress) {
        int row = 1;
        String rc = cellAddress;
        if (cellAddress.contains("!")) {
            rc = cellAddress.split("!")[1];
        }
        int rowPos = Parser.getFirstNumberPosition(rc);
        row = Integer.parseInt(rc.substring(rowPos));
        return row;
    }

    public static String getColumnLettersFromCellAddress(String cellAddress) {
        boolean column = true;
        String rc = cellAddress;
        if (cellAddress.contains("!")) {
            rc = cellAddress.split("!")[1];
        }
        int rowPos = Parser.getFirstNumberPosition(rc);
        return rc.substring(0, rowPos);
    }

    public static int getColumnFromCellAddress(String cellAddress) {
        int column = 1;
        String rc = cellAddress;
        if (cellAddress.contains("!")) {
            rc = cellAddress.split("!")[1];
        }
        int rowPos = Parser.getFirstNumberPosition(rc);
        column = Parser.convertColumnToNumber(rc.substring(0, rowPos));
        return column;
    }

    public static int convertColumnToNumber(String column) {
        int num = 0;
        int pos = 0;
        char[] chars = column.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            num = (int)((double)num + (double)(Character.getNumericValue(chars[i]) - 9) * Math.pow(26.0, pos++));
            --i;
        }
        return num;
    }

    private static int getFirstNumberPosition(String address) {
        MutableInteger pos = new MutableInteger(0);
        while (Parser.inRange(address, pos) && Character.isLetter(Parser.characterAt(address, pos).toCharArray()[0])) {
            pos.add(1);
        }
        return pos.value();
    }

    public static boolean containsNonquotedColon(String line) {
        boolean colon = false;
        boolean inQuote = false;
        MutableInteger position = new MutableInteger(0);
        while (Parser.inRange(line, position)) {
            if (Parser.characterAt(line, position).equals("\"")) {
                boolean bl = inQuote = !inQuote;
            }
            if (Parser.characterAt(line, position).equals(":") && !colon) {
                colon = !inQuote;
            }
            position.add(1);
        }
        return colon;
    }

    /*
     * Unable to fully structure code
     */
    public static String getStringStartingAt(MutableInteger position, String equation) {
        string = "";
        if (!Parser.inRange(position, equation) || !Parser.characterAt(position, equation).equals("\"")) ** GOTO lbl7
        return Parser.getQuotedStringStartingAt(position, equation);
lbl-1000:
        // 1 sources

        {
            string = String.valueOf(string) + Parser.characterAt(position, equation);
            position.add(1);
lbl7:
            // 2 sources

            ** while (Parser.inRange((MutableInteger)position, (String)equation) && (Character.isLetter((char)Parser.characterAt((MutableInteger)position, (String)equation).charAt((int)0)) || Character.isDigit((char)Parser.characterAt((MutableInteger)position, (String)equation).charAt((int)0)) || Parser.characterAt((MutableInteger)position, (String)equation).equals((Object)" ") || Parser.characterAt((MutableInteger)position, (String)equation).equals((Object)"\"") || Parser.characterAt((MutableInteger)position, (String)equation).equals((Object)"!")))
        }
lbl8:
        // 1 sources

        return string.trim();
    }

    public static String getNumberStartingAt(MutableInteger position, String equation) {
        String number = "";
        if (Parser.characterAt(position, equation).equals("-")) {
            number = "-";
            position.add(1);
        }
        while (Parser.inRange(position, equation) && (Character.isDigit(Parser.characterAt(position, equation).charAt(0)) || Parser.characterAt(position, equation).equals("."))) {
            number = String.valueOf(number) + Parser.characterAt(position, equation);
            position.add(1);
        }
        return number;
    }

    public static String getNonQuotedStringStartingAtWithDelimitor(MutableInteger position, String equation, String delimitor) {
        String nonQuotedString = "";
        while (Parser.inRange(position, equation) && !Parser.characterAt(position, equation).equals(delimitor)) {
            nonQuotedString = String.valueOf(nonQuotedString) + Parser.characterAt(position, equation);
            position.add(1);
        }
        return nonQuotedString.trim();
    }

    public static String getNonQuotedStringStartingAt(MutableInteger position, String equation, boolean allowColon) {
        String nonQuotedString = "";
        while (Parser.inRange(position, equation) && (Character.isLetterOrDigit(Parser.characterAt(position, equation).charAt(0)) || Parser.characterAt(position, equation).equals("#") || Parser.characterAt(position, equation).equals(".") || Parser.characterAt(position, equation).equals(INTERNAL_UNARY_MINUS) || Parser.characterAt(position, equation).equals("$") || Parser.characterAt(position, equation).equals("!") || allowColon && Parser.characterAt(position, equation).equals(":") || Parser.characterAt(position, equation).equals(" "))) {
            nonQuotedString = String.valueOf(nonQuotedString) + Parser.characterAt(position, equation);
            position.add(1);
        }
        return nonQuotedString.trim();
    }

    public static String getQuotedStringStartingAt(MutableInteger position, String equation) {
        String quoteChar = Parser.characterAt(position, equation);
        String quotedString = "";
        position.add(1);
        while (Parser.inRange(position, equation) && !Parser.characterAt(position, equation).equals(quoteChar)) {
            quotedString = String.valueOf(quotedString) + Parser.characterAt(position, equation);
            position.add(1);
        }
        position.add(1);
        return quotedString;
    }

    public static String characterAt(int position, String equation) {
        if (position > equation.length() - 1) {
            return null;
        }
        String s = equation.substring(position, position + 1);
        return equation.substring(position, position + 1);
    }

    public static String characterAt(MutableInteger position, String equation) {
        String s = equation.substring(position.value(), position.value() + 1);
        return equation.substring(position.value(), position.value() + 1);
    }

    public static String beyondPosition(MutableInteger position, String equation) {
        return equation.substring(position.value() + 1);
    }

    public static void skipWhiteSpace(MutableInteger position, String equation) {
        while (Parser.inRange(position, equation) && Character.isWhitespace(Parser.characterAt(position, equation).charAt(0))) {
            position.add(1);
        }
    }

    public static boolean inRange(MutableInteger position, String equation) {
        return position.value() <= equation.length() - 1;
    }

    public static String[] splitQuoted(String record, String delimitor) {
        MutableInteger position = new MutableInteger(0);
        ArrayList<String> tokens = new ArrayList<String>();
        String token = "";
        Parser.skipWhiteSpace(position, record);
        boolean done = false;
        while (!done) {
            Parser.skipWhiteSpace(position, record);
            if (!Parser.inRange(position, record)) break;
            String theChar = Parser.characterAt(position, record);
            if (Parser.characterAt(position, record).equals(delimitor)) {
                tokens.add("");
                position.add(1);
                continue;
            }
            if (Parser.characterAt(position, record).equals("\"") || Parser.characterAt(position, record).equals("'")) {
                token = Parser.getQuotedStringStartingAt(position, record);
                tokens.add(token);
                Parser.skipWhiteSpace(position, record);
                if (Parser.inRange(position, record) && !Parser.characterAt(position, record).equals(delimitor)) {
                    System.out.println("Not Delimiter(1)! " + Parser.characterAt(position, record));
                }
                position.add(1);
                continue;
            }
            token = Parser.getNonQuotedStringStartingAtWithDelimitor(position, record, delimitor);
            tokens.add(token);
            Parser.skipWhiteSpace(position, record);
            if (Parser.inRange(position, record) && !Parser.characterAt(position, record).equals(delimitor)) {
                System.out.println("Not Delimiter(2)! " + Parser.characterAt(position, record));
            }
            position.add(1);
        }
        String[] split = new String[tokens.size()];
        int i = 0;
        for (String s : tokens) {
            split[i++] = s;
        }
        return split;
    }

    public static List<String> tokenize(String equation) {
        MutableInteger position = new MutableInteger(0);
        ArrayList<String> tokens = new ArrayList<String>();
        String token = "";
        String unaryMinus = "";
        Parser.skipWhiteSpace(position, equation);
        boolean done = false;
        while (!done) {
            Parser.skipWhiteSpace(position, equation);
            if (!Parser.inRange(position, equation)) break;
            String theChar = Parser.characterAt(position, equation);
            if (Parser.characterAt(position, equation).equals("\"") || Parser.characterAt(position, equation).equals("'")) {
                token = Parser.getQuotedStringStartingAt(position, equation);
            } else if (Character.isLetter(Parser.characterAt(position, equation).charAt(0)) || Parser.characterAt(position, equation).equals("$")) {
                boolean allowColon = false;
                token = String.valueOf(unaryMinus) + Parser.getNonQuotedStringStartingAt(position, equation, allowColon);
            } else if (Character.isDigit(Parser.characterAt(position, equation).charAt(0))) {
                token = String.valueOf(unaryMinus) + Parser.getNumberStartingAt(position, equation);
            } else if (Parser.characterAt(position, equation).equals(":")) {
                token = Parser.getBooleanOperatorStartingAt(position, equation);
            } else if (Parser.isTerminator(Parser.characterAt(position, equation).charAt(0))) {
                if (Parser.characterAt(position, equation).equals("-")) {
                    String previousToken;
                    token = tokens.size() - 1 >= 0 ? ((previousToken = (String)tokens.get(tokens.size() - 1)).equals("(") || previousToken.equals("=") || Parser.isOperator(previousToken) || Parser.isFunctionArgumentSeparator(previousToken) ? INTERNAL_UNARY_MINUS : "-") : INTERNAL_UNARY_MINUS;
                } else if (Parser.characterAt(position, equation).equals("+")) {
                    String previousToken = (String)tokens.get(tokens.size() - 1);
                    token = previousToken.equals("(") || previousToken.equals("=") || Parser.isOperator(previousToken) || Parser.isFunctionArgumentSeparator(previousToken) ? " " : "+";
                } else if (Parser.characterAt(position, equation).equals("=")) {
                    token = "=";
                } else if (Parser.characterAt(position, equation).equals("<")) {
                    if (Parser.characterAt(position.value() + 1, equation).equals(">")) {
                        token = "<>";
                        position.add(1);
                    }
                    if (Parser.characterAt(position.value() + 1, equation).equals("=")) {
                        token = "<=";
                        position.add(1);
                    } else {
                        token = Parser.characterAt(position, equation);
                    }
                } else if (Parser.characterAt(position, equation).equals(">")) {
                    if (Parser.characterAt(position.value() + 1, equation).equals("=")) {
                        token = ">=";
                        position.add(1);
                    } else {
                        token = Parser.characterAt(position, equation);
                    }
                } else {
                    token = Parser.characterAt(position, equation);
                }
                position.add(1);
            } else if (Parser.characterAt(position, equation).equals("[") || Parser.characterAt(position, equation).equals("]")) {
                token = Parser.characterAt(position, equation);
                position.add(1);
            }
            tokens.add(token);
        }
        return tokens;
    }

    private static String getBooleanOperatorStartingAt(MutableInteger position, String equation) {
        String booleanOperator = ":";
        position.add(1);
        while (Parser.inRange(position, equation) && !Parser.characterAt(position, equation).equals(":")) {
            booleanOperator = String.valueOf(booleanOperator) + Parser.characterAt(position, equation);
            position.add(1);
        }
        booleanOperator = String.valueOf(booleanOperator) + ":";
        position.add(1);
        return booleanOperator;
    }

    public static boolean isTerminator(char c) {
        return terminatorSet.contains(Character.valueOf(c));
    }

    public static String extractLHS(String equation) {
        return equation.split("=")[0].trim();
    }

    public static String extractRHS(String equation) {
        return equation.split("=", 2)[1].trim();
    }
}

