/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import repast.simphony.data2.AggregateOp;
import repast.simphony.data2.engine.DataSetDescriptor;
import repast.simphony.engine.schedule.PriorityType;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.MutableBoolean;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.ArrayDeclaration;
import repast.simphony.systemdynamics.translator.CodeGenerator;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.EquationProcessor;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeArray;
import repast.simphony.systemdynamics.translator.OperationResult;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.Translator;

public class NativeDataTypeManager {
    private final String[] SYSTEM_INITIAL = new String[]{"INITIAL TIME", "INITIALTIME", "INTIAL_TIME"};
    private final String[] SYSTEM_FINAL = new String[]{"FINAL TIME", "FINALTIME", "FINAL_TIME"};
    private final String[] SYSTEM_TIMESTEP = new String[]{"TIME STEP", "TIMESTEP", "TIME_STEP"};
    public Set<String> scalars;
    public Map<String, String> legal;
    public Map<String, String> original;
    public Map<String, String> dataType;
    public Map<String, NativeArray> arrays;
    public Set<ArrayDeclaration> arrayDeclarations = new HashSet<ArrayDeclaration>();
    private int getterFile = 1;

    public NativeDataTypeManager() {
        this.scalars = new HashSet<String>();
        this.legal = new HashMap<String, String>();
        this.original = new HashMap<String, String>();
        this.dataType = new HashMap<String, String>();
        this.arrays = new HashMap<String, NativeArray>();
        this.arrayDeclarations = new HashSet<ArrayDeclaration>();
    }

    public OperationResult validateScalarReference(Map<String, Equation> equations, Equation equation, MutableInteger pos, MutableBoolean lhs) {
        OperationResult or = new OperationResult();
        String token = equation.getTokens().get(pos.value());
        String original = this.getOriginalName(token);
        if (this.scalars.contains(original)) {
            return or;
        }
        if (this.arrays.containsKey(original)) {
            if (InformationManagers.getInstance().getArrayManager().isUsedAsLookup(original)) {
                return or;
            }
            or.setErrorMessage("Array referenced as Scalar - " + token + " - original name " + original);
            return or;
        }
        if (equations.containsKey(original)) {
            return or;
        }
        or.setErrorMessage("Scalar not found - " + token + " - original name " + original);
        return or;
    }

    public NativeArray getNativeArray(String array) {
        return this.arrays.get(array);
    }

    public void addVariable(Equation equation, String variable, String dataType) {
        this.dataType.put(variable, dataType);
        if (ArrayReference.isArrayReference(variable)) {
            this.addArray(equation, variable, dataType);
        } else {
            this.addScalar(variable, dataType);
        }
    }

    private void addScalar(String scalar, String dataType) {
        if (this.arrays.containsKey(scalar)) {
            System.out.println("#####Attempting to add scalar already defined as array: " + scalar);
            System.out.println("Using array definition");
            return;
        }
        this.scalars.add(scalar);
        String legalized = this.legalize(scalar);
        this.legal.put(scalar, legalized);
        this.legal.put(legalized, legalized);
        this.original.put(legalized, scalar);
    }

    private void addArray(Equation equation, String arrayRef, String dataType) {
        ArrayReference ar = new ArrayReference(arrayRef);
        String name = ar.getArrayName();
        NativeArray na = new NativeArray(name);
        if (this.scalars.contains(name)) {
            System.out.println("Attempting to add array already defined as scalar: " + name);
            System.out.println("Remove from scalars");
            this.scalars.remove(name);
        }
        this.arrays.put(name, na);
        String legalized = this.legalize(name);
        this.legal.put(name, legalized);
        this.legal.put(legalized, legalized);
        this.original.put(legalized, name);
        int lookupHiddenDimensions = 0;
        if (equation != null && equation.isDefinesLookupGetXls()) {
            lookupHiddenDimensions = 2;
        }
        na.setNumDimensions(ar.getSubscripts().size() + lookupHiddenDimensions);
        int s = 0;
        for (String subscript : ar.getSubscripts()) {
            na.setDimensionName(s++, subscript);
        }
    }

    private String legalize(String name) {
        String legalName = null;
        legalName = this.makeLegal(name);
        if (Parser.isNumber(Parser.characterAt(legalName, new MutableInteger(0)))) {
            legalName = "_" + legalName;
        }
        if (this.legal.containsValue(legalName)) {
            String col = this.collision(legalName);
            this.legal.put(name, col);
            this.original.put(col, name);
        } else {
            this.legal.put(name, legalName);
            this.original.put(legalName, name);
        }
        return legalName;
    }

    public static String getAsJavaLocalVariable(String var) {
        return var.replace("memory.", "").replace("lookup.", "");
    }

    public String makeLegal(String name) {
        return name.replace(" ", "_").replace("/", "_").replace(":", "_").replace("-", "_").replace("&", "_").replace("(", "_").replace(")", "_").replace("(", "_").replace(")", "_").replace(".", "_").replace(",", "_").replace("'", "").replace("*", "_");
    }

    private String collision(String name) {
        String aPossible = String.valueOf(name) + "_";
        while (this.legal.containsValue(aPossible)) {
            aPossible = String.valueOf(aPossible) + "_";
        }
        return aPossible;
    }

    public String quoteIfNecessary(String vensimVariable) {
        if (Parser.isOperator(vensimVariable)) {
            return vensimVariable;
        }
        if (vensimVariable.contains("/") || vensimVariable.contains(":") || vensimVariable.contains("-") || vensimVariable.contains("&") || vensimVariable.contains("+") || vensimVariable.contains("*") || vensimVariable.contains(".") || vensimVariable.contains("(") || vensimVariable.contains(")")) {
            String quoted = "\"" + vensimVariable + "\"";
            if (quoted.contains("[")) {
                quoted = quoted.replace("]\"", "]").replace("[", "\"[");
            }
            return quoted;
        }
        return vensimVariable;
    }

    public String getOriginalName(String legalized) {
        if (legalized.startsWith("array.")) {
            return legalized.replace("array.", "");
        }
        String s = legalized.replace("memory.", "").replace("lookup.", "");
        if (this.original.containsKey(s)) {
            return this.original.get(s);
        }
        return legalized;
    }

    public String getOriginalNameQuotedIfNecessary(String legalized) {
        if (legalized.startsWith("array.")) {
            return this.quoteIfNecessary(legalized.replace("array.", ""));
        }
        String s = legalized.replace("memory.", "").replace("lookup.", "");
        if (this.original.containsKey(s)) {
            return this.quoteIfNecessary(this.original.get(s));
        }
        return this.quoteIfNecessary(legalized);
    }

    public String getLegalName(String variable) {
        return this.getLegalName(null, variable);
    }

    public String getLegalName(Equation equation, String variable) {
        String name;
        String referenceType = "memory.";
        if (variable.contains("memory.")) {
            referenceType = "memory.";
        } else if (variable.contains("lookup.")) {
            referenceType = "lookup.";
        }
        String in = variable.replace("memory.", "").replace("lookup.", "");
        if (ArrayReference.isArrayReference(in)) {
            in = new ArrayReference(in).getArrayName();
        }
        if ((name = this.legal.get(in)) == null) {
            if (Parser.isInteger(in) || Parser.isReal(in)) {
                return in;
            }
            if (in.equals("array")) {
                new Exception("Stack trace").printStackTrace();
            }
            this.addVariable(equation, variable, "double");
        }
        if ((name = this.legal.get(in)) == null && in.equals("array")) {
            new Exception("Stack trace").printStackTrace();
        }
        if (Translator.target.equals("Java")) {
            return "memory." + name;
        }
        if (Translator.target.equals("C")) {
            return "memory." + name;
        }
        return "memory." + name;
    }

    public void generateMemoryJava(BufferedWriter bw, String objectName, Translator translator) {
        try {
            bw.append("package " + translator.getPackageName() + ";\n\n");
            bw.append("public class Memory" + objectName + " {\n");
            ArrayList<String> al = new ArrayList<String>();
            al.addAll(this.scalars);
            Collections.sort(al);
            for (String scalar : al) {
                bw.append("public " + this.dataType.get(scalar) + " " + this.legal.get(scalar) + ";\n");
            }
            al = new ArrayList();
            al.addAll(this.arrays.keySet());
            Collections.sort(al);
            for (String array : al) {
                bw.append("public double");
                NativeArray na = this.arrays.get(array);
                int i = 0;
                while (i < na.getNumDimensions()) {
                    bw.append("[]");
                    ++i;
                }
                bw.append(" " + this.legal.get(array) + ";\n");
            }
            bw.append("public Memory" + objectName + "() {\n");
            for (String array : al) {
                String numInd;
                String subscript;
                if (InformationManagers.getInstance().getArrayManager().isUsedAsLookup(array)) continue;
                int dim = 0;
                NativeArray na = this.arrays.get(array);
                boolean declare = false;
                String[] stringArray = na.getDimensionNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    subscript = stringArray[n2];
                    numInd = Integer.toString(InformationManagers.getInstance().getArrayManager().getNumIndicies(array, dim));
                    if (!numInd.equals("0")) {
                        declare = true;
                    }
                    ++dim;
                    ++n2;
                }
                if (!declare) continue;
                bw.append(String.valueOf(this.legal.get(array)) + " = new double");
                dim = 0;
                stringArray = na.getDimensionNames();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    subscript = stringArray[n2];
                    numInd = Integer.toString(InformationManagers.getInstance().getArrayManager().getNumIndicies(array, dim));
                    if (numInd.equals("0")) {
                        numInd = "/* " + subscript + " */";
                    }
                    bw.append("[" + numInd + "]");
                    ++dim;
                    ++n2;
                }
                bw.append(";\n");
            }
            bw.append("}\n\n");
            if (translator.isHybridCompatibility()) {
                this.generateMemoryGettersSetters(bw, objectName, translator);
            } else {
                this.generateDataSetGetters(objectName, translator);
            }
            bw.append("public double get_SAVEPER() {");
            bw.append("return SAVEPER;");
            bw.append("}\n");
            bw.append("public double getINITIALTIME() {");
            bw.append("return " + this.getInitialTimeVariable() + ";");
            bw.append("}\n");
            bw.append("public double getFINALTIME() {");
            bw.append("return " + this.getFinalTimeVariable() + ";");
            bw.append("}\n");
            bw.append("public double getTIMESTEP() {");
            bw.append("return " + this.getTimeStepVariable() + ";");
            bw.append("}\n");
            bw.append("}\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateMemoryC(BufferedWriter bw, String objectName, Translator translator) {
        try {
            ArrayList<String> al = new ArrayList<String>();
            al.addAll(this.scalars);
            Collections.sort(al);
            for (String scalar : al) {
                if (InformationManagers.getInstance().getArrayManager().isUsedAsLookup(scalar)) {
                    bw.append(CodeGenerator.scrub("LOOKUP_t *"));
                } else {
                    String t = "double";
                    if (this.dataType.get(scalar).equals("String")) {
                        t = "char[256]";
                    }
                    bw.append(CodeGenerator.scrub(String.valueOf(t) + " "));
                }
                bw.append(CodeGenerator.scrub(String.valueOf(this.legal.get(scalar)) + ";\n"));
            }
            al = new ArrayList();
            al.addAll(this.arrays.keySet());
            Collections.sort(al);
            for (String array : al) {
                String arrayType;
                int dim = 0;
                if (InformationManagers.getInstance().getArrayManager().isUsedAsLookup(array)) {
                    bw.append(CodeGenerator.scrub("LOOKUP_t *"));
                    arrayType = "LOOKUP_t";
                } else {
                    bw.append(CodeGenerator.scrub("double "));
                    arrayType = "double";
                }
                NativeArray na = this.arrays.get(array);
                dim = 0;
                int numDimensions = na.getDimensionNames().length;
                if (arrayType.equals("LOOKUP_t")) {
                    numDimensions -= 2;
                }
                if (numDimensions <= 0) {
                    bw.append("");
                } else {
                    Integer[] dimSize = new Integer[numDimensions];
                    String[] stringArray = na.getDimensionNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String subscript = stringArray[n2];
                        String numInd = Integer.toString(InformationManagers.getInstance().getArrayManager().getNumIndicies(array, dim));
                        bw.append("*");
                        dimSize[dim] = Integer.parseInt(numInd);
                        if (++dim == numDimensions) break;
                        ++n2;
                    }
                    ArrayDeclaration ad = new ArrayDeclaration(CodeGenerator.scrub(this.legal.get(array)), arrayType, dimSize.length, dimSize);
                    this.arrayDeclarations.add(ad);
                }
                bw.append(CodeGenerator.scrub(this.legal.get(array)));
                bw.append(";\n");
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateArrayDeclarationC(BufferedWriter bw) {
        try {
            bw.append("void declareArrays() {\n");
            Iterator<ArrayDeclaration> iter = this.arrayDeclarations.iterator();
            ArrayList<ArrayDeclaration> sortedAD = new ArrayList<ArrayDeclaration>();
            while (iter.hasNext()) {
                sortedAD.add(iter.next());
            }
            Collections.sort(sortedAD, new Comparator<ArrayDeclaration>(){

                @Override
                public int compare(ArrayDeclaration o1, ArrayDeclaration o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            iter = sortedAD.iterator();
            int alreadyDefined = 0;
            while (iter.hasNext()) {
                ArrayDeclaration ad = iter.next();
                int currentR = 1;
                bw.append(String.valueOf(ad.getName()) + " = (" + ad.getType());
                if (ad.getType().equals("LOOKUP_t")) {
                    bw.append("*");
                }
                int i = 0;
                while (i < ad.getNumDimensions()) {
                    bw.append("*");
                    ++i;
                }
                bw.append(") malloc(" + ad.getDimensionSize()[0] + " * sizeof(" + ad.getType());
                if (ad.getNumDimensions() > 1 || ad.getType().equals("LOOKUP_t")) {
                    bw.append(" *));\n");
                } else {
                    bw.append("));\n");
                }
                if (ad.getType().equals("LOOKUP_t")) continue;
                int dim = 1;
                while (dim < ad.getNumDimensions()) {
                    if (currentR > alreadyDefined) {
                        bw.append("int r" + currentR + ";\n");
                        alreadyDefined = currentR;
                    }
                    bw.append("for (r" + currentR + " = 0; r" + currentR + " < " + ad.getDimensionSize()[dim - 1] + "; r" + currentR + "++) {\n");
                    bw.append(String.valueOf(ad.getName()) + "[r" + currentR + "] = (" + ad.getType() + "*) malloc(" + ad.getDimensionSize()[dim] + " * sizeof(" + ad.getType() + "));\n");
                    ++currentR;
                    ++dim;
                }
                dim = 1;
                while (dim < ad.getNumDimensions()) {
                    bw.append("}\n");
                    ++dim;
                }
            }
            bw.append("}\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String generateMemoryGettersSettersConvenience(String objectName) {
        StringBuffer bw = new StringBuffer();
        ArrayList<String> al = new ArrayList<String>();
        al.addAll(this.scalars);
        Collections.sort(al);
        for (String scalar : al) {
            String getter = "get" + StringUtils.capitalize((String)this.legal.get(scalar));
            String setter = "set" + StringUtils.capitalize((String)this.legal.get(scalar));
            bw.append("public double " + getter + "() {");
            bw.append("return memory." + this.legal.get(scalar) + ";");
            bw.append("}\n");
            bw.append("public void   " + setter + "(double value) {");
            bw.append("memory." + this.legal.get(scalar) + " = value;");
            bw.append("}\n");
        }
        return bw.toString();
    }

    private void generateMemoryGettersSetters(BufferedWriter bw, String objectName, Translator translator) {
        try {
            ArrayList<String> al = new ArrayList<String>();
            al.addAll(this.scalars);
            Collections.sort(al);
            for (String scalar : al) {
                String getter = "get" + StringUtils.capitalize((String)this.legal.get(scalar));
                String setter = "set" + StringUtils.capitalize((String)this.legal.get(scalar));
                bw.append("public double " + getter + "() {");
                bw.append("return " + this.legal.get(scalar) + ";");
                bw.append("}\n");
                bw.append("public void   " + setter + "(double value) {");
                bw.append(String.valueOf(this.legal.get(scalar)) + " = value;");
                bw.append("}\n");
            }
            al = new ArrayList();
            al.addAll(this.arrays.keySet());
            Collections.sort(al);
            for (String array : al) {
                if (EquationProcessor.lookups.contains(array)) continue;
                HashMap indexValueMap = new HashMap();
                int dimension = 0;
                while (dimension < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                    indexValueMap.put(dimension, new ArrayList());
                    int index = 0;
                    while (index < InformationManagers.getInstance().getArrayManager().getNumIndicies(array, dimension)) {
                        ((List)indexValueMap.get(dimension)).add(index);
                        ++index;
                    }
                    ++dimension;
                }
                int numDimensions = InformationManagers.getInstance().getArrayManager().getNumDimensions(array);
                ArrayList<StringBuffer> methodName = new ArrayList<StringBuffer>();
                ArrayList<StringBuffer> bodySubscript = new ArrayList<StringBuffer>();
                int numToGenerate = 1;
                int dimension2 = 0;
                while (dimension2 < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                    numToGenerate *= ((List)indexValueMap.get(dimension2)).size();
                    ++dimension2;
                }
                int i = 0;
                while (i < numToGenerate) {
                    methodName.add(new StringBuffer());
                    bodySubscript.add(new StringBuffer());
                    ++i;
                }
                dimension2 = 0;
                while (dimension2 < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                    int numPer = 1;
                    int dim = dimension2 + 1;
                    while (dim < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                        numPer *= ((List)indexValueMap.get(dim)).size();
                        ++dim;
                    }
                    int ptr = 0;
                    while (ptr < numToGenerate) {
                        int subr = 0;
                        while (subr < ((List)indexValueMap.get(dimension2)).size()) {
                            int j = 0;
                            while (j < numPer) {
                                StringBuffer sb = (StringBuffer)bodySubscript.get(ptr);
                                sb.append("[" + subr + "]");
                                StringBuffer sb2 = (StringBuffer)methodName.get(ptr);
                                ++ptr;
                                if (sb2.length() == 0) {
                                    sb2.append("$__$");
                                } else {
                                    sb2.append("$_$");
                                }
                                sb2.append(InformationManagers.getInstance().getArrayManager().getVensimSubscript(array, dimension2, subr));
                                ++j;
                            }
                            ++subr;
                        }
                    }
                    ++dimension2;
                }
                i = 0;
                while (i < bodySubscript.size()) {
                    String getter = "get" + StringUtils.capitalize((String)this.legal.get(array)) + this.makeLegal(((StringBuffer)methodName.get(i)).toString().trim());
                    String original = array;
                    String vensim = this.asVensim(String.valueOf(original) + this.makeLegal(((StringBuffer)methodName.get(i)).toString().trim()));
                    int dim = 0;
                    NativeArray na = this.arrays.get(array);
                    StringBuffer squareBrackets = new StringBuffer();
                    String[] stringArray = na.getDimensionNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String subscript = stringArray[n2];
                        String numInd = Integer.toString(InformationManagers.getInstance().getArrayManager().getNumIndicies(array, dim));
                        if (numInd.equals("0")) {
                            squareBrackets.append("[]");
                        }
                        ++dim;
                        ++n2;
                    }
                    if (squareBrackets.toString().length() <= 0) {
                        bw.append("public double" + squareBrackets.toString() + " " + getter + "() {\n");
                        bw.append("return memory." + this.legal.get(array) + ((StringBuffer)bodySubscript.get(i)).toString() + ";\n");
                        bw.append("}\n");
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateDataSetGetters(String objectName, Translator translator) {
        int maxGetterCount = 500;
        int getterCount = 0;
        BufferedWriter bw = null;
        DataSetDescriptor dsd = new DataSetDescriptor("DS1", DataSetDescriptor.DataSetType.AGGREGATE);
        dsd.setIncludeRandomSeed(true);
        dsd.setIncludeTick(true);
        dsd.setScheduleParameters(ScheduleParameters.createRepeating((double)1.0, (double)1.0));
        ++getterCount;
        String SourceDirectory = String.valueOf(translator.getSourceDirectory()) + translator.asDirectoryPath(translator.getPackageName()) + "/";
        this.writeMemoryGetterBaseClass(SourceDirectory, translator.getPackageName(), objectName);
        bw = Translator.openReport(String.valueOf(SourceDirectory) + "MemoryGetter" + this.getterFile + "_" + objectName + ".java");
        this.writeMemoryGetterHeader(bw, "MemoryGetter" + this.getterFile + "_" + objectName, objectName, translator.getPackageName(), this.getterFile - 1);
        try {
            bw.append("public String getID() {\n");
            bw.append("return \"" + objectName + "\";\n");
            bw.append("}\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ArrayList<String> al = new ArrayList<String>();
            al.addAll(this.scalars);
            Collections.sort(al);
            for (String scalar : al) {
                if (getterCount >= maxGetterCount) {
                    bw.append("}\n");
                    bw.close();
                    ++this.getterFile;
                    getterCount = 0;
                    bw = Translator.openReport(String.valueOf(SourceDirectory) + "MemoryGetter" + this.getterFile + "_" + objectName + ".java");
                    this.writeMemoryGetterHeader(bw, "MemoryGetter" + this.getterFile + "_" + objectName, objectName, translator.getPackageName(), this.getterFile - 1);
                }
                String getter = "get_" + this.legal.get(scalar);
                String original = scalar;
                dsd.addAggregateMethodDataSource(original, String.valueOf(translator.getPackageName()) + ".MemoryGetter" + this.getterFile + "_" + objectName, getter, AggregateOp.SUM);
                ++getterCount;
                bw.append("public double get_" + this.legal.get(scalar) + "() {\n");
                bw.append("return memory." + this.legal.get(scalar) + ";\n");
                bw.append("}\n");
            }
            al = new ArrayList();
            al.addAll(this.arrays.keySet());
            Collections.sort(al);
            for (String array : al) {
                if (EquationProcessor.lookups.contains(array)) continue;
                HashMap indexValueMap = new HashMap();
                int dimension = 0;
                while (dimension < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                    indexValueMap.put(dimension, new ArrayList());
                    int index = 0;
                    while (index < InformationManagers.getInstance().getArrayManager().getNumIndicies(array, dimension)) {
                        ((List)indexValueMap.get(dimension)).add(index);
                        ++index;
                    }
                    ++dimension;
                }
                int numDimensions = InformationManagers.getInstance().getArrayManager().getNumDimensions(array);
                ArrayList<StringBuffer> methodName = new ArrayList<StringBuffer>();
                ArrayList<StringBuffer> bodySubscript = new ArrayList<StringBuffer>();
                int numToGenerate = 1;
                int dimension2 = 0;
                while (dimension2 < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                    numToGenerate *= ((List)indexValueMap.get(dimension2)).size();
                    ++dimension2;
                }
                int i = 0;
                while (i < numToGenerate) {
                    methodName.add(new StringBuffer());
                    bodySubscript.add(new StringBuffer());
                    ++i;
                }
                dimension2 = 0;
                while (dimension2 < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                    int numPer = 1;
                    int dim = dimension2 + 1;
                    while (dim < InformationManagers.getInstance().getArrayManager().getNumDimensions(array)) {
                        numPer *= ((List)indexValueMap.get(dim)).size();
                        ++dim;
                    }
                    int ptr = 0;
                    while (ptr < numToGenerate) {
                        int subr = 0;
                        while (subr < ((List)indexValueMap.get(dimension2)).size()) {
                            int j = 0;
                            while (j < numPer) {
                                StringBuffer sb = (StringBuffer)bodySubscript.get(ptr);
                                sb.append("[" + subr + "]");
                                StringBuffer sb2 = (StringBuffer)methodName.get(ptr);
                                ++ptr;
                                if (sb2.length() == 0) {
                                    sb2.append("$__$");
                                } else {
                                    sb2.append("$_$");
                                }
                                sb2.append(InformationManagers.getInstance().getArrayManager().getVensimSubscript(array, dimension2, subr));
                                ++j;
                            }
                            ++subr;
                        }
                    }
                    ++dimension2;
                }
                i = 0;
                while (i < bodySubscript.size()) {
                    String getter = "get_" + this.legal.get(array) + this.makeLegal(((StringBuffer)methodName.get(i)).toString().trim());
                    String original = array;
                    String vensim = this.asVensim(String.valueOf(original) + this.makeLegal(((StringBuffer)methodName.get(i)).toString().trim()));
                    if (getterCount >= maxGetterCount) {
                        bw.append("}\n");
                        bw.close();
                        ++this.getterFile;
                        getterCount = 0;
                        bw = Translator.openReport(String.valueOf(SourceDirectory) + "MemoryGetter" + this.getterFile + "_" + objectName + ".java");
                        this.writeMemoryGetterHeader(bw, "MemoryGetter" + this.getterFile + "_" + objectName, objectName, translator.getPackageName(), this.getterFile - 1);
                    }
                    ++getterCount;
                    int dim = 0;
                    NativeArray na = this.arrays.get(array);
                    StringBuffer squareBrackets = new StringBuffer();
                    String[] stringArray = na.getDimensionNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String subscript = stringArray[n2];
                        String numInd = Integer.toString(InformationManagers.getInstance().getArrayManager().getNumIndicies(array, dim));
                        if (numInd.equals("0")) {
                            squareBrackets.append("[]");
                        }
                        ++dim;
                        ++n2;
                    }
                    if (squareBrackets.toString().length() <= 0) {
                        dsd.addAggregateMethodDataSource(vensim, String.valueOf(translator.getPackageName()) + ".MemoryGetter" + this.getterFile + "_" + objectName, getter, AggregateOp.SUM);
                        bw.append("public double" + squareBrackets.toString() + " " + getter + "() {\n");
                        bw.append("return memory." + this.legal.get(array) + ((StringBuffer)bodySubscript.get(i)).toString() + ";\n");
                        bw.append("}\n");
                    }
                    ++i;
                }
            }
            bw.append("}\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String ScenarioDirectory = translator.getScenarioDirectory();
        dsd.setScheduleParameters(ScheduleParameters.createRepeating((double)1.0, (double)1.0, (PriorityType)PriorityType.LAST));
        this.serialize(dsd, String.valueOf(ScenarioDirectory) + "repast.simphony.action.data_set_0.xml");
    }

    private void writeMemoryGetterBaseClass(String sourceDirectory, String packageName, String objectName) {
        BufferedWriter bw = Translator.openReport(String.valueOf(sourceDirectory) + "MemoryGetter" + objectName + ".java");
        try {
            bw.append("package " + packageName + ";\n\n");
            bw.append("public class MemoryGetter" + objectName + " {\n");
            bw.append("protected Memory" + objectName + " memory;\n");
            bw.append("public MemoryGetter" + objectName + "(Memory" + objectName + " memory) {\n");
            bw.append("this.memory = memory;\n");
            bw.append("}");
            bw.append("}");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeMemoryGetterHeader(BufferedWriter bw, String newObjectName, String objectName, String packageName, int previous) {
        try {
            bw.append("package " + packageName + ";\n\n");
            if (previous == 0) {
                bw.append("public class " + newObjectName + " extends MemoryGetter" + objectName + "{\n");
            } else {
                bw.append("public class " + newObjectName + " extends MemoryGetter" + objectName + "{\n");
            }
            bw.append("public " + newObjectName + "(Memory" + objectName + " memory) {\n");
            bw.append("super(memory);\n\n");
            bw.append("}\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void serialize(DataSetDescriptor dsd, String toFile) {
        XStream xstream = new XStream();
        try {
            xstream.toXML((Object)dsd, (Writer)new FileWriter(toFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String asVensim(String s) {
        String vensim = s.replace("$__$", "[");
        vensim = vensim.replace("$_$", ",");
        return String.valueOf(vensim) + "]";
    }

    private String getInitialTimeVariable() {
        for (String s : this.scalars) {
            String[] stringArray = this.SYSTEM_INITIAL;
            int n = this.SYSTEM_INITIAL.length;
            int n2 = 0;
            while (n2 < n) {
                String si = stringArray[n2];
                if (si.equalsIgnoreCase(s)) {
                    return this.makeLegal(s);
                }
                ++n2;
            }
        }
        return "ERROR_INITIAL";
    }

    private String getFinalTimeVariable() {
        for (String s : this.scalars) {
            String[] stringArray = this.SYSTEM_FINAL;
            int n = this.SYSTEM_FINAL.length;
            int n2 = 0;
            while (n2 < n) {
                String si = stringArray[n2];
                if (si.equalsIgnoreCase(s)) {
                    return this.makeLegal(s);
                }
                ++n2;
            }
        }
        return "ERROR_FINAL";
    }

    private String getTimeStepVariable() {
        for (String s : this.scalars) {
            String[] stringArray = this.SYSTEM_TIMESTEP;
            int n = this.SYSTEM_TIMESTEP.length;
            int n2 = 0;
            while (n2 < n) {
                String si = stringArray[n2];
                if (si.equalsIgnoreCase(s)) {
                    return this.makeLegal(s);
                }
                ++n2;
            }
        }
        return "ERROR_TIMESTEP";
    }

    public void dumpLegalNames(BufferedWriter bw) {
        try {
            bw.append("Name,Legal Name\n");
            for (String name : this.legal.keySet()) {
                bw.append(String.valueOf(name) + "," + this.legal.get(name) + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDataType(String var) {
        return this.dataType.get(var);
    }

    public String getLegalNameWithSubscripts(Equation equation, String variable) {
        String name;
        String subscript = "";
        String referenceType = "memory.";
        if (variable.contains("memory.")) {
            referenceType = "memory.";
        } else if (variable.contains("lookup.")) {
            referenceType = "lookup.";
        } else if (variable.contains("array.")) {
            referenceType = "array.";
        }
        String in = variable.replace("memory.", "").replace("lookup.", "");
        if (ArrayReference.isArrayReference(in)) {
            in = new ArrayReference(in).getArrayName();
            subscript = "[" + variable.split("\\[")[1];
        }
        if ((name = this.legal.get(in)) == null) {
            if (Parser.isInteger(in) || Parser.isReal(in)) {
                return in;
            }
            System.out.println("getLegalNameWithSubscripts Legal -> <" + in + "><" + name + ">");
            this.addVariable(equation, variable, "double");
        }
        if ((name = this.legal.get(in)) == null) {
            System.out.println("Legal -> <" + in + "><" + name + ">");
        }
        if (Translator.target.equals("Java")) {
            return String.valueOf(referenceType) + name + subscript;
        }
        if (Translator.target.equals("C")) {
            return "memory." + name;
        }
        return "memory." + name;
    }

    public boolean isScalar(String variable) {
        return this.scalars.contains(variable);
    }

    public boolean isArray(String variable) {
        return this.arrays.containsKey(variable);
    }

    public int getGetterFile() {
        return this.getterFile;
    }
}

