/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.Parser;

public class Macro {
    private String macroName;
    private List<String> arguments = new ArrayList<String>();
    private String originalMacroEquation;
    private List<String> expandedMacroEquation;
    private Map<String, String> localVariables = new HashMap<String, String>();

    public Macro(String macroName, List<String> arguments) {
        this.macroName = macroName;
        this.arguments.addAll(arguments);
    }

    public void addEquation(String equation) {
        String eqn = equation.split("~")[0];
        String lhs = this.extractLHS(eqn);
        String rhs = this.extractRHS(eqn);
        if (lhs.equals(this.macroName)) {
            this.originalMacroEquation = rhs;
        } else {
            this.localVariables.put(lhs, rhs);
        }
    }

    public void expand() {
        List<String> tokens = Parser.tokenize(this.originalMacroEquation);
        while (this.needsLocalVariableSubstitution(tokens)) {
            tokens = this.substituteLocalVariables(tokens);
        }
        tokens = this.substituteArguments(tokens);
        this.expandedMacroEquation = tokens;
    }

    public List<String> apply(List<String> tokens, int index) {
        ArrayList<String> applied = new ArrayList<String>();
        String lhs = "";
        int it = 0;
        while (it < tokens.size()) {
            String t;
            if ((t = tokens.get(it++)).equals("=")) break;
            lhs = String.valueOf(lhs) + t;
        }
        MutableInteger pos = new MutableInteger(index);
        String macro = tokens.get(pos.valueAndInc());
        String paren = tokens.get(pos.valueAndInc());
        List<String> args = this.extractArguments(tokens, pos, this.arguments.size());
        int i = 0;
        while (i < index) {
            applied.add(tokens.get(i));
            ++i;
        }
        applied.addAll(this.applyArguments(args, lhs));
        i = pos.value();
        while (i < tokens.size()) {
            applied.add(tokens.get(i));
            ++i;
        }
        return applied;
    }

    private List<String> applyArguments(List<String> args, String lhs) {
        ArrayList<String> applied = new ArrayList<String>();
        for (String token : this.expandedMacroEquation) {
            if (token.startsWith("_$arg")) {
                int index = Integer.parseInt(token.replace("_$arg", "").replace("$_", ""));
                applied.addAll(Parser.tokenize(args.get(index)));
                continue;
            }
            if (token.startsWith("_$macro")) {
                applied.add(lhs);
                continue;
            }
            if (token.endsWith("$")) {
                applied.add(token.substring(0, token.length() - 1));
                continue;
            }
            applied.add(token);
        }
        return applied;
    }

    private List<String> extractArguments(List<String> tokens, MutableInteger pos, int numArgs) {
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        while (i < numArgs) {
            args.add(this.extractArgument(tokens, pos));
            ++i;
        }
        return args;
    }

    private String extractArgument(List<String> tokens, MutableInteger pos) {
        StringBuffer sb = new StringBuffer();
        int parenCount = 0;
        int blockCount = 0;
        while (true) {
            String token;
            if ((token = tokens.get(pos.valueAndInc())).equals("(")) {
                ++parenCount;
            } else if (token.equals(")")) {
                if (--parenCount < 0) {
                    break;
                }
            } else if (token.equals("[")) {
                ++blockCount;
            } else if (token.equals("]")) {
                --blockCount;
            } else if (token.equals(",") && parenCount == 0 && blockCount == 0) break;
            sb.append(token);
        }
        return sb.toString();
    }

    private String makeEquation(List<String> tokens) {
        StringBuffer sb = new StringBuffer();
        for (String token : tokens) {
            if (token.equals(this.macroName)) {
                sb.append("_$macro$_");
                continue;
            }
            if (token.endsWith("$")) {
                sb.append(token.substring(0, token.length() - 1));
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private List<String> substituteArguments(List<String> tokens) {
        ArrayList<String> args = new ArrayList<String>();
        for (String token : tokens) {
            if (this.arguments.contains(token)) {
                int pos = this.arguments.indexOf(token);
                args.add("_$arg" + pos + "$_");
                continue;
            }
            if (token.equals(this.macroName)) {
                args.add("_$macro$_");
                continue;
            }
            args.add(token);
        }
        return args;
    }

    private List<String> substituteLocalVariables(List<String> tokens) {
        ArrayList<String> expanded = new ArrayList<String>();
        for (String token : tokens) {
            if (this.localVariables.containsKey(token)) {
                expanded.addAll(Parser.tokenize(this.localVariables.get(token)));
                continue;
            }
            expanded.add(token);
        }
        return expanded;
    }

    private boolean needsLocalVariableSubstitution(List<String> tokens) {
        for (String localVariable : this.localVariables.keySet()) {
            if (!tokens.contains(localVariable)) continue;
            return true;
        }
        return false;
    }

    public String getExpandedMacroEquation() {
        return this.makeEquation(this.expandedMacroEquation);
    }

    private String extractLHS(String equation) {
        return equation.split("=")[0].trim();
    }

    private String extractRHS(String equation) {
        return equation.split("=", 2)[1].trim();
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setMacroName(String macroName) {
        this.macroName = macroName;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public String getOriginalMacroEquation() {
        return this.originalMacroEquation;
    }

    public void setOriginalMacroEquation(String originalMacroEquation) {
        this.originalMacroEquation = originalMacroEquation;
    }

    public Map<String, String> getLocalVariables() {
        return this.localVariables;
    }

    public void setLocalVariables(Map<String, String> localVariables) {
        this.localVariables = localVariables;
    }
}

