/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import repast.simphony.systemdynamics.sdmodel.InfluenceLink;
import repast.simphony.systemdynamics.sdmodel.Rate;
import repast.simphony.systemdynamics.sdmodel.SDModelFactory;
import repast.simphony.systemdynamics.sdmodel.SDModelPackage;
import repast.simphony.systemdynamics.sdmodel.Subscript;
import repast.simphony.systemdynamics.sdmodel.SystemModel;
import repast.simphony.systemdynamics.sdmodel.Variable;
import repast.simphony.systemdynamics.sdmodel.VariableType;
import repast.simphony.systemdynamics.translator.MDLToSystemModel;

public class MDLToSystemModelTests {
    private static final String EPIDEMIC_MDL = "./test_data/EPIDEMIC.MDL";
    private static final String WFINV_MDL = "./test_data/WFINV.MDL";
    private static final String ARMS_MDL = "./test_data/arms4.mdl";
    private SystemModel model;
    private Diagram diagram;
    private static final String[][] EPI_EXPECTED = new String[][]{{"rate that people contact other people", "constant", "5", "rate that people contact other people", "1/day", "", ""}, {"Contacts between infected and unaffected", "auxiliary", "rate of potential infectious contacts  * Fraction of population infected", "Contacts between infected and unaffected", "Person/day", "", ""}, {"total population", "auxiliary", "Healthy + Infected", "total population", "Person", "", ""}, {"Infected", "stock", "getting sick, initial infected", "Infected", "Person", "", ""}, {"fraction infected from contact", "constant", "0.1", "fraction infected from contact", "Dmnl", "", ""}, {"Fraction of population infected", "auxiliary", "Infected / total population", "Fraction of population infected", "Dmnl", "", ""}, {"getting sick", "rate", "Contacts between infected and unaffected  * fraction infected from contact", "getting sick", "Person/day", "", ""}, {"initial infected", "constant", "10", "initial infected", "Person", "", ""}, {"initial susceptible", "constant", "1000000.0", "initial susceptible", "Person", "", ""}, {"rate of potential infectious contacts", "auxiliary", "Healthy  * rate that people contact other people", "rate of potential infectious contacts", "Person/day", "", ""}, {"Healthy", "stock", "- getting sick, initial susceptible", "Healthy", "Person", "", ""}};
    private static final String[][] EPI_LINKS = new String[][]{{"initial susceptible", "Healthy"}, {"Healthy", "total population"}, {"Healthy", "rate of potential infectious contacts"}, {"rate that people contact other people", "rate of potential infectious contacts"}, {"rate of potential infectious contacts", "Contacts between infected and unaffected"}, {"Contacts between infected and unaffected", "getting sick"}, {"fraction infected from contact", "getting sick"}, {"total population", "Fraction of population infected"}, {"Fraction of population infected", "Contacts between infected and unaffected"}, {"Infected", "Fraction of population infected"}, {"Infected", "total population"}, {"initial infected", "Infected"}};

    @Before
    public void setup() {
        this.model = SDModelFactory.eINSTANCE.createSystemModel();
        this.diagram = NotationFactory.eINSTANCE.createDiagram();
        if (this.diagram != null) {
            this.diagram.setName("test.rsd");
            this.diagram.setElement((EObject)this.model);
        }
    }

    @Test
    public void simpleTest() {
        MDLToSystemModel trans = new MDLToSystemModel();
        trans.run(this.model, this.diagram, EPIDEMIC_MDL);
        Assert.assertEquals((double)50.0, (double)this.model.getEndTime(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)this.model.getStartTime(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)this.model.getReportingInterval(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)this.model.getTimeStep(), (double)0.0);
        Assert.assertEquals((Object)"day", (Object)this.model.getUnits());
        HashMap<String, Variable> varMap = new HashMap<String, Variable>();
        for (Variable var : this.model.getVariables()) {
            System.out.println(var.getName());
            varMap.put(var.getName(), var);
        }
        Assert.assertEquals((long)EPI_EXPECTED.length, (long)varMap.size());
        String[][] stringArray = EPI_EXPECTED;
        int n = EPI_EXPECTED.length;
        int n2 = 0;
        while (n2 < n) {
            String[] exp = stringArray[n2];
            this.testVar(exp, varMap);
            ++n2;
        }
        ArrayList<InfluenceLink> links = new ArrayList<InfluenceLink>((Collection<InfluenceLink>)this.model.getLinks());
        String[][] stringArray2 = EPI_LINKS;
        int n3 = EPI_LINKS.length;
        n = 0;
        while (n < n3) {
            String[] link = stringArray2[n];
            Assert.assertTrue((String)(String.valueOf(link[0]) + " -> " + link[1]), (boolean)this.findLink(link[0], link[1], links));
            ++n;
        }
        Assert.assertEquals((long)0L, (long)links.size());
        Variable var = (Variable)varMap.get("getting sick");
        Assert.assertNotNull((Object)var);
        Assert.assertEquals((Object)"Healthy", (Object)((Rate)var).getFrom().getName());
        Assert.assertEquals((Object)"Infected", (Object)((Rate)var).getTo().getName());
    }

    private boolean findLink(String source, String target, List<InfluenceLink> links) {
        for (InfluenceLink link : links) {
            if (!link.getFrom().getName().equals(source) || !link.getTo().getName().equals(target)) continue;
            links.remove(link);
            return true;
        }
        return false;
    }

    private VariableType convertType(String type) {
        if (type.equals("constant")) {
            return VariableType.CONSTANT;
        }
        if (type.equals("stock")) {
            return VariableType.STOCK;
        }
        if (type.equals("auxiliary")) {
            return VariableType.AUXILIARY;
        }
        if (type.equals("rate")) {
            return VariableType.RATE;
        }
        if (type.equals("lookup")) {
            return VariableType.LOOKUP;
        }
        return null;
    }

    private void testVar(String[] exp, Map<String, Variable> varMap) {
        Variable var = varMap.get(exp[0]);
        Assert.assertNotNull((String)exp[0], (Object)var);
        Assert.assertEquals((Object)exp[0], (Object)var.getName());
        Assert.assertEquals((Object)this.convertType(exp[1]), (Object)var.getType());
        Assert.assertEquals((String)var.getName(), (Object)exp[2], (Object)var.getEquation());
        Assert.assertEquals((Object)exp[3], (Object)var.getLhs());
        Assert.assertEquals((Object)exp[4], (Object)var.getUnits());
        Assert.assertEquals((Object)exp[5], (Object)var.getComment());
        this.testSubscripts(exp[6], var.getSubscripts());
    }

    private void testSubscripts(String subString, List<String> subscripts) {
        String[] subs = subString.split(",");
        if (subs.length == 1 && subs[0].equals("")) {
            subs = new String[]{};
        }
        Assert.assertEquals((long)subs.length, (long)subscripts.size());
        String[] stringArray = subs;
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            String sub = stringArray[n2];
            Assert.assertTrue((boolean)subscripts.remove(sub.trim()));
            ++n2;
        }
        Assert.assertEquals((long)0L, (long)subscripts.size());
    }

    private Variable findVar(String name) {
        for (Variable var : this.model.getVariables()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    @Test
    public void testCloud() {
        MDLToSystemModel trans = new MDLToSystemModel();
        trans.run(this.model, this.diagram, WFINV_MDL);
        Rate production = (Rate)this.findVar("production");
        Assert.assertNotNull((Object)production);
        Assert.assertNotNull((Object)production.getFrom());
        Assert.assertEquals((Object)SDModelPackage.Literals.CLOUD, (Object)production.getFrom().eClass());
    }

    @Test
    public void testSubscripts() {
        MDLToSystemModel trans = new MDLToSystemModel();
        trans.run(this.model, this.diagram, ARMS_MDL);
        EList subscripts = this.model.getSubscripts();
        Assert.assertEquals((long)1L, (long)subscripts.size());
        Subscript sub = (Subscript)subscripts.get(0);
        Assert.assertEquals((Object)"region", (Object)sub.getName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("east");
        expected.add("west");
        for (String val : sub.getElements()) {
            Assert.assertTrue((boolean)expected.remove(val));
        }
        Assert.assertEquals((long)0L, (long)expected.size());
    }
}

