/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import repast.simphony.systemdynamics.sdmodel.Cloud;
import repast.simphony.systemdynamics.sdmodel.InfluenceLink;
import repast.simphony.systemdynamics.sdmodel.Rate;
import repast.simphony.systemdynamics.sdmodel.SDModelFactory;
import repast.simphony.systemdynamics.sdmodel.Stock;
import repast.simphony.systemdynamics.sdmodel.Subscript;
import repast.simphony.systemdynamics.sdmodel.SystemModel;
import repast.simphony.systemdynamics.sdmodel.Variable;
import repast.simphony.systemdynamics.sdmodel.VariableType;
import repast.simphony.systemdynamics.translator.Arrow;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.EquationProcessor;
import repast.simphony.systemdynamics.translator.GraphicsProcessor;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Node;
import repast.simphony.systemdynamics.translator.Reader;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;

public class MDLToSystemModel {
    private boolean fatal = false;
    private boolean warnings = false;
    String fatalMessages = "";
    List<String> warningMessages = new ArrayList<String>();
    private static final Set<String> MODEL_VARS = new HashSet<String>();

    static {
        MODEL_VARS.add("FINAL TIME");
        MODEL_VARS.add("INITIAL TIME");
        MODEL_VARS.add("SAVEPER");
        MODEL_VARS.add("TIME STEP");
    }

    public SystemModel run(SystemModel model, Diagram diagram, String mdlFile) {
        Reader reader = new Reader(mdlFile);
        List<String> mdlContents = reader.readMDLFile();
        return this.run(model, diagram, mdlContents);
    }

    public SystemModel run(SystemModel model, Diagram diagram, List<String> mdlContents) {
        boolean errors;
        InformationManagers.clear();
        InformationManagers.getInstance().getFunctionManager().load(this.getClass().getResourceAsStream("/implementedFunctions.csv"));
        InformationManagers.getInstance().setSystemModel(model);
        SystemDynamicsObjectManager sdObjectManager = InformationManagers.getInstance().getSystemDynamicsObjectManager();
        new GraphicsProcessor().processGraphics(sdObjectManager, mdlContents);
        EquationProcessor eqProcessor = new EquationProcessor();
        HashMap<String, Equation> equations = eqProcessor.processRawEquations(sdObjectManager, mdlContents);
        Map<String, Equation> fatalErrors = eqProcessor.getFatalErrors(equations);
        boolean bl = errors = fatalErrors.size() > 0;
        if (errors) {
            this.fatal = true;
            Iterator<String> iter = fatalErrors.keySet().iterator();
            this.fatalMessages = String.valueOf(this.fatalMessages) + "+++ Fatal Errors Detected +++";
            while (iter.hasNext()) {
                String lhs = iter.next();
                Equation eqn = fatalErrors.get(lhs);
                this.fatalMessages = String.valueOf(this.fatalMessages) + "\nEquation:";
                this.fatalMessages = String.valueOf(this.fatalMessages) + "\n\t" + eqn.getVensimEquation().split("~")[0];
                for (String msg : eqn.getFatalMessages()) {
                    this.fatalMessages = String.valueOf(this.fatalMessages) + "\n" + msg;
                }
                this.fatalMessages = String.valueOf(this.fatalMessages) + "\n----------";
            }
        }
        this.initModel(model, equations);
        HashMap<String, Variable> varMap = new HashMap<String, Variable>();
        ArrayList<Rate> rates = new ArrayList<Rate>();
        for (String names : sdObjectManager.screenNames()) {
            Variable var;
            String name = SystemDynamicsObjectManager.getScreenName(names);
            if (MODEL_VARS.contains(name)) continue;
            List<Equation> eqs = sdObjectManager.getEquations(name);
            if (eqs.size() > 0) {
                Variable var2;
                Equation peek = eqs.get(0);
                if (peek.isDefinesSubscript() || (var2 = this.processEquations(name, eqs, model)) == null) continue;
                if (var2.getType().equals((Object)VariableType.RATE)) {
                    rates.add((Rate)var2);
                }
                varMap.put(name, var2);
                continue;
            }
            if (!name.startsWith("CLOUD") || (var = this.processEquations(name, eqs, model)) == null) continue;
            if (var.getType().equals((Object)VariableType.RATE)) {
                rates.add((Rate)var);
            }
            varMap.put(name, var);
        }
        this.createSubscripts(model, equations);
        this.createLinks(varMap, model, sdObjectManager);
        this.processRates(rates, varMap, sdObjectManager);
        return model;
    }

    private void createSubscripts(SystemModel model, Map<String, Equation> equations) {
        for (Equation eqn : equations.values()) {
            if (!eqn.isDefinesSubscript()) continue;
            Subscript sub = SDModelFactory.eINSTANCE.createSubscript();
            sub.setName(eqn.getTokens().get(0));
            int ind = 2;
            while (ind < eqn.getTokens().size()) {
                sub.getElements().add((Object)eqn.getTokens().get(ind));
                ind += 2;
            }
            model.getSubscripts().add((Object)sub);
        }
    }

    private void createLinks(Map<String, Variable> varMap, SystemModel model, SystemDynamicsObjectManager objMan) {
        for (String name : varMap.keySet()) {
            List<Arrow> sources = objMan.getIncomingArrows(name);
            Variable target = varMap.get(name);
            for (Arrow source : sources) {
                if (!source.getType().equals("INFLUENCE")) continue;
                Variable vSource = varMap.get(source.getOtherEnd());
                InfluenceLink link = SDModelFactory.eINSTANCE.createInfluenceLink();
                link.setFrom(vSource);
                link.setTo(target);
                link.setUuid(EcoreUtil.generateUUID());
                model.getLinks().add((Object)link);
            }
        }
    }

    private void processRates(List<Rate> rates, Map<String, Variable> varMap, SystemDynamicsObjectManager objMan) {
        for (Rate rate : rates) {
            Stock from = null;
            Stock to = null;
            for (Arrow arrow : objMan.getIncomingArrows(rate.getName())) {
                if (!arrow.getType().equals("FLOW")) continue;
                arrow.getOtherEnd().startsWith("CLOUD");
                from = (Stock)varMap.get(arrow.getOtherEnd());
                break;
            }
            for (Arrow arrow : objMan.getOutgoingArrows(rate.getName())) {
                if (!arrow.getType().equals("FLOW")) continue;
                arrow.getOtherEnd().startsWith("CLOUD");
                to = (Stock)varMap.get(arrow.getOtherEnd());
                break;
            }
            rate.setFrom(from);
            rate.setTo(to);
        }
    }

    private Variable processEquations(String name, List<Equation> eqs, SystemModel model) {
        Cloud var = null;
        if (eqs.size() > 0) {
            Equation eq = eqs.get(0);
            VariableType type = eq.getVariableType();
            if (type == VariableType.RATE) {
                var = SDModelFactory.eINSTANCE.createRate();
                var.setType(VariableType.RATE);
            } else if (type == VariableType.AUXILIARY) {
                var = SDModelFactory.eINSTANCE.createVariable();
                var.setType(VariableType.AUXILIARY);
            } else if (type == VariableType.CONSTANT) {
                var = SDModelFactory.eINSTANCE.createVariable();
                var.setType(VariableType.CONSTANT);
            } else if (type == VariableType.STOCK) {
                var = SDModelFactory.eINSTANCE.createStock();
                var.setType(VariableType.STOCK);
            } else if (type == VariableType.LOOKUP) {
                var = SDModelFactory.eINSTANCE.createVariable();
                var.setType(VariableType.LOOKUP);
            }
            eq = eqs.get(eqs.size() - 1);
            if (var != null) {
                var.setName(name);
                String comment = eq.getComment() == null ? "" : eq.getComment();
                var.setComment(comment);
                this.parseEquation((Variable)var, eqs);
                var.setUnits(eq.getUnits());
                var.setUuid(EcoreUtil.generateUUID());
                model.getVariables().add((Object)var);
            }
        } else if (name.startsWith("CLOUD")) {
            var = SDModelFactory.eINSTANCE.createCloud();
            var.setName(name);
            var.setUuid(EcoreUtil.generateUUID());
            model.getVariables().add((Object)var);
        } else {
            System.out.println("^^^^^^^^^^^^ No Equation, not cloud: " + name);
        }
        return var;
    }

    private void parseEquation(Variable var, List<Equation> eqns) {
        int eqnNum = 0;
        while (eqnNum < eqns.size()) {
            Equation eqn = eqns.get(eqnNum);
            String equation = eqn.getEquation().trim();
            String[] sides = equation.split("=", 2);
            if (sides.length == 2) {
                String lhs = sides[0].trim();
                String rhs = sides[1].trim();
                if (var.getType() == VariableType.STOCK && rhs.startsWith("INTEG")) {
                    Node root = eqn.getTreeRoot();
                    Node lhsNode = root.getChild();
                    Node rhsNode = lhsNode.getNext();
                    Node arg1 = rhsNode.getChild();
                    Node arg5 = arg1.getNext().getNext().getNext().getNext();
                    Node arg6 = arg5.getNext();
                    Stock svar = (Stock)var;
                    String arg6Expression = arg6.generateExpression();
                    String arg5Expression = arg5.generateExpression();
                    if (eqnNum == 0) {
                        svar.setInitialValue(arg6Expression);
                        var.setEquation(arg5Expression);
                    } else {
                        String multiEqn = "~~|" + lhs.trim() + "=INTEG(" + arg5Expression + "," + arg6Expression + ")";
                        var.setEquation(String.valueOf(var.getEquation()) + multiEqn);
                    }
                } else if (eqnNum == 0) {
                    var.setEquation(rhs.trim());
                } else {
                    String multiEqn = rhs.trim().length() > 0 ? "~~|" + lhs.trim() + "=" + rhs.trim() : "~~|" + lhs.trim();
                    var.setEquation(String.valueOf(var.getEquation()) + multiEqn);
                }
                if (eqnNum == 0) {
                    var.setLhs(lhs.trim());
                }
            } else if (eqnNum == 0) {
                var.setEquation(equation.trim());
            } else {
                String multiEqn = "~~|" + equation.trim();
                var.setEquation(String.valueOf(var.getEquation()) + multiEqn);
            }
            ++eqnNum;
        }
    }

    private String getRHS(String equation) {
        String[] vals = equation.split("=");
        if (vals.length == 2) {
            return vals[1].trim();
        }
        return "";
    }

    private double getValue(String name, Map<String, Equation> equations) {
        Equation eq = equations.get(name);
        if (eq == null) {
            throw new IllegalArgumentException("Equation '" + name + "' does not exist");
        }
        String val = this.getRHS(eq.getEquation());
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException numberFormatException) {
            return this.getValue(val, equations);
        }
    }

    private void initModel(SystemModel model, Map<String, Equation> equations) {
        double val = this.getValue("FINAL TIME", equations);
        model.setEndTime(val);
        val = this.getValue("INITIAL TIME", equations);
        model.setStartTime(val);
        val = this.getValue("SAVEPER", equations);
        model.setReportingInterval(val);
        val = this.getValue("TIME STEP", equations);
        model.setTimeStep(val);
        model.setUnits(equations.get("TIME STEP").getUnits().trim());
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    public boolean isWarnings() {
        return this.warnings;
    }

    public void setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    public String getFatalMessages() {
        return this.fatalMessages;
    }

    public void setFatalMessages(String fatalMessages) {
        this.fatalMessages = fatalMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public void setWarningMessages(List<String> warningMessages) {
        this.warningMessages = warningMessages;
    }
}

