/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

public class FunctionDescription {
    private String externalName;
    private String internalName;
    private boolean supported = false;
    private String javaObject;
    private boolean requiresName = false;
    private boolean requiresValue = false;
    private boolean requiresTime = false;
    private boolean requiresTimeStep = false;
    private String returnType;
    private String returnUnits;
    private boolean suppliesInitialValue = false;
    private int numArgs;
    private String[] argUnits;

    public FunctionDescription(String description) {
        this.parse(description);
    }

    private void parse(String description) {
        String[] fields = description.split(",");
        this.setExternalName(fields[0]);
        this.setInternalName(fields[1]);
        this.setSupported(fields[2].equals("Y"));
        this.setJavaObject(fields[3]);
        this.setRequiresName(fields[4].equals("Y"));
        this.setRequiresValue(fields[5].equals("Y"));
        this.setRequiresTime(fields[6].equals("Y"));
        this.setRequiresTimeStep(fields[7].equals("Y"));
        this.setReturnType(fields[8]);
        this.setReturnUnits(fields[9]);
        this.setSuppliesInitialValue(fields[10].equals("Y"));
        this.setNumArgs(Integer.parseInt(fields[11]));
        this.argUnits = new String[this.getNumArgs()];
        int pos = 0;
        int i = 12;
        while (i < 12 + this.getNumArgs()) {
            this.argUnits[pos++] = fields[i];
            ++i;
        }
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public void setSupported(boolean supported) {
        this.supported = supported;
    }

    public String getJavaObject() {
        return this.javaObject;
    }

    public void setJavaObject(String javaObject) {
        this.javaObject = javaObject;
    }

    public boolean isRequiresName() {
        return this.requiresName;
    }

    public void setRequiresName(boolean requiresName) {
        this.requiresName = requiresName;
    }

    public boolean isRequiresValue() {
        return this.requiresValue;
    }

    public void setRequiresValue(boolean requiresValue) {
        this.requiresValue = requiresValue;
    }

    public boolean isRequiresTime() {
        return this.requiresTime;
    }

    public void setRequiresTime(boolean requiresTime) {
        this.requiresTime = requiresTime;
    }

    public boolean isRequiresTimeStep() {
        return this.requiresTimeStep;
    }

    public void setRequiresTimeStep(boolean requiresTimeStep) {
        this.requiresTimeStep = requiresTimeStep;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getAlternateReturnUnits() {
        StringBuffer sb = new StringBuffer();
        int definedReturnIndex = Integer.parseInt(this.returnUnits.replace("arg", "")) - 1;
        int i = 0;
        while (i < this.numArgs) {
            if (i != definedReturnIndex && this.argUnits[i].equals(this.argUnits[definedReturnIndex])) {
                sb.append(",");
                sb.append("arg" + (i + 1));
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean requiresUnitExpression() {
        return this.returnUnits.contains("/") || this.returnUnits.contains("*");
    }

    public static String getFunctionReturn(String func) {
        String funcAndReturn = func.replace("sdFunctions.", "");
        if (funcAndReturn.contains("<")) {
            return funcAndReturn.split("<")[1].split(">")[0];
        }
        return "";
    }

    public static int getFunctionReturnIndex(String loadedFunctionName) {
        String funcReturn = FunctionDescription.getFunctionReturn(loadedFunctionName);
        if (funcReturn.contains("/") || funcReturn.contains("*")) {
            return -1;
        }
        if (funcReturn.startsWith("arg")) {
            return Integer.parseInt(funcReturn.replace("arg", "")) - 1;
        }
        return -2;
    }

    public static String getFunctionName(String loadedFunctionName) {
        String funcAndReturn = loadedFunctionName.replace("sdFunctions.", "");
        if (funcAndReturn.contains("<")) {
            return funcAndReturn.split("<")[0];
        }
        return funcAndReturn;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getReturnUnits() {
        return this.returnUnits;
    }

    public void setReturnUnits(String returnUnits) {
        this.returnUnits = returnUnits;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public int getNumArgsAll() {
        int n = this.numArgs;
        if (this.isRequiresName()) {
            ++n;
        }
        if (this.isRequiresValue()) {
            ++n;
        }
        if (this.isRequiresTime()) {
            ++n;
        }
        if (this.isRequiresTimeStep()) {
            ++n;
        }
        return n;
    }

    public void setNumArgs(int numArgs) {
        this.numArgs = numArgs;
    }

    public String[] getArgUnits() {
        return this.argUnits;
    }

    public void setArgUnits(String[] argUnits) {
        this.argUnits = argUnits;
    }

    public boolean isSuppliesInitialValue() {
        return this.suppliesInitialValue;
    }

    public void setSuppliesInitialValue(boolean suppliesInitialValue) {
        this.suppliesInitialValue = suppliesInitialValue;
    }
}

