/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import repast.simphony.systemdynamics.sdmodel.VariableType;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.support.SubscriptCombination;
import repast.simphony.systemdynamics.translator.EquationArrayReferenceStructure;
import repast.simphony.systemdynamics.translator.EquationProcessor;
import repast.simphony.systemdynamics.translator.FunctionDescription;
import repast.simphony.systemdynamics.translator.GrammarChecker;
import repast.simphony.systemdynamics.translator.GraphicObject;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Node;
import repast.simphony.systemdynamics.translator.OperationResult;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.Translator;
import repast.simphony.systemdynamics.translator.TreeTraversal;
import repast.simphony.systemdynamics.translator.UnitExpression;
import repast.simphony.systemdynamics.translator.UsageChecker;

public class Equation {
    private String vensimEquation;
    private String equation;
    private List<String> multiEquations;
    private String cleanEquation = "";
    private String lhs;
    private String rhs;
    private HashSet<String> rhsTokens;
    private String units = null;
    private String comment = null;
    private String other;
    private HashSet<String> references;
    private HashSet<String> referencedBy;
    private Node treeRoot;
    private boolean syntacticallyCorrect = true;
    private boolean usageCorrect = true;
    private boolean fatal = false;
    private List<String> syntaxMessages = new ArrayList<String>();
    private List<String> usageMessages = new ArrayList<String>();
    private List<String> unitsMessages = new ArrayList<String>();
    private List<String> fatalMessages = new ArrayList<String>();
    private OperationResult opRes = new OperationResult();
    private boolean stockVariable = false;
    private String btwnMode = "INTERPOLATE";
    private boolean arrayInitialization = false;
    private static int nextArray = 0;
    private static int nextInt = 0;
    private static int nextInteger = 0;
    private static int nextTimeSeries = 0;
    private boolean oneTime = false;
    private boolean vdmLookup = false;
    private List<String> tokens = new ArrayList<String>();
    private List<String> rpn = new ArrayList<String>();
    private boolean getXls = false;
    private boolean definesLookup = false;
    private boolean definesLookupGetXls = false;
    private boolean definesLookupWithRange = false;
    private boolean referencesLookup = false;
    private boolean hasInitialValue = false;
    private boolean assignment = false;
    private boolean typeString = false;
    private boolean definesSubscript = false;
    private boolean hasMacroInvocation = false;
    private boolean usesTimeSeries = false;
    private boolean hasException = false;
    private int leftBracketCount = 0;
    private List<String> exceptions;
    private boolean hasMultipleEquations = false;
    private String lhsArray;
    private List<String> lhsSubscripts = null;
    private boolean hasLHSArrayReference = false;
    private boolean hasRHSArrayReference = false;
    private EquationArrayReferenceStructure ears;
    private boolean orderedWithInitialValue = false;
    private boolean hasVectorSortOrder = false;
    private boolean hasVectorElmMap = false;
    private UnitExpression unitExpression;
    private boolean autoGenerated = false;
    private VariableType variableType;
    private boolean treeCodeGenerated = false;
    private static HashSet<Character> terminatorSet = new HashSet();
    private static char[] terminators = new char[]{'+', '-', '*', '/', '(', ')', '=', ',', '^', '`', '>', '<', ':', ';'};
    private static boolean terminatorsInitialized = false;
    private static HashSet<String> lookupTables = new HashSet();
    private static HashMap<String, Integer> precedence = new HashMap();
    private static HashMap<String, Boolean> leftAssociative = new HashMap();

    static {
        precedence.put("_", 8);
        precedence.put("^", 7);
        precedence.put("*", 6);
        precedence.put("/", 6);
        precedence.put("+", 5);
        precedence.put("-", 5);
        precedence.put("==", 4);
        precedence.put("<>", 4);
        precedence.put(">", 4);
        precedence.put(">=", 4);
        precedence.put("<", 4);
        precedence.put("<=", 4);
        precedence.put(":AND:", 2);
        precedence.put(":OR:", 1);
        precedence.put(":NOT:", 3);
        leftAssociative.put("_", false);
        leftAssociative.put("^", false);
        leftAssociative.put("*", true);
        leftAssociative.put("/", true);
        leftAssociative.put("+", true);
        leftAssociative.put("-", true);
        leftAssociative.put("==", true);
        leftAssociative.put("<>", true);
        leftAssociative.put(">", true);
        leftAssociative.put(">=", true);
        leftAssociative.put("<", true);
        leftAssociative.put("<=", true);
        leftAssociative.put(":AND:", true);
        leftAssociative.put(":OR:", true);
        leftAssociative.put(":NOT:", false);
    }

    public Equation() {
        this.references = new HashSet();
        this.referencedBy = new HashSet();
        this.rhsTokens = new HashSet();
        if (!terminatorsInitialized) {
            Equation.initializeTerminators();
        }
    }

    private static void initializeTerminators() {
        char[] cArray = terminators;
        int n = terminators.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            terminatorSet.add(Character.valueOf(c));
            ++n2;
        }
        terminatorsInitialized = true;
    }

    public static void initializeCounts() {
        nextArray = 0;
        nextInt = 0;
        nextInteger = 0;
        nextTimeSeries = 0;
    }

    public Equation(String vensimEquation) {
        this();
        GrammarChecker checker;
        OperationResult or;
        if (InformationManagers.getInstance().getMacroManager().containsMacroInvocation(vensimEquation)) {
            this.vensimEquation = InformationManagers.getInstance().getMacroManager().expand(vensimEquation).replaceAll("\t", "");
            this.hasMacroInvocation = true;
        } else {
            this.vensimEquation = vensimEquation.replaceAll("\t", "");
        }
        if (this.vensimEquation.contains("!")) {
            this.vensimEquation = vensimEquation.replaceAll(" *!", "!");
        }
        this.tokenize();
        if (this.syntacticallyCorrect && !(or = (checker = new GrammarChecker(this, this.tokens)).checkGrammar()).isOk()) {
            this.syntacticallyCorrect = false;
            this.syntaxMessages.add(or.getMessage());
            System.out.println("Bad Grammar Check: " + vensimEquation);
            System.out.println(or.getMessage());
        }
    }

    public VariableType getVariableType() {
        if (this.isStock()) {
            return VariableType.STOCK;
        }
        if (this.isDefinesLookup()) {
            return VariableType.LOOKUP;
        }
        if (this.isOneTime()) {
            return VariableType.CONSTANT;
        }
        List<GraphicObject> go = InformationManagers.getInstance().getSystemDynamicsObjectManager().getGraphicObjects(this.lhs);
        if (go == null || go.size() == 0) {
            return VariableType.AUXILIARY;
        }
        if (go.get(0).getType().equals("99")) {
            return VariableType.RATE;
        }
        return VariableType.AUXILIARY;
    }

    public boolean checkUsage(Map<String, Equation> equations) {
        OperationResult or = new UsageChecker(equations, this).checkUsage();
        if (!or.isOk()) {
            this.usageMessages.add(or.getMessage());
        }
        this.usageCorrect = or.isOk();
        return this.usageCorrect;
    }

    private String[] getPair(MutableInteger pos, char[] data) {
        String[] pair = new String[2];
        pair[0] = this.getNextNumber(pos, data);
        if (pair[0] == null) {
            return null;
        }
        pair[1] = this.getNextNumber(pos, data);
        if (pair[1] == null) {
            return null;
        }
        return pair;
    }

    /*
     * Unable to fully structure code
     */
    private String getNextNumber(MutableInteger pos, char[] data) {
        num = "";
        if (pos.value() < data.length) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            pos.add(1);
            if (pos.value() < data.length) continue;
            return null;
lbl8:
            // 2 sources

            ** while (!Character.isDigit((char)data[pos.value()]) && data[pos.value()] != '+' && data[pos.value()] != '-')
        }
lbl9:
        // 1 sources

        num = String.valueOf(num) + data[pos.value()];
        pos.add(1);
        while (Character.isDigit(data[pos.value()]) || data[pos.value()] == '.') {
            num = String.valueOf(num) + data[pos.value()];
            pos.add(1);
        }
        return num;
    }

    private void createEars() {
        this.ears = new EquationArrayReferenceStructure(this);
    }

    private String processPairs(String lookupData) {
        String minX = "";
        String minXY = "";
        String maxX = "";
        String maxXY = "";
        StringBuffer x = new StringBuffer();
        StringBuffer y = new StringBuffer();
        MutableInteger pos = new MutableInteger(0);
        String[] pair = null;
        int numValues = 0;
        char[] lookupDataChars = lookupData.replace(")-(", ")(").toCharArray();
        if (this.definesLookupWithRange) {
            pair = this.getPair(pos, lookupDataChars);
            minX = Parser.forceDouble(pair[0]);
            minXY = Parser.forceDouble(pair[1]);
            pair = this.getPair(pos, lookupDataChars);
            maxX = Parser.forceDouble(pair[0]);
            maxXY = Parser.forceDouble(pair[1]);
        }
        while (pos.value() < lookupDataChars.length) {
            pair = this.getPair(pos, lookupDataChars);
            if (pair == null) break;
            ++numValues;
            x.append("," + Parser.forceDouble(pair[0]));
            y.append("," + Parser.forceDouble(pair[1]));
        }
        if (this.definesLookupWithRange) {
            return String.valueOf(numValues) + "," + minX + "," + minXY + "," + maxX + "," + maxXY + x.toString() + y.toString();
        }
        return String.valueOf(numValues) + "," + "Double.MIN_VALUE" + "," + "Double.MIN_VALUE" + "," + "Double.MAX_VALUE" + "," + "Double.MAX_VALUE" + x.toString() + y.toString();
    }

    public void processExponentiation() {
        this.cleanEquation = this.processExponentiation(this.cleanEquation);
    }

    public String processExponentiation(String eqn) {
        if (eqn.contains("^")) {
            int pos = eqn.indexOf("^");
            MutableInteger l = new MutableInteger(pos - 1);
            String lhs = this.getExpLHS(l, eqn);
            MutableInteger r = new MutableInteger(pos + 1);
            String rhs = this.getExpRHS(r, eqn);
            eqn = String.valueOf(eqn.substring(0, l.value())) + "Math.pow(" + lhs + "," + rhs + ")" + eqn.substring(r.value() + 1);
            return this.processExponentiation(eqn);
        }
        return eqn;
    }

    private String getExpLHS(MutableInteger r, String eqn) {
        String c = eqn.substring(r.value(), r.value() + 1);
        String rhs = "";
        rhs = c.equals(")") ? this.toOpeningParen(r, eqn) : this.toBeginningOfLHS(r, eqn);
        return this.reverse(rhs);
    }

    private String getExpRHS(MutableInteger r, String eqn) {
        String c = eqn.substring(r.value(), r.value() + 1);
        String rhs = "";
        rhs = c.equals("(") ? this.toClosingParen(r, eqn) : this.toEndOfRHS(r, eqn);
        return rhs;
    }

    public String toBeginningOfLHS(MutableInteger r, String eqn) {
        String rhs = "";
        String c = eqn.substring(r.value(), r.value() + 1);
        if (Character.isDigit(c.toCharArray()[0])) {
            rhs = c;
            r.add(-1);
            c = eqn.substring(r.value(), r.value() + 1);
            while (c.equals(".") || Character.isDigit(c.toCharArray()[0])) {
                rhs = String.valueOf(rhs) + c;
                r.add(-1);
                c = eqn.substring(r.value(), r.value() + 1);
            }
            r.add(1);
        } else {
            rhs = c;
            r.add(-1);
            c = eqn.substring(r.value(), r.value() + 1);
            while (c.equals("_") || Character.isLetterOrDigit(c.toCharArray()[0])) {
                rhs = String.valueOf(rhs) + c;
                r.add(-1);
                c = eqn.substring(r.value(), r.value() + 1);
            }
            r.add(1);
        }
        return rhs;
    }

    public String toEndOfRHS(MutableInteger r, String eqn) {
        String rhs = "";
        String c = eqn.substring(r.value(), r.value() + 1);
        if (c.equals("-") || c.equals("+") || c.equals(".") || Character.isDigit(c.toCharArray()[0])) {
            rhs = c;
            r.add(1);
            if (r.value() < eqn.length()) {
                c = eqn.substring(r.value(), r.value() + 1);
                while ((c.equals(".") || Character.isDigit(c.toCharArray()[0])) && r.value() < eqn.length()) {
                    rhs = String.valueOf(rhs) + c;
                    r.add(1);
                    if (r.value() >= eqn.length()) continue;
                    c = eqn.substring(r.value(), r.value() + 1);
                }
            }
            r.add(-1);
        } else {
            rhs = c;
            r.add(1);
            c = eqn.substring(r.value(), r.value() + 1);
            while ((c.equals("_") || Character.isLetterOrDigit(c.toCharArray()[0])) && r.value() < eqn.length()) {
                rhs = String.valueOf(rhs) + c;
                r.add(1);
                if (r.value() >= eqn.length()) continue;
                c = eqn.substring(r.value(), r.value() + 1);
            }
            if (c.equals("(")) {
                rhs = String.valueOf(rhs) + this.toClosingParen(r, eqn);
            } else {
                r.add(-1);
            }
        }
        return rhs;
    }

    public String reverse(String s) {
        String rev = "";
        char[] chars = s.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            rev = String.valueOf(rev) + chars[i];
            --i;
        }
        return rev;
    }

    public String toClosingParen(MutableInteger r, String eqn) {
        String c;
        String rhs = c = eqn.substring(r.value(), r.value() + 1);
        int paren = 1;
        while (paren > 0) {
            r.add(1);
            c = eqn.substring(r.value(), r.value() + 1);
            rhs = String.valueOf(rhs) + c;
            if (c.equals(")")) {
                --paren;
                continue;
            }
            if (!c.equals("(")) continue;
            ++paren;
        }
        return rhs;
    }

    public String toOpeningParen(MutableInteger r, String eqn) {
        String c;
        String rhs = c = eqn.substring(r.value(), r.value() + 1);
        int paren = 1;
        while (paren > 0) {
            r.add(-1);
            c = eqn.substring(r.value(), r.value() + 1);
            rhs = String.valueOf(rhs) + c;
            if (c.equals(")")) {
                ++paren;
                continue;
            }
            if (!c.equals("(")) continue;
            --paren;
        }
        r.add(-1);
        c = eqn.substring(r.value(), r.value() + 1);
        if (c.equals("_") || Character.isLetterOrDigit(c.toCharArray()[0])) {
            rhs = String.valueOf(rhs) + this.toFunctionStart(r, eqn);
        } else {
            r.add(1);
        }
        return rhs;
    }

    public String toFunctionStart(MutableInteger r, String eqn) {
        String rhs = "";
        String c = eqn.substring(r.value(), r.value() + 1);
        while (c.equals("_") || Character.isLetterOrDigit(c.toCharArray()[0])) {
            rhs = String.valueOf(rhs) + c;
            r.add(-1);
            c = eqn.substring(r.value(), r.value() + 1);
        }
        r.add(1);
        return rhs;
    }

    public void processSubscriptDefinition() {
        if (this.definesSubscript) {
            StringBuffer sb = new StringBuffer("\tregisterSubscript(\"" + this.tokens.get(0) + "\",");
            int i = 1;
            while (i < this.tokens.size()) {
                String token = this.tokens.get(i);
                if (token.equals(",")) {
                    sb.append(token);
                } else {
                    sb.append("\"" + token + "\"");
                }
                ++i;
            }
            sb.append(")");
            this.cleanEquation = sb.toString();
            this.setOneTime(true);
        }
    }

    public void processLookup() {
        if (this.definesLookup) {
            String[] lookup = this.cleanEquation.split("\\(", 2);
            Object definition = lookup[0];
            definition = ((String)definition).contains("]") ? String.valueOf(((String)definition).replace("]", "")) + ",holder1,holder2]" : String.valueOf(definition) + "[holder1,holder2]";
            InformationManagers.getInstance().getNativeDataTypeManager().addVariable(this, (String)definition, this.typeString ? "String" : "double");
            if (!lookup[1].contains("(")) {
                int numValues = lookup[1].split(",").length / 2;
                this.cleanEquation = "sdFunctions.ADDLOOKUPNATIVE(\"" + lookup[0] + "\", " + numValues + "," + lookup[1];
            } else {
                this.cleanEquation = "sdFunctions.ADDLOOKUPPAIRSNATIVE(\"" + lookup[0] + "\", " + this.processPairs(lookup[1]) + ")";
            }
            this.setOneTime(true);
        }
        if (this.referencesLookup) {
            return;
        }
        if (this.referencesLookup) {
            for (String tableReference : lookupTables) {
                if (!this.cleanEquation.contains(tableReference)) continue;
                this.cleanEquation = this.cleanEquation.replace(String.valueOf(tableReference) + "(", "sdFunctions.LOOKUP(\"" + tableReference + "\",");
                ArrayList<String> newTokens = new ArrayList<String>();
                int skipParenAt = -1;
                int i = 0;
                while (i < this.tokens.size()) {
                    String t = this.tokens.get(i);
                    if (t.equals(tableReference.replaceAll("\"", ""))) {
                        this.tokens.set(i, "sdFunctions.LOOKUP(\"" + tableReference + "\",");
                        newTokens.add("sdFunctions.LOOKUP");
                        newTokens.add("(");
                        newTokens.add("\"" + tableReference + "\"");
                        skipParenAt = i + 1;
                    } else if (!t.equals("(") || i != skipParenAt) {
                        newTokens.add(t);
                    }
                    ++i;
                }
                this.tokens = newTokens;
            }
            int tokNum = 0;
            boolean skipParen = false;
            ArrayList<String> newTokens = new ArrayList<String>();
            int i = 0;
            while (i < this.tokens.size()) {
                String token = this.tokens.get(i);
                if (token.equals("(") && skipParen) {
                    skipParen = false;
                } else {
                    if (this.isArrayLookup(token)) {
                        ArrayReference ar = new ArrayReference(token);
                        List<String> subscripts = ar.getSubscripts();
                        List<String> rangeSubscripts = ar.getRangeSubscriptsNames();
                        List<String> nonRangeSubscripts = ar.getNonRangeSubscripts();
                        newTokens.add("sdFunctions.LOOKUP");
                        newTokens.add("(");
                        skipParen = true;
                        StringBuffer sb = new StringBuffer();
                        sb.append("\"" + token + "+[\"+concatAsSubscriptEQUATION(");
                        int subr = 0;
                        for (String sub : subscripts) {
                            if (subr++ > 0) {
                                sb.append(",");
                            }
                            if (nonRangeSubscripts.contains(sub)) {
                                sb.append("outerSub.getSubscriptValue(\"" + sub + "\")");
                                continue;
                            }
                            sb.append("rangeSub.getSubscriptValue(\"" + sub + "\")");
                        }
                        sb.append(")+\"]\"");
                        newTokens.add(sb.toString());
                        newTokens.add(",");
                    } else {
                        newTokens.add(token);
                    }
                    ++tokNum;
                }
                ++i;
            }
            this.tokens = newTokens;
        }
    }

    private boolean isArrayLookupWithSubscript(String s) {
        if (!ArrayReference.isArrayReference(s)) {
            return false;
        }
        return lookupTables.contains(s.replace("array.", ""));
    }

    private boolean isArrayLookup(String s) {
        if (!ArrayReference.isArrayReference(s)) {
            return false;
        }
        return this.getLookupArrays().contains(new ArrayReference(s.replace("array.", "")).getArrayName());
    }

    private Set<String> getLookupArrays() {
        HashSet<String> lookupArrays = new HashSet<String>();
        for (String lookup : lookupTables) {
            if (!ArrayReference.isArrayReference(lookup)) continue;
            lookupArrays.add(new ArrayReference(lookup).getArrayName());
        }
        return lookupArrays;
    }

    private static String convertExponentialNotation(String equation) {
        String noExp = new String(equation);
        String notation = "[-]?[0-9]?\\.?[0-9]+[Ee][-+]?[0-9]+";
        Pattern p = Pattern.compile(notation);
        Matcher m = p.matcher(equation);
        while (m.find()) {
            String not = m.group();
            BigDecimal bd = BigDecimal.valueOf(Double.parseDouble(not));
            String bdString = bd.toPlainString();
            if (!bdString.contains(".")) {
                bdString = String.valueOf(bdString) + ".0";
            }
            noExp = noExp.replace(not, bdString);
        }
        return noExp;
    }

    private boolean canRemoveColonEqual() {
        String[] btwnModes = new String[]{":INTERPOLATE:", ":LOOK FORWARD:", ":HOLD BACKWORD:"};
        boolean canRemove = true;
        boolean containsColonEqual = this.equation.contains(":=");
        if (!containsColonEqual) {
            return canRemove;
        }
        String tempEqn = new String(this.equation);
        String[] stringArray = btwnModes;
        int n = btwnModes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            if (tempEqn.contains(mode)) {
                tempEqn = tempEqn.replace(mode, "");
                return tempEqn.contains(":=");
            }
            ++n2;
        }
        return canRemove;
    }

    private void tokenize() {
        MutableInteger position = new MutableInteger(0);
        boolean repastSimphony = true;
        if (this.vensimEquation.contains(":IS:")) {
            this.vensimEquation = this.vensimEquation.replace(":IS:", "=");
            this.typeString = true;
        }
        if (this.vensimEquation.contains(":NA:")) {
            this.vensimEquation = this.vensimEquation.replaceAll(":NA:", "NAREPLACEMENT");
        }
        String[] eqn = this.vensimEquation.split("~");
        if (!repastSimphony && eqn[0].endsWith("=")) {
            eqn[0] = String.valueOf(eqn[0]) + " VDMLOOKUP(\"" + eqn[0].replace("=", "").trim() + "\")";
            this.setVdmLookup(true);
        }
        this.equation = eqn[0];
        if (this.equation.contains("=")) {
            this.rhs = this.equation.split("=", 2)[1];
        }
        if (this.canRemoveColonEqual()) {
            this.equation = eqn[0].replace(":=", "=").trim();
        }
        if (eqn.length > 1) {
            this.units = eqn[1].replaceAll("  *", " ").trim();
        }
        if (eqn.length > 2) {
            this.comment = eqn[2].replaceAll("  *", " ").trim();
        }
        this.equation = Equation.convertExponentialNotation(this.equation);
        boolean hasRHS = this.tokenizeLHS(position);
        if (!this.isSyntacticallyCorrect()) {
            return;
        }
        if (hasRHS) {
            this.tokenizeRHS(position);
            if (!this.isSyntacticallyCorrect()) {
                return;
            }
        }
        if (this.isDefinesLookup()) {
            this.processLookup();
            if (!this.isSyntacticallyCorrect()) {
                return;
            }
        }
        if (this.isAssignment()) {
            InformationManagers.getInstance().getNativeDataTypeManager().addVariable(this, this.getLhs(), this.typeString ? "String" : "double");
        }
        int i = 1;
        while (i < this.tokens.size()) {
            if (this.tokens.get(i - 1).equals(",") && this.tokens.get(i).equals(",")) {
                this.syntacticallyCorrect = false;
                this.syntaxMessages.add("Parsing Equation: Missing argument to function invocation");
            }
            ++i;
        }
    }

    private boolean tokenizeLHS(MutableInteger position) {
        boolean hasRHS = true;
        boolean hasEqualSign = this.equation.contains("=");
        String token = "";
        this.skipWhiteSpace(position);
        if (!this.inRange(position)) {
            this.syntacticallyCorrect = false;
            this.syntaxMessages.add("Parsing LHS: No Equation provided " + this.vensimEquation);
            this.lhs = this.vensimEquation;
            return false;
        }
        if (this.characterAt(position).equals("\"")) {
            token = this.getQuotedStringStartingAt(position, this.opRes);
            if (!this.opRes.isOk()) {
                this.syntacticallyCorrect = false;
                this.syntaxMessages.add("Parsing LHS: " + this.opRes.getMessage());
                return false;
            }
        } else {
            boolean allowColon = false;
            token = this.getNonQuotedStringStartingAt(position, allowColon, this.opRes);
        }
        this.skipWhiteSpace(position);
        this.cleanEquation = token;
        this.lhs = token;
        boolean ignore = true;
        if (this.inRange(position) && this.characterAt(position).equals("=")) {
            if (this.inRange(position.value() + 1) && this.characterAt(position.value() + 1).equals("=")) {
                position.add(1);
            }
            this.tokens.add(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(token));
            this.assignment = true;
            this.tokens.add("=");
            this.cleanEquation = String.valueOf(this.cleanEquation) + "=";
            ignore = false;
        } else if (this.inRange(position) && this.characterAt(position).equals("(")) {
            ArrayList<String> tokenizedLookup;
            ignore = false;
            this.tokens.add(token);
            if (this.equation.contains("[") || this.beyondPosition(position).contains("(")) {
                tokenizedLookup = this.tokenizeWithLookup(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add(this.opRes.getMessage());
                    return false;
                }
            } else {
                tokenizedLookup = this.tokenizeLookup(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add(this.opRes.getMessage());
                    return false;
                }
            }
            this.tokens.addAll(tokenizedLookup);
            for (String s : tokenizedLookup) {
                this.cleanEquation = String.valueOf(this.cleanEquation) + s;
            }
            hasRHS = false;
            this.definesLookup = true;
            InformationManagers.getInstance().getArrayManager().setUsedAsLookup(token);
            lookupTables.add(token);
            EquationProcessor.lookups.add(token);
        } else if (this.inRange(position) && this.characterAt(position).equals("[") && !hasEqualSign && this.equation.contains("(")) {
            ArrayList<String> tokenizedLookup;
            String pastLeftBracket = this.equation.split("\\[", 2)[1].trim();
            String subscript = pastLeftBracket.split("\\]", 2)[0].trim();
            String origLHS = token;
            token = String.valueOf(token) + "[" + subscript + "]";
            this.setLhs(token);
            while (this.inRange(position) && !this.characterAt(position).equals("(")) {
                position.add(1);
            }
            ignore = false;
            this.tokens.add(token);
            if (this.beyondPosition(position).contains("[") || this.beyondPosition(position).contains("(")) {
                tokenizedLookup = this.tokenizeWithLookup(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add(this.opRes.getMessage());
                    return false;
                }
            } else {
                tokenizedLookup = this.tokenizeLookup(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add(this.opRes.getMessage());
                    return false;
                }
            }
            this.tokens.addAll(tokenizedLookup);
            hasRHS = false;
            this.definesLookup = true;
            lookupTables.add(token);
            InformationManagers.getInstance().getArrayManager().setUsedAsLookup(token);
            EquationProcessor.lookups.add(token);
            List<String> s = this.extractSubscripts(subscript);
            InformationManagers.getInstance().getArrayManager().arrayReference(origLHS, s);
        } else if (this.inRange(position) && this.characterAt(position).equals(":")) {
            ignore = false;
            this.tokens.add(token);
            this.tokens.add(":");
            ArrayList<String> tokenizedSubscripts = this.tokenizeSubscripts(position, this.opRes);
            if (!this.opRes.isOk()) {
                this.syntacticallyCorrect = false;
                this.syntaxMessages.add(this.opRes.getMessage());
                return false;
            }
            this.tokens.addAll(tokenizedSubscripts);
            for (String s : tokenizedSubscripts) {
                this.cleanEquation = String.valueOf(this.cleanEquation) + s;
            }
            hasRHS = false;
            this.definesSubscript = true;
            EquationProcessor.subscripts.add(token);
            this.registerSubscripts(this.tokens.get(0), tokenizedSubscripts);
            InformationManagers.getInstance().getNamedSubscriptManager().subscriptDefinition(this.tokens.get(0), this.extractSubscripts(tokenizedSubscripts));
            MutableInteger lookAhead1 = new MutableInteger(position.value() + 1);
            if (this.inRange(position) && this.characterAt(position).equals("-") && this.inRange(lookAhead1) && this.characterAt(lookAhead1).equals(">")) {
                this.processSubscriptMapping(this.tokens.get(0), this.extractSubscripts(tokenizedSubscripts), position);
            }
        } else if (this.inRange(position) && this.characterAt(position).equals("<") && this.inRange(position.value() + 1) && this.characterAt(position.value() + 1).equals("-") && this.inRange(position.value() + 2) && this.characterAt(position.value() + 2).equals(">")) {
            ignore = false;
            hasRHS = false;
            String rhsSubscript = this.equation.split("<->")[1].trim();
            InformationManagers.getInstance().getMappedSubscriptManager().addSubscriptNameFullSubrangeMapping(this.lhs, rhsSubscript);
        } else if (this.inRange(position) && this.characterAt(position).equals("[")) {
            String subs;
            ++this.leftBracketCount;
            ignore = false;
            this.lhsArray = token;
            StringBuffer sb = new StringBuffer("array." + token);
            this.hasLHSArrayReference = true;
            hasRHS = true;
            this.lhsSubscripts = this.getSubscriptsStartingAt(position, this.opRes);
            if (!this.opRes.isOk()) {
                this.syntacticallyCorrect = false;
                this.syntaxMessages.add("Tokenize LHS: " + this.opRes.getMessage());
            }
            InformationManagers.getInstance().getArrayManager().arrayReference(this.lhsArray, this.extractSubscripts(this.lhsSubscripts));
            this.skipWhiteSpace(position);
            if (this.inRange(position) && this.characterAt(position).equals(":")) {
                this.btwnMode = this.getStringDelimitedBy(position);
                this.skipWhiteSpace(position);
            }
            if (this.inRange(position) && this.characterAt(position).equals("=")) {
                subs = "";
                for (String s : this.lhsSubscripts) {
                    subs = String.valueOf(subs) + s;
                }
                sb.append(subs);
                this.lhs = sb.toString();
                this.tokens.add(sb.toString());
                this.assignment = true;
                this.tokens.add("=");
                if (this.inRange(position.value() + 1) && this.characterAt(position.value() + 1).equals("=")) {
                    position.add(1);
                }
            } else if (this.inRange(position) && this.characterAt(position).equals("[")) {
                ++this.leftBracketCount;
                this.exceptions = this.extractExceptions(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add("Tokenize LHS: " + this.opRes.getMessage());
                    return false;
                }
                this.setHasException(true);
                this.skipWhiteSpace(position);
                if (this.inRange(position) && this.characterAt(position).equals("=")) {
                    subs = "";
                    for (String s : this.lhsSubscripts) {
                        subs = String.valueOf(subs) + s;
                    }
                    sb.append(subs);
                    this.lhs = sb.toString();
                    this.tokens.add(sb.toString());
                    this.assignment = true;
                    this.tokens.add("=");
                    if (this.inRange(position.value() + 1) && this.characterAt(position.value() + 1).equals("=")) {
                        position.add(1);
                    }
                } else {
                    System.out.println("ERROR: Bad Array Reference (A)!character found is <" + this.characterAt(position) + "> position " + position);
                    ignore = true;
                }
            } else {
                System.out.println("ERROR: Bad Array Reference (B)! character found is <" + this.characterAt(position) + "> position " + position + " ###" + this.equation + "###");
                ignore = true;
            }
        } else {
            this.syntacticallyCorrect = false;
            this.syntaxMessages.add("LHS: Missing or misplaced character");
            return false;
        }
        if (ignore) {
            System.out.println("IGNORING <" + this.equation + ">");
            this.syntacticallyCorrect = false;
            this.syntaxMessages.add("Ignoring: " + this.equation);
            return false;
        }
        this.cleanEquation = "";
        for (String s : this.tokens) {
            this.cleanEquation = String.valueOf(this.cleanEquation) + s;
        }
        position.add(1);
        if (hasEqualSign || this.definesLookup) {
            InformationManagers.getInstance().getUnitsManager().addLhsUnits(this.lhs, this.units);
        }
        return hasRHS;
    }

    private String getStringDelimitedBy(MutableInteger position) {
        StringBuffer sb = new StringBuffer();
        String delim = this.characterAt(position);
        position.add(1);
        while (!this.characterAt(position).equals(delim)) {
            sb.append(this.characterAt(position));
            position.add(1);
        }
        position.add(1);
        return sb.toString();
    }

    public void removeExceptions(Set<String> arrayReferenceSet) {
        ArrayList<String> removeList = new ArrayList<String>();
        for (String arrayReference : arrayReferenceSet) {
            if (!this.containsException(arrayReference)) continue;
            removeList.add(arrayReference);
        }
        arrayReferenceSet.removeAll(removeList);
    }

    public boolean containsException(String arrayReference) {
        if (this.exceptions == null) {
            return false;
        }
        boolean contains = false;
        for (String except : this.exceptions) {
            if (!arrayReference.contains(except)) continue;
            contains = true;
        }
        return contains;
    }

    private List<String> extractExceptions(MutableInteger position, OperationResult or) {
        ArrayList<String> exceptions = new ArrayList<String>();
        while (this.getNextNonBlank(position).equals("[")) {
            String essa = this.getExceptionSubscriptStartingAt(position, or);
            if (!or.isOk()) {
                return exceptions;
            }
            exceptions.add(essa);
            System.out.println("Detected Exception: " + (String)exceptions.get(exceptions.size() - 1));
        }
        return exceptions;
    }

    private void checkSpecialFunctions(String token) {
        if (token.equalsIgnoreCase("Vector Sort Order")) {
            this.hasVectorSortOrder = true;
        } else if (token.equalsIgnoreCase("Vector Elm Map")) {
            this.hasVectorElmMap = true;
        }
    }

    private void tokenizeRHS(MutableInteger position) {
        String token = "";
        String unaryMinus = "";
        boolean function = false;
        boolean variable = false;
        boolean array = false;
        boolean macro = false;
        boolean stringConstant = false;
        boolean lookupRef = false;
        this.skipWhiteSpace(position);
        boolean done = false;
        while (!done) {
            function = false;
            variable = false;
            array = false;
            stringConstant = false;
            macro = false;
            lookupRef = false;
            if (position.value() >= this.equation.length()) break;
            String theChar = this.characterAt(position);
            if (this.characterAt(position).equals("\"") || this.characterAt(position).equals("'")) {
                if (this.characterAt(position).equals("'")) {
                    stringConstant = true;
                }
                token = this.typeString ? this.getQuotedStringWithQuotesStartingAt(position, this.opRes) : this.getQuotedStringStartingAt(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add("Parsing RHS: " + this.opRes.getMessage());
                    return;
                }
                this.skipWhiteSpace(position);
                if (this.inRange(position)) {
                    theChar = this.characterAt(position);
                    if (this.characterAt(position).equals("(")) {
                        if (InformationManagers.getInstance().getFunctionManager().isFunction(token)) {
                            this.checkSpecialFunctions(token);
                            function = true;
                            if (Equation.isGetXlsDataFunction(token)) {
                                this.usesTimeSeries = true;
                            }
                            if (Equation.isGetXlsLookupsFunction(token)) {
                                this.definesLookupGetXls = true;
                            }
                            if (token.toUpperCase().equals("INTEG")) {
                                this.stockVariable = true;
                            }
                            position.add(1);
                        } else if (Equation.isMacroName(token)) {
                            macro = true;
                            position.add(1);
                        } else {
                            this.referencesLookup = true;
                            lookupRef = true;
                            this.rhsTokens.add(token);
                        }
                    } else if (this.characterAt(position).equals("[")) {
                        array = true;
                        this.hasRHSArrayReference = true;
                        token = this.tokenizeArrayReference(token, position, this.opRes);
                        if (!this.opRes.isOk()) {
                            this.syntacticallyCorrect = false;
                            this.syntaxMessages.add("Parsing RHS: " + this.opRes.getMessage());
                            return;
                        }
                        position.add(1);
                        this.skipWhiteSpace(position);
                        if (this.inRange(position.value()) && this.characterAt(position.value()).equals("(")) {
                            this.referencesLookup = true;
                            lookupRef = true;
                            token = token.replace("array.", "");
                            this.rhsTokens.add(token);
                        } else {
                            this.rhsTokens.add(token);
                        }
                    } else {
                        if (!stringConstant) {
                            variable = true;
                        }
                        this.rhsTokens.add(token);
                    }
                } else {
                    variable = true;
                    this.rhsTokens.add(token);
                }
            } else if (Character.isLetter(this.characterAt(position).charAt(0))) {
                boolean allowColon = false;
                token = String.valueOf(unaryMinus) + this.getNonQuotedStringStartingAt(position, allowColon, this.opRes);
                this.skipWhiteSpace(position);
                if (this.inRange(position)) {
                    if (this.characterAt(position).equals("(")) {
                        if (InformationManagers.getInstance().getFunctionManager().isFunction(token)) {
                            this.checkSpecialFunctions(token);
                            function = true;
                            if (Equation.isGetXlsDataFunction(token)) {
                                this.usesTimeSeries = true;
                            }
                            if (Equation.isGetXlsLookupsFunction(token)) {
                                this.definesLookupGetXls = true;
                            }
                            if (token.toUpperCase().equals("INTEG")) {
                                this.stockVariable = true;
                            }
                            token = token.toUpperCase();
                            position.add(1);
                        } else if (Equation.isMacroName(token)) {
                            macro = true;
                            position.add(1);
                        } else {
                            lookupRef = true;
                            this.referencesLookup = true;
                            this.rhsTokens.add(token);
                        }
                    } else if (this.characterAt(position).equals("[")) {
                        array = true;
                        this.hasRHSArrayReference = true;
                        token = this.tokenizeArrayReference(token, position, this.opRes);
                        if (!this.opRes.isOk()) {
                            this.syntacticallyCorrect = false;
                            this.syntaxMessages.add("Parsing RHS: " + this.opRes.getMessage());
                            return;
                        }
                        position.add(1);
                        this.skipWhiteSpace(position);
                        theChar = this.characterAt(position.value());
                        if (this.inRange(position.value()) && this.characterAt(position.value()).equals("(")) {
                            this.referencesLookup = true;
                            lookupRef = true;
                            token = token.replace("array.", "");
                            this.rhsTokens.add(token);
                        } else {
                            this.rhsTokens.add(token);
                        }
                    } else {
                        variable = true;
                        this.rhsTokens.add(token);
                    }
                } else {
                    variable = true;
                    this.rhsTokens.add(token);
                }
            } else if (Character.isDigit(this.characterAt(position).charAt(0))) {
                String numeric = this.getNumberStartingAt(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add("RHS: " + this.opRes.getMessage());
                    return;
                }
                token = String.valueOf(unaryMinus) + numeric;
            } else if (this.characterAt(position).equals(":")) {
                token = this.getBooleanOperatorStartingAt(position, this.opRes);
                if (!this.opRes.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add("RHS: " + this.opRes.getMessage());
                    return;
                }
            } else if (Equation.isTerminator(this.characterAt(position).charAt(0))) {
                if (this.characterAt(position).equals("-")) {
                    String previousToken = this.tokens.get(this.tokens.size() - 1);
                    token = previousToken.equals("(") || previousToken.equals("=") || Parser.isOperator(previousToken) || this.isFunctionArgumentSeparator(previousToken) ? "_" : "-";
                } else if (this.characterAt(position).equals("+")) {
                    String previousToken = this.tokens.get(this.tokens.size() - 1);
                    token = previousToken.equals("(") || previousToken.equals("=") || Parser.isOperator(previousToken) || this.isFunctionArgumentSeparator(previousToken) ? " " : "+";
                } else if (this.characterAt(position).equals("=")) {
                    token = "==";
                } else if (this.characterAt(position).equals("<")) {
                    if (this.characterAt(position.value() + 1).equals(">")) {
                        token = "<>";
                        position.add(1);
                    }
                    if (this.characterAt(position.value() + 1).equals("=")) {
                        token = "<=";
                        position.add(1);
                    } else {
                        token = this.characterAt(position);
                    }
                } else if (this.characterAt(position).equals(">")) {
                    if (this.characterAt(position.value() + 1).equals("=")) {
                        token = ">=";
                        position.add(1);
                    } else {
                        token = this.characterAt(position);
                    }
                } else {
                    token = this.characterAt(position);
                }
                position.add(1);
            }
            if (function) {
                if (this.clean(token).startsWith("GETXLSXXX")) {
                    this.tokens.add("sdFunctions." + this.clean(token));
                    this.tokens.add("(");
                    this.cleanEquation = String.valueOf(this.cleanEquation) + "sdFunctions." + this.clean(token) + "(";
                } else {
                    int goober;
                    this.tokens.add("sdFunctions." + this.clean(token));
                    this.tokens.add("(");
                    FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(token);
                    if (fd.isRequiresName()) {
                        this.tokens.add("\"" + this.lhs + "\"");
                        this.tokens.add(",");
                    }
                    String valueOf = "";
                    valueOf = InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(this, this.lhs);
                    if (ArrayReference.isArrayReference(this.lhs)) {
                        goober = 1;
                        valueOf = this.lhs;
                    } else {
                        goober = 2;
                    }
                    if (fd.isRequiresValue()) {
                        this.tokens.add(valueOf);
                        this.tokens.add(",");
                    }
                    if (fd.isRequiresTime()) {
                        this.tokens.add("time");
                        this.tokens.add(",");
                    }
                    if (fd.isRequiresTimeStep()) {
                        this.tokens.add("timeStep");
                        this.tokens.add(",");
                    }
                    this.cleanEquation = String.valueOf(this.cleanEquation) + "sdFunctions." + this.clean(token) + "(\"" + this.lhs + "\"," + valueOf + ", time, timeStep, ";
                }
            } else if (macro) {
                this.tokens.add(token);
                this.tokens.add("(");
                this.cleanEquation = String.valueOf(this.cleanEquation) + this.clean(token) + "(";
            } else if (lookupRef) {
                this.tokens.add("sdFunctions.LOOKUP");
                this.tokens.add("(");
                this.tokens.add("lookup." + token);
                this.tokens.add(",");
                position.add(1);
                this.skipWhiteSpace(position);
                this.cleanEquation = String.valueOf(this.cleanEquation) + "sdFunctions.LOOKUP(lookup." + token + ",";
            } else if (array) {
                this.tokens.add(token);
                this.cleanEquation = String.valueOf(this.cleanEquation) + token;
            } else if (variable) {
                this.tokens.add(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(token));
                this.cleanEquation = String.valueOf(this.cleanEquation) + InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(token);
            } else if (stringConstant) {
                this.tokens.add("\"" + token + "\"");
                this.cleanEquation = String.valueOf(this.cleanEquation) + "\"" + token + "\"";
            } else {
                this.tokens.add(token);
                this.cleanEquation = String.valueOf(this.cleanEquation) + (token.equals("_") ? "-" : token);
            }
            this.skipWhiteSpace(position);
        }
        if (this.vensimEquation.contains("VDMLOOKUP")) {
            this.setVdmLookup(true);
        }
        if (this.rhsTokens.size() == 0 || this.equation.contains("GET XLS") || this.equation.contains("VDMLOOKUP") || this.definesLookup || this.hasInitialValue || this.definesSubscript || this.definesLookupWithRange) {
            this.setOneTime(true);
        }
        if (this.equation.contains("RANDOM")) {
            this.setOneTime(false);
        }
        if (this.tokens.contains("time")) {
            this.setOneTime(false);
        }
    }

    public String getIntialValue() {
        if (!this.isStock()) {
            return "";
        }
        if (this.rpn.size() == 0) {
            this.generateRpn();
        }
        if (this.treeRoot == null) {
            this.generateTree();
        }
        StringBuffer sb = new StringBuffer();
        Node integ = this.treeRoot.getChild().getNext();
        Node arg = integ.getChild();
        while (arg.getNext() != null) {
            arg = arg.getNext();
        }
        sb.append(Node.expand(arg));
        return sb.toString();
    }

    private boolean isArrayReference(MutableInteger position) {
        MutableInteger pos = new MutableInteger(position);
        while (!this.characterAt(pos).equals("]")) {
            pos.add(1);
        }
        pos.add(1);
        this.skipWhiteSpace(pos);
        return !this.characterAt(pos).equals("(");
    }

    private void validateIFTHENELSEInTree(Node root) {
        ArrayList<Node> iteNodes = new ArrayList<Node>();
        this.findITE(root, iteNodes);
        for (Node node : iteNodes) {
            this.validateIFTHENELSE(node);
        }
    }

    public void findITE(Node node, List<Node> iteNodes) {
        if (node == null) {
            return;
        }
        if (Equation.isITENode(node)) {
            iteNodes.add(node);
        }
        this.findITE(node.getChild(), iteNodes);
        this.findITE(node.getNext(), iteNodes);
    }

    public static boolean isITENode(Node node) {
        return node.getToken().equals("sdFunctions.IFTHENELSE");
    }

    private void validateIFTHENELSE(Node iteNode) {
        Node conditionNode;
        Node c = iteNode.getChild();
        if (c == null) {
            System.out.println("MISSING ARG");
        }
        if ((c = c.getNext()) == null) {
            System.out.println("MISSING ARG");
        }
        if ((c = c.getNext()) == null) {
            System.out.println("MISSING ARG");
        }
        if ((c = c.getNext()) == null) {
            System.out.println("MISSING ARG");
        }
        if ((c = c.getNext()) == null) {
            System.out.println("MISSING ARG");
        }
        if ((conditionNode = TreeTraversal.getFunctionArgument(iteNode, 1)).isTerminal()) {
            this.replaceBooleanVariable(conditionNode);
        } else {
            ArrayList<Node> terminals = new ArrayList<Node>();
            this.findTerminal(conditionNode.getChild(), terminals);
            for (Node node : terminals) {
                if (Parser.isRelationalOperator(node.getParent().getToken()) || Parser.isArithmeticOperator(node.getParent().getToken()) || Parser.isFunctionInvocation(node.getParent().getToken())) continue;
                this.replaceBooleanVariable(node);
            }
        }
    }

    private void findTerminal(Node node, List<Node> terminals) {
        if (node == null) {
            return;
        }
        if (node.isTerminal()) {
            terminals.add(node);
        }
        this.findTerminal(node.getChild(), terminals);
        this.findTerminal(node.getNext(), terminals);
    }

    private void replaceBooleanVariable(Node node) {
        Node equalsNode = new Node("==");
        Node one = new Node("1.0");
        Node previous = node.getPrevious();
        Node next = node.getNext();
        Node parent = node.getParent();
        if (previous != null) {
            previous.setNext(equalsNode);
        } else {
            parent.setChild(equalsNode);
        }
        if (next != null) {
            next.setPrevious(equalsNode);
        }
        equalsNode.setParent(node.getParent());
        equalsNode.setNext(node.getNext());
        equalsNode.setPrevious(node.getPrevious());
        equalsNode.setChild(node);
        node.setPrevious(null);
        node.setNext(one);
    }

    private void processSubscriptMapping(String rhsSubscriptName, List<String> rhsSubscriptValues, MutableInteger position) {
        String mappedTo = this.equation.split("->")[1].trim();
        if (!mappedTo.contains("(")) {
            InformationManagers.getInstance().getMappedSubscriptManager().addSubscriptNameMapping(rhsSubscriptName, mappedTo);
            if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(mappedTo)) {
                List<String> mappedToValues = InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(mappedTo);
                int i = 0;
                while (i < mappedToValues.size()) {
                    InformationManagers.getInstance().getMappedSubscriptManager().addSubscriptValueMapping(rhsSubscriptName, mappedTo, rhsSubscriptValues.get(i), mappedToValues.get(i));
                    ++i;
                }
            } else {
                InformationManagers.getInstance().getMappedSubscriptManager().addSubscriptValueMappingDelayed(rhsSubscriptName, mappedTo, rhsSubscriptValues);
            }
            return;
        }
        String s = this.characterAt(position);
        position.add(2);
        s = this.characterAt(position);
        this.skipWhiteSpace(position);
        s = this.characterAt(position);
        while (this.inRange(position) && this.characterAt(position).equals("(")) {
            List<String> tokens = this.tokenizeMappedSubscriptInParens(position);
            mappedTo = tokens.get(0);
            tokens.remove(0);
            InformationManagers.getInstance().getMappedSubscriptManager().addSubscriptNameMapping(rhsSubscriptName, mappedTo);
            if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(mappedTo)) {
                int i = 0;
                while (i < tokens.size()) {
                    InformationManagers.getInstance().getMappedSubscriptManager().addSubscriptValueMapping(rhsSubscriptName, mappedTo, rhsSubscriptValues.get(i), tokens.get(i));
                    ++i;
                }
                continue;
            }
            InformationManagers.getInstance().getMappedSubscriptManager().addSubscriptValueMappingDelayed(rhsSubscriptName, mappedTo, rhsSubscriptValues, tokens);
        }
    }

    private List<String> tokenizeMappedSubscriptInParens(MutableInteger position) {
        ArrayList<String> tokens = new ArrayList<String>();
        int matchingParen = this.equation.indexOf(")", position.value());
        String s = this.equation.substring(position.value() + 1, matchingParen);
        String[] t = s.split(",");
        String name = t[0].split(":")[0].trim();
        String first = t[0].split(":")[1].trim();
        tokens.add(name);
        tokens.add(first);
        int i = 1;
        while (i < t.length) {
            tokens.add(t[i].trim());
            ++i;
        }
        position.setValue(matchingParen + 1);
        if (!this.inRange(position)) {
            return tokens;
        }
        String s1 = this.characterAt(position);
        this.skipWhiteSpace(position);
        s1 = this.characterAt(position);
        if (this.inRange(position.value()) && this.characterAt(position.value()).equals(",")) {
            position.add(1);
            s1 = this.characterAt(position);
            this.skipWhiteSpace(position);
            s1 = this.characterAt(position);
        }
        return tokens;
    }

    private String tokenizeArrayReference(String arrayName, MutableInteger position, OperationResult or) {
        or.clear();
        StringBuffer sb = new StringBuffer();
        sb.append("array." + arrayName);
        sb.append("[");
        ArrayList<String> tokenList = this.tokenizeSubscripts(position, or);
        if (!or.isOk()) {
            return "";
        }
        for (String token : tokenList) {
            sb.append(token);
        }
        InformationManagers.getInstance().getArrayManager().arrayReference(arrayName, this.extractSubscripts(tokenList));
        return sb.toString();
    }

    private List<String> getRHStokens(List<String> tokens) {
        ArrayList<String> al = new ArrayList<String>();
        boolean afterEquals = false;
        for (String token : tokens) {
            if (afterEquals) {
                if (token.equals(",") || token.equals(";")) continue;
                al.add(token);
                continue;
            }
            if (!token.equals("=")) continue;
            afterEquals = true;
        }
        return al;
    }

    private void registerSubscripts(String subscript, List<String> tokenizedSubscripts) {
        ArrayList<String> al = new ArrayList<String>();
        for (String token : tokenizedSubscripts) {
            if (token.equals(",")) continue;
            al.add(token);
        }
        EquationProcessor.subscriptValues.put(subscript, al);
    }

    private String getOffset(SubscriptCombination combo1, SubscriptCombination combo2) {
        return "";
    }

    public List<SubscriptCombination> getSubscriptValueCombinations(String ... strings) {
        ArrayList<List<String>> bySubscriptValue = new ArrayList<List<String>>();
        ArrayList<SubscriptCombination> values = new ArrayList<SubscriptCombination>();
        ArrayList<String> order = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String subscriptName = stringArray[n2];
            bySubscriptValue.add(this.extractSubscripts(this.getSubscriptValues(subscriptName)));
            order.add(subscriptName);
            ++n2;
        }
        int numPermutations = 1;
        int i = 0;
        while (i < bySubscriptValue.size()) {
            numPermutations *= ((List)bySubscriptValue.get(i)).size();
            ++i;
        }
        SubscriptCombination[] combinations = new SubscriptCombination[numPermutations];
        int i2 = 0;
        while (i2 < numPermutations) {
            combinations[i2] = new SubscriptCombination(order);
            ++i2;
        }
        int subscriptNumber = 0;
        while (subscriptNumber < strings.length) {
            int numPerValue = 1;
            int i3 = subscriptNumber + 1;
            while (i3 < bySubscriptValue.size()) {
                numPerValue *= ((List)bySubscriptValue.get(i3)).size();
                ++i3;
            }
            int row = 0;
            while (row < numPermutations) {
                for (String value : (List)bySubscriptValue.get(subscriptNumber)) {
                    int i4 = 0;
                    while (i4 < numPerValue) {
                        combinations[row].addSubscriptValue(strings[subscriptNumber], value);
                        ++row;
                        ++i4;
                    }
                }
            }
            ++subscriptNumber;
        }
        SubscriptCombination[] subscriptCombinationArray = combinations;
        int n3 = combinations.length;
        int n4 = 0;
        while (n4 < n3) {
            SubscriptCombination combo = subscriptCombinationArray[n4];
            values.add(combo);
            ++n4;
        }
        return values;
    }

    public List<String> getSubscriptValues(String subscriptName) {
        ArrayList<String> al = new ArrayList<String>();
        if (this.isNamedSubscript(subscriptName)) {
            for (String v : EquationProcessor.subscriptValues.get(subscriptName)) {
                if (this.isNamedSubscript(v)) {
                    al.addAll(this.getSubscriptValues(v));
                    continue;
                }
                al.add(v);
            }
        } else {
            al.add(subscriptName);
        }
        return al;
    }

    public boolean isNamedSubscript(String subscriptName) {
        return EquationProcessor.subscriptValues.containsKey(subscriptName);
    }

    private List<String> extractSubscripts(List<String> subscriptList) {
        ArrayList<String> al = new ArrayList<String>();
        for (String token : subscriptList) {
            if (token.equals("[") || token.equals(",") || token.equals("]")) continue;
            al.add(token);
        }
        return al;
    }

    private List<String> extractSubscripts(String subscript) {
        String[] subrs;
        ArrayList<String> al = new ArrayList<String>();
        String[] stringArray = subrs = subscript.split(",");
        int n = subrs.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            al.add(token.trim());
            ++n2;
        }
        return al;
    }

    public String generateArrayConstantsInitialization(boolean logit) {
        StringBuffer sb = new StringBuffer();
        String[] values = this.asArray(this.getRHStokens(this.tokens));
        if (!this.equation.contains("GET XLS")) {
            if (this.cleanEquation.contains("sdFunction")) {
                String funcCallHead = "";
                String funcCallTail = "";
                funcCallHead = String.valueOf(this.tokens.get(2)) + "(";
                int t = 7;
                while (t < this.tokens.size()) {
                    funcCallTail = String.valueOf(funcCallTail) + this.tokens.get(t);
                    ++t;
                }
                funcCallTail = String.valueOf(funcCallTail) + ";\n";
                sb.append("// funcCallTail = " + funcCallTail);
                sb.append("// getOuter Equation 1691\n");
                sb.append(this.getEars().getOuterLoops());
                sb.append(String.valueOf(this.ears.getLHSassignment()) + " = " + funcCallHead + "\"" + this.ears.getLHSassignment() + "\"," + this.ears.getLHSassignment() + funcCallTail);
                int i = 0;
                while (i < this.ears.getOuterClosingCount()) {
                    sb.append("} // close outer \n");
                    ++i;
                }
            } else {
                int i;
                String vArray = this.getNextArray();
                if (!Translator.target.equals("C")) {
                    sb.append("double[] ");
                } else {
                    sb.append("double* ");
                }
                sb.append(String.valueOf(vArray) + " = newDoubleArray( ");
                boolean needsIncrement = false;
                if (values.length > 1) {
                    needsIncrement = true;
                }
                int len = values.length;
                int j = 0;
                while (j < values.length) {
                    if (values[j].equals("_")) {
                        --len;
                    }
                    ++j;
                }
                sb.append(len);
                j = 0;
                while (j < values.length) {
                    sb.append(",");
                    if (values[j].equals("_")) {
                        sb.append("-");
                        ++j;
                    }
                    sb.append(values[j]);
                    ++j;
                }
                sb.append(");\n");
                String integer = this.getNextInt();
                sb.append("int " + integer + " = 0;\n");
                sb.append("// getOuter Equation 1742\n");
                sb.append(this.getEars().getOuterLoops());
                sb.append(this.getEars().getLHSassignment());
                sb.append(" = " + vArray + "[" + integer + "];\n");
                sb.append("/* generateArrayConstantsInitialization 1 */\n");
                if (logit) {
                    sb.append("/* log7 */logit(stringConcat(\"" + this.getEars().getLhsArrayReference().getArrayName() + "\"");
                    i = 0;
                    while (i < this.getEars().getOuterClosingCount()) {
                        sb.append(",\"[\",intToString(outer" + i + "),\"]\"");
                        ++i;
                    }
                    sb.append("),0.0,");
                    sb.append(String.valueOf(vArray) + "[" + integer + "],memory.get_SAVEPER());\n");
                }
                if (needsIncrement) {
                    sb.append(String.valueOf(integer) + "++;\n");
                }
                i = 0;
                while (i < this.getEars().getOuterClosingCount()) {
                    sb.append("}\n");
                    ++i;
                }
            }
        } else if (this.equation.contains("CONSTANTS")) {
            int i;
            int numTokens = this.tokens.size();
            int cellLocation = numTokens - 2;
            String funcCallHead = "";
            String funcCallCellStart = "";
            String funcCallCell = "";
            String funcCallTail = ")";
            int t = 2;
            while (t < cellLocation) {
                funcCallHead = String.valueOf(funcCallHead) + this.tokens.get(t);
                ++t;
            }
            funcCallCellStart = this.tokens.get(cellLocation).replace("\"", "");
            int numDimensions = this.asArray(this.extractSubscripts(this.lhsSubscripts)).length;
            String columnStart = Parser.getColumnLettersFromCellAddress(funcCallCellStart);
            int rowStart = Parser.getRowFromCellAddress(funcCallCellStart);
            int numRows = 1;
            int numCols = -1;
            List<String> subs = this.extractSubscripts(this.lhsSubscripts);
            int i2 = subs.size() - 1;
            while (i2 >= 0) {
                if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(subs.get(i2))) {
                    if (numCols == -1) {
                        numCols = InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subs.get(i2)).size();
                    } else {
                        numRows *= InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subs.get(i2)).size();
                    }
                }
                --i2;
            }
            List<SubscriptCombination> combos = this.getSubscriptValueCombinations(this.asArray(this.extractSubscripts(this.lhsSubscripts)));
            String v = String.valueOf(funcCallHead) + "\"" + funcCallCellStart + "\"" + "," + numRows + "," + numCols + funcCallTail;
            String array = this.getNextArray();
            sb.append("double[] " + array + " = " + v + ";\n");
            String integer = this.getNextInt();
            sb.append("int " + integer + " = 0;\n");
            sb.append("// getOuter Equation 1811\n");
            sb.append(this.getEars().getOuterLoops());
            sb.append(this.getEars().getLHSassignment());
            sb.append(" = " + array + "[" + integer + "];\n");
            sb.append("/* generateArrayConstantsInitialization 2 */\n");
            if (logit) {
                sb.append("/* log8 */logit(\"" + this.getEars().getLhsArrayReference().getArrayName() + "\"");
                i = 0;
                while (i < this.getEars().getOuterClosingCount()) {
                    sb.append("+\"[\"+outer" + i + "+\"]\"");
                    ++i;
                }
                sb.append(",0.0,");
                sb.append(String.valueOf(array) + "[" + integer + "],memory.get_SAVEPER());\n");
            }
            sb.append(String.valueOf(integer) + "++;\n");
            i = 0;
            while (i < this.getEars().getOuterClosingCount()) {
                sb.append("}\n");
                ++i;
            }
        } else {
            int numTokens = this.tokens.size();
            int cellLocation = numTokens - 2;
            String funcCallHead = "";
            String funcCallCellStart = "";
            String funcCallTail = ")";
            int t = 2;
            while (t < cellLocation) {
                funcCallHead = String.valueOf(funcCallHead) + this.tokens.get(t);
                ++t;
            }
            funcCallCellStart = this.tokens.get(cellLocation).replace("\"", "");
            int numRows = 1;
            int numCols = -1;
            List<String> subs = this.extractSubscripts(this.lhsSubscripts);
            int i = subs.size() - 1;
            while (i >= 0) {
                if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(subs.get(i))) {
                    if (numCols == -1) {
                        numCols = InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subs.get(i)).size();
                    } else {
                        numRows *= InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subs.get(i)).size();
                    }
                }
                --i;
            }
            List<SubscriptCombination> combos = this.getSubscriptValueCombinations(this.asArray(this.extractSubscripts(this.lhsSubscripts)));
            String timeSeries = this.getNextTimeSeries();
            String v = String.valueOf(funcCallHead) + "\"" + funcCallCellStart + "\"" + "," + numRows + "," + numCols + funcCallTail;
            sb.append("TimeSeriesInstance " + timeSeries + " = " + v + ";\n");
            String integer = this.getNextInt();
            sb.append("int " + integer + " = 0;\n");
            sb.append("// getOuter Equation 1877\n");
            sb.append(this.getEars().getOuterLoops());
            if (this.isDefinesLookupGetXls()) {
                sb.append(String.valueOf(this.getEars().getLHSassignment()) + " = ");
                sb.append("sdFunctions.ADDLOOKUPNATIVE(\"" + this.lhsArray + "\"+ " + this.getEars().getLHSsubscript() + ", " + timeSeries + ".getTime()," + timeSeries + ".valuesForIndex(" + integer + "++));");
            } else {
                sb.append("\ttimeSeriesData.addTimeSeries(data, \"" + this.lhsArray + "\", " + this.getEars().getLHSsubscript() + ", " + timeSeries + ".getTime()," + timeSeries + ".valuesForIndex(" + integer + "++));");
            }
            int i3 = 0;
            while (i3 < this.getEars().getOuterClosingCount()) {
                sb.append("}\n");
                ++i3;
            }
        }
        return sb.toString();
    }

    private String asString(String[] asArray) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = asArray;
        int n = asArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }

    private String[] asArray(List<String> items) {
        String[] array = new String[items.size()];
        int i = 0;
        while (i < items.size()) {
            array[i] = items.get(i);
            ++i;
        }
        return array;
    }

    private ArrayList<String> tokenizeWithLookup(MutableInteger position, OperationResult or) {
        String numeric;
        or.clear();
        ArrayList<String> al = new ArrayList<String>();
        al.add("(");
        position.add(1);
        this.skipWhiteSpace(position);
        if (this.characterAt(position).equals("[")) {
            this.definesLookupWithRange = true;
            if (!this.checkIf(this.characterAt(position), "[", or)) {
                return al;
            }
            al.add("[");
            position.add(1);
            this.skipWhiteSpace(position);
            if (!this.checkIf(this.characterAt(position), "(", or)) {
                return al;
            }
            al.add("(");
            position.add(1);
            this.skipWhiteSpace(position);
            numeric = this.getNumberStartingAt(position, or);
            if (!or.isOk()) {
                return al;
            }
            al.add(numeric);
            this.skipWhiteSpace(position);
            if (!this.checkIf(this.characterAt(position), ",", or)) {
                return al;
            }
            al.add(",");
            position.add(1);
            this.skipWhiteSpace(position);
            numeric = this.getNumberStartingAt(position, or);
            if (!or.isOk()) {
                return al;
            }
            al.add(numeric);
            this.skipWhiteSpace(position);
            if (!this.checkIf(this.characterAt(position), ")", or)) {
                return al;
            }
            al.add(")");
            position.add(1);
            this.skipWhiteSpace(position);
            if (!this.checkIf(this.characterAt(position), "-", or)) {
                return al;
            }
            al.add("-");
            position.add(1);
            this.skipWhiteSpace(position);
            al.add("(");
            position.add(1);
            this.skipWhiteSpace(position);
            numeric = this.getNumberStartingAt(position, or);
            if (!or.isOk()) {
                return al;
            }
            al.add(numeric);
            this.skipWhiteSpace(position);
            al.add(",");
            position.add(1);
            this.skipWhiteSpace(position);
            numeric = this.getNumberStartingAt(position, or);
            if (!or.isOk()) {
                return al;
            }
            al.add(numeric);
            this.skipWhiteSpace(position);
            al.add(")");
            position.add(1);
            this.skipWhiteSpace(position);
            al.add("]");
            position.add(1);
            this.skipWhiteSpace(position);
        }
        boolean done = false;
        int openParens = 1;
        while (this.inRange(position) && !done) {
            if (Character.isDigit(this.characterAt(position).charAt(0)) || this.characterAt(position).equals("-")) {
                numeric = this.getNumberStartingAt(position, or);
                if (!or.isOk()) {
                    return al;
                }
                al.add(numeric);
                continue;
            }
            if (!Character.isWhitespace(this.characterAt(position).toCharArray()[0])) {
                al.add(this.characterAt(position));
            }
            if (this.characterAt(position).equals("(")) {
                ++openParens;
            } else if (this.characterAt(position).equals(")") && --openParens == 0) {
                done = true;
            }
            position.add(1);
        }
        if (!done) {
            or.setErrorMessage("Closing paren(s) missing");
            return al;
        }
        return al;
    }

    private boolean checkIf(String s1, String s2, OperationResult or) {
        or.clear();
        if (!s1.equals(s2)) {
            or.setErrorMessage("Expecting <" + s1 + "> found <" + s2 + ">");
        }
        return or.isOk();
    }

    private ArrayList<String> tokenizeSubscripts(MutableInteger position, OperationResult or) {
        or.clear();
        ArrayList<String> al = new ArrayList<String>();
        position.add(1);
        this.skipWhiteSpace(position);
        if (this.characterAt(position).equals("(")) {
            this.expandNumericRange(position, al, or);
            if (!or.isOk()) {
                this.syntacticallyCorrect = false;
                this.syntaxMessages.add(or.getMessage());
                return al;
            }
        } else {
            al.add(this.getStringStartingAt(position, or));
            if (!or.isOk()) {
                this.syntacticallyCorrect = false;
                this.syntaxMessages.add(or.getMessage());
                return al;
            }
        }
        this.skipWhiteSpace(position);
        while (this.inRange(position)) {
            MutableInteger lookAhead1 = new MutableInteger(position);
            lookAhead1.add(1);
            this.skipWhiteSpace(position);
            if (this.characterAt(position).equals("]")) {
                al.add("]");
                break;
            }
            if (this.characterAt(position).equals("-") && this.characterAt(lookAhead1).equals(">")) {
                return al;
            }
            al.add(this.characterAt(position));
            position.add(1);
            this.skipWhiteSpace(position);
            if (this.characterAt(position).equals("(")) {
                this.expandNumericRange(position, al, or);
                if (!or.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add(or.getMessage());
                    return al;
                }
            } else {
                al.add(this.getStringStartingAt(position, or));
                if (!or.isOk()) {
                    this.syntacticallyCorrect = false;
                    this.syntaxMessages.add(or.getMessage());
                    return al;
                }
            }
            this.skipWhiteSpace(position);
        }
        return al;
    }

    private void expandNumericRange(MutableInteger position, ArrayList<String> tokenList, OperationResult or) {
        or.clear();
        if (!or.isOk()) {
            this.syntacticallyCorrect = false;
            this.syntaxMessages.add("Subscript Definition: " + or.getMessage());
            return;
        }
        String str = this.equation.substring(position.value());
        if (!str.contains(")")) {
            or.setErrorMessage("Numeric Range Subscript Definition: Missing closing paren");
            return;
        }
        str = str.substring(1, str.indexOf(")")).trim();
        String l = str.split("-")[0].trim();
        String r = str.split("-")[1].trim();
        String lHead = this.extractHeadOfSubscript(l, or);
        if (!or.isOk()) {
            return;
        }
        String start = this.extractNumberFromEndOfSubscript(l, or);
        if (!or.isOk()) {
            return;
        }
        String rHead = this.extractHeadOfSubscript(l, or);
        if (!or.isOk()) {
            return;
        }
        String end = this.extractNumberFromEndOfSubscript(r, or);
        if (!or.isOk()) {
            return;
        }
        if (!lHead.equals(rHead)) {
            or.setErrorMessage("Numeric Subscript Range: subscript heads do not match");
        }
        String chars = l.replaceAll(start, "");
        int numIndex = 0;
        int i = Integer.parseInt(start);
        while (i <= Integer.parseInt(end)) {
            if (numIndex++ > 0) {
                tokenList.add(",");
            }
            tokenList.add(String.valueOf(chars) + Integer.toString(i));
            ++i;
        }
        while (!this.characterAt(position).equals(")")) {
            position.add(1);
        }
        position.add(1);
        this.skipWhiteSpace(position);
    }

    private String extractHeadOfSubscript(String s, OperationResult or) {
        or.clear();
        String n = "";
        int i = 0;
        while (i < s.length()) {
            if (Character.isDigit(s.charAt(i))) {
                return n;
            }
            n = String.valueOf(s.charAt(i)) + n;
            ++i;
        }
        or.setErrorMessage("Non-numeric Subscript head not found");
        return "";
    }

    private String extractNumberFromEndOfSubscript(String s, OperationResult or) {
        String n = "";
        int i = s.length() - 1;
        while (i >= 0) {
            if (!Character.isDigit(s.charAt(i))) {
                return n;
            }
            n = String.valueOf(s.charAt(i)) + n;
            --i;
        }
        or.setErrorMessage("Numeric Subscript tail not found");
        return "";
    }

    private ArrayList<String> tokenizeLookup(MutableInteger position, OperationResult or) {
        or.clear();
        ArrayList<String> al = new ArrayList<String>();
        al.add("(");
        position.add(1);
        this.skipWhiteSpace(position);
        String numeric = this.getNumberStartingAt(position, or);
        if (!or.isOk()) {
            return al;
        }
        al.add(numeric);
        this.skipWhiteSpace(position);
        while (!this.characterAt(position).equals(")")) {
            this.skipWhiteSpace(position);
            al.add(this.characterAt(position));
            position.add(1);
            this.skipWhiteSpace(position);
            numeric = this.getNumberStartingAt(position, or);
            if (!or.isOk()) {
                return al;
            }
            al.add(numeric);
            this.skipWhiteSpace(position);
        }
        al.add(")");
        return al;
    }

    private boolean inRange(int position) {
        return position <= this.equation.length() - 1;
    }

    private boolean inRange(MutableInteger position) {
        return position.value() <= this.equation.length() - 1;
    }

    private String getBooleanOperatorStartingAt(MutableInteger position, OperationResult or) {
        String booleanOperator = ":";
        position.add(1);
        while (this.inRange(position) && !this.characterAt(position).equals(":")) {
            booleanOperator = String.valueOf(booleanOperator) + this.characterAt(position);
            position.add(1);
        }
        booleanOperator = String.valueOf(booleanOperator) + ":";
        if (!this.inRange(position) || !Parser.isLogicalOperator(booleanOperator)) {
            or.setErrorMessage("Expecting boolean operator");
            return booleanOperator;
        }
        position.add(1);
        return booleanOperator;
    }

    private List<String> getSubscriptsStartingAt(MutableInteger position, OperationResult or) {
        ArrayList<String> al = new ArrayList<String>();
        al.add("[");
        position.add(1);
        this.skipWhiteSpace(position);
        al.add(this.getStringStartingAt(position, or));
        if (!or.isOk()) {
            return al;
        }
        this.skipWhiteSpace(position);
        while (!this.characterAt(position).equals("]")) {
            this.skipWhiteSpace(position);
            al.add(this.characterAt(position));
            position.add(1);
            this.skipWhiteSpace(position);
            al.add(this.getStringStartingAt(position, or));
            if (!or.isOk()) {
                return al;
            }
            this.skipWhiteSpace(position);
        }
        position.add(1);
        al.add("]");
        return al;
    }

    private String getExceptionSubscriptStartingAt(MutableInteger position, OperationResult or) {
        String exceptionSubscript = "";
        position.add(1);
        this.skipWhiteSpace(position);
        exceptionSubscript = String.valueOf(exceptionSubscript) + this.getStringStartingAt(position, or);
        if (!or.isOk()) {
            return "";
        }
        this.skipWhiteSpace(position);
        while (!this.characterAt(position).equals("]")) {
            this.skipWhiteSpace(position);
            exceptionSubscript = String.valueOf(exceptionSubscript) + this.characterAt(position);
            position.add(1);
            this.skipWhiteSpace(position);
            exceptionSubscript = String.valueOf(exceptionSubscript) + this.getStringStartingAt(position, or);
            if (!or.isOk()) {
                return "";
            }
            this.skipWhiteSpace(position);
        }
        position.add(1);
        return exceptionSubscript;
    }

    private String getNextNonBlank(MutableInteger position) {
        String string = "";
        MutableInteger pos = new MutableInteger(position);
        this.skipWhiteSpace(pos);
        return this.characterAt(position);
    }

    /*
     * Unable to fully structure code
     */
    private String getStringStartingAt(MutableInteger position, OperationResult or) {
        string = "";
        or.clear();
        if (!this.inRange(position) || !this.characterAt(position).equals("\"")) ** GOTO lbl8
        return this.getQuotedStringStartingAt(position, or);
lbl-1000:
        // 1 sources

        {
            string = String.valueOf(string) + this.characterAt(position);
            position.add(1);
lbl8:
            // 2 sources

            ** while (this.inRange((MutableInteger)position) && (Character.isLetter((char)this.characterAt((MutableInteger)position).charAt((int)0)) || Character.isDigit((char)this.characterAt((MutableInteger)position).charAt((int)0)) || this.characterAt((MutableInteger)position).equals((Object)" ") || this.characterAt((MutableInteger)position).equals((Object)"\"") || this.characterAt((MutableInteger)position).equals((Object)"!")))
        }
lbl9:
        // 1 sources

        return string.trim();
    }

    private String getNumberStartingAt(MutableInteger position, OperationResult or) {
        String number = "";
        if (this.characterAt(position).equals("-")) {
            number = "-";
            position.add(1);
        }
        while (this.inRange(position) && (Character.isDigit(this.characterAt(position).charAt(0)) || this.characterAt(position).equals("."))) {
            number = String.valueOf(number) + this.characterAt(position);
            position.add(1);
        }
        if (number.length() == 0) {
            or.setErrorMessage("Expecting numeric value");
        }
        return number;
    }

    private String getNonQuotedStringStartingAt(MutableInteger position, boolean allowColon, OperationResult or) {
        or.clear();
        String nonQuotedString = "";
        while (this.inRange(position) && (Character.isLetterOrDigit(this.characterAt(position).charAt(0)) || this.characterAt(position).equals("_") || this.characterAt(position).equals("$") || this.characterAt(position).equals("'") || allowColon && this.characterAt(position).equals(":") || this.characterAt(position).equals(" "))) {
            nonQuotedString = String.valueOf(nonQuotedString) + this.characterAt(position);
            position.add(1);
        }
        return nonQuotedString.trim();
    }

    private String getQuotedStringStartingAt(MutableInteger position, OperationResult or) {
        or.clear();
        String quoteChar = this.characterAt(position);
        String quotedString = "";
        position.add(1);
        while (this.inRange(position) && !this.characterAt(position).equals(quoteChar)) {
            quotedString = String.valueOf(quotedString) + this.characterAt(position);
            position.add(1);
        }
        if (!this.inRange(position)) {
            or.setErrorMessage("Missing end quote");
            return quotedString;
        }
        if (this.characterAt(position).equals(quoteChar)) {
            or.setOk(true);
        }
        position.add(1);
        return quotedString;
    }

    private String getQuotedStringWithQuotesStartingAt(MutableInteger position, OperationResult or) {
        or.clear();
        String quoteChar = this.characterAt(position);
        String quotedString = "\\\"";
        position.add(1);
        while (this.inRange(position) && !this.characterAt(position).equals(quoteChar)) {
            quotedString = String.valueOf(quotedString) + this.characterAt(position);
            position.add(1);
        }
        quotedString = String.valueOf(quotedString) + "\\\"";
        if (this.characterAt(position).equals(quoteChar)) {
            or.setOk(true);
        }
        if (!this.inRange(position)) {
            or.setErrorMessage("Missing end quote");
        }
        position.add(1);
        return quotedString;
    }

    private String characterAt(int position) {
        if (position > this.equation.length() - 1) {
            return null;
        }
        String s = this.equation.substring(position, position + 1);
        return this.equation.substring(position, position + 1);
    }

    private String characterAt(MutableInteger position) {
        if (this.inRange(position)) {
            String s = this.equation.substring(position.value(), position.value() + 1);
            return this.equation.substring(position.value(), position.value() + 1);
        }
        return null;
    }

    private String beyondPosition(MutableInteger position) {
        return this.equation.substring(position.value() + 1);
    }

    private void skipWhiteSpace(MutableInteger position) {
        while (this.inRange(position) && Character.isWhitespace(this.characterAt(position).charAt(0))) {
            position.add(1);
        }
    }

    private boolean requiresLHS(String func) {
        return !func.equals("LOOKUP)");
    }

    public static boolean isSeparator(String token) {
        if (token.trim().length() == 0) {
            return true;
        }
        return token.equals(")") || token.equals("(") || token.equals("[") || token.equals("]");
    }

    private String clean(String s) {
        return s.replace(" ", "").replace(":", "_").replace("\t", "").replace("&", "_").replace("-", "_").replace("\"", "").replace("(", "_").replace(")", "_").replace("'", "");
    }

    public static boolean isTerminator(char c) {
        return terminatorSet.contains(Character.valueOf(c));
    }

    public static boolean isGetXlsDataFunction(String s) {
        return s.equals("GET XLS DATA");
    }

    public static boolean isGetXlsConstantsFunction(String s) {
        return s.equals("GET XLS CONSTANTS");
    }

    public static boolean isGetXlsLookupsFunction(String s) {
        return s.equals("GET XLS LOOKUPS");
    }

    public static boolean isVectorSortOrder(String s) {
        return s.equals("VECTOR SORT ORDER");
    }

    public static boolean isVectorElmMap(String s) {
        return s.equals("VECTOR ELM MAP");
    }

    public static boolean isMacroName(String s) {
        return InformationManagers.getInstance().getMacroManager().isMacroName(s);
    }

    public String getEquation() {
        return this.equation;
    }

    public void setEquation(String equation) {
        this.equation = equation;
    }

    public String getLhs() {
        return this.lhs;
    }

    public void setLhs(String lhs) {
        this.lhs = lhs;
    }

    public String getRhs() {
        return this.rhs;
    }

    public void setRhs(String rhs) {
        this.rhs = rhs;
    }

    public void addReferencedBy(String equation) {
        this.referencedBy.add(equation);
    }

    public List<String> getReferences() {
        ArrayList<String> refs = new ArrayList<String>();
        return refs;
    }

    public String getVensimEquation() {
        return this.vensimEquation;
    }

    public String getVensimEquationOnly() {
        return this.vensimEquation.split("~")[0].replaceAll("\n", " ");
    }

    public void setVensimEquation(String vensimEquation) {
        if (InformationManagers.getInstance().getMacroManager().containsMacroInvocation(vensimEquation)) {
            this.vensimEquation = InformationManagers.getInstance().getMacroManager().expand(vensimEquation).replaceAll("\t", "");
            this.hasMacroInvocation = true;
        } else {
            this.vensimEquation = vensimEquation.replaceAll("\t", "");
        }
        this.tokenize();
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public String getCleanEquation() {
        return this.cleanEquation;
    }

    public void setCleanEquation(String cleanEquation) {
        this.cleanEquation = cleanEquation;
    }

    public HashSet<String> getRHSVariables() {
        return new HashSet<String>(this.rhsTokens);
    }

    public HashSet<String> getRHSVariablesExpanded() {
        HashSet<String> s = new HashSet<String>();
        if (this.rhsTokens == null) {
            return s;
        }
        for (String t : this.rhsTokens) {
            String tNoBang = t.replaceAll("!", "");
            if (ArrayReference.isArrayReference(tNoBang)) {
                s.addAll(InformationManagers.getInstance().getArrayManager().expand(new ArrayReference(tNoBang)));
                continue;
            }
            if (Parser.isFunctionInvocation(t)) continue;
            s.add(t);
        }
        this.removeExceptions(s);
        return s;
    }

    public boolean isDefinesLookup() {
        return this.definesLookup;
    }

    public void setDefinesLookup(boolean definesLookup) {
        this.definesLookup = definesLookup;
    }

    public boolean isReferencesLookup() {
        return this.referencesLookup;
    }

    public void setReferencesLookup(boolean referencesLookup) {
        this.referencesLookup = referencesLookup;
    }

    public boolean isHasInitialValue() {
        return this.hasInitialValue;
    }

    public void setHasInitialValue(boolean hasInitialValue) {
        this.hasInitialValue = hasInitialValue;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public void setTokens(ArrayList<String> tokens) {
        this.tokens = tokens;
    }

    public void printTokens() {
        System.out.println("EQ: " + this.getVensimEquation());
        System.out.println("EQ: " + this.getCleanEquation());
        for (String t : this.getTokens()) {
            System.out.println("   <" + t + ">");
        }
    }

    public String getTokensOneLine() {
        StringBuffer sb = new StringBuffer();
        for (String t : this.getTokens()) {
            sb.append(" <" + t + ">");
        }
        return sb.toString();
    }

    public void printTokensOneLine() {
        for (String t : this.getTokens()) {
            System.out.print(" <" + t + ">");
        }
        System.out.print("\n");
    }

    public void printRpn() {
        System.out.println("EQ: " + this.getCleanEquation());
        for (String t : this.getRpn()) {
            System.out.println("   <" + t + ">");
        }
    }

    public void printRpnUnits() {
        System.out.println("EQ: " + this.getCleanEquation());
        for (String t : this.getRpn()) {
            String u = "";
            if (InformationManagers.getInstance().getUnitsManager().hasUnits(t)) {
                u = InformationManagers.getInstance().getUnitsManager().getUnits(t);
            }
            System.out.println("   <" + t + "> <" + u + ">");
        }
    }

    public void generateRpn() {
        boolean printRPN = false;
        if (!this.isAssignment()) {
            return;
        }
        Stack<String> stack = new Stack<String>();
        boolean tPtr = false;
        boolean locatedEquals = false;
        int functionsActive = 0;
        int activeParens = 0;
        ArrayList<String> combinedTokens = new ArrayList<String>(this.tokens);
        boolean j = false;
        for (String tokenIn : combinedTokens) {
            String token = tokenIn;
            if (token.length() == 0) continue;
            if (token.equals("=")) {
                locatedEquals = true;
                continue;
            }
            if (!locatedEquals) continue;
            if (Parser.isNumber(token) || this.isVariableReference(token) || this.isLookupReference(token)) {
                this.rpn.add(token);
                continue;
            }
            if (this.isFunctionInvocation(token) || this.isMacroInvocation(token)) {
                ++functionsActive;
                stack.push(token);
                continue;
            }
            if (this.isFunctionArgumentSeparator(token) && functionsActive > 0) {
                while (!((String)stack.peek()).equals("(")) {
                    this.rpn.add((String)stack.pop());
                }
                continue;
            }
            if (Parser.isOperator(token) || Parser.isBooleanOperator(token)) {
                while (stack.size() > 0 && (Parser.isOperator((String)stack.peek()) || Parser.isBooleanOperator((String)stack.peek())) && (leftAssociative.get(token).booleanValue() && precedence.get(token) <= precedence.get(stack.peek()) || !leftAssociative.get(token).booleanValue() && precedence.get(token) < precedence.get(stack.peek()))) {
                    this.rpn.add((String)stack.pop());
                }
                stack.push(token);
                continue;
            }
            if (this.isLeftParen(token)) {
                ++activeParens;
                stack.push(token);
                continue;
            }
            if (!this.isRightParen(token)) continue;
            try {
                while (!((String)stack.peek()).equals("(")) {
                    this.rpn.add((String)stack.pop());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            stack.pop();
            if (activeParens == functionsActive) {
                --functionsActive;
            }
            --activeParens;
            if (stack.size() <= 0 || !this.isFunctionInvocation((String)stack.peek()) && !this.isMacroInvocation((String)stack.peek())) continue;
            this.rpn.add((String)stack.pop());
        }
        while (stack.size() > 0) {
            this.rpn.add((String)stack.pop());
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add((String)combinedTokens.get(0));
        al.addAll(this.rpn);
        al.add("=");
        this.rpn = al;
    }

    private boolean isLookupReference(String token) {
        return token.startsWith("lookup.");
    }

    private boolean isVariableReference(String token) {
        return token.startsWith("\"") || token.startsWith("valueOf") || token.startsWith("memory.") || token.startsWith("time") || token.startsWith("array.") || token.startsWith("arrayValueOf");
    }

    private boolean isFunctionInvocation(String token) {
        return token.startsWith("sdFunction");
    }

    private boolean isMacroInvocation(String token) {
        return false;
    }

    private boolean isFunctionArgumentSeparator(String token) {
        return token.equals(",");
    }

    private boolean isLeftParen(String token) {
        return token.equals("(");
    }

    private boolean isRightParen(String token) {
        return token.equals(")");
    }

    public List<String> getRpn() {
        return this.rpn;
    }

    public void setRpn(ArrayList<String> rpn) {
        this.rpn = rpn;
    }

    public boolean isAssignment() {
        return this.assignment;
    }

    public void setAssignment(boolean assignment) {
        this.assignment = assignment;
    }

    public boolean isGetExternalData() {
        return this.getVensimEquationOnly().contains("GET XLS LOOKUPS") || this.getVensimEquationOnly().contains("GET XLS DATA") || this.getVensimEquationOnly().contains("GET XLS CONSTANTS");
    }

    public void generateTree() {
        this.treeRoot = this.generateEquationTree();
        this.validateIFTHENELSEInTree(this.treeRoot);
    }

    public Node generateEquationTree() {
        boolean printit = false;
        Node start = null;
        Node end = null;
        int nPtr = 0;
        if (this.rpn.size() == 0) {
            this.generateRpn();
        }
        for (String token : this.rpn) {
            if (start != null && printit) {
                this.printTree(start);
            }
            Node aNode = new Node(this.rpn.get(nPtr));
            if (nPtr == 0) {
                start = aNode;
                end = aNode;
            } else if (Parser.isOperator(token) || Parser.isBooleanOperator(token)) {
                if (Parser.isBinaryOperator(token)) {
                    Node p1 = end;
                    Node p2 = end.getPrevious();
                    if (p2 == null) {
                        System.out.println("Expecting a previous pointer for p1");
                        System.out.println(p1.getInfo());
                    }
                    Node p3 = end.getPrevious().getPrevious();
                    aNode.setChild(p2);
                    aNode.setPrevious(p3);
                    if (p2 != null) {
                        p2.setPrevious(null);
                        p2.setParent(aNode);
                        p2.setNext(p1);
                    }
                    p1.setParent(aNode);
                    end = aNode;
                    if (p3 != null) {
                        p3.setNext(aNode);
                        aNode.setPrevious(p3);
                    } else {
                        start = aNode;
                    }
                } else {
                    Node p1 = end;
                    Node p2 = end.getPrevious();
                    aNode.setChild(p1);
                    aNode.setPrevious(p2);
                    if (p2 != null) {
                        p2.setNext(aNode);
                    } else {
                        start = aNode;
                    }
                    if (p1 != null) {
                        p1.setPrevious(null);
                        p1.setParent(aNode);
                        p1.setNext(null);
                    }
                    p1.setParent(aNode);
                    end = aNode;
                }
            } else if (this.isFunctionInvocation(token)) {
                int numArgs;
                FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(token);
                if (fd == null) {
                    System.out.println("Null Description");
                }
                if ((numArgs = fd.getNumArgsAll()) > 0) {
                    Node[] args = new Node[numArgs];
                    args[numArgs - 1] = end;
                    int i = numArgs - 2;
                    while (i >= 0) {
                        args[i] = end.getPrevious();
                        end = end.getPrevious();
                        --i;
                    }
                    if (end != null) {
                        end = end.getPrevious();
                    }
                    if (end != null) {
                        aNode.setPrevious(end);
                        end.setNext(aNode);
                    } else {
                        start = aNode;
                    }
                    end = aNode;
                    i = 0;
                    while (i < numArgs) {
                        args[i].setParent(aNode);
                        ++i;
                    }
                    aNode.setChild(args[0]);
                    args[0].setPrevious(null);
                } else {
                    if (end != null) {
                        aNode.setPrevious(end);
                        end.setNext(aNode);
                    } else {
                        start = aNode;
                    }
                    end = aNode;
                }
            } else if (this.isMacroInvocation(token)) {
                int numArgs = InformationManagers.getInstance().getMacroManager().getNumArgumentsFor(token);
                Node[] args = new Node[numArgs];
                args[numArgs - 1] = end;
                int i = numArgs - 2;
                while (i >= 0) {
                    args[i] = end.getPrevious();
                    end = end.getPrevious();
                    --i;
                }
                if (end != null) {
                    end = end.getPrevious();
                }
                if (end != null) {
                    aNode.setPrevious(end);
                    end.setNext(aNode);
                } else {
                    start = aNode;
                }
                end = aNode;
                i = 0;
                while (i < numArgs) {
                    args[i].setParent(aNode);
                    ++i;
                }
                aNode.setChild(args[0]);
                args[0].setPrevious(null);
            } else {
                end.setNext(aNode);
                aNode.setPrevious(end);
                end = aNode;
            }
            ++nPtr;
        }
        if (start != null && printit) {
            this.printTokens();
            this.printRpn();
            this.printTree(start);
        }
        printit = false;
        if (start != null && !Parser.isOperator(start.getToken()) && end.getToken().equals("=")) {
            this.arrayInitialization = true;
        }
        return start;
    }

    public void printTreeLevel1(Node node) {
        if (node == null) {
            System.out.println("End of List");
            return;
        }
        System.out.println("NODE: " + node.getToken());
        this.printTreeLevel1(node.getNext());
    }

    private String getFunctionName(String token) {
        return token.replace("sdFunctions.", "");
    }

    public void printTree(Node node) {
        System.out.println(this.cleanEquation);
        this.printTree(node, 0);
    }

    public void printTree() {
        System.out.println(this.getVensimEquationOnly());
        this.printTree(this.treeRoot, 0);
    }

    private void printTree(Node node, int level) {
        if (node == null) {
            return;
        }
        String blanks = "";
        int i = 0;
        while (i < level) {
            blanks = String.valueOf(blanks) + "    ";
            ++i;
        }
        System.out.println(String.valueOf(blanks) + "Level " + level + " token " + node.getToken() + "\n" + blanks + "   parent: " + (node.getParent() != null ? node.getParent().getToken() : "NULL") + "\n" + blanks + "   next: " + (node.getNext() != null ? node.getNext().getToken() : "NULL"));
        this.printTree(node.getChild(), level + 1);
        this.printTree(node.getNext(), level);
    }

    public void printTreeTerse() {
        System.out.println(this.cleanEquation);
        this.printTreeTerse(this.treeRoot, 0);
    }

    public static void printTreeCausal(Node node, int level, Map<String, Equation> equations) {
        if (node == null) {
            return;
        }
        String blanks = "";
        int i = 0;
        while (i < level) {
            blanks = String.valueOf(blanks) + "    ";
            ++i;
        }
        if (node.getToken() == null) {
            System.out.println(String.valueOf(blanks) + "Level " + level + " token " + node.getToken() + "????? NULL TOKEN");
        } else if (equations.get(node.getToken()) == null) {
            System.out.println(String.valueOf(blanks) + "Level " + level + " token " + node.getToken() + "????? NULL EQUATION");
        } else {
            System.out.println(String.valueOf(blanks) + "Level " + level + " token " + node.getToken() + (equations.get(node.getToken()).isStock() ? "<STOCK>" : ""));
        }
        Equation.printTreeCausal(node.getChild(), level + 1, equations);
        Equation.printTreeCausal(node.getNext(), level, equations);
    }

    private void printTreeTerse(Node node, int level) {
        if (node == null) {
            return;
        }
        String blanks = "";
        int i = 0;
        while (i < level) {
            blanks = String.valueOf(blanks) + "    ";
            ++i;
        }
        System.out.println(String.valueOf(blanks) + "Level " + level + " token " + node.getToken() + "\n");
        this.printTreeTerse(node.getChild(), level + 1);
        this.printTreeTerse(node.getNext(), level);
    }

    public void printTreeCode() {
        System.out.println("######################################################");
        System.out.println(this.cleanEquation);
        this.printTreeCode(this.treeRoot, 0);
    }

    private void printTreeCode(Node node, int level) {
        if (node == null) {
            return;
        }
        String blanks = "";
        int i = 0;
        while (i < level) {
            blanks = String.valueOf(blanks) + "    ";
            ++i;
        }
        System.out.println(String.valueOf(blanks) + "Level " + level + "\n" + node.getInfo(blanks));
        this.printTreeCode(node.getChild(), level + 1);
        this.printTreeCode(node.getNext(), level);
    }

    public List<String> getEquationUnits() {
        ArrayList<String> eqn = new ArrayList<String>();
        this.printTreeCodeUnits(eqn, this.treeRoot, 0);
        if (eqn.size() > 1) {
            eqn.remove(eqn.size() - 1);
            eqn.remove(0);
        }
        return eqn;
    }

    private void printTreeCodeUnits(List<String> eqn, Node node, int level) {
        if (node == null) {
            return;
        }
        if (node.isTerminal()) {
            if (Parser.isNumber(node.getToken())) {
                eqn.add("constant#" + node.getToken());
            } else {
                String v = InformationManagers.getInstance().getUnitsManager().getUnits(node.getToken());
                eqn.add(InformationManagers.getInstance().getUnitsManager().getUnits(node.getToken()));
            }
        }
        if (Parser.isOperator(node.getToken())) {
            Node leftChild = node.getChild();
            Node rightChild = leftChild != null ? leftChild.getNext() : null;
            eqn.add("(");
            this.printTreeCodeUnits(eqn, leftChild, level + 1);
            eqn.add(node.getToken());
            this.printTreeCodeUnits(eqn, rightChild, level + 1);
            eqn.add(")");
        }
        if (Parser.isFunctionInvocation(node.getToken())) {
            eqn.add(String.valueOf(node.getToken()) + "<" + InformationManagers.getInstance().getUnitsManager().getUnits(node.getToken()) + ">");
            eqn.add("(");
            Node child = node.getChild();
            int c = 0;
            while (child != null) {
                if (c++ > 0) {
                    eqn.add(",");
                }
                this.printTreeCodeUnits(eqn, child, level + 1);
                child = child.getNext();
            }
            eqn.add(")");
        }
    }

    public Set<String> getFunctionInitialVariables() {
        HashSet<String> al = new HashSet<String>();
        this.getFunctionInitialVariables(this.treeRoot, al);
        return al;
    }

    public void getFunctionInitialVariables(Node node, Set<String> al) {
        FunctionDescription fd;
        if (node == null) {
            return;
        }
        if (Parser.isFunctionInvocation(node.getToken()) && (fd = InformationManagers.getInstance().getFunctionManager().getDescription(node.getToken())).isSuppliesInitialValue()) {
            Node child = node.getChild();
            while (child.getNext() != null) {
                child = child.getNext();
            }
            ArrayList<Node> nodeList = new ArrayList<Node>();
            this.findTerminal(child, nodeList);
            for (Node n : nodeList) {
                if (Parser.isQuotedString(n.getToken()) || Parser.isNumber(n.getToken()) || al.contains(n.getToken())) continue;
                al.add(n.getToken());
            }
        }
        this.getFunctionInitialVariables(node.getNext(), al);
        this.getFunctionInitialVariables(node.getChild(), al);
    }

    public Set<String> getRHSVariablesForOrderingExpanded() {
        HashSet<String> s = new HashSet<String>();
        for (String rhsVar : this.getRHSVariablesForOrdering()) {
            if (ArrayReference.isArrayReference(rhsVar)) {
                s.addAll(InformationManagers.getInstance().getArrayManager().expand(new ArrayReference(rhsVar)));
                continue;
            }
            s.add(rhsVar);
        }
        this.removeExceptions(s);
        return s;
    }

    public Set<String> getRHSVariablesForOrdering(boolean trace) {
        HashSet<String> al = new HashSet<String>();
        this.getRHSVariablesForOrdering(TreeTraversal.getRhs(this.getTreeRoot()), al, trace);
        return al;
    }

    public void getRHSVariablesForOrdering(Node node, Set<String> al, boolean trace) {
        if (node == null) {
            if (trace) {
                System.out.println("Null Node return");
            }
            return;
        }
        Node aNode = node;
        if (trace) {
            System.out.println("Node: " + aNode.getToken());
        }
        if (Parser.isFunctionInvocation(aNode.getToken())) {
            if (trace) {
                System.out.println("Function: " + aNode.getToken());
            }
            FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(node.getToken());
            aNode = TreeTraversal.getFunctionArgument(aNode, 1);
            if (trace) {
                System.out.println("arg node: " + aNode.getToken());
            }
            this.getRHSVariablesForOrdering(aNode, al, trace);
        } else {
            String token = aNode.getToken();
            if (!(Parser.isOperator(token) || Parser.isQuotedString(token) || Parser.isNumber(token) || Parser.isLeftParen(token) || Parser.isRightParen(token))) {
                al.add(token);
                if (trace) {
                    System.out.println("var? " + token);
                }
            }
        }
        if (aNode != null) {
            this.getRHSVariablesForOrdering(aNode.getNext(), al, trace);
        }
        if (aNode != null) {
            this.getRHSVariablesForOrdering(aNode.getChild(), al, trace);
        }
    }

    public Set<Node> getLookupFunctionNodes(boolean trace) {
        HashSet<Node> aSet = new HashSet<Node>();
        this.getLookupFunctionNodes(TreeTraversal.getRhs(this.getTreeRoot()), aSet, trace);
        if (trace) {
            System.out.println("Returning Set of size: " + aSet.size());
        }
        return aSet;
    }

    public void getLookupFunctionNodes(Node node, Set<Node> aSet, boolean trace) {
        if (node == null) {
            if (trace) {
                System.out.println("Null Node return");
            }
            return;
        }
        Node aNode = node;
        if (trace) {
            System.out.println("Node: " + aNode.getToken());
        }
        if (Parser.isFunctionInvocation(aNode.getToken()) && Parser.getFunctionName(aNode.getToken()).equals("LOOKUP")) {
            if (trace) {
                System.out.println("Function: " + aNode.getToken());
            }
            aSet.add(aNode);
        }
        if (aNode != null) {
            this.getLookupFunctionNodes(aNode.getNext(), aSet, trace);
        }
        if (aNode != null) {
            this.getLookupFunctionNodes(aNode.getChild(), aSet, trace);
        }
    }

    public Set<String> getRHSVariablesForOrdering() {
        HashSet<String> al = new HashSet<String>();
        this.getRHSVariablesForOrdering(TreeTraversal.getRhs(this.getTreeRoot()), al);
        return al;
    }

    public void getRHSVariablesForOrdering(Node node, Set<String> al) {
        if (node == null) {
            return;
        }
        Node aNode = node;
        if (Parser.isFunctionInvocation(aNode.getToken())) {
            FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(node.getToken());
            aNode = TreeTraversal.getFunctionArgument(aNode, 1);
            this.getRHSVariablesForOrdering(aNode, al);
        } else {
            String token = aNode.getToken();
            if (!(Parser.isOperator(token) || Parser.isQuotedString(token) || Parser.isNumber(token) || Parser.isLeftParen(token) || Parser.isRightParen(token))) {
                al.add(token);
            }
        }
        if (aNode != null) {
            this.getRHSVariablesForOrdering(aNode.getNext(), al);
        }
        if (aNode != null) {
            this.getRHSVariablesForOrdering(aNode.getChild(), al);
        }
    }

    public Node getCopyOfTree() {
        return this.generateEquationTree();
    }

    public Node getTreeRoot() {
        if (this.treeRoot == null) {
            this.generateTree();
        }
        return this.treeRoot;
    }

    public void setTreeRoot(Node treeRoot) {
        this.treeRoot = treeRoot;
    }

    public boolean isDefinesSubscript() {
        return this.definesSubscript;
    }

    public void setDefinesSubscript(boolean definesSubscript) {
        this.definesSubscript = definesSubscript;
    }

    public boolean isHasLHSArrayReference() {
        return this.hasLHSArrayReference;
    }

    public void setHasLHSArrayReference(boolean hasLHSArrayReference) {
        this.hasLHSArrayReference = hasLHSArrayReference;
    }

    public boolean isHasRHSArrayReference() {
        return this.hasRHSArrayReference;
    }

    public void setHasRHSArrayReference(boolean hasRHSArrayReference) {
        this.hasRHSArrayReference = hasRHSArrayReference;
    }

    public boolean isHasMultipleEquations() {
        return this.hasMultipleEquations;
    }

    public void setHasMultipleEquations(boolean hasMultipleEquations) {
        this.hasMultipleEquations = hasMultipleEquations;
    }

    public String getUnitsAndComment() {
        StringBuffer sb = new StringBuffer();
        sb.append("/*\n");
        sb.append("\tEquation: " + this.equation + "\n\n");
        if (this.units != null || this.comment != null) {
            sb.append("\tUnits:" + (this.units == null ? "None Provided" : this.units) + "\n\n");
            sb.append("\tComment: " + (this.comment == null ? "None Provided" : this.comment) + "\n\n");
        }
        sb.append("*/\n");
        return sb.toString();
    }

    public boolean isOneTime() {
        return this.oneTime;
    }

    public void setOneTime(boolean oneTime) {
        this.oneTime = oneTime;
    }

    public boolean isRepeated() {
        return !this.isOneTime();
    }

    private String getNextArray() {
        String next = "_a" + nextArray++;
        return next;
    }

    private String getNextInt() {
        String next = "_i" + nextInt++;
        return next;
    }

    private String getNextTimeSeries() {
        String next = "_ts" + nextTimeSeries++;
        return next;
    }

    public boolean isHasException() {
        return this.hasException;
    }

    public void setHasException(boolean hasException) {
        this.hasException = hasException;
    }

    public int getLeftBracketCount() {
        return this.leftBracketCount;
    }

    public void setLeftBracketCount(int leftBracketCount) {
        this.leftBracketCount = leftBracketCount;
    }

    public List<String> getExceptions() {
        ArrayList<String> al = new ArrayList<String>();
        for (String subscript : this.exceptions) {
            al.addAll(InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subscript));
        }
        return al;
    }

    public boolean getsExternalData() {
        return this.equation.contains("VDMLOOKUP") || this.equation.contains("GET XLS DATA") || this.equation.contains("GET XLS LOOKUP") || this.equation.contains("GET XLS CONSTANT");
    }

    public boolean isVdmLookup() {
        return this.vdmLookup;
    }

    public void setVdmLookup(boolean vdmLookup) {
        this.vdmLookup = vdmLookup;
    }

    public String toString() {
        return this.vensimEquation;
    }

    public List<Node> getTreeAsList() {
        if (this.treeRoot == null) {
            return null;
        }
        ArrayList<Node> al = new ArrayList<Node>();
        Node lhs = this.treeRoot.getChild();
        if (this.arrayInitialization) {
            this.traverse(this.treeRoot, al);
            al.remove(al.size() - 1);
        } else {
            al.add(lhs);
            this.traverse(lhs.getNext(), al);
        }
        return al;
    }

    public void traverse(Node node, List<Node> al) {
        if (node == null) {
            return;
        }
        al.add(node);
        this.traverse(node.getChild(), al);
        this.traverse(node.getNext(), al);
    }

    public EquationArrayReferenceStructure getEars() {
        this.createEars();
        return this.ears;
    }

    public void setEars(EquationArrayReferenceStructure ears) {
        this.ears = ears;
    }

    public boolean isArrayInitialization() {
        return this.arrayInitialization;
    }

    public void setArrayInitialization(boolean arrayInitialization) {
        this.arrayInitialization = arrayInitialization;
    }

    public boolean isUsesTimeSeries() {
        return this.usesTimeSeries;
    }

    public void setUsesTimeSeries(boolean usesTimeSeries) {
        this.usesTimeSeries = usesTimeSeries;
    }

    public boolean isHasMacroInvocation() {
        return this.hasMacroInvocation;
    }

    public void setHasMacroInvocation(boolean hasMacroInvocation) {
        this.hasMacroInvocation = hasMacroInvocation;
    }

    public boolean isOrderedWithInitialValue() {
        return this.orderedWithInitialValue;
    }

    public void setOrderedWithInitialValue(boolean orderedWithInitialValue) {
        this.orderedWithInitialValue = orderedWithInitialValue;
    }

    public boolean isHasVectorSortOrder() {
        return this.hasVectorSortOrder;
    }

    public void setHasVectorSortOrder(boolean hasVectorSortOrder) {
        this.hasVectorSortOrder = hasVectorSortOrder;
    }

    public boolean isHasVectorElmMap() {
        return this.hasVectorElmMap;
    }

    public void setHasVectorElmMap(boolean hasVectorElmMap) {
        this.hasVectorElmMap = hasVectorElmMap;
    }

    public boolean requiresPostGenerationProcessing() {
        return this.hasVectorElmMap || this.hasVectorSortOrder;
    }

    public String getBtwnMode() {
        return this.btwnMode;
    }

    public void setBtwnMode(String btwnMode) {
        this.btwnMode = btwnMode;
    }

    public boolean isGetXlsConstants() {
        return this.vensimEquation.toUpperCase().contains("GET XLS CONSTANTS");
    }

    public boolean isDefinesLookupGetXls() {
        return this.vensimEquation.toUpperCase().contains("GET XLS LOOKUPS");
    }

    public boolean isStock() {
        return this.stockVariable;
    }

    public boolean isSyntacticallyCorrect() {
        return this.syntacticallyCorrect;
    }

    public void setSyntacticallyCorrect(boolean syntacticallyCorrect) {
        this.syntacticallyCorrect = syntacticallyCorrect;
    }

    public boolean isUsageCorrect() {
        return this.usageCorrect;
    }

    public void setUsageCorrect(boolean semanticallyCorrect) {
        this.usageCorrect = semanticallyCorrect;
    }

    public List<String> getSyntaxMessages() {
        return this.syntaxMessages;
    }

    public List<String> getSemanticMessages() {
        return this.usageMessages;
    }

    public List<String> getUnitsMessages() {
        return this.unitsMessages;
    }

    public List<String> getUnitsInconsistencyReport() {
        ArrayList<String> bw = new ArrayList<String>();
        if (this.units == null) {
            bw.add("LHS Units: None Specified");
        } else if (this.unitExpression != null) {
            bw.add("LHS Units: ");
            bw.add("\t" + this.unitExpression.getLhsUnitsString());
            bw.add("RHS Units: ");
            bw.add("\t" + this.unitExpression.getRhsUnitsString());
            bw.add("Complete RHS Units: ");
            bw.add("\t" + this.unitExpression.getCompleteRhsUnitsString());
        }
        return bw;
    }

    public UnitExpression getUnitExpression() {
        return this.unitExpression;
    }

    public void setUnitExpression(UnitExpression unitExpression) {
        this.unitExpression = unitExpression;
    }

    public String getEquationFromTree(Node root) {
        StringBuffer sb = new StringBuffer();
        Node lhs = root.getChild();
        Node rhs = lhs.getNext();
        sb.append(String.valueOf(lhs.getToken()) + " = ");
        this.buildEquation(sb, rhs);
        return sb.toString();
    }

    public void buildEquation(StringBuffer sb, Node node) {
        if (node == null) {
            return;
        }
        String token = node.getToken();
        if (Parser.isArithmeticOperator(token) && Parser.isUnaryOperator(token)) {
            if (token.equals("_")) {
                sb.append("-");
            } else {
                sb.append(token);
            }
            this.buildEquation(sb, node.getChild());
        } else if (Parser.isFunctionInvocation(node.getToken())) {
            sb.append(node.getToken());
            sb.append("(");
            int argNum = 0;
            Node args = node.getChild();
            while (args != null) {
                if (argNum++ > 0) {
                    sb.append(",");
                }
                this.buildEquation(sb, args);
                args = args.getNext();
            }
            sb.append(")");
        } else {
            Node child = node.getChild();
            this.buildEquation(sb, child);
            sb.append(node.getToken());
            if (child == null) {
                return;
            }
            Node next = child.getNext();
            this.buildEquation(sb, next);
        }
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public boolean isTreeCodeGenerated() {
        return this.treeCodeGenerated;
    }

    public void setTreeCodeGenerated(boolean treeCodeGenerated) {
        this.treeCodeGenerated = treeCodeGenerated;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    public List<String> getFatalMessages() {
        return this.fatalMessages;
    }
}

