/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import repast.simphony.systemdynamics.support.Utilities;

public class DumpWorkbook {
    BufferedWriter bw;
    String workbookName;
    XSSFWorkbook wb;

    public DumpWorkbook(String inFile, String outFile) {
        this.workbookName = inFile;
        this.bw = Utilities.openFileForWriting(outFile);
    }

    public static void main(String[] args) {
        DumpWorkbook dw = new DumpWorkbook(args[0], args[1]);
        dw.execute();
    }

    public void execute() {
        try {
            this.wb = new XSSFWorkbook(this.workbookName);
            this.bw.append("sheet,row,col,cellAddress,value,formula\n");
            int sheet = 0;
            while (sheet < this.wb.getNumberOfSheets()) {
                this.dumpSheet(this.wb.getSheetName(sheet));
                ++sheet;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dumpSheet(String sheet) {
        try {
            XSSFSheet aSheet = this.wb.getSheet(sheet);
            Iterator rowIt = aSheet.rowIterator();
            while (rowIt.hasNext()) {
                Row aRow = (Row)rowIt.next();
                Iterator cellIt = aRow.cellIterator();
                while (cellIt.hasNext()) {
                    String theFormula;
                    Cell aCell = (Cell)cellIt.next();
                    this.bw.append(String.valueOf(sheet) + ",");
                    this.bw.append(String.valueOf(aRow.getRowNum() + 1) + "," + (aCell.getColumnIndex() + 1) + ",");
                    int rowNum = aRow.getRowNum() + 1;
                    int colNum = aCell.getColumnIndex() + 1;
                    this.bw.append(String.valueOf(sheet) + "_R" + (aRow.getRowNum() + 1) + "C" + (aCell.getColumnIndex() + 1) + ",");
                    if (aCell.getCellType() == 1) {
                        this.bw.append("\"" + aCell.getRichStringCellValue().toString() + "\",");
                        this.bw.append("Constant");
                    } else if (aCell.getCellType() == 2 && aCell.getCachedFormulaResultType() == 1) {
                        this.bw.append("\"" + aCell.getRichStringCellValue().toString() + "\",");
                        theFormula = aCell.getCellFormula();
                        if (theFormula.startsWith("CELL")) {
                            theFormula = "CELL(address reference)";
                        }
                        this.bw.append("\"" + theFormula + "\"");
                    } else if (aCell.getCellType() == 2 && aCell.getCachedFormulaResultType() == 0) {
                        this.bw.append("\"" + aCell.getNumericCellValue() + "\",");
                        theFormula = "PROBLEM!";
                        try {
                            theFormula = aCell.getCellFormula();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (theFormula.startsWith("CELL")) {
                            theFormula = "CELL(address reference)";
                        }
                        this.bw.append("\"" + theFormula + "\"");
                    } else {
                        this.bw.append("\"" + Double.toString(aCell.getNumericCellValue()) + "\",");
                        this.bw.append("Constant");
                    }
                    this.bw.append("\n");
                    this.bw.flush();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

