/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.Utilities;
import repast.simphony.systemdynamics.translator.ArrayReferenceNative;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.EquationArrayReferenceStructure;
import repast.simphony.systemdynamics.translator.FunctionDescription;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeDataTypeManager;
import repast.simphony.systemdynamics.translator.Node;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.RepastSimphonyEnvironment;
import repast.simphony.systemdynamics.translator.Translator;
import repast.simphony.systemdynamics.translator.TreeTraversal;

public class CodeGenerator {
    private static int EQUATION_LIMIT = 200;
    private int currentEquationNumber = 0;
    private int currentMethodNumber;
    private static Set<String> indexArraysPacked = new HashSet<String>();
    private static boolean flatten = true;
    private List<String> evaluationOrder;
    private Map<String, Equation> equations;
    private BufferedWriter sourceCode;
    private String start = "INITIAL_TIME";
    private String end = "FINAL_TIME";
    private String step = "TIME_STEP";
    private String tStep = "1.0";
    private int doubleUsed = 0;
    private int intUsed = 0;
    private int booleanUsed = 0;
    private int stringUsed = 0;
    private int maxTempInt = -1;
    private int maxTemp = -1;
    private int maxBoolean = -1;
    private int maxString = -1;
    private int nextValueVariable = 0;
    private String objectName;
    private String target;
    private String srcDir;
    private Translator translator;
    private Set<String> outerSubscripts = new HashSet<String>();
    private Equation currentGenerate;
    private boolean initializeScenarioDirectory = true;
    private boolean currentHasLhsArrayReference = false;

    public CodeGenerator(String srcDir, List<String> evaluationOrder, Map<String, Equation> equations, String objectName, String target, Translator translator) {
        this.srcDir = srcDir;
        this.evaluationOrder = evaluationOrder;
        this.equations = equations;
        this.objectName = objectName;
        this.target = target;
        this.translator = translator;
        if (!equations.containsKey("INTITIAL_TIME")) {
            this.start = equations.containsKey("INITIALTIME") ? "INITIALTIME" : "nonexistant";
        }
        if (!equations.containsKey("FINAL_TIME")) {
            this.end = equations.containsKey("FINALTIME") ? "FINALTIME" : "nonexistant";
        }
        if (!equations.containsKey("TIME_STEP")) {
            this.step = equations.containsKey("TIMESTEP") ? "TIMESTEP" : "TIME_STEP";
        }
    }

    public void generate() {
        this.openFile();
        this.generateCode();
        this.closeFile();
    }

    public void openFile() {
        this.sourceCode = Translator.target.equals("Java") ? Utilities.openFileForWriting(String.valueOf(this.srcDir) + this.objectName + ".java") : (Translator.target.equals("C") ? Utilities.openFileForWriting(String.valueOf(this.srcDir) + this.objectName + ".c") : null);
    }

    public void closeFile() {
        try {
            this.sourceCode.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateCode() {
        if (this.translator.isGenerateC() || this.translator.isGenerateJava()) {
            this.openFile();
            if (Translator.target.equals("Java")) {
                this.runner(this.srcDir);
            }
            if (Translator.target.equals("Java")) {
                this.startObject(this.sourceCode);
            } else {
                this.startObjectC(this.sourceCode);
                InformationManagers.getInstance().getNativeDataTypeManager().generateArrayDeclarationC(this.sourceCode);
            }
            this.onetime(this.sourceCode, this.isInitializeScenarioDirectory());
            this.repeated(this.sourceCode);
            this.convenienceGettersSetters(this.sourceCode);
            if (Translator.target.equals("Java")) {
                this.timeSeriesReferences(this.sourceCode, this.isInitializeScenarioDirectory());
            }
            if (Translator.target.equals("Java")) {
                this.endObject(this.sourceCode);
            } else {
                this.endObjectC(this.sourceCode);
            }
            this.closeFile();
        }
    }

    private void convenienceGettersSetters(BufferedWriter bw) {
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        try {
            bw.append(ndtm.generateMemoryGettersSettersConvenience(this.objectName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startObject(BufferedWriter bw) {
        try {
            bw.append("package " + this.translator.getPackageName() + ";\n\n");
            bw.append("// imports\n\n");
            if (this.requiresTimeSeries()) {
                bw.append("import repast.simphony.systemdynamics.support.TimeSeriesData;\n");
                bw.append("import repast.simphony.systemdynamics.support.TimeSeriesInstance;\n");
            }
            if (this.target.equals("Java")) {
                bw.append("import repast.simphony.systemdynamics.support.SDModelWithPropertiesVDM_Native;\n");
                bw.append("import repast.simphony.engine.schedule.ISchedule;\n");
                bw.append("import repast.simphony.engine.schedule.ScheduledMethod;\n");
                bw.append("import repast.simphony.engine.environment.RunEnvironment;\n");
                bw.append("import repast.simphony.parameter.Parameters;\n");
                bw.append("import repast.simphony.systemdynamics.support.MessageJava;\n");
                bw.append("import repast.simphony.systemdynamics.support.ResultsReporterJava;\n");
                bw.append("import repast.simphony.systemdynamics.support.SDFunctionsWithXLSColt;\n\n\n");
            } else {
                bw.append("import repast.simphony.systemdynamics.support.SDModel;\n");
                bw.append("import repast.simphony.systemdynamics.support.MessageJS;\n");
                bw.append("import repast.simphony.systemdynamics.support.ResultsReporterJS;\n");
                bw.append("import repast.simphony.systemdynamics.support.SDFunctions;\n\n\n");
            }
            if (this.target.equals("Java")) {
                bw.append("public class " + this.objectName + " extends SDModelWithPropertiesVDM_Native {\n\n");
                bw.append("private Memory" + this.objectName + " memory;\n");
            } else {
                bw.append("public class " + this.objectName + " extends SDModel {\n\n");
            }
            bw.append("public " + this.objectName + "(String name) {\n");
            bw.append("this(name, null);\n");
            bw.append("}\n\n");
            bw.append("public " + this.objectName + "(String name, String[] args) {\n");
            bw.append("super(name," + (this.isInitializeScenarioDirectory() ? "true" : "false") + ", args);\n\n");
            if (this.target.equals("Java")) {
                bw.append("sdFunctions = new SDFunctionsWithXLSColt(this);\n");
                bw.append("message = new MessageJava();\n");
                bw.append("results = new ResultsReporterJava();\n");
                bw.append("memory = new Memory" + this.objectName + "();\n\n\n");
                bw.append("timeSeriesData.setNativeDataTypes(true);\n");
                bw.append("oneTime();\n");
            } else {
                bw.append("sdFunctions = new SDFunctions(this);\n");
                bw.append("message = new MessageJS();\n");
                bw.append("results = new ResultsReporterJS();\n");
            }
            bw.append("}\n\n");
            bw.append("public Memory" + this.objectName + " getMemory() {\n");
            bw.append("return memory;\n");
            bw.append("}\n\n");
            if (this.target.equals("Java")) {
                bw.append("@Override\n");
                bw.append("public double getINITIALTIME() {\n");
                bw.append("return memory.getINITIALTIME();\n");
                bw.append("}\n");
                bw.append("@Override\n");
                bw.append("public double getFINALTIME() {\n");
                bw.append("return memory.getFINALTIME();\n");
                bw.append("}\n");
                bw.append("@Override\n");
                bw.append("public double getTIMESTEP() {\n");
                bw.append("return memory.getTIMESTEP();\n");
                bw.append("}\n");
            }
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startObjectC(BufferedWriter bw) {
        try {
            bw.append("#include <stdio.h>\n");
            bw.append("#include <stdlib.h>\n");
            bw.append("#include <stdarg.h>\n");
            bw.append("#include <stdbool.h>\n");
            bw.append("#include <string.h>\n\n");
            bw.append("#include <float.h>\n\n");
            bw.append("#include <math.h>\n\n");
            bw.append("#include \"vensimSupport.h\"\n\n");
            bw.append("#include \"memory" + this.objectName + ".h\"\n");
            bw.append("void repeated(double time, double timeStep);\n");
            bw.append("int main(void) {\n");
            bw.append("}\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean initialValueInitialized(String lhs) {
        String clean = this.equations.get(lhs).getCleanEquation();
        String[] s = clean.split(",");
        String var = s[s.length - 1].replace(")", "");
        if (Parser.isNumber(var)) {
            return true;
        }
        return this.evaluationOrder.contains(var);
    }

    private String getIntialValueVariable(String lhs) {
        String clean = this.equations.get(lhs).getCleanEquation();
        String[] s = clean.split(",");
        String var = s[s.length - 1].replace(")", "");
        return var;
    }

    private void onetime(BufferedWriter bw, boolean logit) {
        HashMap<String, String> initialValues = new HashMap<String, String>();
        String indent = "    ";
        String statement = null;
        try {
            if (!Translator.target.equals("C")) {
                bw.append("protected ");
            }
            bw.append("void oneTime0() {\n\n");
            bw.append("double time = 0.0;\n");
            bw.append("double timeStep = getTIMESTEP();\n");
            if (!Translator.target.equals("C")) {
                bw.append("Parameters params = RunEnvironment.getInstance().getParameters();\n");
            }
            for (String lhs : this.evaluationOrder) {
                String[] bothSides;
                Equation eqn = this.equations.get(lhs);
                if (this.equations.get(lhs).getCleanEquation().contains("GAME???")) {
                    bothSides = this.equations.get(lhs).getCleanEquation().split("=", 2);
                    statement = String.valueOf(indent) + "setValue(\"" + bothSides[0] + "\"," + bothSides[1] + "); // 1\n";
                    bw.append(eqn.getUnitsAndComment());
                    bw.append("{\n");
                    bw.append(CodeGenerator.scrub(statement));
                    bw.append("}\n");
                    continue;
                }
                if (this.equations.get(lhs).isOneTime()) {
                    ++this.currentEquationNumber;
                    if (this.currentEquationNumber > EQUATION_LIMIT) {
                        this.currentEquationNumber = 0;
                        ++this.currentMethodNumber;
                        this.resetLimits();
                        bw.append("}\n\n");
                        if (!Translator.target.equals("C")) {
                            bw.append("protected ");
                        }
                        bw.append("void oneTime" + this.currentMethodNumber + "() {\n\n");
                        bw.append("double time = 0.0;\n");
                        bw.append("double timeStep = getTIMESTEP();\n");
                        if (!Translator.target.equals("C")) {
                            bw.append("Parameters params = RunEnvironment.getInstance().getParameters();\n");
                        }
                    }
                    if (this.equations.get(lhs).getCleanEquation().contains("=")) {
                        if (this.equations.get(lhs).isHasLHSArrayReference()) {
                            bw.append(eqn.getUnitsAndComment());
                            bw.append("{\n");
                            bw.append(CodeGenerator.scrub(this.equations.get(lhs).generateArrayConstantsInitialization(this.isInitializeScenarioDirectory())));
                            bw.append("}\n");
                            continue;
                        }
                        bw.append(eqn.getUnitsAndComment());
                        bothSides = this.equations.get(lhs).getCleanEquation().split("=", 2);
                        if (InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0]).contains(this.step)) {
                            this.tStep = this.forceDouble(bothSides[1]);
                        }
                        if (Translator.target.equals("C") || !this.isInitializeScenarioDirectory()) {
                            statement = String.valueOf(indent) + InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0]) + " = " + this.forceDouble(bothSides[1]) + "; // 2;\n";
                            if (logit) {
                                statement = String.valueOf(statement) + "/* log2 */logit(\"" + bothSides[0] + "\", 0.0," + this.forceDouble(bothSides[1]) + ",memory.get_SAVEPER());\n";
                            }
                        } else {
                            String legalVar = InformationManagers.getInstance().getNativeDataTypeManager().makeLegal(bothSides[0].replace("memory.", ""));
                            if (legalVar.equals("Time") || legalVar.equals("NAREPLACEMENT") || this.equations.get(lhs).isGetXlsConstants()) {
                                statement = String.valueOf(indent) + InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0]) + " = " + bothSides[1] + ";\n";
                                if (logit) {
                                    statement = String.valueOf(statement) + "logit(\"" + bothSides[0] + "\", getINITIALTIME(), " + bothSides[1] + ",memory.get_SAVEPER());\n";
                                }
                            } else {
                                statement = String.valueOf(indent) + InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0]) + " = (Double) params.getValue(\"" + InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0]).replace("memory.", "") + "\"); // 2;\n";
                                if (logit) {
                                    statement = String.valueOf(statement) + "logit(\"" + bothSides[0] + "\", getINITIALTIME(), (Double) params.getValue(\"" + InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0]).replace("memory.", "") + "\"),memory.get_SAVEPER());\n";
                                }
                            }
                        }
                        if (!this.equations.get(lhs).isGetXlsConstants()) {
                            initialValues.put(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0]), this.forceDouble(bothSides[1]));
                        }
                        bw.append("{\n");
                        bw.append(CodeGenerator.scrub(statement));
                        bw.append("}\n");
                        continue;
                    }
                    if (eqn.isDefinesLookup()) {
                        String lhSide = eqn.getLhs();
                        if (ArrayReference.isArrayReference(lhSide)) {
                            ArrayReference ar = new ArrayReference(lhSide);
                            statement = String.valueOf(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhSide)) + "[" + InformationManagers.getInstance().getArrayManager().getTerminalValue(ar.getArrayName(), ar.getSubscripts().get(0), 0) + "]" + " = " + eqn.getCleanEquation() + "; // 3\n";
                        } else {
                            statement = String.valueOf(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhSide)) + " = " + eqn.getCleanEquation() + "; // 3\n";
                        }
                        bw.append(eqn.getUnitsAndComment());
                        bw.append("{\n");
                        bw.append(CodeGenerator.scrub(statement));
                        bw.append("}\n");
                        continue;
                    }
                    if (eqn.isDefinesSubscript()) continue;
                    statement = String.valueOf(indent) + this.equations.get(lhs).getCleanEquation() + "; // 3\n";
                    bw.append(eqn.getUnitsAndComment());
                    bw.append("{\n");
                    bw.append(CodeGenerator.scrub(statement));
                    bw.append("}\n");
                    continue;
                }
                if (!this.equations.get(lhs).isHasInitialValue() || !this.initialValueInitialized(lhs) || this.equations.get(lhs).isHasLHSArrayReference()) continue;
                statement = String.valueOf(indent) + "setValue(\"" + lhs + "\"," + this.getIntialValueVariable(lhs) + "); // 4\n";
                bw.append(eqn.getUnitsAndComment());
                bw.append("{\n");
                bw.append(CodeGenerator.scrub(statement));
                bw.append("}\n");
            }
            for (String lhs : this.evaluationOrder) {
                Equation equation = this.equations.get(lhs);
                if (!equation.isStock()) continue;
                this.generateCodeForStockInitialization(equation);
                equation.setTreeCodeGenerated(true);
                Node rootNode = equation.getTreeRoot();
                Node rhsNode = TreeTraversal.getRhs(rootNode);
                Node lhsNode = TreeTraversal.getLhs(rootNode);
                Node newRhsNode = TreeTraversal.getFunctionArgument(rhsNode, 2);
                bw.append("{\n");
                this.writeGeneratedCode(rootNode, bw, equation.getUnitsAndComment());
                bw.append("}\n");
            }
            bw.append("}\n\n");
            bw.flush();
            if (!Translator.target.equals("C")) {
                bw.append("protected ");
            }
            bw.append("void oneTime() {\n\n");
            int i = 0;
            while (i <= this.currentMethodNumber) {
                bw.append("   oneTime" + i + "();\n");
                ++i;
            }
            bw.append("}\n\n");
            bw.flush();
            String ScenarioDirectory = this.translator.getScenarioDirectory();
            if (this.isInitializeScenarioDirectory()) {
                RepastSimphonyEnvironment.generateParametersXml(Translator.openReport(String.valueOf(ScenarioDirectory) + "parameters.xml"), this.objectName, this.translator, initialValues);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String forceDouble(String rhs) {
        return Parser.forceDouble(rhs);
    }

    private void repeated(BufferedWriter bw) {
        try {
            if (!Translator.target.equals("C") && this.isInitializeScenarioDirectory()) {
                bw.append("@ScheduledMethod(");
                bw.append("start = 1,");
                bw.append("interval = 1,");
                bw.append("shuffle = true)\n");
            }
            bw.append("public void step() {\n");
            if (!Translator.target.equals("C")) {
                bw.append("ISchedule schedule = repast.simphony.engine.environment.RunEnvironment\n");
                bw.append(".getInstance().getCurrentSchedule();\n");
            }
            bw.append(CodeGenerator.scrub("double timeStep = memory.getTIMESTEP();\n"));
            bw.append(CodeGenerator.scrub("double time = memory.getINITIALTIME() + (schedule.getTickCount() - 1.0);\n"));
            bw.append(CodeGenerator.scrub("double nextTime = time + 1.0;\n"));
            bw.append(CodeGenerator.scrub("while (time < nextTime) {\n"));
            bw.append(CodeGenerator.scrub("memory.Time = time;\n"));
            if (!Translator.target.equals("C")) {
                bw.append(CodeGenerator.scrub("currentTime = time;\n"));
            }
            bw.append(CodeGenerator.scrub("repeated(time, timeStep);\n"));
            bw.append(CodeGenerator.scrub("time += timeStep;\n"));
            bw.append("}\n");
            bw.append("}\n\n");
            if (!Translator.target.equals("C")) {
                bw.append("protected ");
            }
            bw.append("void repeated0(double time, double timeStep) {\n\n");
            this.currentMethodNumber = 0;
            for (String lhs : this.evaluationOrder) {
                Equation equation = this.equations.get(lhs);
                if (!equation.isRepeated()) continue;
                ++this.currentEquationNumber;
                if (this.currentEquationNumber > EQUATION_LIMIT) {
                    this.currentEquationNumber = 0;
                    ++this.currentMethodNumber;
                    this.resetLimits();
                    bw.append("}\n\n");
                    if (!Translator.target.equals("C")) {
                        bw.append("protected ");
                    }
                    bw.append("void repeated" + this.currentMethodNumber + "(double time, double timeStep) {\n\n");
                }
                if (equation.isVdmLookup()) {
                    bw.append("/*\n");
                    bw.append(" * This is automatically processed\n");
                    bw.append(" * Included for documentation purposes\n");
                }
                bw.append("{\n");
                this.resetCounters();
                this.generateCode(equation, bw);
                bw.append("}\n");
                if (!equation.isVdmLookup()) continue;
                bw.append("*/\n");
            }
            bw.append("}\n\n");
            if (!Translator.target.equals("C")) {
                bw.append("protected ");
            }
            bw.append("void repeated(double time, double timeStep) {\n\n");
            if (!Translator.target.equals("C")) {
                bw.append("  data.setCurrentTime(time);\n");
                bw.append("  setValue(\"Time\", time);\n");
                bw.append("  timeSeriesData.advanceTime(data, time);\n");
                bw.append("  updateTimeSeriesReferences(time);\n");
            }
            int i = 0;
            while (i <= this.currentMethodNumber) {
                bw.append("   repeated" + i + "(time, timeStep);\n");
                ++i;
            }
            bw.append("}\n\n");
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void timeSeriesReferences(BufferedWriter bw, boolean logit) {
        try {
            bw.append("protected void updateTimeSeriesReferences(double time) {\n\n");
            for (String lhs : this.evaluationOrder) {
                Equation equation = this.equations.get(lhs);
                if (!equation.isUsesTimeSeries()) continue;
                bw.append("{\n");
                bw.append(equation.getEars().getOuterLoops());
                bw.append(equation.getEars().getLHSassignment());
                bw.append(" = data.arrayValueOf(\"" + equation.getEars().getLhsArrayReference().getArrayName() + "\", ");
                int i = 0;
                while (i < equation.getEars().getOuterClosingCount()) {
                    if (i > 0) {
                        bw.append("+");
                    }
                    bw.append("\"[\"+outer" + i + "+\"]\"");
                    ++i;
                }
                bw.append(");\n");
                if (logit) {
                    bw.append("/* log4 */logit(" + equation.getEars().getLHSassignmentName() + ",time," + equation.getEars().getLHSassignment() + ",memory.get_SAVEPER());\n");
                }
                i = 0;
                while (i < equation.getEars().getOuterClosingCount()) {
                    bw.append("}\n");
                    ++i;
                }
                bw.append("}\n");
            }
            bw.append("}\n\n");
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flattenTree(Node treeRoot) {
        int level = 0;
        if (treeRoot == null) {
            return;
        }
        this.flattenTree(treeRoot.getChild(), level);
    }

    private void flattenTree(Node node, int level) {
        if (node == null) {
            return;
        }
        this.flattenTree(node.getChild(), level + 1);
        Node nextLevel = node.getChild();
        while (nextLevel != null) {
            if (!nextLevel.isPlaceHolder() && this.isEligibleToFlatten(nextLevel)) {
                this.flatten(node, nextLevel);
                nextLevel.setPlaceHolder(true);
                nextLevel.setDeleted(true);
            }
            nextLevel = nextLevel.getNext();
        }
        this.flattenTree(node.getNext(), level);
    }

    private boolean isEligibleToFlatten(Node node) {
        return node.getGeneratedCodeHead().length() == 0 && node.getGeneratedCodeElse().length() == 0 && node.getGeneratedCodeTail().length() > 0;
    }

    private void flatten(Node node, Node child) {
        String childVar = child.getResultsVariable();
        String childEqn = "(" + child.getGeneratedCodeTail().toString().split("=", 2)[1].replace(";", "").trim() + ")";
        String flattened = "";
        if (this.containsChildVar(childVar, node.getGeneratedCodeTail().toString())) {
            flattened = this.replaceChildVar(childVar, childEqn, node.getGeneratedCodeTail().toString());
            node.setGeneratedCodeTail(new StringBuffer(flattened));
        } else if (this.containsChildVar(childVar, node.getGeneratedCodeHead().toString())) {
            flattened = this.replaceChildVar(childVar, childEqn, node.getGeneratedCodeHead().toString());
            node.setGeneratedCodeHead(new StringBuffer(flattened));
        } else if (this.containsChildVar(childVar, node.getGeneratedCodeElse().toString())) {
            flattened = this.replaceChildVar(childVar, childEqn, node.getGeneratedCodeElse().toString());
            node.setGeneratedCodeElse(new StringBuffer(flattened));
        }
    }

    private String replaceChildVar(String childVar, String childEqn, String code) {
        String replaced = code.replace(String.valueOf(childVar) + ",", String.valueOf(childEqn) + ",").replace(String.valueOf(childVar) + " ", String.valueOf(childEqn) + " ").replace(String.valueOf(childVar) + ")", String.valueOf(childEqn) + ")").replace(String.valueOf(childVar) + ";", String.valueOf(childEqn) + ";").replace(String.valueOf(childVar) + ")", String.valueOf(childEqn) + ")");
        return replaced;
    }

    private boolean containsChildVar(String childVar, String code) {
        String[] terminators;
        String[] stringArray = terminators = new String[]{" ", ",", ";", ")"};
        int n = terminators.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            if (code.contains(String.valueOf(childVar) + term)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void printTree(Node treeRoot) {
        int level = 0;
        if (treeRoot == null) {
            return;
        }
        System.out.println("Level " + level + " token " + treeRoot.getToken() + "\n[" + treeRoot.getInfo() + "]");
        this.printTree(treeRoot.getChild(), 1);
    }

    public void generateTemps(Node treeRoot) {
        StringBuffer sb = new StringBuffer();
        if (treeRoot != null) {
            sb.append(this.generateTemps(treeRoot.getChild(), 1));
        }
        if (sb.length() > 0) {
            this.addTempsToLHS(treeRoot, sb.toString());
        }
    }

    private void addTempsToLHS(Node treeRoot, String temps) {
        Node lhs = treeRoot.getChild();
        StringBuffer newHeader = new StringBuffer();
        newHeader.append(temps);
        newHeader.append(lhs.getGeneratedCodeHead());
        lhs.setGeneratedCodeHead(newHeader);
    }

    public String generateTemps(Node node, int level) {
        StringBuffer sb = new StringBuffer();
        if (node != null) {
            if (!node.isPlaceHolder()) {
                sb.append(this.printTemp(node));
            }
            sb.append(this.generateTemps(node.getChild(), level + 1));
            sb.append(this.generateTemps(node.getNext(), level));
        }
        return sb.toString();
    }

    public String printTemp(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node.getResultsVariable() != null) {
            if (node.getResultsVariable().startsWith("_b")) {
                if (Translator.target.equals("C")) {
                    sb.append("bool " + node.getResultsVariable() + " = false;\n");
                } else {
                    sb.append("boolean " + node.getResultsVariable() + " = false;\n");
                }
            } else if (node.getResultsVariable().startsWith("_t")) {
                sb.append("double " + node.getResultsVariable() + " = 0.0;\n");
            } else if (node.getResultsVariable().startsWith("_s")) {
                if (Translator.target.equals("C")) {
                    sb.append("char* " + node.getResultsVariable() + " = (char *) malloc(100);\n");
                } else {
                    sb.append("String " + node.getResultsVariable() + " = \"\";\n");
                }
            }
        }
        return sb.toString();
    }

    private void printTree(Node node, int level) {
        if (node == null) {
            return;
        }
        System.out.println("Level " + level + " token " + node.getToken() + "[" + node.getInfo() + "]");
        this.printTree(node.getChild(), level + 1);
        this.printTree(node.getNext(), level);
    }

    private String convertRangeFunction(Node node, Map<Node, String> rhsStatements, String valueVariable) {
        String exp;
        Node expressionRoot;
        ArrayReference ar;
        StringBuffer code = new StringBuffer();
        EquationArrayReferenceStructure ears = this.currentGenerate.getEars();
        String type = this.getRangeFunctionType(node);
        HashMap<String, Integer> rangeIndex = new HashMap<String, Integer>();
        List<Node> arrayReferenceNodes = this.getArrayReferences(node);
        ArrayList<String> rangeSubscripts = new ArrayList<String>();
        int index = 0;
        for (Node arn : arrayReferenceNodes) {
            ar = new ArrayReference(arn.getToken());
            for (String rangeSub : ar.getRangeSubscripts()) {
                String subscript = rangeSub;
                if (!rangeIndex.containsKey(subscript)) {
                    rangeIndex.put(subscript, index++);
                }
                rangeSubscripts.add(rangeSub.replace("!", ""));
            }
        }
        for (Node arn : arrayReferenceNodes) {
            ar = new ArrayReference(arn.getToken());
        }
        String tVar = this.getNextDouble();
        if (type.equals("VMAX")) {
            code.append("double " + tVar + " = -Double.MAX_VALUE;\n");
        }
        if (type.equals("VMIN")) {
            code.append("double " + tVar + " = Double.MAX_VALUE;\n");
        }
        boolean addRangeBracket = false;
        code.append(ears.getRangeLoops(arrayReferenceNodes));
        addRangeBracket = true;
        if (type.equals("VMAX")) {
            code.append("if (" + tVar + " < ");
            expressionRoot = TreeTraversal.getFunctionArgument(node, 1);
            exp = this.generateExpression(expressionRoot, rhsStatements);
            code.append(exp);
            code.append(") {\n");
            code.append(String.valueOf(tVar) + " = " + exp + ";");
            code.append("\n}\n");
            code.append("\n}\n");
            if (addRangeBracket) {
                code.append("} /* addRangeBracket */\n");
            }
            code.append(String.valueOf(valueVariable) + " = " + tVar + ";\n");
        } else if (type.equals("VMIN")) {
            code.append("if (" + tVar + " > ");
            expressionRoot = TreeTraversal.getFunctionArgument(node, 1);
            exp = this.generateExpression(expressionRoot, rhsStatements);
            code.append(exp);
            code.append(") {\n");
            code.append(String.valueOf(tVar) + " = " + exp + ";");
            code.append("\n}\n");
            code.append("\n}\n");
            if (addRangeBracket) {
                code.append("} /* addRangeBracket */\n");
            }
            code.append(String.valueOf(valueVariable) + " = " + tVar + ";\n");
        } else {
            code.append(valueVariable);
            code.append(" " + (type.equals("SUM") ? "+" : "*") + "= (\n");
            expressionRoot = TreeTraversal.getFunctionArgument(node, 1);
            code.append(this.generateExpression(expressionRoot, rhsStatements));
            code.append(");\n");
            int i = 0;
            while (i < ears.getRangeClosingCount(arrayReferenceNodes)) {
                code.append("}\n");
                ++i;
            }
            if (addRangeBracket) {
                code.append("} /* addRangeBracket */\n");
            }
        }
        node.setToken(valueVariable);
        node.setChild(null);
        return code.toString();
    }

    public static String getLegalName(String s) {
        String legal = InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(s.replace("!", ""));
        return legal.replace("memory.", "");
    }

    private String generateExpression(Node node, Map<Node, String> rhsStatements) {
        StringBuffer sb = new StringBuffer();
        if (node == null) {
            return "";
        }
        if (this.isLeaf(node)) {
            if (rhsStatements.containsKey(node)) {
                return rhsStatements.get(node);
            }
            return node.getToken();
        }
        if (node.getChild() != null) {
            sb.append(this.generateExpression(node.getChild(), rhsStatements));
        }
        sb.append(node.getToken());
        if (node.getChild() != null && node.getChild().getNext() != null) {
            sb.append(this.generateExpression(node.getChild().getNext(), rhsStatements));
        }
        return sb.toString();
    }

    private String getValueVariable() {
        if (this.nextValueVariable == 52) {
            System.out.println("_vv 52");
        }
        String vv = "_vv" + this.nextValueVariable;
        ++this.nextValueVariable;
        return vv;
    }

    private List<Node> getArrayReferences(Node node) {
        List<Node> more;
        ArrayList<Node> al = new ArrayList<Node>();
        if (node == null) {
            return al;
        }
        if (node.getToken().startsWith("array.")) {
            al.add(node);
        }
        if ((more = this.getArrayReferencesChild(node.getChild())).size() > 0) {
            al.addAll(more);
        }
        return al;
    }

    private List<Node> getArrayReferencesChild(Node node) {
        List<Node> more;
        ArrayList<Node> al = new ArrayList<Node>();
        if (node == null) {
            return al;
        }
        if (node.getToken().startsWith("array.")) {
            al.add(node);
        }
        if ((more = this.getArrayReferencesChild(node.getChild())).size() > 0) {
            al.addAll(more);
        }
        if ((more = this.getArrayReferencesChild(node.getNext())).size() > 0) {
            al.addAll(more);
        }
        return al;
    }

    private Node getLHS(Node node) {
        return node.getChild();
    }

    private boolean isArrayReference(Node node) {
        return ArrayReference.isArrayReference(node.getToken());
    }

    private boolean isRangeFunctionNode(Node node) {
        return node.getToken().startsWith("sdFunctions.SUM") || node.getToken().startsWith("sdFunctions.PROD") || node.getToken().startsWith("sdFunctions.VMIN") || node.getToken().startsWith("sdFunctions.VMAX");
    }

    private String getRangeFunctionType(Node node) {
        if (node.getToken().startsWith("sdFunctions.SUM")) {
            return "SUM";
        }
        if (node.getToken().startsWith("sdFunctions.PROD")) {
            return "PROD";
        }
        if (node.getToken().startsWith("sdFunctions.VMIN")) {
            return "VMIN";
        }
        if (node.getToken().startsWith("sdFunctions.VMAX")) {
            return "VMAX";
        }
        return "???";
    }

    private List<Node> getRangeFunctionReferences(Node node) {
        List<Node> more;
        ArrayList<Node> al = new ArrayList<Node>();
        if (node == null) {
            return al;
        }
        if (this.isRangeFunctionNode(node)) {
            al.add(node);
        }
        if ((more = this.getRangeFunctionReferences(node.getChild())).size() > 0) {
            al.addAll(more);
        }
        if ((more = this.getRangeFunctionReferences(node.getNext())).size() > 0) {
            al.addAll(more);
        }
        return al;
    }

    private String generateModifiedCode(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node == null) {
            return "";
        }
        if (!node.getInfo().equals("@")) {
            return node.getInfo();
        }
        if (Parser.isOperator(node.getToken()) || Parser.isBooleanOperator(node.getToken())) {
            if (node.getToken().equals("^")) {
                sb.append("Math.pow(");
                sb.append(this.generateModifiedCode(node.getChild()));
                sb.append(",");
                sb.append(this.generateModifiedCode(node.getChild().getNext()));
                sb.append(");\n");
            } else {
                sb.append(this.generateModifiedCode(node.getChild()));
                sb.append(node.getToken());
                sb.append(this.generateModifiedCode(node.getChild().getNext()));
            }
        } else if (Parser.isFunctionInvocation(node.getToken())) {
            sb.append(String.valueOf(node.getToken()) + "(");
            Node n = node.getChild();
            sb.append(this.generateModifiedCode(n));
            n = n.getNext();
            while (n != null) {
                sb.append(",");
                sb.append(this.generateModifiedCode(n));
                n = n.getNext();
            }
            sb.append(")");
        } else {
            sb.append(node.getToken());
        }
        return sb.toString();
    }

    private void generateCodeForStockInitialization(Equation equation) {
        this.resetCounters();
        this.currentGenerate = equation;
        EquationArrayReferenceStructure ears = null;
        if (equation.isHasLHSArrayReference() || equation.isHasRHSArrayReference()) {
            ears = equation.getEars();
        }
        this.generateLHScode(equation, ears, this.isInitializeScenarioDirectory());
        this.generateRHScode(equation, ears);
        Node root = equation.getTreeRoot();
        if (flatten) {
            this.flattenTree(root);
        }
        this.generateTemps(root);
        if (equation.requiresPostGenerationProcessing()) {
            this.postGenerationProcessing(equation);
        }
    }

    private void generateCode(Equation equation, BufferedWriter bw) {
        this.resetCounters();
        this.currentGenerate = equation;
        if (!equation.isTreeCodeGenerated()) {
            EquationArrayReferenceStructure ears = null;
            if (equation.isHasLHSArrayReference() || equation.isHasRHSArrayReference()) {
                ears = equation.getEars();
            }
            this.generateLHScode(equation, ears, this.isInitializeScenarioDirectory());
            this.generateRHScode(equation, ears);
            Node root = equation.getTreeRoot();
            if (flatten) {
                this.flattenTree(root);
            }
            this.generateTemps(equation.getTreeRoot());
        }
        if (equation.requiresPostGenerationProcessing()) {
            this.postGenerationProcessing(equation);
        }
        this.writeGeneratedCode(equation, bw);
    }

    private void postGenerationProcessing(Equation equation) {
        if (equation.isHasVectorSortOrder()) {
            this.postGenerationProcessingVectorSortOrder(equation);
        } else if (equation.isHasVectorElmMap()) {
            this.postGenerationProcessingVectorElmMap(equation);
        }
    }

    private void postGenerationProcessingVectorSortOrder(Equation equation) {
        Node root = equation.getTreeRoot();
        Node lhs = root.getChild();
        Node rhs = lhs.getNext();
        String resultsVariable = rhs.getResultsVariable();
        String[] linesOfCode = lhs.getGeneratedCodeHead().toString().split("\n");
        int vectorLength = 0;
        int keepToLine = 0;
        String removedLoopVar = "";
        int i = linesOfCode.length - 1;
        while (i >= 0) {
            String code = linesOfCode[i];
            if (code.contains("newIntArray(")) {
                String vLen = code.split("Array\\(")[1].split(",")[0];
                vectorLength = Integer.parseInt(vLen);
                keepToLine = i;
                removedLoopVar = code.split("=")[0].replace("int* ", "").replace("int[] ", "").replace("_index ", "");
                break;
            }
            --i;
        }
        String scalarDeclaration = "double " + resultsVariable + " = 0.0";
        String vectorDeclaration = "";
        vectorDeclaration = Translator.target.equals("C") ? "double *" + resultsVariable + ";" : "double[] " + resultsVariable + " = new double[" + vectorLength + "];";
        StringBuffer newHeader = new StringBuffer();
        int i2 = 0;
        while (i2 < keepToLine) {
            if (linesOfCode[i2].contains(scalarDeclaration)) {
                newHeader.append(vectorDeclaration);
            } else {
                newHeader.append(linesOfCode[i2]);
            }
            newHeader.append("\n");
            ++i2;
        }
        lhs.setGeneratedCodeHead(newHeader);
        StringBuffer newTail = new StringBuffer();
        linesOfCode = lhs.getGeneratedCodeTail().toString().split("\n");
        int i3 = 0;
        while (i3 < linesOfCode.length - 1) {
            if (linesOfCode[i3].contains("[" + removedLoopVar + "]")) {
                newTail.append(linesOfCode[i3].replace("[" + removedLoopVar + "]", ""));
            } else if (linesOfCode[i3].contains("logit")) {
                String newLog = linesOfCode[i3].replace("logit", "/* log5 */logitVector").replace(resultsVariable, String.valueOf(vectorLength) + "," + resultsVariable).replace(removedLoopVar, "0");
                newTail.append(newLog);
            } else {
                newTail.append(linesOfCode[i3]);
            }
            newTail.append("\n");
            ++i3;
        }
        lhs.setGeneratedCodeTail(newTail);
        StringBuffer rhsNewTail = new StringBuffer();
        linesOfCode = rhs.getGeneratedCodeTail().toString().split("\n");
        int i4 = 0;
        while (i4 < linesOfCode.length) {
            if (linesOfCode[i4].contains("[" + removedLoopVar + "]")) {
                int occurrence = 0;
                String[] stuff = linesOfCode[i4].split(",");
                int s = 0;
                while (s < stuff.length) {
                    if (s > 0) {
                        rhsNewTail.append(",");
                    }
                    if (stuff[s].contains("[" + removedLoopVar + "]")) {
                        if (++occurrence == 1) {
                            rhsNewTail.append(stuff[s].replace(removedLoopVar, "0"));
                        } else if (occurrence == 2) {
                            rhsNewTail.append(stuff[s].replace("[" + removedLoopVar + "]", ""));
                        } else {
                            rhsNewTail.append(stuff[s]);
                        }
                    } else if (stuff[s].contains("intToString(" + removedLoopVar + ")")) {
                        rhsNewTail.append(stuff[s].replace(removedLoopVar, "0"));
                    } else {
                        rhsNewTail.append(stuff[s]);
                    }
                    ++s;
                }
            } else {
                rhsNewTail.append(linesOfCode[i4]);
            }
            rhsNewTail.append("\n");
            ++i4;
        }
        rhs.setGeneratedCodeTail(rhsNewTail);
    }

    private void postGenerationProcessingVectorElmMap(Equation equation) {
        Node root = equation.getTreeRoot();
        Node lhs = root.getChild();
        Node rhs = lhs.getNext();
        String zeroOffset = "0";
        String[] invocation = rhs.getGeneratedCodeTail().toString().split(",");
        int index = invocation.length - 2;
        if (Translator.target.equals("Java")) {
            zeroOffset = this.getZeroOffset(invocation[index]);
            invocation[index] = invocation[index].replace("[" + zeroOffset + "]", "");
        } else {
            invocation[index] = "&" + invocation[index];
        }
        index = invocation.length - 1;
        invocation[index] = invocation[index].replace("(", "(" + zeroOffset + "+");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        String[] stringArray = invocation;
        int n = invocation.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(s);
            ++n2;
        }
        rhs.setGeneratedCodeTail(sb);
    }

    private String getZeroOffset(String invocation) {
        String zeroOffset = "";
        String notation = "\\[[0-9]+\\]\\)";
        Pattern p = Pattern.compile(notation);
        Matcher m = p.matcher(invocation);
        boolean found = m.find();
        String fnd = m.group();
        zeroOffset = fnd.replace("[", "").replace("])", "");
        return zeroOffset;
    }

    private void generateLHScode(Equation equation, EquationArrayReferenceStructure ears, boolean logit) {
        Node lhs = null;
        Node root = equation.getTreeRoot();
        lhs = root.getChild();
        if (lhs == null) {
            System.out.println("BRKPT (rhs)");
        }
        Node rhs = lhs.getNext();
        String resultsVariable = this.getNextDouble();
        rhs.setResultsVariable(resultsVariable);
        if (!this.isArrayReference(lhs)) {
            this.currentHasLhsArrayReference = false;
            this.outerSubscripts.clear();
            lhs.getGeneratedCodeTail().append(String.valueOf(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhs.getToken())) + " = " + resultsVariable + ";\n");
            if (logit) {
                lhs.getGeneratedCodeTail().append("/* log6 */logit(\"" + lhs.getToken() + "\",time," + resultsVariable + ",memory.get_SAVEPER());\n");
            }
        } else {
            ArrayReferenceNative ar = new ArrayReferenceNative(lhs.getToken(), equation);
            this.currentHasLhsArrayReference = true;
            this.outerSubscripts.addAll(ar.getSubscripts());
            lhs.getGeneratedCodeHead().append(ar.generateLHSHeader(resultsVariable));
            lhs.getGeneratedCodeTail().append(ar.generateLHSFooter(resultsVariable, this.isInitializeScenarioDirectory()));
        }
    }

    private void generateRHScode(Equation equation, EquationArrayReferenceStructure ears) {
        Node node = TreeTraversal.getRhs(equation.getTreeRoot());
        this.generateRHSCode(node);
    }

    private void printNode(Node node, boolean traverseChildSiblings) {
        if (node == null) {
            return;
        }
        if (Equation.isITENode(node)) {
            Node condition = TreeTraversal.getFunctionArgument(node, 1);
            Node thenExpression = condition.getNext();
            Node elseExpression = thenExpression.getNext();
            this.printNode(condition, false);
            this.printNodeCodeHead(node);
            this.printNode(thenExpression, false);
            this.printNodeCodeElse(node);
            this.printNode(elseExpression, false);
            this.printNodeCodeTail(node);
        } else {
            this.printNode(node.getChild(), true);
            if (traverseChildSiblings) {
                this.printNode(node.getNext(), true);
            }
            this.printNodeCode(node);
        }
    }

    private void printNodeCode(Node node) {
        try {
            if (!node.isPlaceHolder()) {
                if (node.getGeneratedCodeHead().length() > 0) {
                    this.sourceCode.append(CodeGenerator.scrub(node.getGeneratedCodeHead().toString()));
                }
                if (node.getGeneratedCodeElse().length() > 0) {
                    this.sourceCode.append(CodeGenerator.scrub(node.getGeneratedCodeElse().toString()));
                }
                if (node.getGeneratedCodeTail().length() > 0) {
                    this.sourceCode.append(CodeGenerator.scrub(node.getGeneratedCodeTail().toString()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printNodeCodeHead(Node node) {
        try {
            if (!node.isPlaceHolder() && node.getGeneratedCodeHead().length() > 0) {
                this.sourceCode.append(CodeGenerator.scrub(node.getGeneratedCodeHead().toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printNodeCodeElse(Node node) {
        try {
            if (!node.isPlaceHolder() && node.getGeneratedCodeElse().length() > 0) {
                this.sourceCode.append(CodeGenerator.scrub(node.getGeneratedCodeElse().toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printNodeCodeTail(Node node) {
        try {
            if (!node.isPlaceHolder() && node.getGeneratedCodeTail().length() > 0) {
                this.sourceCode.append(CodeGenerator.scrub(node.getGeneratedCodeTail().toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeGeneratedCode(Node root, BufferedWriter bw, String unitsAndComment) {
        try {
            Node lhs = root.getChild();
            Node rhs = lhs.getNext();
            bw.append(unitsAndComment);
            bw.append(CodeGenerator.scrub(lhs.getGeneratedCodeHead().toString()));
            boolean traverseChildSiblings = true;
            this.printNode(rhs, traverseChildSiblings);
            bw.append(CodeGenerator.scrub(lhs.getGeneratedCodeTail().toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeGeneratedCode(Equation equation, BufferedWriter bw) {
        this.writeGeneratedCode(equation.getTreeRoot(), bw, equation.getUnitsAndComment());
    }

    private void generateRHSCode(Node node) {
        StringBuffer sb = new StringBuffer();
        StringBuffer theHead = node.getGeneratedCodeHead();
        StringBuffer theElse = node.getGeneratedCodeElse();
        StringBuffer theTail = node.getGeneratedCodeTail();
        String tempVariable = "";
        String booleanVariable = "";
        if (node == null) {
            return;
        }
        if (!node.isPlaceHolder()) {
            if (this.isRangeFunctionNode(node)) {
                Node n = node.getChild();
                int i = 0;
                while (i < 4) {
                    n.setPlaceHolder(true);
                    n = n.getNext();
                    ++i;
                }
                theHead.append(String.valueOf(node.getResultsVariable()) + " = 0.0;\n");
                theHead.append(this.convertRangeFunction(node, this.genRHSStatements(node), node.getResultsVariable()));
                n.setPlaceHolder(true);
            } else if (node.getToken().equals("sdFunctions.IFTHENELSE")) {
                Node condition = this.getCONDITION(node);
                String conditionVariable = this.getNextBoolean();
                condition.setResultsVariable(conditionVariable);
                Node thenNode = this.getTHEN(node);
                String thenVariable = this.getNextDouble();
                thenNode.setResultsVariable(thenVariable);
                Node elseNode = this.getELSE(node);
                String elseVariable = this.getNextDouble();
                elseNode.setResultsVariable(elseVariable);
                Node n = node.getChild();
                int i = 0;
                while (i < 4) {
                    n.setPlaceHolder(true);
                    n = n.getNext();
                    ++i;
                }
                theHead.append("if (" + conditionVariable + ") {\n");
                boolean rvDouble = node.getResultsVariable().startsWith("_t");
                boolean thenVariableDouble = thenVariable.startsWith("_t");
                boolean elseVariableDouble = thenVariable.startsWith("_t");
                boolean rvBoolean = !rvDouble;
                boolean thenVariableBoolean = !thenVariableDouble;
                boolean elseVariableBoolean = !elseVariableDouble;
                String cast = "";
                if (rvBoolean && thenVariableDouble) {
                    cast = " == 1 ";
                }
                theElse.append(String.valueOf(node.getResultsVariable()) + " = " + thenVariable + cast + ";\n");
                theElse.append("} else {\n");
                cast = "";
                if (rvBoolean && elseVariableDouble) {
                    cast = " == 1 ";
                }
                theTail.append(String.valueOf(node.getResultsVariable()) + " = " + elseVariable + cast + ";\n");
                theTail.append("}\n");
            } else if (Parser.isOperator(node.getToken()) || Parser.isBooleanOperator(node.getToken())) {
                String variable1 = "";
                String variable2 = "";
                if (!Parser.isBooleanOperator(node.getToken())) {
                    variable1 = this.getNextDouble();
                    Node left = node.getChild();
                    left.setResultsVariable(variable1);
                    if (left.getNext() == null) {
                        theTail.append(String.valueOf(node.getResultsVariable()) + " = " + node.getToken().replace("_", "-") + " " + variable1 + ";\n");
                    } else {
                        variable2 = this.getNextDouble();
                        Node right = left.getNext();
                        right.setResultsVariable(variable2);
                        if (node.getToken().equals("^")) {
                            theTail.append(String.valueOf(node.getResultsVariable()) + " = Math.pow(" + variable1 + "," + variable2 + ");\n");
                        } else {
                            theTail.append(String.valueOf(node.getResultsVariable()) + " = " + variable1 + " " + node.getToken() + " " + variable2 + ";\n");
                        }
                    }
                } else {
                    if (node.getToken().equals(":AND:")) {
                        node.setToken("&&");
                    }
                    if (node.getToken().equals(":OR:")) {
                        node.setToken("||");
                    }
                    if (node.getToken().equals(":NOT:")) {
                        node.setToken("!");
                    }
                    if (Parser.isLogicalOperator(node.getToken())) {
                        variable1 = this.getNextBoolean();
                        variable2 = this.getNextBoolean();
                    } else {
                        variable1 = this.getNextDouble();
                        variable2 = this.getNextDouble();
                    }
                    if (Parser.isBinaryOperator(node.getToken())) {
                        node.getChild().setResultsVariable(variable1);
                        node.getChild().getNext().setResultsVariable(variable2);
                        theTail.append(String.valueOf(node.getResultsVariable()) + " = " + variable1 + " " + node.getToken() + " " + variable2 + ";\n");
                    } else {
                        node.getChild().setResultsVariable(variable1);
                        theTail.append(String.valueOf(node.getResultsVariable()) + " = " + node.getToken() + " (" + variable1 + ");\n");
                    }
                }
            } else if (node.getToken().equals("sdFunctions.VECTORSELECT")) {
                String nameArg;
                String valueArg;
                String suffix1 = this.getNextInt();
                String suffix2 = this.getNextInt();
                ArrayReference ar1 = null;
                ArrayReference ar2 = null;
                Node arg1 = TreeTraversal.getFunctionArgument(node, 1);
                Node arg2 = TreeTraversal.getFunctionArgument(node, 2);
                if (ArrayReference.isArrayReference(arg1.getToken())) {
                    ar1 = new ArrayReference(arg1.getToken());
                }
                if (ArrayReference.isArrayReference(arg2.getToken())) {
                    ar2 = new ArrayReference(arg2.getToken());
                }
                List<String> range = ar1.getRangeSubscriptsNames();
                if (Translator.target.equals("C")) {
                    theHead.append("double _da" + suffix1 + "[" + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(range.get(0)) + "];\n");
                } else {
                    theHead.append("double[] _da" + suffix1 + " = new double" + "[" + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(range.get(0)) + "];\n");
                }
                theHead.append("int _i" + suffix1 + " = 0;\n");
                ArrayReferenceNative ar1n = new ArrayReferenceNative(arg1.getToken(), this.currentGenerate);
                EquationArrayReferenceStructure ears = this.currentGenerate.getEars();
                List<Node> arrayReferenceNodes = this.getArrayReferences(node);
                theHead.append(ears.getRangeLoops(arrayReferenceNodes));
                theHead.append("_da" + suffix1 + "[_i" + suffix1 + "++] = " + ar1n.generateRHSImplementation() + ";\n");
                int i = 0;
                while (i < ears.getRangeClosingCount()) {
                    theHead.append("}\n");
                    ++i;
                }
                theHead.append("}\n");
                if (ar2 != null) {
                    range = ar2.getRangeSubscriptsNames();
                    if (Translator.target.equals("C")) {
                        theHead.append("double _da" + suffix2 + "[" + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(range.get(0)) + "];\n");
                    } else {
                        theHead.append("double[] _da" + suffix2 + " = new double" + "[" + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(range.get(0)) + "];\n");
                    }
                    theHead.append("int _i" + suffix2 + " = 0;\n");
                    ar1n = new ArrayReferenceNative(arg2.getToken(), this.currentGenerate);
                    ears = this.currentGenerate.getEars();
                    arrayReferenceNodes = this.getArrayReferences(node);
                    theHead.append(ears.getRangeLoops(arrayReferenceNodes));
                    theHead.append("_da" + suffix2 + "[_i" + suffix2 + "++] = " + ar1n.generateRHSImplementation() + ";\n");
                    i = 0;
                    while (i < ears.getRangeClosingCount()) {
                        theHead.append("}\n");
                        ++i;
                    }
                    theHead.append("}\n");
                } else {
                    if (Translator.target.equals("C")) {
                        theHead.append("double _da" + suffix2 + "[" + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(range.get(0)) + "];\n");
                    } else {
                        theHead.append("double[] _da" + suffix2 + " = new double" + "[" + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(range.get(0)) + "];\n");
                    }
                    theHead.append("int _i" + suffix2 + " = 0;\n");
                    ears = this.currentGenerate.getEars();
                    arrayReferenceNodes = this.getArrayReferences(node);
                    theHead.append(ears.getRangeLoops(arrayReferenceNodes));
                    theHead.append("_da" + suffix2 + "[_i" + suffix2 + "++] = " + this.generateExpression(arg2) + ";\n");
                    i = 0;
                    while (i < ears.getRangeClosingCount()) {
                        theHead.append("}\n");
                        ++i;
                    }
                    theHead.append("}\n");
                    arg2.setPlaceHolder(false);
                }
                theTail.append(String.valueOf(node.getResultsVariable()) + " = ");
                theTail.append(String.valueOf(node.getToken()) + "(");
                Node n = node.getChild();
                String lhs = this.currentGenerate.getLhs();
                if (ArrayReference.isArrayReference(lhs)) {
                    valueArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSImplementation();
                    nameArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSName();
                } else {
                    valueArg = InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhs);
                    nameArg = "\"" + lhs + "\"";
                }
                int numSkip = 4;
                int i2 = 0;
                while (i2 < numSkip) {
                    if (i2 > 0) {
                        theTail.append(",");
                    }
                    if (i2 == 1) {
                        n.setToken(valueArg);
                    } else if (i2 == 0) {
                        n.setToken(nameArg);
                    }
                    theTail.append(n.getToken());
                    n.setPlaceHolder(true);
                    n = n.getNext();
                    ++i2;
                }
                theTail.append(",");
                String name = "_da1";
                nameArg = "_da" + suffix1;
                n.setToken(nameArg);
                n.setPlaceHolder(true);
                theTail.append(nameArg);
                n = n.getNext();
                theTail.append(",");
                nameArg = "_da" + suffix2;
                n.setPlaceHolder(true);
                n.setToken(nameArg);
                theTail.append(nameArg);
                n = n.getNext();
                while (n != null) {
                    theTail.append(",");
                    String t = this.getNextDouble();
                    n.setResultsVariable(t);
                    theTail.append(t);
                    n = n.getNext();
                }
                theTail.append(");\n");
            } else if (node.getToken().equals("sdFunctions.SAMPLEIFTRUE")) {
                String nameArg;
                String valueArg;
                theTail.append(String.valueOf(node.getResultsVariable()) + " = ");
                theTail.append(String.valueOf(node.getToken()) + "(");
                Node n = node.getChild();
                String lhs = this.currentGenerate.getLhs();
                if (ArrayReference.isArrayReference(lhs)) {
                    valueArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSImplementation();
                    nameArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSName();
                } else {
                    valueArg = InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhs);
                    nameArg = "\"" + lhs + "\"";
                }
                int i = 0;
                while (i < 4) {
                    if (i > 0) {
                        theTail.append(",");
                    }
                    if (i == 1) {
                        n.setToken(valueArg);
                    } else if (i == 0) {
                        n.setToken(nameArg);
                    }
                    theTail.append(n.getToken());
                    n.setPlaceHolder(true);
                    n = n.getNext();
                    ++i;
                }
                theTail.append(",");
                String b = this.getNextBoolean();
                n.setResultsVariable(b);
                theTail.append(b);
                n = n.getNext();
                while (n != null) {
                    theTail.append(",");
                    String t = this.getNextDouble();
                    n.setResultsVariable(t);
                    theTail.append(t);
                    n = n.getNext();
                }
                theTail.append(");\n");
            } else if (node.getToken().equals("sdFunctions.GETDATABETWEENTIMES")) {
                theTail.append(String.valueOf(node.getResultsVariable()) + " = ");
                theTail.append(String.valueOf(node.getToken()) + "(");
                Node n = node.getChild();
                String lhs = this.currentGenerate.getLhs();
                String valueArg = InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhs);
                String nameArg = "/* FixThis  */ \"" + lhs + "\"";
                String name = this.getNextString();
                n.setResultsVariable(name);
                theTail.append(name);
                String aRef = n.getToken();
                nameArg = ArrayReferenceNative.isArrayReference(aRef) ? new ArrayReferenceNative(aRef, this.currentGenerate).generateRHSOriginalName() : this.generateRHSName(aRef);
                n.setToken(nameArg);
                n = n.getNext();
                while (n != null) {
                    theTail.append(",");
                    String t = this.getNextDouble();
                    n.setResultsVariable(t);
                    theTail.append(t);
                    n = n.getNext();
                }
                theTail.append(");\n");
            } else if (Parser.isFunctionInvocation(node.getToken())) {
                String nameArg;
                String valueArg;
                FunctionDescription fd = InformationManagers.getInstance().getFunctionManager().getDescription(node.getToken());
                int numFunctionArgs = fd.getNumArgsAll();
                boolean providesInitialValue = fd.isSuppliesInitialValue();
                int processArgNum = 0;
                theTail.append(String.valueOf(node.getResultsVariable()) + " = ");
                theTail.append(String.valueOf(node.getToken()) + "(");
                Node n = node.getChild();
                String lhs = this.currentGenerate.getLhs();
                if (ArrayReference.isArrayReference(lhs)) {
                    valueArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSImplementation();
                    nameArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSName();
                } else {
                    valueArg = InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhs);
                    nameArg = "\"" + lhs + "\"";
                }
                int numTransfer = 4;
                if (node.getToken().startsWith("sdFunctions.LOOKUP")) {
                    numTransfer = 0;
                }
                int i = 0;
                while (i < numTransfer) {
                    ++processArgNum;
                    if (i > 0) {
                        theTail.append(",");
                    }
                    if (i == 1) {
                        n.setToken(valueArg);
                    } else if (i == 0) {
                        n.setToken(nameArg);
                    }
                    theTail.append(n.getToken());
                    n.setPlaceHolder(true);
                    n = n.getNext();
                    ++i;
                }
                int cnt = 0;
                while (n != null) {
                    if (numTransfer == 4 || numTransfer == 0 && cnt > 0) {
                        theTail.append(",");
                    }
                    ++cnt;
                    String t = this.getNextDouble();
                    n.setResultsVariable(t);
                    if (!providesInitialValue) {
                        theTail.append(t);
                    } else if (processArgNum < numFunctionArgs - 1) {
                        theTail.append("(time == 0.0 ? 0.0 : " + t + " )");
                    } else {
                        theTail.append(t);
                    }
                    ++processArgNum;
                    n = n.getNext();
                }
                theTail.append(");\n");
            } else if (this.isArrayReference(node)) {
                if (node.getResultsVariable() != null) {
                    if (node.getResultsVariable().startsWith("_s")) {
                        theTail.append(String.valueOf(node.getResultsVariable()) + " = " + node.getToken() + ";\n");
                    } else {
                        theTail.append(String.valueOf(node.getResultsVariable()) + " = " + new ArrayReferenceNative(node.getToken(), this.currentGenerate).generateRHSImplementation() + ";\n");
                    }
                } else {
                    theTail.append(String.valueOf(node.getResultsVariable()) + " = " + new ArrayReferenceNative(node.getToken(), this.currentGenerate).generateRHSImplementation() + ";\n");
                }
            } else {
                if (node.getResultsVariable() == null) {
                    System.out.println("HUH?");
                }
                boolean resultTypeDouble = node.getResultsVariable().startsWith("_t");
                boolean resultTypeBoolean = node.getResultsVariable().startsWith("_b");
                boolean resultString = node.getResultsVariable().startsWith("_s");
                String castToBoolean = "";
                if (resultTypeBoolean) {
                    castToBoolean = " == 1";
                }
                if (resultTypeDouble || resultTypeBoolean) {
                    theTail.append(String.valueOf(node.getResultsVariable()) + " = " + InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(node.getToken()) + castToBoolean + ";\n");
                } else {
                    theTail.append(String.valueOf(node.getResultsVariable()) + " = " + node.getToken() + ";\n");
                }
            }
        }
        if (node.getChild() != null) {
            this.generateRHSCode(node.getChild());
        }
        if (node.getNext() != null) {
            this.generateRHSCode(node.getNext());
        }
    }

    private String generateExpression(Node node) {
        StringBuffer sb = new StringBuffer();
        node.setPlaceHolder(true);
        if (Parser.isArithmeticOperator(node.getToken())) {
            sb.append(this.generateExpression(node.getChild()));
            sb.append(node.getToken());
            sb.append(this.generateExpression(node.getChild().getNext()));
            return sb.toString();
        }
        if (ArrayReference.isArrayReference(node.getToken())) {
            sb.append(new ArrayReferenceNative(node.getToken(), this.currentGenerate).generateRHSImplementation());
            return sb.toString();
        }
        if (node.getToken().startsWith("sdFunctions.LOOKUP")) {
            sb.append("/* MJB Requires dealing with LOOKUP access!*/");
            sb.append("   ");
            sb.append(this.generateLOOKUP(node));
            return sb.toString();
        }
        sb.append(node.getToken());
        return sb.toString();
    }

    private String generateLOOKUP(Node node) {
        String nameArg;
        String valueArg;
        StringBuffer theTail = new StringBuffer();
        theTail.append(String.valueOf(node.getToken()) + "(");
        Node n = node.getChild();
        String lhs = this.currentGenerate.getLhs();
        if (ArrayReference.isArrayReference(lhs)) {
            valueArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSImplementation();
            nameArg = new ArrayReferenceNative(lhs, this.currentGenerate).generateRHSName();
        } else {
            valueArg = InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(lhs);
            nameArg = "\"" + lhs + "\"";
        }
        int numTransfer = 4;
        if (node.getToken().startsWith("sdFunctions.LOOKUP")) {
            numTransfer = 0;
        }
        int cnt = 0;
        while (n != null) {
            if (numTransfer == 4 || numTransfer == 0 && cnt > 0) {
                theTail.append(",");
            }
            ++cnt;
            String t = this.getNextDouble();
            n.setResultsVariable(t);
            theTail.append(this.generateExpression(n));
            n = n.getNext();
        }
        theTail.append(")\n");
        return theTail.toString();
    }

    private String generateRHSName(String valueOfRef) {
        return valueOfRef.replace("valueOf(", "").replace(")", "");
    }

    private Node getCONDITION(Node node) {
        return TreeTraversal.getFunctionArgument(node, 1);
    }

    private Node getTHEN(Node node) {
        return TreeTraversal.getFunctionArgument(node, 2);
    }

    private Node getELSE(Node node) {
        return TreeTraversal.getFunctionArgument(node, 3);
    }

    private boolean isLeaf(Node node) {
        if (node == null) {
            return true;
        }
        return node.getChild() == null;
    }

    private boolean isTerminal(Node node) {
        if (node == null) {
            return true;
        }
        if (node.getToken().startsWith("sdFunctions.IFTHENELSE")) {
            return false;
        }
        return this.isTerminal(node.getChild()) && this.isTerminal(node.getNext());
    }

    private void report(BufferedWriter bw) {
        try {
            bw.append("public BufferedWriter report(String filename) {\n\n");
            bw.append("    if (!trace.isTrace() || report == null)\n");
            bw.append("       return null;\n");
            bw.append("  BufferedWriter bw = null;\n");
            bw.append("  try {\n");
            bw.append("    bw = Utilities.openFileForWriting(filename);\n\n");
            ArrayList<String> sortOrder = new ArrayList<String>(this.evaluationOrder);
            Collections.sort(sortOrder);
            bw.append("    bw.append(\"time\");");
            for (String lhs : sortOrder) {
                if (!this.equations.get(lhs).getCleanEquation().contains("=") || this.equations.get(lhs).isHasLHSArrayReference()) continue;
                if (this.equations.get(lhs).isRepeated()) {
                    bw.append("    bw.append(\"," + lhs + "\");\n");
                    continue;
                }
                bw.append("    bw.append(\"," + lhs + "\");\n");
            }
            bw.append("    bw.append(\"\\n\");\n");
            bw.append("    bw.flush();\n");
            bw.append("  } catch (IOException e) {\n");
            bw.append("    e.printStackTrace();\n");
            bw.append("  }\n");
            bw.append("    return bw;\n\n");
            bw.append("  }\n");
            bw.append("public void reportTimeStep(double time) {\n");
            bw.append("    if (!trace.isTrace() || report == null)\n");
            bw.append("       return;\n");
            bw.append("    int i = (int) ((currentTime - getINITIALTIME())/getTIMESTEP());\n");
            bw.append("BufferedWriter bw = report;\n");
            bw.append("  try {\n");
            bw.append("    bw.append(Double.toString(currentTime));\n");
            for (String lhs : sortOrder) {
                if (!this.equations.get(lhs).getCleanEquation().contains("=") || this.equations.get(lhs).isHasLHSArrayReference()) continue;
                bw.append("    bw.append(\",\"+Double.toString(valueOf(\"" + lhs + "\", i)));\n");
            }
            bw.append("    bw.append(\"\\n\");\n");
            bw.append("    i++;\n");
            bw.append("    bw.flush();\n");
            bw.append("  } catch (IOException e) {\n");
            bw.append("    e.printStackTrace();\n");
            bw.append("  }\n");
            bw.append("}\n\n");
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void runner(String srcDir) {
        BufferedWriter bw = Utilities.openFileForWriting(String.valueOf(srcDir) + this.objectName + "_runner.java");
        try {
            bw.append("package " + this.translator.getPackageName() + ";\n\n");
            bw.append("public class " + this.objectName + "_runner  {\n");
            bw.append("public " + this.objectName + "_runner(String name, String[] args) {}\n");
            bw.append("public static void main(String[] args) {\n");
            bw.append("new " + this.objectName + "(\"" + this.objectName + "\", args).execute();\n");
            bw.append("}\n");
            bw.append("}\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void endObject(BufferedWriter bw) {
        try {
            bw.append("}\n\n");
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void endObjectC(BufferedWriter bw) {
        try {
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getNextBoolean() {
        String next = "_b" + this.booleanUsed;
        if (this.booleanUsed > this.maxBoolean) {
            this.maxBoolean = this.booleanUsed;
        }
        ++this.booleanUsed;
        return next;
    }

    private String getNextDouble() {
        String next = "_t" + this.doubleUsed;
        if (this.doubleUsed > this.maxTemp) {
            this.maxTemp = this.doubleUsed;
        }
        ++this.doubleUsed;
        return next;
    }

    private String getNextInt() {
        String next = Integer.toString(this.intUsed);
        if (this.intUsed > this.maxTempInt) {
            this.maxTempInt = this.intUsed;
        }
        ++this.intUsed;
        return next;
    }

    private String getNextString() {
        String next = "_s" + this.stringUsed;
        if (this.stringUsed > this.maxString) {
            this.maxString = this.stringUsed;
        }
        ++this.stringUsed;
        return next;
    }

    private void resetCounters() {
        this.resetLimits();
        this.booleanUsed = 0;
        this.doubleUsed = 0;
        this.stringUsed = 0;
        this.intUsed = 0;
    }

    private void resetLimits() {
        this.maxTemp = -1;
        this.maxTempInt = -1;
        this.maxBoolean = -1;
        this.maxString = -1;
        indexArraysPacked.clear();
    }

    public static boolean indexDefined(String pack) {
        return indexArraysPacked.contains(pack);
    }

    public static void defineIndex(String pack) {
        indexArraysPacked.add(pack);
    }

    private Map<Node, String> genRHSStatements(Node node) {
        List<Node> arrayReferenceNodes = this.getArrayReferences(node);
        HashMap<Node, String> rhsStatements = new HashMap<Node, String>();
        Node lhsNode = null;
        lhsNode = this.getLHS(node);
        for (Node n : arrayReferenceNodes) {
            if (n.equals(lhsNode)) continue;
            rhsStatements.put(n, new ArrayReferenceNative(n.getToken(), this.currentGenerate).generateRHSImplementation());
        }
        return rhsStatements;
    }

    public BufferedWriter getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(BufferedWriter sourceCode) {
        this.sourceCode = sourceCode;
    }

    public static String scrub(String lineOfCode) {
        if (Translator.target.equals("Java")) {
            return lineOfCode;
        }
        if (Translator.target.equals("Javascript")) {
            return lineOfCode;
        }
        if (Translator.target.equals("C")) {
            return lineOfCode.replace("memory.", "").replace("sdFunctions.", "").replace("Double.MAX_VALUE", "DBL_MAX").replace("Double.MIN_VALUE", "DBL_MIN").replace("/* holder1 */", "1").replace("/* holder2 */", "1").replace("schedule.", "").replace("Math.pow", "pow");
        }
        return lineOfCode;
    }

    public void performUnitsConsistencyCheck() {
    }

    public boolean isInitializeScenarioDirectory() {
        return this.initializeScenarioDirectory;
    }

    public void setInitializeScenarioDirectory(boolean inializeScenarioDirectory) {
        this.initializeScenarioDirectory = inializeScenarioDirectory;
    }

    private boolean requiresTimeSeries() {
        for (Equation eqn : this.equations.values()) {
            if (!eqn.isUsesTimeSeries()) continue;
            return true;
        }
        return false;
    }
}

