/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.translator.InformationManagers;

public class SubscriptCombination {
    private Map<String, String> values = new HashMap<String, String>();
    private List<String> order;

    public SubscriptCombination(List<String> subOrder) {
        this.order = new ArrayList<String>(subOrder);
    }

    public void addSubscriptValue(String subscript, String value) {
        this.values.put(subscript, value);
    }

    public String getSubscriptValue(String subscript) {
        if (!this.values.containsKey(subscript)) {
            String alternate = InformationManagers.getInstance().getMappedSubscriptManager().getMappedValue(subscript, this.order, this);
            if (alternate != null) {
                return alternate;
            }
            return subscript;
        }
        return this.values.get(subscript);
    }

    public String getSubscriptValueWithoutMapping(String subscript) {
        if (!this.values.containsKey(subscript)) {
            return subscript;
        }
        return this.values.get(subscript);
    }

    public String getSubscriptValue() {
        String concatenated = "";
        for (String sub : this.order) {
            if (concatenated.length() > 0) {
                concatenated = String.valueOf(concatenated) + ",";
            }
            concatenated = String.valueOf(concatenated) + this.getSubscriptValueWithoutMapping(sub);
        }
        return concatenated;
    }
}

