/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Properties;
import repast.simphony.systemdynamics.support.Initializer;
import repast.simphony.systemdynamics.support.LoggerJava;
import repast.simphony.systemdynamics.support.RunnerConstants;
import repast.simphony.systemdynamics.support.SDModel;
import repast.simphony.systemdynamics.support.Synchronizer;
import repast.simphony.systemdynamics.support.VDM;

public class SDModelWithPropertiesVDM_Native
extends SDModel {
    public static Properties PROPERTIES = new Properties();
    private static String DEFAULT_PROPERTIES = "DefaultRunner.properties";
    protected LoggerJava logger = new LoggerJava();
    public static String SEPARATOR = "\t";
    public static final boolean trace = false;
    private String lastVar = "";
    protected VDM vdm = null;

    public SDModelWithPropertiesVDM_Native(String name, boolean logit, String[] args) {
        super(name, args);
        if (args != null && args.length > 0) {
            this.loadProperties(args[0]);
        } else {
            this.loadProperties();
        }
        OUTPUT_DIRECTORY = PROPERTIES.getProperty("outputDirectory");
        DATA_DIRECTORY = PROPERTIES.getProperty("dataDirectory");
        if (logit) {
            this.logger.setLogFile(String.valueOf(name) + "Log.tab");
            this.logger.log("Variable" + SEPARATOR + "Time" + SEPARATOR + "Value");
        }
    }

    @Override
    public void execute() {
        System.out.println("SDModelWithPropertiesVDM_Native: execute()");
        Initializer.initialize();
        this.initializeVDM();
        if (this.vdm != null) {
            this.vdm.advanceTime();
        }
        this.oneTime();
        int tick = 0;
        double time = this.getINITIALTIME();
        while (time <= this.getFINALTIME()) {
            this.data.setCurrentTime(time);
            this.currentTime = time;
            Synchronizer.synchronize(this.currentTime, this.getTIMESTEP());
            this.repeated(time, this.getTIMESTEP());
            this.reportTimeStep(time);
            if (dumpMemory) {
                String filename = "_memoryDump_" + tick++ + ".csv";
                this.results.writeReport(String.valueOf(RunnerConstants.OUTPUT_DIRECTORY) + this.name + filename, this.data);
            }
            if (this.vdm != null) {
                this.vdm.advanceTime();
            }
            time += this.getTIMESTEP();
        }
        System.out.println("SDModelWithPropertiesVDM_Native: logger.close()");
        this.logger.close();
    }

    public void finish() {
        System.out.println("SDModelWithPropertiesVDM_Native: logger.close()");
        this.logger.close();
    }

    protected void logit(String var, double time, double value, double savper) {
        int t = (int)(time / savper);
        double remainder = time - (double)t * savper;
        if (remainder == 0.0) {
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                this.logger.log(String.valueOf(var.replace("memory.", "")) + SEPARATOR + time + SEPARATOR + value);
            } else {
                BigDecimal bd = new BigDecimal(value);
                bd = bd.round(new MathContext(6));
                double d = bd.doubleValue();
                this.logger.log(String.valueOf(var.replace("memory.", "")) + SEPARATOR + time + SEPARATOR + d);
            }
        }
    }

    protected void logitVector(String var, double time, int length, double[] value) {
        this.logger.log(String.valueOf(var) + SEPARATOR + time + SEPARATOR + value);
    }

    public boolean loadProperties(String file) {
        File props = new File(file);
        if (props.exists()) {
            try {
                PROPERTIES.load(new FileInputStream(props));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public boolean loadProperties() {
        return this.loadProperties(DEFAULT_PROPERTIES);
    }

    private void initializeVDM() {
        String vdmFile = PROPERTIES.getProperty("vdmfile");
        if (vdmFile.length() > 0) {
            this.vdm = new VDM(this);
            this.vdm.setFile(vdmFile);
            this.vdm.loadFromFile();
        }
    }
}

