/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import repast.simphony.systemdynamics.support.Initializer;
import repast.simphony.systemdynamics.support.RunnerConstants;
import repast.simphony.systemdynamics.support.SDModel;
import repast.simphony.systemdynamics.support.Synchronizer;
import repast.simphony.systemdynamics.support.VDM;

public class SDModelWithPropertiesVDM
extends SDModel {
    public static Properties PROPERTIES = new Properties();
    private static String DEFAULT_PROPERTIES = "DefaultRunner.properties";
    protected VDM vdm = null;

    public SDModelWithPropertiesVDM(String name, String[] args) {
        super(name, args);
        if (args.length > 0) {
            this.loadProperties(args[0]);
        } else {
            this.loadProperties();
        }
        OUTPUT_DIRECTORY = PROPERTIES.getProperty("outputDirectory");
        DATA_DIRECTORY = PROPERTIES.getProperty("dataDirectory");
    }

    @Override
    public void execute() {
        Initializer.initialize();
        this.initializeVDM();
        if (this.vdm != null) {
            this.vdm.advanceTime();
        }
        this.oneTime();
        int tick = 0;
        double time = this.getINITIALTIME();
        while (time <= this.getFINALTIME()) {
            this.data.setCurrentTime(time);
            this.currentTime = time;
            Synchronizer.synchronize(this.currentTime, this.getTIMESTEP());
            this.repeated(time, this.getTIMESTEP());
            this.reportTimeStep(time);
            if (dumpMemory) {
                String filename = "_memoryDump_" + tick++ + ".csv";
                this.results.writeReport(String.valueOf(RunnerConstants.OUTPUT_DIRECTORY) + this.name + filename, this.data);
            }
            if (this.vdm != null) {
                this.vdm.advanceTime();
            }
            time += this.getTIMESTEP();
        }
        this.results.writeReport(String.valueOf(RunnerConstants.OUTPUT_DIRECTORY) + this.name + "_sdReport.csv", this.data);
    }

    public boolean loadProperties(String file) {
        File props = new File(file);
        if (props.exists()) {
            try {
                PROPERTIES.load(new FileInputStream(props));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public boolean loadProperties() {
        return this.loadProperties(DEFAULT_PROPERTIES);
    }

    private void initializeVDM() {
        String vdmFile = PROPERTIES.getProperty("vdmfile");
        if (vdmFile.length() > 0) {
            this.vdm = new VDM(this);
            this.vdm.setFile(vdmFile);
            this.vdm.loadFromFile();
        }
    }
}

