/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.util.List;
import repast.simphony.systemdynamics.support.Data;
import repast.simphony.systemdynamics.support.Initializer;
import repast.simphony.systemdynamics.support.Message;
import repast.simphony.systemdynamics.support.ResultsReporter;
import repast.simphony.systemdynamics.support.RunnerConstants;
import repast.simphony.systemdynamics.support.SDFunctions;
import repast.simphony.systemdynamics.support.SDFunctionsWithXLSColt;
import repast.simphony.systemdynamics.support.SubscriptCombination;
import repast.simphony.systemdynamics.support.Synchronizer;
import repast.simphony.systemdynamics.support.TimeSeriesData;

public class SDModel {
    public static String OUTPUT_DIRECTORY = "output/";
    public static String DATA_DIRECTORY = "data/";
    protected Data data;
    protected SDFunctionsWithXLSColt sdFunctions;
    protected String name;
    protected Message message = null;
    protected ResultsReporter results = null;
    protected TimeSeriesData timeSeriesData = new TimeSeriesData();
    protected double currentTime;
    protected static boolean dumpMemory = false;

    public SDModel(String name, String[] args) {
        this.name = name;
        this.data = new Data(this);
    }

    public double getINITIALTIME() {
        return this.data.getINITIALTIME();
    }

    public double getFINALTIME() {
        return this.data.getFINALTIME();
    }

    public double getTIMESTEP() {
        return this.data.getTIMESTEP();
    }

    public void setValue(String var, double v) {
        this.data.setValue(var, v);
    }

    public double valueOf(String var) {
        double d = this.data.valueOf(var);
        return this.data.valueOf(var);
    }

    public double valueOf(String var, int time) {
        return this.data.valueOf(var, time);
    }

    public double arrayValueOf(String array, String subscript) {
        return this.data.arrayValueOf(array, subscript);
    }

    public void arraySetValue(String array, String subscript, double value) {
        this.registerArray(array);
        this.data.arraySetValue(array, subscript, value);
    }

    public int[] newIntArray(int len, int ... values) {
        int[] array = new int[len];
        int i = 0;
        while (i < len) {
            array[i] = values[i];
            ++i;
        }
        return array;
    }

    public double[] newDoubleArray(int len, double ... values) {
        double[] array = new double[len];
        int i = 0;
        while (i < len) {
            array[i] = values[i];
            ++i;
        }
        return array;
    }

    public String intToString(int i) {
        return Integer.toString(i);
    }

    public String doubleToString(double d) {
        return Double.toString(d);
    }

    public String stringConcat(String ... strings) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }

    public void execute() {
        Initializer.initialize();
        this.oneTime();
        int tick = 0;
        double time = this.getINITIALTIME();
        while (time <= this.getFINALTIME()) {
            this.data.setCurrentTime(time);
            this.currentTime = time;
            Synchronizer.synchronize(this.currentTime, this.getTIMESTEP());
            this.repeated(time, this.getTIMESTEP());
            this.reportTimeStep(time);
            if (dumpMemory) {
                String filename = "_memoryDump_" + tick++ + ".csv";
                this.results.writeReport(String.valueOf(RunnerConstants.OUTPUT_DIRECTORY) + this.name + filename, this.data);
            }
            time += this.getTIMESTEP();
        }
        this.results.writeReport(String.valueOf(RunnerConstants.OUTPUT_DIRECTORY) + this.name + "_sdReport.csv", this.data);
    }

    protected void oneTime() {
    }

    protected void oneTime(double time, double timeStep) {
    }

    protected void repeated(double time, double timeStep) {
    }

    protected void reportTimeStep(double time) {
    }

    public void registerArray(String arrayName) {
        this.data.registerArray(arrayName);
    }

    public void registerSubscript(String subscriptName, String ... strings) {
        this.data.registerSubscript(subscriptName, strings);
    }

    public List<SubscriptCombination> getSubscriptValueCombinations(String ... strings) {
        return this.data.getSubscriptValueCombinations(strings);
    }

    public List<SubscriptCombination> getSubscriptValueCombinations(String string) {
        return this.data.getSubscriptValueCombinations(string);
    }

    public List<String> getSubscriptValues(String subscriptName) {
        return this.data.getSubscriptValues(subscriptName);
    }

    public String concatAsSubscript(List<String> list) {
        return this.data.concatAsSubscript(list);
    }

    public String concatAsSubscript(String ... list) {
        return this.data.concatAsSubscript(list);
    }

    public boolean isSubscript(String subscriptName) {
        return this.data.isSubscript(subscriptName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Data getData() {
        return this.data;
    }

    public SDFunctions getSdFunctions() {
        return this.sdFunctions;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(double currentTime) {
        this.currentTime = currentTime;
    }

    public TimeSeriesData getTimeSeriesData() {
        return this.timeSeriesData;
    }

    public void setTimeSeriesData(TimeSeriesData timeSeriesData) {
        this.timeSeriesData = timeSeriesData;
    }
}

