/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.Data;
import repast.simphony.systemdynamics.support.ResultsReporter;
import repast.simphony.systemdynamics.support.Utilities;

public class ResultsReporterJava
implements ResultsReporter {
    private String file;
    private Data data;
    private BufferedWriter bw;

    @Override
    public void writeReport(String file, Data data) {
        this.file = file;
        this.data = data;
        this.bw = Utilities.openFileForWriting(file);
        try {
            double step = this.getStepForReport();
            this.bw.append("Variable/Time");
            double time = data.getINITIALTIME();
            while (time <= data.getFINALTIME()) {
                this.bw.append("," + time);
                time += step;
            }
            this.bw.append("\n");
            for (String array : data.getArraysHistory().keySet()) {
                Map<String, List<Double>> subscripts = data.getArraysHistory().get(array);
                for (String subscript : subscripts.keySet()) {
                    List<Double> values = subscripts.get(subscript);
                    this.bw.append("\"" + array);
                    this.bw.append("[" + subscript + "]\"");
                    double time2 = data.getINITIALTIME();
                    while (time2 <= data.getFINALTIME()) {
                        int index = this.toIndex(time2 - data.getINITIALTIME(), data.getTIMESTEP());
                        if (index > values.size() - 1) {
                            index = 0;
                        }
                        this.bw.append("," + values.get(index));
                        time2 += step;
                    }
                    this.bw.append("\n");
                }
            }
            for (String var : data.getModelVariables()) {
                this.bw.append(var);
                double time3 = data.getINITIALTIME();
                while (time3 <= data.getFINALTIME()) {
                    int index = this.toIndex(time3 - data.getINITIALTIME(), data.getTIMESTEP());
                    if (index > data.getDataHistoryFor(var).size() - 1) {
                        index = 0;
                    }
                    this.bw.append("," + data.getDataHistoryFor(var).get(index));
                    time3 += step;
                }
                this.bw.append("\n");
            }
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int toIndex(double time, double timeStep) {
        return (int)(time / timeStep);
    }

    public int toIndex(double time) {
        return (int)((time - this.data.getINITIALTIME()) / this.data.getTIMESTEP());
    }

    public double getStepForReport() {
        double step = this.data.getTIMESTEP();
        if (this.data.hasData("SAVEPER")) {
            step = this.data.valueOf("SAVEPER");
        }
        return step;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

