/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.NamedSubscriptDefinition;

public class NamedSubscriptManager {
    private Map<String, NamedSubscriptDefinition> namedSubscripts = new HashMap<String, NamedSubscriptDefinition>();

    public void subscriptDefinition(String subscriptName, String ... subscriptNames) {
        if (!this.namedSubscripts.containsKey(subscriptName)) {
            this.namedSubscripts.put(subscriptName, new NamedSubscriptDefinition(subscriptName, subscriptNames));
        }
    }

    public void subscriptDefinition(String subscriptName, List<String> subscriptNames) {
        if (!this.namedSubscripts.containsKey(subscriptName)) {
            this.namedSubscripts.put(subscriptName, new NamedSubscriptDefinition(subscriptName, subscriptNames));
        }
    }

    public List<String> getValuesFor(String subscript) {
        ArrayList<String> al = new ArrayList<String>();
        if (!this.isNamedSubscript(subscript.replace("!", ""))) {
            al.add(subscript);
        } else {
            for (String val : this.namedSubscripts.get(subscript.replace("!", "")).getValues()) {
                al.addAll(this.getValuesFor(val));
            }
        }
        return al;
    }

    public int getNumIndexFor(String subscript) {
        return this.getValuesFor(subscript.replace("!", "")).size();
    }

    public int getIndexFor(String namedSubscript, String subscript) {
        return this.getValuesFor(namedSubscript).indexOf(subscript);
    }

    public boolean isNamedSubscript(String subscript) {
        return this.namedSubscripts.containsKey(subscript.replace("!", ""));
    }

    public boolean hasNamedSubscript(ArrayReference arrayReference) {
        for (String subscript : arrayReference.getSubscripts()) {
            if (!this.namedSubscripts.containsKey(subscript)) continue;
            return true;
        }
        return false;
    }

    public String[] getExpandedSubscripts(ArrayReference arrayReference) {
        ArrayList<String> exp = new ArrayList<String>();
        for (String subscript : arrayReference.getSubscripts()) {
            if (!this.namedSubscripts.containsKey(subscript)) continue;
            exp.addAll(this.getValuesFor(subscript));
        }
        int i = 0;
        String[] expSub = new String[exp.size()];
        for (String s : exp) {
            expSub[i++] = s;
        }
        return expSub;
    }

    public void dumpMappings(BufferedWriter bw) {
        try {
            bw.append("Name,Value,Index\n");
            for (String name : this.namedSubscripts.keySet()) {
                NamedSubscriptDefinition nsd = this.namedSubscripts.get(name);
                int index = 0;
                for (String value : nsd.getValues()) {
                    bw.append(String.valueOf(name) + "," + value + "," + index++ + "\n");
                }
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getIndex(String name, String value) {
        if (this.namedSubscripts.containsKey(name)) {
            return this.namedSubscripts.get(name).getValues().indexOf(value);
        }
        return -1;
    }
}

