/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.SDModel;
import repast.simphony.systemdynamics.support.SubscriptCombination;

public class Data {
    protected Map<String, Double> data = new HashMap<String, Double>();
    protected Map<String, List<Double>> dataHistory = new HashMap<String, List<Double>>();
    protected double currentTime;
    protected SDModel model;
    protected Map<String, Map<String, Double>> arrays = new HashMap<String, Map<String, Double>>();
    protected Map<String, Map<String, List<Double>>> arraysHistory = new HashMap<String, Map<String, List<Double>>>();
    protected Map<String, List<String>> subscripts = new HashMap<String, List<String>>();

    public Data(SDModel model) {
        this.model = model;
    }

    public void registerArray(String arrayName) {
        if (!this.arrays.containsKey(arrayName)) {
            this.arrays.put(arrayName, new HashMap());
            this.arraysHistory.put(arrayName, new HashMap());
        }
    }

    public void registerSubscript(String subscriptName, String ... strings) {
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            values.add(val);
            ++n2;
        }
        this.subscripts.put(subscriptName, values);
    }

    public List<SubscriptCombination> getSubscriptValueCombinations(String ... strings) {
        ArrayList<List<String>> bySubscriptValue = new ArrayList<List<String>>();
        ArrayList<SubscriptCombination> values = new ArrayList<SubscriptCombination>();
        ArrayList<String> order = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String subscriptName = stringArray[n2];
            bySubscriptValue.add(this.extractSubscripts(this.getSubscriptValues(subscriptName)));
            order.add(subscriptName);
            ++n2;
        }
        int numPermutations = 1;
        int i = 0;
        while (i < bySubscriptValue.size()) {
            numPermutations *= ((List)bySubscriptValue.get(i)).size();
            ++i;
        }
        SubscriptCombination[] combinations = new SubscriptCombination[numPermutations];
        int i2 = 0;
        while (i2 < numPermutations) {
            combinations[i2] = new SubscriptCombination(order);
            ++i2;
        }
        int subscriptNumber = 0;
        while (subscriptNumber < strings.length) {
            int numPerValue = 1;
            int i3 = subscriptNumber + 1;
            while (i3 < bySubscriptValue.size()) {
                numPerValue *= ((List)bySubscriptValue.get(i3)).size();
                ++i3;
            }
            int row = 0;
            while (row < numPermutations) {
                for (String value : (List)bySubscriptValue.get(subscriptNumber)) {
                    int i4 = 0;
                    while (i4 < numPerValue) {
                        combinations[row].addSubscriptValue(strings[subscriptNumber], value);
                        ++row;
                        ++i4;
                    }
                }
            }
            ++subscriptNumber;
        }
        SubscriptCombination[] subscriptCombinationArray = combinations;
        int n3 = combinations.length;
        int n4 = 0;
        while (n4 < n3) {
            SubscriptCombination combo = subscriptCombinationArray[n4];
            values.add(combo);
            ++n4;
        }
        return values;
    }

    private List<String> extractSubscripts(List<String> subscriptList) {
        ArrayList<String> al = new ArrayList<String>();
        for (String token : subscriptList) {
            if (token.equals("[") || token.equals(",") || token.equals("]")) continue;
            al.add(token);
        }
        return al;
    }

    public List<String> getSubscriptValues(String subscriptName) {
        ArrayList<String> al = new ArrayList<String>();
        if (this.subscripts.get(subscriptName) == null) {
            al.add(subscriptName);
        } else {
            for (String v : this.subscripts.get(subscriptName)) {
                if (this.isSubscript(v)) {
                    al.addAll(this.getSubscriptValues(v));
                    continue;
                }
                al.add(v);
            }
        }
        return al;
    }

    public String concatAsSubscript(List<String> list) {
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String concatAsSubscript(String ... list) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }

    public boolean isSubscript(String subscriptName) {
        return this.subscripts.containsKey(subscriptName);
    }

    public boolean hasData(String var) {
        return this.data.containsKey(var);
    }

    public double valueOf(String var) {
        if (this.data.containsKey(var)) {
            return this.data.get(var);
        }
        return 0.0;
    }

    public List<Double> getDataHistoryFor(String variable) {
        return this.dataHistory.get(variable);
    }

    public double valueOf(String var, int time) {
        List<Double> history = this.dataHistory.get(var);
        if (history == null) {
            this.model.message.println("Uninitialized variable: " + var + " time = " + time);
            return -99999.0;
        }
        if (history.size() == 1) {
            return history.get(0);
        }
        if (history.size() > time) {
            return history.get(time);
        }
        this.model.message.println("Reaching past data: " + var + " time = " + time);
        return -99999.0;
    }

    public double arrayValueOf(String array, String subscript) {
        if (this.getArrays().get(array) == null) {
            this.model.message.println("Premature access to undefined array " + array + " with sub " + subscript);
            if (this.currentTime > 0.0 || array.equals("Concentration")) {
                this.model.message.println("Time > 0");
            }
            return -999.0;
        }
        if (this.getArrays().get(array).get(subscript) == null) {
            this.model.message.println("Premature access to uninitialized array " + array + " with sub " + subscript);
            if (this.currentTime > 0.0 || array.equals("Concentration")) {
                this.model.message.println("Time > 0");
            }
            return -999.0;
        }
        return this.getArrays().get(array).get(subscript);
    }

    public List<String> getModelVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        for (String var : this.data.keySet()) {
            if (var.equalsIgnoreCase("time")) continue;
            variables.add(var);
        }
        Collections.sort(variables);
        return variables;
    }

    public void setValue(String var, double value) {
        if (Double.isNaN(value)) {
            this.model.message.println("Nan Error: " + var);
        }
        this.data.put(var, value);
        if (!this.dataHistory.containsKey(var)) {
            this.dataHistory.put(var, new ArrayList());
        }
        List<Double> history = this.dataHistory.get(var);
        history.add(value);
    }

    public void extendScalarHistory(String var) {
        this.setValue(var, this.valueOf(var));
    }

    public void extendArrayHistory(String array, String subscript) {
        this.arraySetValue(array, subscript, this.arrayValueOf(array, subscript));
    }

    public void arraySetValue(String arrayName, String subscript, double value) {
        if (Double.isNaN(value)) {
            this.model.message.println("Nan Error: " + arrayName + "[" + subscript + "]");
        }
        this.arrays.get(arrayName).put(subscript, value);
        if (!this.arraysHistory.containsKey(arrayName)) {
            this.arraysHistory.put(arrayName, new HashMap());
        }
        if (!this.arraysHistory.get(arrayName).containsKey(subscript)) {
            this.arraysHistory.get(arrayName).put(subscript, new ArrayList());
        }
        List<Double> history = this.arraysHistory.get(arrayName).get(subscript);
        history.add(value);
    }

    public double getINITIALTIME() {
        if (this.data.containsKey("INITIALTIME")) {
            return this.data.get("INITIALTIME");
        }
        if (this.data.containsKey("INITIAL_TIME")) {
            return this.data.get("INITIAL_TIME");
        }
        if (this.data.containsKey("INITIAL TIME")) {
            return this.data.get("INITIAL TIME");
        }
        return -999.0;
    }

    public double getFINALTIME() {
        if (this.data.containsKey("FINALTIME")) {
            return this.data.get("FINALTIME");
        }
        if (this.data.containsKey("FINAL_TIME")) {
            return this.data.get("FINAL_TIME");
        }
        return this.data.get("FINAL TIME");
    }

    public double getTIMESTEP() {
        if (this.data.containsKey("TIMESTEP")) {
            return this.data.get("TIMESTEP");
        }
        if (this.data.containsKey("TIME_STEP")) {
            return this.data.get("TIME_STEP");
        }
        if (!this.data.containsKey("TIME STEP")) {
            this.model.message.println("TIME STEP: WTF!");
            return 0.125;
        }
        return this.data.get("TIME STEP");
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(double currentTime) {
    }

    public Map<String, Double> getData() {
        return this.data;
    }

    public Map<String, List<Double>> getDataHistory() {
        return this.dataHistory;
    }

    public SDModel getModel() {
        return this.model;
    }

    public Map<String, Map<String, Double>> getArrays() {
        return this.arrays;
    }

    public void setArrays(Map<String, Map<String, Double>> arrays) {
        this.arrays = arrays;
    }

    public Map<String, List<String>> getSubscripts() {
        return this.subscripts;
    }

    public void setSubscripts(Map<String, List<String>> subscripts) {
        this.subscripts = subscripts;
    }

    public int getELMCOUNT(String subscript) {
        return this.subscripts.get(subscript).size();
    }

    public Map<String, Map<String, List<Double>>> getArraysHistory() {
        return this.arraysHistory;
    }
}

